/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gui.beans;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Iterator;
import java.util.ListIterator;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.opensha.commons.data.Site;
import org.opensha.commons.geo.Location;
import org.opensha.commons.param.AbstractParameter;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.constraint.ParameterConstraint;
import org.opensha.commons.param.editor.impl.ParameterListEditor;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeFailEvent;
import org.opensha.commons.param.event.ParameterChangeFailListener;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.DoubleParameter;

public class Site_GuiBean
extends JPanel
implements ParameterChangeListener,
ParameterChangeFailListener {
    protected static final String C = "SiteParamList";
    public static final String LONGITUDE = "Longitude";
    public static final String LATITUDE = "Latitude";
    private Site site;
    protected static final String SITE_PARAMS = "Set Site Params";
    private ParameterList parameterList = new ParameterList();
    private ParameterListEditor parameterEditor;
    private DoubleParameter longitude = new DoubleParameter("Longitude", (Double)-360.0, (Double)360.0, (Double)-118.243);
    private DoubleParameter latitude = new DoubleParameter("Latitude", (Double)-90.0, (Double)90.0, (Double)34.053);
    private GridBagLayout gridBagLayout1 = new GridBagLayout();

    public Site_GuiBean() {
        this.setMinimumSize(new Dimension(140, 100));
        this.setPreferredSize(new Dimension(160, 100));
        this.parameterList.addParameter(this.longitude);
        this.parameterList.addParameter(this.latitude);
        this.latitude.addParameterChangeListener(this);
        this.longitude.addParameterChangeListener(this);
        this.latitude.addParameterChangeFailListener(this);
        this.longitude.addParameterChangeFailListener(this);
        this.site = new Site(new Location((Double)this.latitude.getValue(), (Double)this.longitude.getValue()));
        this.parameterEditor = new ParameterListEditor(this.parameterList);
        this.parameterEditor.setTitle(SITE_PARAMS);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.add((Component)this.parameterEditor, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void addSiteParams(Iterator it) {
        while (it.hasNext()) {
            AbstractParameter tempParam = (AbstractParameter)it.next();
            if (!this.parameterList.containsParameter(tempParam)) {
                this.parameterList.addParameter(tempParam);
            }
            if (this.site.containsParameter(tempParam)) continue;
            this.site.addParameter(tempParam);
        }
        this.remove(this.parameterEditor);
        this.parameterEditor = new ParameterListEditor(this.parameterList);
        this.parameterEditor.setTitle(SITE_PARAMS);
        this.add((Component)this.parameterEditor, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void addSiteParamsClone(Iterator it) {
        while (it.hasNext()) {
            AbstractParameter tempParam = (AbstractParameter)it.next();
            if (this.parameterList.containsParameter(tempParam)) continue;
            AbstractParameter cloneParam = (AbstractParameter)tempParam.clone();
            this.parameterList.addParameter(cloneParam);
            this.site.addParameter(cloneParam);
        }
        this.remove(this.parameterEditor);
        this.parameterEditor = new ParameterListEditor(this.parameterList);
        this.parameterEditor.setTitle(SITE_PARAMS);
        this.add((Component)this.parameterEditor, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(4, 4, 4, 4), 0, 0));
    }

    public void replaceSiteParams(Iterator it) {
        this.site = new Site(new Location((Double)this.latitude.getValue(), (Double)this.longitude.getValue()));
        ListIterator<String> siteIt = this.parameterList.getParameterNamesIterator();
        while (siteIt.hasNext()) {
            String paramName = (String)siteIt.next();
            if (paramName.equalsIgnoreCase(LATITUDE) || paramName.equalsIgnoreCase(LONGITUDE)) continue;
            this.parameterList.removeParameter(paramName);
        }
        this.addSiteParams(it);
    }

    public void setSite(Site site) {
        this.site = site;
        ListIterator<Parameter<?>> it = site.getParametersIterator();
        this.replaceSiteParams(it);
    }

    public Site getSite() {
        return this.site;
    }

    public Site getSiteClone() {
        Site newSite = new Site(new Location((Double)this.latitude.getValue(), (Double)this.longitude.getValue()));
        ListIterator<Parameter<?>> it = this.site.getParametersIterator();
        while (it.hasNext()) {
            newSite.addParameter((Parameter)((Parameter)it.next()).clone());
        }
        return this.site;
    }

    @Override
    public void parameterChange(ParameterChangeEvent e) {
        this.site.setLocation(new Location((Double)this.latitude.getValue(), (Double)this.longitude.getValue()));
    }

    @Override
    public void parameterChangeFailed(ParameterChangeFailEvent e) {
        String S = "SiteParamList : parameterChangeFailed(): ";
        StringBuffer b = new StringBuffer();
        Parameter param = (Parameter)e.getSource();
        ParameterConstraint constraint = param.getConstraint();
        String oldValueStr = e.getOldValue().toString();
        String badValueStr = e.getBadValue().toString();
        String name = param.getName();
        b.append("The value ");
        b.append(badValueStr);
        b.append(" is not permitted for '");
        b.append(name);
        b.append("'.\n");
        b.append("Resetting to ");
        b.append(oldValueStr);
        b.append(". The constraints are: \n");
        b.append(constraint.toString());
        JOptionPane.showMessageDialog(this, b.toString(), "Cannot Change Value", 1);
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.setBackground(Color.white);
    }

    public ParameterListEditor getParameterListEditor() {
        return this.parameterEditor;
    }
}

