/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gui.beans;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import javax.swing.JOptionPane;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.region.CaliforniaRegions;
import org.opensha.commons.data.region.SitesInGriddedRegion;
import org.opensha.commons.geo.BorderType;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.Region;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.constraint.ParameterConstraint;
import org.opensha.commons.param.editor.impl.ParameterListEditor;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeFailEvent;
import org.opensha.commons.param.event.ParameterChangeFailListener;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.commons.param.impl.IntegerParameter;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.sha.util.SiteTranslator;

public class SitesInGriddedRegionGuiBean
extends ParameterListEditor
implements ParameterChangeFailListener,
ParameterChangeListener,
Serializable {
    protected static final String C = "SiteParamList";
    public static final String MIN_LONGITUDE = "Min Longitude";
    public static final String MAX_LONGITUDE = "Max Longitude";
    public static final String MIN_LATITUDE = "Min  Latitude";
    public static final String MAX_LATITUDE = "Max  Latitude";
    public static final String GRID_SPACING = "Grid Spacing";
    public static final String SITE_PARAM_NAME = "Set Site Params";
    public static final String REGION_SELECT_NAME = "Region Type/Preset";
    public static final String NUM_SITES_NAME = "Number Of Sites";
    public static final String DEFAULT = "Default ";
    public static final String GRIDDED_SITE_PARAMS = "Set Gridded Region Params";
    ArrayList<Parameter> siteParams = new ArrayList();
    public static final String SET_ALL_SITES = "Apply same site parameter(s) to all locations";
    public static final String USE_SITE_DATA = "Use site data providers";
    private DoubleParameter minLon = new DoubleParameter("Min Longitude", (Double)-360.0, (Double)360.0, (Double)-119.5);
    private DoubleParameter maxLon = new DoubleParameter("Max Longitude", (Double)-360.0, (Double)360.0, (Double)-117.0);
    private DoubleParameter minLat = new DoubleParameter("Min  Latitude", (Double)-90.0, (Double)90.0, (Double)33.5);
    private DoubleParameter maxLat = new DoubleParameter("Max  Latitude", (Double)-90.0, (Double)90.0, (Double)34.7);
    private DoubleParameter gridSpacing = new DoubleParameter("Grid Spacing", (Double)0.001, (Double)1.0, new String("Degrees"), (Double)0.1);
    private IntegerParameter numSites = new IntegerParameter("Number Of Sites");
    private StringParameter siteParam;
    private SiteTranslator siteTrans = new SiteTranslator();
    private SitesInGriddedRegion gridRegion;
    public static final String RECTANGULAR_NAME = "Rectangular Region";
    public static final String CUSTOM_NAME = "Custom Region";
    public static final String RELM_TESTING_NAME = "RELM Testing Region";
    public static final String RELM_COLLECTION_NAME = "RELM Collection Region";
    public static final String SO_CAL_NAME = "Southern California Region";
    public static final String NO_CAL_NAME = "Northern Caliofnia Region";
    ArrayList<Region> presets;
    private StringParameter regionSelect;

    public SitesInGriddedRegionGuiBean(ArrayList<Region> presets) {
        ArrayList<String> presetsStr = new ArrayList<String>();
        presetsStr.add(RECTANGULAR_NAME);
        for (Region preset : presets) {
            presetsStr.add(preset.getName());
        }
        this.presets = presets;
        this.regionSelect = new StringParameter(REGION_SELECT_NAME, presetsStr);
        this.regionSelect.setValue(RECTANGULAR_NAME);
        this.regionSelect.addParameterChangeListener(this);
        this.minLat.addParameterChangeFailListener(this);
        this.minLon.addParameterChangeFailListener(this);
        this.maxLat.addParameterChangeFailListener(this);
        this.maxLon.addParameterChangeFailListener(this);
        this.gridSpacing.addParameterChangeFailListener(this);
        this.minLat.addParameterChangeListener(this);
        this.minLon.addParameterChangeListener(this);
        this.maxLat.addParameterChangeListener(this);
        this.maxLon.addParameterChangeListener(this);
        this.gridSpacing.addParameterChangeListener(this);
        ArrayList<String> siteOptions = new ArrayList<String>();
        siteOptions.add(SET_ALL_SITES);
        siteOptions.add(USE_SITE_DATA);
        this.siteParam = new StringParameter(SITE_PARAM_NAME, siteOptions, (String)siteOptions.get(0));
        this.siteParam.addParameterChangeListener(this);
        this.parameterList = new ParameterList();
        this.parameterList.addParameter(this.regionSelect);
        this.parameterList.addParameter(this.minLon);
        this.parameterList.addParameter(this.maxLon);
        this.parameterList.addParameter(this.minLat);
        this.parameterList.addParameter(this.maxLat);
        this.parameterList.addParameter(this.gridSpacing);
        this.parameterList.addParameter(this.numSites);
        this.parameterList.addParameter(this.siteParam);
        this.updateNumSites();
        this.editorPanel.removeAll();
        this.addParameters();
        this.createAndUpdateSites();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public SitesInGriddedRegionGuiBean() {
        this(SitesInGriddedRegionGuiBean.generateDefaultRegions());
    }

    public static ArrayList<Region> generateDefaultRegions() {
        ArrayList<Region> regions = new ArrayList<Region>();
        Region region = new Region(new CaliforniaRegions.RELM_TESTING().getBorder(), BorderType.MERCATOR_LINEAR);
        region.setName(RELM_TESTING_NAME);
        regions.add(region);
        region = new Region(new CaliforniaRegions.RELM_COLLECTION().getBorder(), BorderType.MERCATOR_LINEAR);
        region.setName(RELM_COLLECTION_NAME);
        regions.add(region);
        region = new Region(new CaliforniaRegions.RELM_SOCAL().getBorder(), BorderType.MERCATOR_LINEAR);
        region.setName(SO_CAL_NAME);
        regions.add(region);
        region = new Region(new CaliforniaRegions.RELM_NOCAL().getBorder(), BorderType.MERCATOR_LINEAR);
        region.setName(NO_CAL_NAME);
        regions.add(region);
        return regions;
    }

    private void reloadSiteParams() {
        boolean useData = this.isUseSiteData();
        ListIterator<Parameter<?>> it = this.parameterList.getParametersIterator();
        while (it.hasNext()) {
            Parameter param = (Parameter)it.next();
            if (!this.isSiteParam(param)) continue;
            this.parameterList.removeParameter(param);
            String name = param.getName();
            if (useData) {
                if (!name.startsWith(DEFAULT)) {
                    param.setName(DEFAULT + name);
                }
            } else if (name.startsWith(DEFAULT)) {
                param.setName(name.replaceFirst(DEFAULT, ""));
            }
            System.out.println("Reloaded: " + name);
            this.parameterList.addParameter(param);
        }
        for (Parameter param : this.siteParams) {
            if (this.parameterList.containsParameter(param) || !this.isSiteParam(param)) continue;
            String name = param.getName();
            if (useData) {
                if (!name.startsWith(DEFAULT)) {
                    param.setName(DEFAULT + name);
                }
            } else if (name.startsWith(DEFAULT)) {
                param.setName(name.replaceFirst(DEFAULT, ""));
            }
            this.parameterList.addParameter(param);
        }
        this.refreshParamEditor();
        this.editorPanel.removeAll();
        this.addParameters();
        this.editorPanel.validate();
        this.editorPanel.repaint();
        this.setTitle(GRIDDED_SITE_PARAMS);
    }

    public void replaceSiteParams(Iterator<Parameter<?>> it) {
        Parameter param;
        boolean useData = this.isUseSiteData();
        ListIterator<Parameter<?>> siteIt = this.parameterList.getParametersIterator();
        while (siteIt.hasNext()) {
            param = (Parameter)siteIt.next();
            if (!this.isSiteParam(param)) continue;
            this.parameterList.removeParameter(param);
            System.out.println("Removed: " + param.getName());
        }
        this.siteParams.clear();
        while (it.hasNext()) {
            param = (Parameter)it.next().clone();
            String name = param.getName();
            if (useData) {
                if (!name.startsWith(DEFAULT)) {
                    param.setName(DEFAULT + name);
                }
            } else if (name.startsWith(DEFAULT)) {
                param.setName(name.replaceFirst(DEFAULT, ""));
            }
            this.parameterList.addParameter(param);
            this.siteParams.add(param);
            System.out.println("Added: " + param.getName());
        }
        this.editorPanel.removeAll();
        this.addParameters();
        this.editorPanel.validate();
        this.editorPanel.repaint();
        this.setTitle(GRIDDED_SITE_PARAMS);
    }

    public Iterator<Site> getSitesClone() {
        Iterator lIt = this.gridRegion.getRegion().getNodeList().iterator();
        ArrayList<Site> newSiteVector = new ArrayList<Site>();
        while (lIt.hasNext()) {
            newSiteVector.add(new Site((Location)lIt.next()));
        }
        ListIterator<Parameter<?>> it = this.parameterList.getParametersIterator();
        while (it.hasNext()) {
            Parameter<?> tempParam = it.next();
            for (int i = 0; i < newSiteVector.size(); ++i) {
                if (((Site)newSiteVector.get(i)).containsParameter(tempParam)) continue;
                ((Site)newSiteVector.get(i)).addParameter((Parameter)tempParam.clone());
            }
        }
        return newSiteVector.iterator();
    }

    private void updateGriddedSiteParams() {
        ArrayList<Parameter> v = new ArrayList<Parameter>();
        this.createAndUpdateSites();
        Iterator<Parameter> it = this.siteParams.iterator();
        while (it.hasNext()) {
            v.add(it.next());
        }
        this.gridRegion.addSiteParams(v.iterator());
    }

    public ArrayList<Parameter> getSiteParams() {
        return this.siteParams;
    }

    @Override
    public void parameterChangeFailed(ParameterChangeFailEvent e) {
        String S = "SiteParamList : parameterChangeFailed(): ";
        StringBuffer b = new StringBuffer();
        Parameter param = (Parameter)e.getSource();
        ParameterConstraint constraint = param.getConstraint();
        String oldValueStr = e.getOldValue().toString();
        String badValueStr = e.getBadValue().toString();
        String name = param.getName();
        b.append("The value ");
        b.append(badValueStr);
        b.append(" is not permitted for '");
        b.append(name);
        b.append("'.\n");
        b.append("Resetting to ");
        b.append(oldValueStr);
        b.append(". The constraints are: \n");
        b.append(constraint.toString());
        JOptionPane.showMessageDialog(this, b.toString(), "Cannot Change Value", 1);
    }

    private boolean updateNumSites() {
        try {
            this.createAndUpdateSites();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.gridRegion != null) {
            this.numSites.setValue(this.gridRegion.getRegion().getNodeCount());
            LocationList locs = this.gridRegion.getRegion().getBorder();
            for (int i = 0; i < locs.size(); ++i) {
                Location loc = (Location)locs.get(i);
                System.out.println(loc.getLatitude() + " " + loc.getLongitude());
            }
            return true;
        }
        return false;
    }

    @Override
    public void parameterChange(ParameterChangeEvent e) {
        Parameter param = (Parameter)e.getSource();
        boolean update = false;
        if (param == this.regionSelect || param == this.minLat || param == this.maxLat || param == this.minLon || param == this.maxLon || param == this.gridSpacing) {
            update = this.updateNumSites();
        }
        if (param.getName().equals(SITE_PARAM_NAME)) {
            this.reloadSiteParams();
        } else if (param == this.regionSelect || update) {
            String name = (String)this.regionSelect.getValue();
            this.parameterList.clear();
            this.parameterList.addParameter(this.regionSelect);
            if (name.equals(RECTANGULAR_NAME)) {
                this.parameterList.addParameter(this.minLon);
                this.parameterList.addParameter(this.maxLon);
                this.parameterList.addParameter(this.minLat);
                this.parameterList.addParameter(this.maxLat);
            } else if (name.equals(CUSTOM_NAME)) {
                // empty if block
            }
            this.parameterList.addParameter(this.gridSpacing);
            this.parameterList.addParameter(this.numSites);
            this.parameterList.addParameter(this.siteParam);
            this.reloadSiteParams();
            this.refreshParamEditor();
            this.editorPanel.removeAll();
            this.addParameters();
            this.editorPanel.validate();
            this.editorPanel.repaint();
        }
    }

    private void createAndUpdateSites() {
        if (this.regionSelect == null) {
            System.out.println("REGION SELECT NULL");
        }
        if (this.regionSelect.getValue() == null) {
            System.out.println("REGION SELECT VALUE NULL");
        }
        String name = (String)this.regionSelect.getValue();
        double gridSpacingD = (Double)this.gridSpacing.getValue();
        if (name.equalsIgnoreCase(RECTANGULAR_NAME)) {
            double minLatitude = (Double)this.minLat.getValue();
            double maxLatitude = (Double)this.maxLat.getValue();
            double minLongitude = (Double)this.minLon.getValue();
            double maxLongitude = (Double)this.maxLon.getValue();
            GriddedRegion eggr = new GriddedRegion(new Location(minLatitude, minLongitude), new Location(maxLatitude, maxLongitude), gridSpacingD, new Location(0.0, 0.0));
            this.gridRegion = new SitesInGriddedRegion(eggr);
        } else {
            for (Region region : this.presets) {
                if (!name.equals(region.getName())) continue;
                GriddedRegion eggr = new GriddedRegion(region.getBorder(), BorderType.MERCATOR_LINEAR, gridSpacingD, new Location(0.0, 0.0));
                this.gridRegion = new SitesInGriddedRegion(eggr);
                break;
            }
        }
    }

    public boolean isUseSiteData() {
        return ((String)this.siteParam.getValue()).equals(USE_SITE_DATA);
    }

    public SitesInGriddedRegion getGriddedRegionSite() {
        this.updateGriddedSiteParams();
        return this.gridRegion;
    }

    private boolean isSiteParam(Parameter param) {
        String name = param.getName();
        if (name.equalsIgnoreCase(MAX_LATITUDE)) {
            return false;
        }
        if (name.equalsIgnoreCase(MIN_LATITUDE)) {
            return false;
        }
        if (name.equalsIgnoreCase(MAX_LONGITUDE)) {
            return false;
        }
        if (name.equalsIgnoreCase(MIN_LONGITUDE)) {
            return false;
        }
        if (name.equalsIgnoreCase(GRID_SPACING)) {
            return false;
        }
        if (name.equalsIgnoreCase(SITE_PARAM_NAME)) {
            return false;
        }
        if (name.equalsIgnoreCase(REGION_SELECT_NAME)) {
            return false;
        }
        return !name.equalsIgnoreCase(NUM_SITES_NAME);
    }
}

