/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gui.controls;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.opensha.commons.gui.ControlPanel;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.constraint.ParameterConstraint;
import org.opensha.commons.param.event.ParameterChangeFailEvent;
import org.opensha.commons.param.event.ParameterChangeFailListener;
import org.opensha.sha.gui.HazardCurveApplication;

public class ERF_EpistemicListControlPanel
extends ControlPanel
implements ParameterChangeFailListener {
    public static final String NAME = "Epistemic List Control";
    private JCheckBox allCurvesCheckBox = new JCheckBox();
    private JComboBox fractileComboBox = new JComboBox();
    public static final String NO_PERCENTILE = "No Fractiles";
    public static final String CUSTOM_FRACTILE = "Plot Fractiles";
    HazardCurveApplication api;
    private JCheckBox avgCheckBox = new JCheckBox();
    private JScrollPane fractileScrollPane = new JScrollPane();
    private JTextArea fractilesTextArea = new JTextArea();
    private ArrayList<Double> fractileValues;
    private JButton updateFractileButton = new JButton();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JFrame frame;
    private Component parentComponent;

    public ERF_EpistemicListControlPanel(HazardCurveApplication api, Component parentComponent) {
        super(NAME);
        this.api = api;
        this.parentComponent = parentComponent;
    }

    @Override
    public void doinit() {
        try {
            this.frame = new JFrame();
            this.jbInit();
            this.initFractileCombo();
            this.frame.setLocation(this.parentComponent.getX() + this.parentComponent.getWidth() / 2, this.parentComponent.getY() + this.parentComponent.getHeight() / 2);
            this.api.setFractileOption(this.fractileComboBox.getSelectedItem().toString());
            this.api.setAverageSelected(this.avgCheckBox.isSelected());
            this.api.setPlotAllCurves(this.allCurvesCheckBox.isSelected());
            this.api.setFractileOption(this.fractileComboBox.getSelectedItem().toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<Double> defaultFractileValues = new ArrayList<Double>();
        defaultFractileValues.add(0.05);
        defaultFractileValues.add(0.5);
        defaultFractileValues.add(0.95);
        this.setCustomFractileValues(defaultFractileValues);
    }

    private void jbInit() throws Exception {
        this.allCurvesCheckBox.setActionCommand("Plot all curves (in one color)");
        this.allCurvesCheckBox.setSelected(true);
        this.allCurvesCheckBox.setText("Plot all curves (in one color)");
        this.allCurvesCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ERF_EpistemicListControlPanel.this.allCurvesCheckBox_actionPerformed(e);
            }
        });
        this.frame.setDefaultCloseOperation(1);
        this.frame.setTitle(NAME);
        this.frame.getContentPane().setLayout(this.gridBagLayout1);
        this.fractileComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ERF_EpistemicListControlPanel.this.fractileComboBox_actionPerformed(e);
            }
        });
        this.avgCheckBox.setText("Plot Average");
        this.avgCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ERF_EpistemicListControlPanel.this.avgCheckBox_actionPerformed(e);
            }
        });
        this.updateFractileButton.setText("Update Fractile List");
        this.updateFractileButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ERF_EpistemicListControlPanel.this.updateFractileButton_actionPerformed(e);
            }
        });
        this.frame.getContentPane().add((Component)this.fractileComboBox, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(7, 11, 0, 20), 94, 0));
        this.frame.getContentPane().add((Component)this.fractileScrollPane, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(14, 17, 0, 29), 214, 15));
        this.frame.getContentPane().add((Component)this.updateFractileButton, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 0, new Insets(15, 35, 19, 45), 30, 8));
        this.frame.getContentPane().add((Component)this.allCurvesCheckBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(14, 11, 0, 34), 28, 0));
        this.frame.getContentPane().add((Component)this.avgCheckBox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 11, 0, 34), 125, 0));
        this.fractileScrollPane.getViewport().add((Component)this.fractilesTextArea, null);
        this.frame.setSize(new Dimension(270, 210));
    }

    private void initFractileCombo() {
        this.fractileComboBox.addItem(NO_PERCENTILE);
        this.fractileComboBox.addItem(CUSTOM_FRACTILE);
    }

    @Override
    public void parameterChangeFailed(ParameterChangeFailEvent e) {
        StringBuffer b = new StringBuffer();
        Parameter param = (Parameter)e.getSource();
        ParameterConstraint constraint = param.getConstraint();
        String oldValueStr = e.getOldValue().toString();
        String badValueStr = e.getBadValue().toString();
        String name = param.getName();
        b.append("The value ");
        b.append(badValueStr);
        b.append(" is not permitted for '");
        b.append(name);
        b.append("'.\n");
        b.append("Resetting to ");
        b.append(oldValueStr);
        b.append(". The constraints are: \n");
        b.append(constraint.toString());
        JOptionPane.showMessageDialog(this.frame, b.toString(), "Cannot Change Value", 1);
    }

    void fractileComboBox_actionPerformed(ActionEvent e) {
        String selected = this.fractileComboBox.getSelectedItem().toString();
        if (selected.equalsIgnoreCase(NO_PERCENTILE)) {
            this.fractileScrollPane.setVisible(false);
            this.updateFractileButton.setVisible(false);
            this.frame.setSize(new Dimension(270, 210));
        } else if (selected.equalsIgnoreCase(CUSTOM_FRACTILE)) {
            this.frame.setSize(new Dimension(270, 492));
            this.fractileScrollPane.setVisible(true);
            this.updateFractileButton.setVisible(true);
            this.setValuesInFractileTextArea();
        }
        this.api.setFractileOption(selected);
    }

    public void setCustomFractileValues(ArrayList<Double> values) {
        this.fractileValues = values;
    }

    void allCurvesCheckBox_actionPerformed(ActionEvent e) {
        this.api.setPlotAllCurves(this.allCurvesCheckBox.isSelected());
    }

    void avgCheckBox_actionPerformed(ActionEvent e) {
        this.api.setAverageSelected(this.avgCheckBox.isSelected());
    }

    void updateFractileButton_actionPerformed(ActionEvent e) {
        boolean errorFlag = false;
        try {
            this.setCustomFractileValues();
            if (this.fractilesTextArea.getText().trim().equalsIgnoreCase("")) {
                JOptionPane.showMessageDialog(this.frame, "Must enter Fractile values", "Invalid Entry", 0);
                errorFlag = true;
            }
        }
        catch (NumberFormatException ee) {
            errorFlag = true;
            JOptionPane.showMessageDialog(this.frame, ee.getMessage(), "Invalid Entry", 0);
        }
        catch (RuntimeException ee) {
            errorFlag = true;
            JOptionPane.showMessageDialog(this.frame, ee.getMessage(), "Invalid Entry", 0);
        }
        if (!errorFlag) {
            this.frame.setVisible(false);
        }
    }

    private void setCustomFractileValues() {
        String str = this.fractilesTextArea.getText();
        StringTokenizer st = new StringTokenizer(str, "\n");
        this.fractileValues.clear();
        while (st.hasMoreTokens()) {
            double fractileVal = Double.valueOf(st.nextToken().trim());
            if (fractileVal < 1.0 && fractileVal > 0.0) {
                this.fractileValues.add(fractileVal);
                continue;
            }
            throw new RuntimeException("Fractile value must  be between 0 and 1");
        }
    }

    private void setValuesInFractileTextArea() {
        Object fractileVals = "";
        int size = this.fractileValues.size();
        for (int i = 0; i < size; ++i) {
            fractileVals = (String)fractileVals + String.valueOf(this.fractileValues.get(i)) + "\n";
        }
        this.fractilesTextArea.setText((String)fractileVals);
    }

    public ArrayList<Double> getSelectedFractileValues() {
        return this.fractileValues;
    }

    @Override
    public Window getComponent() {
        return this.frame;
    }
}

