/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gui.controls;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import org.opensha.commons.geo.Location;
import org.opensha.commons.gui.ControlPanel;
import org.opensha.sha.gui.beans.Site_GuiBean;
import org.opensha.sha.util.NEHRP_TestCity;

public class SitesOfInterestControlPanel
extends ControlPanel {
    public static final String NAME = "Sites of Interest";
    private JLabel jLabel1 = new JLabel();
    private JComboBox sitesComboBox = new JComboBox();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private ArrayList<Double> latVector;
    private ArrayList<Double> lonVector;
    private Site_GuiBean siteGuiBean;
    private Component parent;
    private JFrame frame;

    public SitesOfInterestControlPanel(Component parent, Site_GuiBean siteGuiBean) {
        super(NAME);
        this.parent = parent;
        this.siteGuiBean = siteGuiBean;
    }

    @Override
    public void doinit() {
        this.frame = new JFrame();
        try {
            this.latVector = new ArrayList();
            this.lonVector = new ArrayList();
            for (NEHRP_TestCity city : NEHRP_TestCity.getShortListCA()) {
                this.sitesComboBox.addItem("NEHRP city: " + city.toString());
                Location loc = city.location();
                this.latVector.add(loc.getLatitude());
                this.lonVector.add(loc.getLongitude());
            }
            this.sitesComboBox.addItem("GEM test site");
            this.latVector.add(40.0);
            this.lonVector.add(70.0);
            this.sitesComboBox.addItem("Los Angeles Civic Center");
            this.latVector.add(34.055);
            this.lonVector.add(-118.2467);
            this.sitesComboBox.addItem("San Francisco City Hall");
            this.latVector.add(37.775);
            this.lonVector.add(-122.4183);
            this.sitesComboBox.addItem("San Francisco Class B");
            this.latVector.add(37.8);
            this.lonVector.add(-122.417);
            this.sitesComboBox.addItem("San Francisco Class D");
            this.latVector.add(37.783);
            this.lonVector.add(-122.417);
            this.sitesComboBox.addItem("Sierra Madre Fault Gap");
            this.latVector.add(34.225);
            this.lonVector.add(-117.835);
            this.sitesComboBox.addItem("Alaskan Pipeline");
            this.latVector.add(63.375);
            this.lonVector.add(-145.825);
            this.sitesComboBox.addItem("Santiago, Chile");
            this.latVector.add(-33.45);
            this.lonVector.add(-70.6666667);
            this.jbInit();
            this.frame.setLocation(this.parent.getX() + this.parent.getWidth() / 2, this.parent.getY() + this.parent.getHeight() / 2);
            this.setLatAndLon();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.jLabel1.setFont(new Font("Dialog", 1, 12));
        this.jLabel1.setForeground(Color.black);
        this.jLabel1.setText("Choose Site:");
        this.frame.getContentPane().setLayout(this.gridBagLayout1);
        this.frame.setTitle("Sites Of Interest");
        this.sitesComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SitesOfInterestControlPanel.this.sitesComboBox_actionPerformed(e);
            }
        });
        this.frame.getContentPane().add((Component)this.sitesComboBox, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(14, 6, 10, 12), 149, 2));
        this.frame.getContentPane().add((Component)this.jLabel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(14, 5, 10, 0), 13, 11));
    }

    void sitesComboBox_actionPerformed(ActionEvent e) {
        this.setLatAndLon();
    }

    private void setLatAndLon() {
        int index = this.sitesComboBox.getSelectedIndex();
        this.siteGuiBean.getParameterListEditor().getParameterList().getParameter("Latitude").setValue(this.latVector.get(index));
        this.siteGuiBean.getParameterListEditor().getParameterList().getParameter("Longitude").setValue(this.lonVector.get(index));
        this.siteGuiBean.getParameterListEditor().refreshParamEditor();
    }

    @Override
    public Window getComponent() {
        return this.frame;
    }
}

