/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gui.controls;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.gui.ControlPanel;
import org.opensha.sha.gui.controls.CurveDisplayAppAPI;
import org.opensha.sha.gui.infoTools.IMT_Info;

public class X_ValuesInCurveControlPanel
extends ControlPanel {
    public static final String NAME = "Set X values for Hazard Curve Calc.";
    public static final String PEER_X_VALUES = "PEER Test-Case Values";
    public static final String USGS_PGA_X_VALUES = "USGS-2002 PGA Values";
    public static final String USGS_SA_01_AND_02_X_VALUES = "USGS-2002 SA Values for 0.1 and 0.2sec";
    public static final String USGS_SA_X_VALUES = "USGS-2002 SA 0.3,0.4,0.5 and 1.0 Values";
    public static final String CUSTOM_VALUES = "Custom Values";
    public static final String DEFAULT = "DEFAULT";
    public static final String MIN_MAX_NUM = "Enter Min, Max and Num";
    private JPanel jPanel1 = new JPanel();
    private JLabel xValuesLabel = new JLabel();
    private JScrollPane xValuesScrollPane = new JScrollPane();
    private JTextArea xValuesText = new JTextArea();
    ArbitrarilyDiscretizedFunc function;
    private JButton doneButton = new JButton();
    private JComboBox xValuesSelectionCombo = new JComboBox();
    private JLabel minLabel = new JLabel();
    private JLabel maxLabel = new JLabel();
    private JLabel numLabel = new JLabel();
    private JTextField minText = new JTextField();
    private JTextField maxText = new JTextField();
    private JTextField numText = new JTextField();
    private JButton setButton = new JButton();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private BorderLayout borderLayout1 = new BorderLayout();
    private DecimalFormat format = new DecimalFormat("0.000000##");
    CurveDisplayAppAPI api;
    private String imt;
    private Component parent;
    private JFrame frame;

    public X_ValuesInCurveControlPanel(Component parent, CurveDisplayAppAPI api) {
        super(NAME);
        this.api = api;
        this.parent = parent;
    }

    @Override
    public void doinit() {
        this.frame = new JFrame();
        this.imt = this.api.getSelectedIMT();
        try {
            this.jbInit();
            this.frame.setLocation(this.parent.getX() + this.parent.getWidth() / 2, this.parent.getY());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.format.setMaximumFractionDigits(6);
        this.generateXValues();
    }

    private void jbInit() throws Exception {
        this.xValuesLabel.setHorizontalAlignment(0);
        this.xValuesLabel.setHorizontalTextPosition(0);
        this.doneButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                X_ValuesInCurveControlPanel.this.doneButton_actionPerformed(e);
            }
        });
        this.minLabel.setForeground(Color.black);
        this.minLabel.setText("Min :");
        this.maxLabel.setForeground(Color.black);
        this.maxLabel.setText("Max :");
        this.numLabel.setForeground(Color.black);
        this.numLabel.setText("Num :");
        this.setButton.setText("Set Values");
        this.setButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                X_ValuesInCurveControlPanel.this.setButton_actionPerformed(e);
            }
        });
        this.xValuesSelectionCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                X_ValuesInCurveControlPanel.this.xValuesSelectionCombo_actionPerformed(e);
            }
        });
        this.frame.getContentPane().setLayout(this.borderLayout1);
        this.jPanel1.setMinimumSize(new Dimension(300, 350));
        this.jPanel1.setPreferredSize(new Dimension(340, 430));
        this.frame.setDefaultCloseOperation(2);
        this.frame.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel1.setLayout(this.gridBagLayout1);
        this.jPanel1.add((Component)this.xValuesLabel, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 17, 0, new Insets(6, 15, 0, 68), 7, 0));
        this.jPanel1.add((Component)this.xValuesScrollPane, new GridBagConstraints(0, 2, 1, 5, 1.0, 1.0, 10, 1, new Insets(17, 28, 15, 0), 87, 400));
        this.jPanel1.add((Component)this.xValuesSelectionCombo, new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 10, 2, new Insets(9, 15, 0, 74), 94, 0));
        this.xValuesScrollPane.getViewport().add((Component)this.xValuesText, null);
        this.jPanel1.add((Component)this.numLabel, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(9, 35, 0, 0), 10, 9));
        this.jPanel1.add((Component)this.minText, new GridBagConstraints(2, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(54, 0, 0, 26), 84, 9));
        this.jPanel1.add((Component)this.maxText, new GridBagConstraints(2, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(11, 0, 0, 26), 84, 9));
        this.jPanel1.add((Component)this.numText, new GridBagConstraints(2, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(8, 0, 0, 26), 84, 9));
        this.jPanel1.add((Component)this.doneButton, new GridBagConstraints(1, 6, 2, 1, 0.0, 0.0, 10, 0, new Insets(100, 30, 20, 68), 12, 20));
        this.jPanel1.add((Component)this.maxLabel, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(12, 35, 0, 0), 13, 9));
        this.jPanel1.add((Component)this.setButton, new GridBagConstraints(1, 5, 2, 1, 0.0, 0.0, 10, 0, new Insets(23, 70, 0, 26), 2, 4));
        this.jPanel1.add((Component)this.minLabel, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(56, 35, 0, 0), 13, 9));
        this.frame.setTitle("X Values Control Panel");
        this.xValuesText.setBackground(Color.white);
        this.xValuesText.setForeground(Color.black);
        this.xValuesText.setLineWrap(false);
        this.xValuesLabel.setBackground(new Color(200, 200, 230));
        this.xValuesLabel.setForeground(Color.black);
        this.xValuesLabel.setText("X-axis (IML) Values for Hazard Curves");
        this.doneButton.setText("Done");
        this.frame.setSize(new Dimension(400, 400));
        this.xValuesSelectionCombo.addItem(DEFAULT);
        this.xValuesSelectionCombo.addItem(CUSTOM_VALUES);
        this.xValuesSelectionCombo.addItem(MIN_MAX_NUM);
        this.xValuesSelectionCombo.addItem(PEER_X_VALUES);
        this.xValuesSelectionCombo.addItem(USGS_PGA_X_VALUES);
        this.xValuesSelectionCombo.addItem(USGS_SA_01_AND_02_X_VALUES);
        this.xValuesSelectionCombo.addItem(USGS_SA_X_VALUES);
        this.xValuesSelectionCombo.setSelectedItem(DEFAULT);
    }

    private void createPEER_Function() {
        this.function = new ArbitrarilyDiscretizedFunc();
        this.function.set(0.001, 1.0);
        this.function.set(0.01, 1.0);
        this.function.set(0.05, 1.0);
        this.function.set(0.1, 1.0);
        this.function.set(0.15, 1.0);
        this.function.set(0.2, 1.0);
        this.function.set(0.25, 1.0);
        this.function.set(0.3, 1.0);
        this.function.set(0.35, 1.0);
        this.function.set(0.4, 1.0);
        this.function.set(0.45, 1.0);
        this.function.set(0.5, 1.0);
        this.function.set(0.55, 1.0);
        this.function.set(0.6, 1.0);
        this.function.set(0.7, 1.0);
        this.function.set(0.8, 1.0);
        this.function.set(0.9, 1.0);
        this.function.set(1.0, 1.0);
    }

    private void createUSGS_PGA_Function() {
        this.function = new ArbitrarilyDiscretizedFunc();
        this.function.set(0.005, 1.0);
        this.function.set(0.007, 1.0);
        this.function.set(0.0098, 1.0);
        this.function.set(0.0137, 1.0);
        this.function.set(0.0192, 1.0);
        this.function.set(0.0269, 1.0);
        this.function.set(0.0376, 1.0);
        this.function.set(0.0527, 1.0);
        this.function.set(0.0738, 1.0);
        this.function.set(0.103, 1.0);
        this.function.set(0.145, 1.0);
        this.function.set(0.203, 1.0);
        this.function.set(0.284, 1.0);
        this.function.set(0.397, 1.0);
        this.function.set(0.556, 1.0);
        this.function.set(0.778, 1.0);
        this.function.set(1.09, 1.0);
        this.function.set(1.52, 1.0);
        this.function.set(2.13, 1.0);
    }

    private void createUSGS_SA_01_AND_02_Function() {
        this.function = new ArbitrarilyDiscretizedFunc();
        this.function.set(0.005, 1.0);
        this.function.set(0.0075, 1.0);
        this.function.set(0.0113, 1.0);
        this.function.set(0.0169, 1.0);
        this.function.set(0.0253, 1.0);
        this.function.set(0.038, 1.0);
        this.function.set(0.057, 1.0);
        this.function.set(0.0854, 1.0);
        this.function.set(0.128, 1.0);
        this.function.set(0.192, 1.0);
        this.function.set(0.288, 1.0);
        this.function.set(0.432, 1.0);
        this.function.set(0.649, 1.0);
        this.function.set(0.973, 1.0);
        this.function.set(1.46, 1.0);
        this.function.set(2.19, 1.0);
        this.function.set(3.28, 1.0);
        this.function.set(4.92, 1.0);
        this.function.set(7.38, 1.0);
    }

    private void createUSGS_SA_Function() {
        this.function = new ArbitrarilyDiscretizedFunc();
        this.function.set(0.0025, 1.0);
        this.function.set(0.00375, 1.0);
        this.function.set(0.00563, 1.0);
        this.function.set(0.00844, 1.0);
        this.function.set(0.0127, 1.0);
        this.function.set(0.019, 1.0);
        this.function.set(0.0285, 1.0);
        this.function.set(0.0427, 1.0);
        this.function.set(0.0641, 1.0);
        this.function.set(0.0961, 1.0);
        this.function.set(0.144, 1.0);
        this.function.set(0.216, 1.0);
        this.function.set(0.324, 1.0);
        this.function.set(0.487, 1.0);
        this.function.set(0.73, 1.0);
        this.function.set(1.09, 1.0);
        this.function.set(1.64, 1.0);
        this.function.set(2.46, 1.0);
        this.function.set(3.69, 1.0);
        this.function.set(5.54, 1.0);
    }

    private void createFunctionFromMinMaxNum() {
        this.function = new ArbitrarilyDiscretizedFunc();
        try {
            int numIMT_Vals = (int)Double.parseDouble(this.numText.getText().trim());
            double minIMT_Val = Double.parseDouble(this.minText.getText().trim());
            double maxIMT_Val = Double.parseDouble(this.maxText.getText().trim());
            if (minIMT_Val >= maxIMT_Val) {
                JOptionPane.showMessageDialog(this.frame, "Min Val should be less than Max Val", "Incorrect Input", 0);
                return;
            }
            double discretizationIMT = (Math.log(maxIMT_Val) - Math.log(minIMT_Val)) / (double)(numIMT_Vals - 1);
            for (int i = 0; i < numIMT_Vals; ++i) {
                double xVal = Double.parseDouble(this.format.format(Math.exp(Math.log(minIMT_Val) + (double)i * discretizationIMT)));
                this.function.set(xVal, 1.0);
            }
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(this.frame, "Must enter a Valid Number", "Incorrect Input", 0);
            return;
        }
        catch (NullPointerException e) {
            JOptionPane.showMessageDialog(this.frame, "Null not allowed, must enter a valid number", "Incorrect Input", 0);
            return;
        }
    }

    public void useDefaultX_Values() {
        this.xValuesSelectionCombo.setSelectedItem(DEFAULT);
        this.frame.repaint();
        this.frame.validate();
    }

    public void setX_Values(ArbitrarilyDiscretizedFunc func) {
        Iterator<Double> lt = func.getXValuesIterator();
        this.xValuesSelectionCombo.setSelectedItem(CUSTOM_VALUES);
        Object st = new String("");
        while (lt.hasNext()) {
            st = (String)st + lt.next().toString().trim() + "\n";
        }
        this.xValuesText.setText((String)st);
        this.frame.repaint();
        this.frame.validate();
    }

    private void setX_Values() {
        Iterator<Double> lt = this.function.getXValuesIterator();
        Object st = new String("");
        while (lt.hasNext()) {
            st = (String)st + lt.next().toString().trim() + "\n";
        }
        this.xValuesText.setText((String)st);
    }

    private void getX_Values() throws NumberFormatException, RuntimeException {
        this.function = new ArbitrarilyDiscretizedFunc();
        String str = this.xValuesText.getText();
        StringTokenizer st = new StringTokenizer(str, "\n");
        while (st.hasMoreTokens()) {
            double tempX_Val;
            double previousTempX_Val = tempX_Val = 0.0;
            try {
                tempX_Val = Double.valueOf(st.nextToken().trim());
                if (tempX_Val < previousTempX_Val) {
                    throw new RuntimeException("X Values must be entered in increasing  order");
                }
            }
            catch (NumberFormatException e) {
                throw new NumberFormatException("X Values entered must be a valid number");
            }
            this.function.set(tempX_Val, 1.0);
        }
    }

    private void closeWindow() {
        boolean flag = false;
        try {
            this.getX_Values();
            if (this.xValuesText.getText().trim().equalsIgnoreCase("")) {
                JOptionPane.showMessageDialog(this.frame, "Must enter X values", "Invalid Entry", 0);
                flag = true;
            }
        }
        catch (NumberFormatException ee) {
            JOptionPane.showMessageDialog(this.frame, ee.getMessage(), "Invalid Entry", 0);
            flag = true;
        }
        catch (RuntimeException eee) {
            JOptionPane.showMessageDialog(this.frame, eee.getMessage(), "Invalid Entry", 0);
            flag = true;
        }
        if (!flag) {
            if (!this.xValuesSelectionCombo.getSelectedItem().equals(DEFAULT)) {
                this.api.setCurveXValues(this.function);
            } else {
                this.api.setCurveXValues();
            }
            this.frame.dispose();
        }
    }

    void doneButton_actionPerformed(ActionEvent e) {
        this.closeWindow();
    }

    void xValuesSelectionCombo_actionPerformed(ActionEvent e) {
        block9: {
            String selectedItem;
            block10: {
                block8: {
                    block7: {
                        selectedItem = (String)this.xValuesSelectionCombo.getSelectedItem();
                        if (selectedItem.equals(PEER_X_VALUES) || selectedItem.equals(USGS_PGA_X_VALUES)) break block7;
                        if (selectedItem.equals(CUSTOM_VALUES)) break block7;
                        if (selectedItem.equals(USGS_SA_01_AND_02_X_VALUES)) break block7;
                        if (!selectedItem.equals(USGS_SA_X_VALUES)) break block8;
                    }
                    this.maxLabel.setVisible(false);
                    this.minLabel.setVisible(false);
                    this.numLabel.setVisible(false);
                    this.maxText.setVisible(false);
                    this.minText.setVisible(false);
                    this.numText.setVisible(false);
                    this.setButton.setVisible(false);
                    this.xValuesText.setEditable(false);
                    if (selectedItem.equals(CUSTOM_VALUES)) {
                        this.xValuesText.setEditable(true);
                    }
                    break block9;
                }
                if (selectedItem.equals(DEFAULT)) break block10;
                if (!selectedItem.equals(MIN_MAX_NUM)) break block9;
            }
            this.maxLabel.setVisible(true);
            this.minLabel.setVisible(true);
            this.numLabel.setVisible(true);
            this.maxText.setVisible(true);
            this.minText.setVisible(true);
            this.numText.setVisible(true);
            this.setButton.setVisible(true);
            this.xValuesText.setEditable(false);
            if (selectedItem.equals(DEFAULT)) {
                this.setButton.setVisible(false);
                this.minText.setEditable(false);
                this.maxText.setEditable(false);
                this.numText.setEditable(false);
            }
            if (selectedItem.equals(MIN_MAX_NUM)) {
                this.minText.setEditable(true);
                this.maxText.setEditable(true);
                this.numText.setEditable(true);
            }
        }
        this.generateXValues();
    }

    private void generateXValues() {
        String selectedItem = (String)this.xValuesSelectionCombo.getSelectedItem();
        if (selectedItem.equals(PEER_X_VALUES)) {
            this.createPEER_Function();
            this.setX_Values();
        } else if (selectedItem.equals(USGS_PGA_X_VALUES)) {
            this.createUSGS_PGA_Function();
            this.setX_Values();
        } else if (selectedItem.equals(USGS_SA_01_AND_02_X_VALUES)) {
            this.createUSGS_SA_01_AND_02_Function();
            this.setX_Values();
        } else if (selectedItem.equals(USGS_SA_X_VALUES)) {
            this.createUSGS_SA_Function();
            this.setX_Values();
        } else if (selectedItem.equals(DEFAULT)) {
            this.imt = this.api.getSelectedIMT();
            this.minText.setText("" + IMT_Info.getMinIMT_Val(this.imt));
            this.maxText.setText("" + IMT_Info.getMaxIMT_Val(this.imt));
            this.numText.setText("" + IMT_Info.getNumIMT_Val(this.imt));
            IMT_Info defaultX_Vals = new IMT_Info();
            this.function = defaultX_Vals.getDefaultHazardCurve(this.imt);
            this.setX_Values();
        } else if (selectedItem.equals(MIN_MAX_NUM)) {
            this.xValuesText.setText("");
        } else if (selectedItem.equals(CUSTOM_VALUES)) {
            this.xValuesText.setText("");
        }
    }

    void setButton_actionPerformed(ActionEvent e) {
        this.createFunctionFromMinMaxNum();
        this.setX_Values();
    }

    @Override
    public Window getComponent() {
        return this.frame;
    }
}

