/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gui.infoTools;

import org.apache.commons.math3.util.Precision;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.param.Parameter;

public final class IMT_Info {
    private String S = "IMT_Info()";
    public static final double MIN_SA = 1.0E-4;
    public static final double MAX_SA = 10.0;
    public static final double NUM_SA = 51.0;
    public static final double DEFAULT_SA = 0.1;
    public static final double MIN_PGA = 1.0E-4;
    public static final double MAX_PGA = 10.0;
    public static final double NUM_PGA = 51.0;
    public static final double DEFAULT_PGA = 0.1;
    public static final double MIN_PGV = 0.01;
    public static final double MAX_PGV = 1000.0;
    public static final double NUM_PGV = 51.0;
    public static final double DEFAULT_PGV = 50.0;
    public static final double MIN_PGD = 0.01;
    public static final double MAX_PGD = 1000.0;
    public static final double NUM_PGD = 51.0;
    public static final double DEFAULT_PGD = 50.0;
    public static final double MIN_FAULT_DISPL = 0.001;
    public static final double MAX_FAULT_DISPL = 100.0;
    public static final double NUM_FAULT_DISPL = 51.0;
    public static final double DEFAULT_FAULT_DISPL = 1.0;
    public static final double MIN_MMI = 1.0;
    public static final double MAX_MMI = 10.0;
    public static final double NUM_MMI = 51.0;
    public static final double DEFAULT_MMI = 7.0;
    public static final double MIN_IA = 1.0E-4;
    public static final double MAX_IA = 1000.0;
    public static final double NUM_IA = 51.0;
    public static final double DEFAULT_IA = 0.1;
    public static final double MIN_DUR = 0.01;
    public static final double MAX_DUR = 1000.0;
    public static final double NUM_DUR = 51.0;
    public static final double DEFAULT_DUR = 0.1;
    public double discretization_pga = (Math.log(10.0) - Math.log(1.0E-4)) / 50.0;
    public double discretization_sa = (Math.log(10.0) - Math.log(1.0E-4)) / 50.0;
    public double discretization_pgv = (Math.log(1000.0) - Math.log(0.01)) / 50.0;
    public double discretization_pgd = (Math.log(1000.0) - Math.log(0.01)) / 50.0;
    public double discretization_fault_displ = (Math.log(100.0) - Math.log(0.001)) / 50.0;
    public double discretization_mmi = (Math.log(10.0) - Math.log(1.0)) / 50.0;
    public double discretization_ia = (Math.log(1000.0) - Math.log(1.0E-4)) / 50.0;
    public double discretization_dur = (Math.log(1000.0) - Math.log(0.01)) / 50.0;

    public ArbitrarilyDiscretizedFunc getDefaultHazardCurve(String imtName) {
        ArbitrarilyDiscretizedFunc function = new ArbitrarilyDiscretizedFunc();
        if (imtName.equals("SA") || imtName.equals("SA Interpolated")) {
            int i = 0;
            while ((double)i < 51.0) {
                double xVal = Precision.round((double)Math.exp(Math.log(1.0E-4) + (double)i * this.discretization_sa), (int)5);
                function.set(xVal, 1.0);
                ++i;
            }
            return function;
        }
        if (imtName.equals("PGA")) {
            int i = 0;
            while ((double)i < 51.0) {
                double xVal = Precision.round((double)Math.exp(Math.log(1.0E-4) + (double)i * this.discretization_pga), (int)5);
                function.set(xVal, 1.0);
                ++i;
            }
            return function;
        }
        if (imtName.equals("PGV")) {
            int i = 0;
            while ((double)i < 51.0) {
                double xVal = Precision.round((double)Math.exp(Math.log(0.01) + (double)i * this.discretization_pgv), (int)5);
                function.set(xVal, 1.0);
                ++i;
            }
            return function;
        }
        if (imtName.equals("PGD")) {
            int i = 0;
            while ((double)i < 51.0) {
                double xVal = Precision.round((double)Math.exp(Math.log(0.01) + (double)i * this.discretization_pgd), (int)5);
                function.set(xVal, 1.0);
                ++i;
            }
            return function;
        }
        if (imtName.equals("Fault Displacement")) {
            int i = 0;
            while ((double)i < 51.0) {
                double xVal = Precision.round((double)Math.exp(Math.log(0.001) + (double)i * this.discretization_fault_displ), (int)5);
                function.set(xVal, 1.0);
                ++i;
            }
            return function;
        }
        if (imtName.equals("MMI")) {
            int i = 0;
            while ((double)i < 51.0) {
                double xVal = Precision.round((double)Math.exp(Math.log(1.0) + (double)i * this.discretization_mmi), (int)5);
                function.set(xVal, 1.0);
                ++i;
            }
            return function;
        }
        if (imtName.equals("IA")) {
            int i = 0;
            while ((double)i < 51.0) {
                double xVal = Precision.round((double)Math.exp(Math.log(1.0E-4) + (double)i * this.discretization_ia), (int)5);
                function.set(xVal, 1.0);
                ++i;
            }
            return function;
        }
        if (imtName.equals("Significant Duration")) {
            int i = 0;
            while ((double)i < 51.0) {
                double xVal = Precision.round((double)Math.exp(Math.log(0.01) + (double)i * this.discretization_dur), (int)5);
                function.set(xVal, 1.0);
                ++i;
            }
            return function;
        }
        return null;
    }

    public ArbitrarilyDiscretizedFunc getDefaultHazardCurve(Parameter imtParam) {
        String paramVal = imtParam.getName();
        return this.getDefaultHazardCurve(paramVal);
    }

    public static double getMinIMT_Val(String imt) {
        if (imt.equals("SA")) {
            return 1.0E-4;
        }
        if (imt.equals("PGA")) {
            return 1.0E-4;
        }
        if (imt.equals("PGV")) {
            return 0.01;
        }
        if (imt.equals("PGD")) {
            return 0.01;
        }
        if (imt.equals("Fault Displacement")) {
            return 0.001;
        }
        if (imt.equals("MMI")) {
            return 1.0;
        }
        if (imt.equals("IA")) {
            return 1.0E-4;
        }
        return 0.0;
    }

    public static double getMaxIMT_Val(String imt) {
        if (imt.equals("SA")) {
            return 10.0;
        }
        if (imt.equals("PGA")) {
            return 10.0;
        }
        if (imt.equals("PGV")) {
            return 1000.0;
        }
        if (imt.equals("PGD")) {
            return 1000.0;
        }
        if (imt.equals("Fault Displacement")) {
            return 100.0;
        }
        if (imt.equals("MMI")) {
            return 10.0;
        }
        if (imt.equals("IA")) {
            return 1000.0;
        }
        return 0.0;
    }

    public static double getNumIMT_Val(String imt) {
        if (imt.equals("SA")) {
            return 51.0;
        }
        if (imt.equals("PGA")) {
            return 51.0;
        }
        if (imt.equals("PGV")) {
            return 51.0;
        }
        if (imt.equals("PGD")) {
            return 51.0;
        }
        if (imt.equals("Fault Displacement")) {
            return 51.0;
        }
        if (imt.equals("MMI")) {
            return 51.0;
        }
        if (imt.equals("IA")) {
            return 51.0;
        }
        return 0.0;
    }

    public static double getDefaultIMT_VAL(String imt) {
        if (imt.equals("SA")) {
            return 0.1;
        }
        if (imt.equals("PGA")) {
            return 0.1;
        }
        if (imt.equals("PGV")) {
            return 50.0;
        }
        if (imt.equals("PGD")) {
            return 50.0;
        }
        if (imt.equals("Fault Displacement")) {
            return 1.0;
        }
        if (imt.equals("MMI")) {
            return 7.0;
        }
        if (imt.equals("IA")) {
            return 0.1;
        }
        return 0.0;
    }

    public static boolean isIMT_LogNormalDist(String imt) {
        return imt.equalsIgnoreCase("PGA") || imt.equalsIgnoreCase("PGV") || imt.equalsIgnoreCase("PGD") || imt.equalsIgnoreCase("SA") || imt.equalsIgnoreCase("SA Interpolated") || imt.equalsIgnoreCase("MMI") || imt.equalsIgnoreCase("Fault Displacement") || imt.equalsIgnoreCase("IA");
    }

    public static ArbitrarilyDiscretizedFunc getUSGS_PGA_Function() {
        ArbitrarilyDiscretizedFunc function = new ArbitrarilyDiscretizedFunc();
        function.set(0.005, 1.0);
        function.set(0.007, 1.0);
        function.set(0.0098, 1.0);
        function.set(0.0137, 1.0);
        function.set(0.0192, 1.0);
        function.set(0.0269, 1.0);
        function.set(0.0376, 1.0);
        function.set(0.0527, 1.0);
        function.set(0.0738, 1.0);
        function.set(0.103, 1.0);
        function.set(0.145, 1.0);
        function.set(0.203, 1.0);
        function.set(0.284, 1.0);
        function.set(0.397, 1.0);
        function.set(0.556, 1.0);
        function.set(0.778, 1.0);
        function.set(1.09, 1.0);
        function.set(1.52, 1.0);
        function.set(2.13, 1.0);
        return function;
    }

    public static ArbitrarilyDiscretizedFunc getUSGS_SA_01_AND_02_Function() {
        ArbitrarilyDiscretizedFunc function = new ArbitrarilyDiscretizedFunc();
        function.set(0.005, 1.0);
        function.set(0.0075, 1.0);
        function.set(0.0113, 1.0);
        function.set(0.0169, 1.0);
        function.set(0.0253, 1.0);
        function.set(0.038, 1.0);
        function.set(0.057, 1.0);
        function.set(0.0854, 1.0);
        function.set(0.128, 1.0);
        function.set(0.192, 1.0);
        function.set(0.288, 1.0);
        function.set(0.432, 1.0);
        function.set(0.649, 1.0);
        function.set(0.973, 1.0);
        function.set(1.46, 1.0);
        function.set(2.19, 1.0);
        function.set(3.28, 1.0);
        function.set(4.92, 1.0);
        function.set(7.38, 1.0);
        return function;
    }

    public static ArbitrarilyDiscretizedFunc getUSGS_SA_Function() {
        ArbitrarilyDiscretizedFunc function = new ArbitrarilyDiscretizedFunc();
        function.set(0.0025, 1.0);
        function.set(0.00375, 1.0);
        function.set(0.00563, 1.0);
        function.set(0.00844, 1.0);
        function.set(0.0127, 1.0);
        function.set(0.019, 1.0);
        function.set(0.0285, 1.0);
        function.set(0.0427, 1.0);
        function.set(0.0641, 1.0);
        function.set(0.0961, 1.0);
        function.set(0.144, 1.0);
        function.set(0.216, 1.0);
        function.set(0.324, 1.0);
        function.set(0.487, 1.0);
        function.set(0.73, 1.0);
        function.set(1.09, 1.0);
        function.set(1.64, 1.0);
        function.set(2.46, 1.0);
        function.set(3.69, 1.0);
        function.set(5.54, 1.0);
        return function;
    }

    public static boolean isIMT_LogNormalDist(Parameter imtParam) {
        String paramVal = (String)imtParam.getValue();
        return IMT_Info.isIMT_LogNormalDist(paramVal);
    }

    public static void main(String[] args) {
        IMT_Info hazardCurve = new IMT_Info();
        ArbitrarilyDiscretizedFunc func = hazardCurve.getDefaultHazardCurve("SA");
        System.out.println("For SA and PGA: ");
        System.out.println("Dis: " + hazardCurve.discretization_pga);
        System.out.println(func.toString());
        func = hazardCurve.getDefaultHazardCurve("PGV");
        System.out.println("For PGV: ");
        System.out.println("Dis: " + hazardCurve.discretization_pgv);
        System.out.println(func.toString());
        func = hazardCurve.getDefaultHazardCurve("PGD");
        System.out.println("For PGD: ");
        System.out.println("Dis: " + hazardCurve.discretization_pgd);
        System.out.println(func.toString());
    }
}

