/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gui.servlets;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.util.FileUtils;
import org.opensha.commons.util.RunScript;

public class CyberShakeHazardDataSelectorServlet
extends HttpServlet {
    public static final String GET_CYBERSHAKE_INFO_PROB_CURVE = "SA Period for Cybershake Sites";
    public static final String GET_CYBERSHAKE_INFO_DETER_CURVE = "Deterministic Curve";
    public static final String GET_HAZARD_DATA = "Read the CyberShake Hazard Data";
    public static final String GET_DETERMINISTIC_DATA = "Read the deterministic data";
    private static final String CYBERSHAKE_HAZARD_DATASET = "/opt/install/apache-tomcat-5.5.20/webapps/OpenSHA/CyberShake/";
    private static final String OpenSHA_LIB_PATH = "/opt/install/apache-tomcat-5.5.20/webapps/OpenSHA/WEB-INF/lib/ERF.jar";
    private static final String EXECUTABLE_CLASS_NAME = "CalculateDeterministicHazardCurve";
    private static final String hazardDataFilesStartString = "hazcurve_";

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            System.out.println("CyberShakeHazardDataSelectorServlet: Handling GET");
            ObjectInputStream inputFromApplet = new ObjectInputStream((InputStream)request.getInputStream());
            String functionDesired = (String)inputFromApplet.readObject();
            if (functionDesired.equalsIgnoreCase(GET_CYBERSHAKE_INFO_PROB_CURVE)) {
                HashMap siteSA_PeriodList = this.loadDataSets(false, null);
                ObjectOutputStream outputToApplet = new ObjectOutputStream((OutputStream)response.getOutputStream());
                outputToApplet.writeObject(siteSA_PeriodList);
                outputToApplet.close();
            } else if (functionDesired.equalsIgnoreCase(GET_CYBERSHAKE_INFO_DETER_CURVE)) {
                HashMap siteSrcListMap = new HashMap();
                HashMap siteSA_PeriodList = this.loadDataSets(true, siteSrcListMap);
                ObjectOutputStream outputToApplet = new ObjectOutputStream((OutputStream)response.getOutputStream());
                outputToApplet.writeObject(siteSA_PeriodList);
                outputToApplet.writeObject(siteSrcListMap);
                outputToApplet.close();
            } else if (functionDesired.equalsIgnoreCase(GET_HAZARD_DATA)) {
                String siteName = (String)inputFromApplet.readObject();
                String saPeriod = (String)inputFromApplet.readObject();
                DiscretizedFunc fileData = this.readHazardDataSet(siteName, saPeriod);
                ObjectOutputStream outputToApplet = new ObjectOutputStream((OutputStream)response.getOutputStream());
                outputToApplet.writeObject(fileData);
                outputToApplet.close();
            } else if (functionDesired.equalsIgnoreCase(GET_DETERMINISTIC_DATA)) {
                String siteName = (String)inputFromApplet.readObject();
                String saPeriod = (String)inputFromApplet.readObject();
                String srcIndex = (String)inputFromApplet.readObject();
                Integer rupIndex = (Integer)inputFromApplet.readObject();
                ArrayList imlVals = (ArrayList)inputFromApplet.readObject();
                DiscretizedFunc fileData = this.readDeterministicDataSet(siteName, saPeriod, srcIndex, rupIndex, imlVals);
                ObjectOutputStream outputToApplet = new ObjectOutputStream((OutputStream)response.getOutputStream());
                outputToApplet.writeObject(fileData);
                outputToApplet.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public DiscretizedFunc readHazardDataSet(String siteName, String saPeriod) {
        String saPeriodFile = hazardDataFilesStartString + saPeriod;
        String fileToRead = CYBERSHAKE_HAZARD_DATASET + siteName + "/" + saPeriodFile;
        ArrayList<String> fileLines = null;
        ArbitrarilyDiscretizedFunc func = null;
        try {
            fileLines = FileUtils.loadFile(fileToRead);
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        func = new ArbitrarilyDiscretizedFunc();
        int size = fileLines.size();
        for (int i = 0; i < size; ++i) {
            StringTokenizer st = new StringTokenizer(fileLines.get(i));
            func.set(Double.parseDouble(st.nextToken()), Double.parseDouble(st.nextToken()));
        }
        return func;
    }

    public DiscretizedFunc readDeterministicDataSet(String siteName, String saPeriod, String srcIndex, Integer rupIndex, ArrayList imlVals) {
        String fileName = CYBERSHAKE_HAZARD_DATASET + siteName + "/iml.txt";
        ArbitrarilyDiscretizedFunc func = null;
        try {
            FileWriter fw = new FileWriter(fileName);
            int size = imlVals.size();
            for (int i = 0; i < size; ++i) {
                fw.write((Double)imlVals.get(i) + "\n");
            }
            fw.close();
            RunScript.runScript(new String[]{"sh", "-c", "java -classpath /opt/install/apache-tomcat-5.5.20/webapps/OpenSHA/WEB-INF/lib/ERF.jar:/opt/install/apache-tomcat-5.5.20/webapps/OpenSHA/CyberShake/. CalculateDeterministicHazardCurve   " + srcIndex + "  " + rupIndex + "   " + fileName + " " + siteName + " " + saPeriod});
            func = new ArbitrarilyDiscretizedFunc();
            ArrayList<String> fileLines = FileUtils.loadFile(CYBERSHAKE_HAZARD_DATASET + siteName + "/Deterministic_File_Pd_" + saPeriod);
            size = fileLines.size();
            for (int i = 0; i < size; ++i) {
                String xyVal = fileLines.get(i);
                StringTokenizer st = new StringTokenizer(xyVal);
                double xVal = Double.parseDouble(st.nextToken().trim());
                double yVal = Double.parseDouble(st.nextToken().trim());
                func.set(xVal, yVal);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return func;
    }

    private HashMap loadDataSets(boolean isDeterministic, HashMap siteSrcListMap) {
        HashMap siteSA_PeriodHazardDatasetMap = new HashMap();
        try {
            File dirs = new File(CYBERSHAKE_HAZARD_DATASET);
            File[] dirList = dirs.listFiles();
            for (int i = 0; i < dirList.length; ++i) {
                if (!dirList[i].isDirectory()) continue;
                try {
                    File hazFiles = new File(dirList[i].getAbsolutePath());
                    File[] hazardFiles = hazFiles.listFiles();
                    int numTotalFiles = hazardFiles.length;
                    ArrayList<String> saPeriodVals = new ArrayList<String>();
                    TreeSet<Integer> srcIndexList = null;
                    if (isDeterministic) {
                        srcIndexList = new TreeSet<Integer>();
                    }
                    for (int j = 0; j < numTotalFiles; ++j) {
                        String fileName = hazardFiles[j].getName();
                        if (fileName.startsWith(hazardDataFilesStartString)) {
                            String saPeriod = fileName.substring(fileName.indexOf("_") + 1);
                            saPeriodVals.add(saPeriod);
                        }
                        if (!fileName.endsWith("bsa") || !isDeterministic) continue;
                        String srcRupfileName = fileName.substring(fileName.indexOf("_") + 1);
                        int firstIndex = srcRupfileName.indexOf("_") + 1;
                        int lastIndex = srcRupfileName.lastIndexOf("_");
                        String srcIndex = srcRupfileName.substring(firstIndex, lastIndex);
                        srcIndexList.add(Integer.valueOf(srcIndex));
                    }
                    siteSA_PeriodHazardDatasetMap.put(dirList[i].getName(), saPeriodVals);
                    if (!isDeterministic) continue;
                    siteSrcListMap.put(dirList[i].getName(), srcIndexList);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return siteSA_PeriodHazardDatasetMap;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

