/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gui.servlets;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opensha.commons.util.FileUtils;

public class HazardDataSetPlotterCalcServlet
extends HttpServlet {
    public static final String PARENT_DIR = "/opt/install/apache-tomcat-5.5.20/webapps/OpenSHA/HazardMapDatasets/";
    public static final String SITES_FILE_NAME = "sites.txt";

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        System.out.println("HazardDataSetPlotterCalcServlet: Handling GET");
        ArrayList locationVector = new ArrayList();
        try {
            ObjectInputStream inputFromApplication = new ObjectInputStream((InputStream)request.getInputStream());
            String selectedDataSet = (String)inputFromApplication.readObject();
            double lat = (Double)inputFromApplication.readObject();
            double lon = (Double)inputFromApplication.readObject();
            inputFromApplication.close();
            ObjectOutputStream output = new ObjectOutputStream((OutputStream)response.getOutputStream());
            output.writeObject(this.getDataSet(selectedDataSet, lat, lon));
            output.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ArrayList getDataSet(String selectedSet, double selectedLat, double selectedLon) {
        File dir = new File(PARENT_DIR + selectedSet + "/");
        String[] fileList = dir.list();
        DecimalFormat d = new DecimalFormat("0.00##");
        String latitude = null;
        String longitude = null;
        try {
            FileReader sitesReader = new FileReader(PARENT_DIR + selectedSet + "/sites.txt");
            BufferedReader sitesin = new BufferedReader(sitesReader);
            latitude = sitesin.readLine();
            longitude = sitesin.readLine();
            sitesReader.close();
            sitesin.close();
        }
        catch (Exception e) {
            System.out.println("Error reading the site file");
            e.printStackTrace();
        }
        StringTokenizer st = new StringTokenizer(latitude);
        double minLat = Double.parseDouble(st.nextToken().trim());
        double maxLat = Double.parseDouble(st.nextToken().trim());
        double gridSpacing = Double.parseDouble(st.nextToken().trim());
        st = new StringTokenizer(longitude);
        double minLon = Double.parseDouble(st.nextToken().trim());
        double maxLon = Double.parseDouble(st.nextToken().trim());
        boolean latFlag = false;
        boolean lonFlag = false;
        double latForFile = 0.0;
        double lonForFile = 0.0;
        double matchingGridSpacing = gridSpacing / 2.0 + 1.0E-4;
        double lat = minLat;
        double lon = minLon;
        double latForComparison = Double.parseDouble(d.format(lat));
        double lonForComparison = Double.parseDouble(d.format(lon));
        while (latForComparison <= maxLat) {
            if (Math.abs(selectedLat - lat) <= matchingGridSpacing) {
                latFlag = true;
                latForFile = lat;
            }
            latForComparison = Double.parseDouble(d.format(lat += gridSpacing));
        }
        if (lat > maxLat && !latFlag) {
            latFlag = true;
            latForFile = lat;
        }
        while (lonForComparison <= maxLon && latFlag) {
            if (Math.abs(selectedLon - lon) <= matchingGridSpacing) {
                lonFlag = true;
                lonForFile = lon;
                break;
            }
            lonForComparison = Double.parseDouble(d.format(lon += gridSpacing));
        }
        if (lon > maxLon && latFlag && !lonFlag) {
            lonForFile = lon;
        }
        try {
            System.out.println("Selected Lat and Lon:" + latForFile + " , " + lonForFile);
            System.out.println("Selected Lat and Lon for comparison:" + latForComparison + " , " + lonForComparison);
            String fileName = d.format(latForFile) + "_" + d.format(lonForFile) + ".txt";
            ArrayList<String> listfiles = FileUtils.loadFile(PARENT_DIR + selectedSet + "/" + fileName);
            return listfiles;
        }
        catch (Exception e) {
            System.out.println("Error reading the lat lon file");
            e.printStackTrace();
            return null;
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.doGet(request, response);
    }
}

