/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.gui.util;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.imageio.ImageIO;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.opensha.commons.data.siteData.gui.SiteDataCombinedApp;
import org.opensha.commons.mapping.gmt.gui.GMT_MapGeneratorApplet;
import org.opensha.commons.metadata.XMLSaveable;
import org.opensha.commons.util.DevStatus;
import org.opensha.commons.util.IconGen;
import org.opensha.commons.util.ServerPrefUtils;
import org.opensha.commons.util.ServerPrefs;
import org.opensha.commons.util.XMLUtils;
import org.opensha.sha.gui.HazardCurveApplication;
import org.opensha.sha.gui.HazardSpectrumApplication;
import org.opensha.sha.gui.ScenarioShakeMapApp;
import org.opensha.sha.imr.attenRelImpl.gui.AttenuationRelationshipApplet;
import org.opensha.sha.magdist.gui.MagFreqDistApp;

public class JNLPGen {
    public static final String jnlpDir = "ant" + File.separator + "jnlp";
    protected static final String webRoot = "http://opensha.usc.edu/apps/opensha";
    protected static final int[] icon_sizes = new int[]{128, 64, 48, 32, 16};
    private static final String vendor = "OpenSHA";
    private static final String homepage = "http://www.opensha.org";
    private static final String iconsDirName = "icons";
    private Class<?> theClass;
    private String shortName;
    private String title;
    private String iconText;
    private int xmxMegs = 1024;
    private ServerPrefs prefs = ServerPrefUtils.SERVER_PREFS;
    private boolean startMenu = true;
    private boolean desktop = true;
    private boolean allowOffline = true;
    private ArrayList<IconEntry> icons;

    public JNLPGen(Class<?> theClass, String shortName, String title, String iconText, boolean allowOffline) {
        System.out.println("Creating JNLP for: " + theClass.getName());
        this.theClass = theClass;
        this.shortName = shortName;
        this.title = title;
        this.iconText = iconText;
        this.allowOffline = allowOffline;
    }

    public void generateAppIcons(String baseDir, HashMap<int[], BufferedImage> logoIcon) throws IOException {
        String iconDir = baseDir + File.separator + iconsDirName;
        File dirFile = new File(iconDir);
        if (!dirFile.exists()) {
            dirFile.mkdirs();
        }
        IconGen gen = new IconGen(logoIcon, this.iconText, "SansSerif", Color.WHITE, Color.BLACK);
        if (this.allowOffline) {
            gen.setUpperRightImage(IconGen.loadLocalIcon());
        } else {
            gen.setUpperRightImage(IconGen.loadServerIcon());
        }
        this.icons = new ArrayList();
        for (int size : icon_sizes) {
            BufferedImage icon = gen.getIcon(size, size);
            String fileName = JNLPGen.getIconName(this.shortName, size);
            ImageIO.write((RenderedImage)icon, "png", new File(iconDir + File.separator + fileName));
            this.icons.add(new IconEntry("icons/" + fileName, size, size));
        }
    }

    private void generateAppIcons(String baseDir) throws IOException {
        this.generateAppIcons(baseDir, IconGen.loadLogoIcon());
    }

    protected static String getIconName(String shortName, int size) {
        return shortName + "_" + size + "x" + size + ".png";
    }

    public void setServerPrefs(ServerPrefs prefs) {
        this.prefs = prefs;
    }

    private DevStatus getDistType() {
        return this.prefs.getBuildType();
    }

    public void setAllowOffline(boolean allowOffline) {
        this.allowOffline = allowOffline;
    }

    public void writeJNLPFile() throws IOException {
        this.writeJNLPFile(jnlpDir);
    }

    public void writeJNLPFile(String dir) throws IOException {
        Document doc = this.createDocument();
        File dirFile = new File(dir);
        if (!dirFile.exists()) {
            dirFile.mkdirs();
        }
        String fileName = dir + File.separator + this.shortName + ".jnlp";
        System.out.println("Writing JNLP to: " + fileName);
        XMLUtils.writeDocumentToFile(new File(fileName), doc);
    }

    public Document createDocument() {
        Document doc = DocumentHelper.createDocument();
        doc.addElement("jnlp");
        Element root = doc.getRootElement();
        root.addAttribute("spec", "6.0+");
        String codeBaseURL = "http://opensha.usc.edu/apps/opensha/" + this.shortName + "/" + this.getDistType().getBuildDirName();
        root.addAttribute("codebase", codeBaseURL);
        root.addAttribute("href", this.shortName + ".jnlp");
        Element infoEl = root.addElement("information");
        Element titleEl = infoEl.addElement("title");
        titleEl.addText(this.title);
        Element vendorEl = infoEl.addElement("vendor");
        vendorEl.addText(vendor);
        if (this.startMenu || this.desktop) {
            Element shortcutEl = infoEl.addElement("shortcut");
            shortcutEl.addAttribute("online", "true");
            if (this.desktop) {
                shortcutEl.addElement("desktop");
            }
            if (this.startMenu) {
                Element menuEl = shortcutEl.addElement("menu");
                menuEl.addAttribute("submenu", vendor);
            }
        }
        infoEl.addElement("homepage").addAttribute("href", homepage);
        if (this.allowOffline) {
            infoEl.addElement("offline-allowed");
        }
        if (this.icons != null) {
            for (IconEntry icon : this.icons) {
                icon.toXMLMetadata(infoEl);
            }
        }
        Element resourcesEl = root.addElement("resources");
        Element javaEl = resourcesEl.addElement("java");
        javaEl.addAttribute("version", "1.6+");
        javaEl.addAttribute("java-vm-args", "-Xmx" + this.xmxMegs + "M");
        javaEl.addAttribute("href", "http://java.sun.com/products/autodl/j2se");
        Element jarEl = resourcesEl.addElement("jar");
        String jarName = this.shortName + ".jar";
        jarEl.addAttribute("href", jarName);
        jarEl.addAttribute("main", "true");
        Element appDestEl = root.addElement("application-desc");
        appDestEl.addAttribute("name", this.title);
        appDestEl.addAttribute("main-class", this.theClass.getName());
        Element updateEl = root.addElement("update");
        updateEl.addAttribute("check", "timeout");
        Element securityEl = root.addElement("security");
        securityEl.addElement("all-permissions");
        return doc;
    }

    public static void main(String[] args) throws IOException {
        String outputDir = null;
        ServerPrefs[] prefsToBuild = ServerPrefs.values();
        if (args.length == 0) {
            outputDir = jnlpDir;
        } else if (args.length == 1 || args.length == 2) {
            outputDir = args[0];
            if (args.length == 2) {
                String buildType = args[1];
                prefsToBuild = new ServerPrefs[]{ServerPrefs.fromBuildType(buildType)};
            }
        } else {
            System.err.println("USAGE: JNLPGen [outputDir [build_type]]");
            System.exit(2);
        }
        ArrayList<JNLPGen> appsToBuild = new ArrayList<JNLPGen>();
        appsToBuild.add(new JNLPGen(HazardCurveApplication.class, "HazardCurveLocal", "Hazard Curve Application", "HC", true));
        appsToBuild.add(new JNLPGen(HazardSpectrumApplication.class, "HazardSpectrumLocal", "Hazard Spectrum Application", "HS", true));
        appsToBuild.add(new JNLPGen(ScenarioShakeMapApp.class, "ScenarioShakeMapLocal", "Scenario ShakeMap Application", "SM", false));
        appsToBuild.add(new JNLPGen(AttenuationRelationshipApplet.class, "AttenuationRelationship", "Attenuation Relationship Application", "AR", true));
        appsToBuild.add(new JNLPGen(MagFreqDistApp.class, "MagFreqDist", "Magnitude Frequency Distribution Application", "MFD", true));
        appsToBuild.add(new JNLPGen(GMT_MapGeneratorApplet.class, "GMTMap", "GMT Map Generator Application", "GMT", false));
        appsToBuild.add(new JNLPGen(SiteDataCombinedApp.class, "SiteData", "Site Data Application", "SD", false));
        for (ServerPrefs myPrefs : prefsToBuild) {
            String distOutDir = outputDir + File.separator + myPrefs.getBuildType().getBuildDirName();
            for (JNLPGen app : appsToBuild) {
                app.setServerPrefs(myPrefs);
                app.generateAppIcons(distOutDir);
                app.writeJNLPFile(distOutDir);
            }
        }
    }

    private class IconEntry
    implements XMLSaveable {
        String url;
        String kind;
        int width;
        int height;

        public IconEntry(String url, int width, int height) {
            this(url, width, height, null);
        }

        public IconEntry(String url, int width, int height, String kind) {
            this.url = url;
            this.width = width;
            this.height = height;
            this.kind = kind;
        }

        @Override
        public Element toXMLMetadata(Element root) {
            Element iconEl = root.addElement("icon");
            iconEl.addAttribute("href", this.url);
            iconEl.addAttribute("width", "" + this.width);
            iconEl.addAttribute("height", "" + this.height);
            if (this.kind != null && this.kind.length() > 0) {
                iconEl.addAttribute("kind", this.kind);
            }
            return root;
        }
    }
}

