/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr;

import gov.usgs.earthquake.nshmp.gmm.Gmm;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.opensha.commons.data.WeightedList;
import org.opensha.commons.data.WeightedValue;
import org.opensha.commons.param.event.ParameterChangeWarningListener;
import org.opensha.commons.util.DevStatus;
import org.opensha.commons.util.ServerPrefs;
import org.opensha.nshmp2.imr.NSHMP08_CEUS;
import org.opensha.nshmp2.imr.impl.AB2006_140_AttenRel;
import org.opensha.nshmp2.imr.impl.AB2006_200_AttenRel;
import org.opensha.nshmp2.imr.impl.Campbell_2003_AttenRel;
import org.opensha.nshmp2.imr.impl.FrankelEtAl_1996_AttenRel;
import org.opensha.nshmp2.imr.impl.SilvaEtAl_2002_AttenRel;
import org.opensha.nshmp2.imr.impl.SomervilleEtAl_2001_AttenRel;
import org.opensha.nshmp2.imr.impl.TP2005_AttenRel;
import org.opensha.nshmp2.imr.impl.ToroEtAl_1997_AttenRel;
import org.opensha.sha.imr.AttenRelSupplier;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.imr.attenRelImpl.AS_1997_AttenRel;
import org.opensha.sha.imr.attenRelImpl.AS_2005_AttenRel;
import org.opensha.sha.imr.attenRelImpl.AS_2008_AttenRel;
import org.opensha.sha.imr.attenRelImpl.Abrahamson_2000_AttenRel;
import org.opensha.sha.imr.attenRelImpl.AfshariStewart_2016_AttenRel;
import org.opensha.sha.imr.attenRelImpl.BA_2006_AttenRel;
import org.opensha.sha.imr.attenRelImpl.BA_2008_AttenRel;
import org.opensha.sha.imr.attenRelImpl.BC_2004_AttenRel;
import org.opensha.sha.imr.attenRelImpl.BJF_1997_AttenRel;
import org.opensha.sha.imr.attenRelImpl.BS_2003_AttenRel;
import org.opensha.sha.imr.attenRelImpl.CB_2003_AttenRel;
import org.opensha.sha.imr.attenRelImpl.CB_2006_AttenRel;
import org.opensha.sha.imr.attenRelImpl.CB_2008_AttenRel;
import org.opensha.sha.imr.attenRelImpl.CS_2005_AttenRel;
import org.opensha.sha.imr.attenRelImpl.CY_2006_AttenRel;
import org.opensha.sha.imr.attenRelImpl.CY_2008_AttenRel;
import org.opensha.sha.imr.attenRelImpl.Campbell_1997_AttenRel;
import org.opensha.sha.imr.attenRelImpl.DahleEtAl_1995_AttenRel;
import org.opensha.sha.imr.attenRelImpl.Field_2000_AttenRel;
import org.opensha.sha.imr.attenRelImpl.GouletEtAl_2006_AttenRel;
import org.opensha.sha.imr.attenRelImpl.McVerryetal_2000_AttenRel;
import org.opensha.sha.imr.attenRelImpl.NGAWest_2014_Averaged_AttenRel;
import org.opensha.sha.imr.attenRelImpl.NGA_2008_Averaged_AttenRel;
import org.opensha.sha.imr.attenRelImpl.NGA_2008_Averaged_AttenRel_NoAS;
import org.opensha.sha.imr.attenRelImpl.NSHMP_2008_CA;
import org.opensha.sha.imr.attenRelImpl.SA_InterpolatedWrapperAttenRel.InterpolatedBA_2008_AttenRel;
import org.opensha.sha.imr.attenRelImpl.SEA_1999_AttenRel;
import org.opensha.sha.imr.attenRelImpl.SadighEtAl_1997_AttenRel;
import org.opensha.sha.imr.attenRelImpl.ShakeMap_2003_AttenRel;
import org.opensha.sha.imr.attenRelImpl.SiteSpecific_2006_AttenRel;
import org.opensha.sha.imr.attenRelImpl.USGS_Combined_2004_AttenRel;
import org.opensha.sha.imr.attenRelImpl.WC94_DisplMagRel;
import org.opensha.sha.imr.attenRelImpl.ZhaoEtAl_2006_AttenRel;
import org.opensha.sha.imr.attenRelImpl.ngaw2.NGAW2_Wrappers;
import org.opensha.sha.imr.attenRelImpl.nshmp.NSHMP_GMM_Wrapper;
import org.opensha.sha.imr.mod.ModAttenuationRelationship;
import org.opensha.sha.imr.mod.impl.stewartSiteSpecific.StewartAfshariGoulet2017NonergodicGMPE;

public enum AttenRelRef implements AttenRelSupplier
{
    ASK_2014(NGAW2_Wrappers.ASK_2014_Wrapper.class, "Abrahamson, Silva & Kamai (2014)", "ASK2014", DevStatus.PRODUCTION),
    BSSA_2014(NGAW2_Wrappers.BSSA_2014_Wrapper.class, "Boore, Stewart, Seyhan & Atkinson (2014)", "BSSA2014", DevStatus.PRODUCTION),
    CB_2014(NGAW2_Wrappers.CB_2014_Wrapper.class, "Campbell & Bozorgnia (2014)", "CB2014", DevStatus.PRODUCTION),
    CY_2014(NGAW2_Wrappers.CY_2014_Wrapper.class, "Chiou & Youngs (2014)", "CY2014", DevStatus.PRODUCTION),
    IDRISS_2014(NGAW2_Wrappers.Idriss_2014_Wrapper.class, "Idriss (2014)", "Idriss2014", DevStatus.PRODUCTION),
    NGAWest_2014_AVG(NGAWest_2014_Averaged_AttenRel.class, "NGAWest2 2014 Averaged Attenuation Relationship", "NGAWest_2014", DevStatus.PRODUCTION),
    NGAWest_2014_AVG_NOIDRISS(NGAWest_2014_Averaged_AttenRel.NGAWest_2014_Averaged_AttenRel_NoIdriss.class, "NGAWest2 2014 Averaged No Idriss", "NGAWest_2014_NoIdr", DevStatus.PRODUCTION),
    CB_2008(CB_2008_AttenRel.class, "Campbell & Bozorgnia (2008)", "CB2008", DevStatus.PRODUCTION),
    BA_2008(BA_2008_AttenRel.class, "Boore & Atkinson (2008)", "Boore2008", DevStatus.PRODUCTION),
    AS_2008(AS_2008_AttenRel.class, "Abrahamson & Silva (2008)", "AS2008", DevStatus.PRODUCTION),
    CY_2008(CY_2008_AttenRel.class, "Chiou & Youngs (2008)", "CY2008", DevStatus.PRODUCTION),
    GOULET_2006(GouletEtAl_2006_AttenRel.class, "Goulet Et. Al. (2006)", "GouletEtAl2006", DevStatus.PRODUCTION),
    ZHAO_2006(ZhaoEtAl_2006_AttenRel.class, "ZhaoEtAl (2006)", "ZhaoEtAl2006", DevStatus.PRODUCTION),
    CS_2005(CS_2005_AttenRel.class, "Choi & Stewart (2005)", "CS2005", DevStatus.PRODUCTION),
    BC_2004(BC_2004_AttenRel.class, "Bazzuro and Cornell (2004)", "BC2004", DevStatus.PRODUCTION),
    USGS_2004_COMBO(USGS_Combined_2004_AttenRel.class, "USGS Combined (2004)", "USGS_2004", DevStatus.PRODUCTION),
    BS_2003(BS_2003_AttenRel.class, "Baturay and Stewart (2003)", "BS2006", DevStatus.PRODUCTION),
    CB_2003(CB_2003_AttenRel.class, "Campbell and Bozorgnia (2003)", "CB2003", DevStatus.PRODUCTION),
    SHAKE_2003(ShakeMap_2003_AttenRel.class, "ShakeMap (2003)", "ShakeMap2003", DevStatus.PRODUCTION),
    FIELD_2000(Field_2000_AttenRel.class, "Field (2000)", "Field2000", DevStatus.PRODUCTION),
    ABRAHAM_2000(Abrahamson_2000_AttenRel.class, "Abrahamson (2000)", "Abrahamson2000", DevStatus.PRODUCTION),
    MCVERRY_2000(McVerryetal_2000_AttenRel.class, "McVerry et al (2000)", "McVerryetal2000", DevStatus.PRODUCTION),
    SADIGH_1999(SEA_1999_AttenRel.class, "SEA (Spudich et al., 1999)", "Spudich1999", DevStatus.PRODUCTION),
    AS_1997(AS_1997_AttenRel.class, "Abrahamson & Silva (1997)", "AS1997", DevStatus.PRODUCTION),
    BJF_1997(BJF_1997_AttenRel.class, "Boore, Joyner & Fumal (1997)", "BJF1997", DevStatus.PRODUCTION),
    CAMPBELL_1997(Campbell_1997_AttenRel.class, "Campbell (1997) w/ erratum (2000) changes", "Campbell_1997", DevStatus.PRODUCTION),
    SADIGH_1997(SadighEtAl_1997_AttenRel.class, "Sadigh et al (1997)", "SadighEtAl1997", DevStatus.PRODUCTION),
    DAHLE_1995(DahleEtAl_1995_AttenRel.class, "Dahle et al. (1995)", "Dahle1995", DevStatus.PRODUCTION),
    NON_ERGODIC_2016(StewartAfshariGoulet2017NonergodicGMPE.class, "Stewart, Afshari, Goulet (2017) Non-Ergodic Site Response GMPE", "SAG_NonErgodic2017", DevStatus.PRODUCTION),
    USGS_NSHM23_ACTIVE(null, "USGS NSHM23 Active Crustal", "NSHM23-Active", DevStatus.PRODUCTION){

        @Override
        public AttenuationRelationship instance(ParameterChangeWarningListener listener) {
            return new NSHMP_GMM_Wrapper.Single(Gmm.TOTAL_TREE_CONUS_ACTIVE_CRUST_2023, this.getName(), this.getShortName(), false, null);
        }
    }
    ,
    USGS_NSHM23_ACTIVE_LA(null, "USGS NSHM23 Los Angeles Basin", "NSHM23-Active-LA", DevStatus.PRODUCTION){

        @Override
        public AttenuationRelationship instance(ParameterChangeWarningListener listener) {
            WeightedList.Unmodifiable<Gmm> gmms = WeightedList.of(new WeightedValue<Gmm>(Gmm.ASK_14, 0.125), new WeightedValue<Gmm>(Gmm.BSSA_14, 0.125), new WeightedValue<Gmm>(Gmm.CB_14, 0.125), new WeightedValue<Gmm>(Gmm.CY_14, 0.125), new WeightedValue<Gmm>(Gmm.ASK_14_BASIN, 0.0625), new WeightedValue<Gmm>(Gmm.BSSA_14_BASIN, 0.0625), new WeightedValue<Gmm>(Gmm.CB_14_BASIN, 0.0625), new WeightedValue<Gmm>(Gmm.CY_14_BASIN, 0.0625), new WeightedValue<Gmm>(Gmm.ASK_14_CYBERSHAKE, 0.0625), new WeightedValue<Gmm>(Gmm.BSSA_14_CYBERSHAKE, 0.0625), new WeightedValue<Gmm>(Gmm.CB_14_CYBERSHAKE, 0.0625), new WeightedValue<Gmm>(Gmm.CY_14_CYBERSHAKE, 0.0625));
            return new NSHMP_GMM_Wrapper.WeightedCombination(gmms, this.getName(), this.getShortName(), false, null);
        }
    }
    ,
    USGS_NSHM23_ACTIVE_SF(null, "USGS NSHM23 San Francisco", "NSHM23-Active-SF", DevStatus.PRODUCTION){

        @Override
        public AttenuationRelationship instance(ParameterChangeWarningListener listener) {
            WeightedList.Unmodifiable<Gmm> gmms = WeightedList.of(new WeightedValue<Gmm>(Gmm.ASK_14, 0.125), new WeightedValue<Gmm>(Gmm.BSSA_14, 0.125), new WeightedValue<Gmm>(Gmm.CB_14, 0.125), new WeightedValue<Gmm>(Gmm.CY_14, 0.125), new WeightedValue<Gmm>(Gmm.ASK_14_BASIN, 0.125), new WeightedValue<Gmm>(Gmm.BSSA_14_BASIN, 0.125), new WeightedValue<Gmm>(Gmm.CB_14_BASIN, 0.125), new WeightedValue<Gmm>(Gmm.CY_14_BASIN, 0.125));
            return new NSHMP_GMM_Wrapper.WeightedCombination(gmms, this.getName(), this.getShortName(), false, null);
        }
    }
    ,
    WRAPPED_ASK_2014(null, "NSHMP-Haz ASK (2014) Base", "WrapedASK2014", DevStatus.DEVELOPMENT){

        @Override
        public AttenuationRelationship instance(ParameterChangeWarningListener listener) {
            return new NSHMP_GMM_Wrapper.Single(Gmm.ASK_14_BASE, this.getName(), this.getShortName(), false, null);
        }
    }
    ,
    WRAPPED_BSSA_2014(null, "NSHMP-Haz BSSA (2014) Base", "WrapedBSSA2014", DevStatus.DEVELOPMENT){

        @Override
        public AttenuationRelationship instance(ParameterChangeWarningListener listener) {
            return new NSHMP_GMM_Wrapper.Single(Gmm.BSSA_14_BASE, this.getName(), this.getShortName(), false, null);
        }
    }
    ,
    WRAPPED_NGAW2_NoIDR(null, "NSHMP-Haz NGA-W2 (2014) Base (excl. Idriss)", "WrappedNGAW2-NoIdr", DevStatus.PRODUCTION){

        @Override
        public AttenuationRelationship instance(ParameterChangeWarningListener listener) {
            WeightedList.Unmodifiable<Gmm> gmms = WeightedList.of(new WeightedValue<Gmm>(Gmm.ASK_14_BASE, 0.25), new WeightedValue<Gmm>(Gmm.BSSA_14_BASE, 0.25), new WeightedValue<Gmm>(Gmm.CB_14_BASE, 0.25), new WeightedValue<Gmm>(Gmm.CY_14_BASE, 0.25));
            return new NSHMP_GMM_Wrapper.WeightedCombination(gmms, this.getName(), this.getShortName(), false, null);
        }
    }
    ,
    AG_2020_GLOBAL_INTERFACE(null, "AG (2020) Global Interface", "AG2020", DevStatus.DEVELOPMENT){

        @Override
        public AttenuationRelationship instance(ParameterChangeWarningListener listener) {
            return new NSHMP_GMM_Wrapper.Single(Gmm.AG_20_GLOBAL_INTERFACE, this.getName(), this.getShortName(), false, null);
        }
    }
    ,
    PSBAH_2020_GLOBAL_INTERFACE(null, "PSBAH (2020) Global Interface", "PSBAH2020-Interface", DevStatus.DEVELOPMENT){

        @Override
        public AttenuationRelationship instance(ParameterChangeWarningListener listener) {
            return new NSHMP_GMM_Wrapper.Single(Gmm.PSBAH_20_GLOBAL_INTERFACE, this.getName(), this.getShortName(), false, null);
        }
    }
    ,
    PSBAH_2020_GLOBAL_SLAB(null, "PSBAH (2020) Global Slab", "PSBAH2020-Slab", DevStatus.DEVELOPMENT){

        @Override
        public AttenuationRelationship instance(ParameterChangeWarningListener listener) {
            return new NSHMP_GMM_Wrapper.Single(Gmm.PSBAH_20_GLOBAL_SLAB, this.getName(), this.getShortName(), false, null);
        }
    }
    ,
    USGS_PRVI_ACTIVE(null, "USGS PRVI25 Active Crustal (beta)", "PRVI25-Active", DevStatus.DEVELOPMENT){

        @Override
        public AttenuationRelationship instance(ParameterChangeWarningListener listener) {
            return new NSHMP_GMM_Wrapper.Single(Gmm.TOTAL_TREE_PRVI_ACTIVE_CRUST_2025, this.getName(), this.getShortName(), false, null);
        }
    }
    ,
    USGS_PRVI_INTERFACE(null, "USGS PRVI25 Interface (beta)", "PRVI25-Interface", DevStatus.DEVELOPMENT){

        @Override
        public AttenuationRelationship instance(ParameterChangeWarningListener listener) {
            return new NSHMP_GMM_Wrapper.Single(Gmm.TOTAL_TREE_PRVI_INTERFACE_2025, this.getName(), this.getShortName(), false, null);
        }
    }
    ,
    USGS_PRVI_SLAB(null, "USGS PRVI25 Intraslab (beta)", "PRVI25-Intraslab", DevStatus.DEVELOPMENT){

        @Override
        public AttenuationRelationship instance(ParameterChangeWarningListener listener) {
            return new NSHMP_GMM_Wrapper.Single(Gmm.TOTAL_TREE_PRVI_INTRASLAB_2025, this.getName(), this.getShortName(), false, null);
        }
    }
    ,
    BA_2008_INTERP(InterpolatedBA_2008_AttenRel.class, "Interpolated Boore & Atkinson (2008)", "InterpBoore2008", DevStatus.DEVELOPMENT),
    NGA_2008_4AVG(NGA_2008_Averaged_AttenRel.class, "NGA 2008 Averaged Attenuation Relationship (unverified!)", "NGA_2008", DevStatus.DEVELOPMENT),
    NGA_2008_3AVG(NGA_2008_Averaged_AttenRel_NoAS.class, "NGA 2008 Averaged Attenuation Relationship (NO AS) (unverified!)", "NGA_NO_AS_2008", DevStatus.DEVELOPMENT),
    NSHMP_2008(NSHMP_2008_CA.class, "NSHMP 2008 California Combined", "NSHMP_2008_CA", DevStatus.DEVELOPMENT),
    NSHMP_2008_CEUS(NSHMP08_CEUS.class, "NSHMP 2008 CEUS Combined", "NSHMP08_CEUS", DevStatus.ERROR),
    AB_2006_140(AB2006_140_AttenRel.class, "Atkinson and Boore (2002) 140bar", "AB2006_140", DevStatus.DEVELOPMENT),
    AB_2006_200(AB2006_200_AttenRel.class, "Atkinson and Boore (2002) 200bar", "AB2006_200", DevStatus.DEVELOPMENT),
    CAMPBELL_2003(Campbell_2003_AttenRel.class, "Campbell (2003)", "Campbell2003", DevStatus.DEVELOPMENT),
    FEA_1996(FrankelEtAl_1996_AttenRel.class, "Frankel et al. (1996)", "FrankelEtAl1996", DevStatus.ERROR),
    SOMERVILLE_2001(SomervilleEtAl_2001_AttenRel.class, "Somerville et al. (2001)", "SomervilleEtAl2001", DevStatus.DEVELOPMENT),
    SILVA_2002(SilvaEtAl_2002_AttenRel.class, "Silva et al. (2002)", "SilvaEtAl2002", DevStatus.DEVELOPMENT),
    TORO_1997(ToroEtAl_1997_AttenRel.class, "Toro et al. (1997)", "ToroEtAl1997", DevStatus.DEVELOPMENT),
    TP_2005(TP2005_AttenRel.class, "Tavakoli and Pezeshk (2005)", "TP2005", DevStatus.DEVELOPMENT),
    GK_2014(NGAW2_Wrappers.GK_2014_Wrapper.class, "Graizer & Kalkan (2013)", "GK2013", DevStatus.EXPERIMENTAL),
    MOD_ATTEN_REL(ModAttenuationRelationship.class, "Modified Attenuation Relationship", "ModAttenRel", DevStatus.EXPERIMENTAL),
    AFSHARI_STEWART_2016(AfshariStewart_2016_AttenRel.class, "Afshari & Stewart (2016)", "AfshariStewart2016", DevStatus.EXPERIMENTAL),
    CB_2006(CB_2006_AttenRel.class, "Campbell & Bozorgnia (2006)", "CB2006", DevStatus.DEPRECATED),
    BA_2006(BA_2006_AttenRel.class, "Boore & Atkinson (2006)", "Boore2006", DevStatus.DEPRECATED),
    AS_2005(AS_2005_AttenRel.class, "Abrahamson & Silva (2005 prelim)", "AS2005", DevStatus.DEPRECATED),
    CY_2006(CY_2006_AttenRel.class, "Chiou & Youngs (2006)", "CY2006", DevStatus.DEPRECATED),
    SITESPEC_2006(SiteSpecific_2006_AttenRel.class, "Site Specfic AttenuationRelationship (2006)", "SS2006", DevStatus.DEPRECATED),
    WC_1994(WC94_DisplMagRel.class, "Wells & Coppersmith (1994)", "WC_1994", DevStatus.DEPRECATED);

    private Class<? extends AttenuationRelationship> clazz;
    private String name;
    private String shortName;
    private DevStatus status;

    private AttenRelRef(Class<? extends AttenuationRelationship> clazz, String name, String shortName, DevStatus status) {
        this.clazz = clazz;
        this.name = name;
        this.shortName = shortName;
        this.status = status;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    public DevStatus status() {
        return this.status;
    }

    public Class<? extends AttenuationRelationship> getAttenRelClass() {
        return this.clazz;
    }

    public AttenuationRelationship instance(ParameterChangeWarningListener listener) {
        try {
            Object[] args = new Object[]{listener};
            Class[] params = new Class[]{ParameterChangeWarningListener.class};
            Constructor<? extends AttenuationRelationship> con = this.clazz.getConstructor(params);
            return con.newInstance(args);
        }
        catch (Exception e) {
            try {
                Object[] args = new Object[]{};
                Class[] params = new Class[]{};
                Constructor<? extends AttenuationRelationship> con = this.clazz.getConstructor(params);
                return con.newInstance(args);
            }
            catch (Exception e1) {
                e.printStackTrace();
                return null;
            }
        }
    }

    public static Set<AttenRelRef> getAll() {
        return AttenRelRef.get(DevStatus.PRODUCTION, DevStatus.DEVELOPMENT, DevStatus.EXPERIMENTAL);
    }

    public static Set<AttenRelRef> get(ServerPrefs prefs) {
        if (prefs == ServerPrefs.DEV_PREFS) {
            return AttenRelRef.get(DevStatus.PRODUCTION, DevStatus.DEVELOPMENT, DevStatus.EXPERIMENTAL);
        }
        if (prefs == ServerPrefs.PRODUCTION_PREFS) {
            return AttenRelRef.get(DevStatus.PRODUCTION);
        }
        throw new IllegalArgumentException("Unknown ServerPrefs instance: " + String.valueOf((Object)prefs));
    }

    public static Set<AttenRelRef> get(DevStatus ... stati) {
        EnumSet<AttenRelRef> ariSet = EnumSet.allOf(AttenRelRef.class);
        for (AttenRelRef ari : ariSet) {
            if (ArrayUtils.contains((Object[])stati, (Object)ari.status)) continue;
            ariSet.remove(ari);
        }
        return ariSet;
    }

    public static List<AttenuationRelationship> instanceList(ParameterChangeWarningListener listener, boolean sorted) {
        return AttenRelRef.buildInstanceList(AttenRelRef.getAll(), listener, sorted);
    }

    public static List<AttenuationRelationship> instanceList(ParameterChangeWarningListener listener, boolean sorted, ServerPrefs prefs) {
        return AttenRelRef.buildInstanceList(AttenRelRef.get(prefs), listener, sorted);
    }

    public static List<AttenuationRelationship> instanceList(ParameterChangeWarningListener listener, boolean sorted, Collection<AttenRelRef> refs) {
        return AttenRelRef.buildInstanceList(refs, listener, sorted);
    }

    public static List<AttenuationRelationship> instanceList(ParameterChangeWarningListener listener, boolean sorted, AttenRelRef ... refs) {
        return AttenRelRef.buildInstanceList(Arrays.asList(refs), listener, sorted);
    }

    public static List<AttenuationRelationship> instanceList(ParameterChangeWarningListener listener, boolean sorted, DevStatus ... stati) {
        return AttenRelRef.buildInstanceList(AttenRelRef.get(stati), listener, sorted);
    }

    private static List<AttenuationRelationship> buildInstanceList(Collection<AttenRelRef> arrSet, ParameterChangeWarningListener listener, boolean sorted) {
        ArrayList<AttenuationRelationship> arList = new ArrayList<AttenuationRelationship>();
        for (AttenRelRef arr : arrSet) {
            arList.add(arr.instance(listener));
        }
        if (sorted) {
            Collections.sort(arList);
        }
        return arList;
    }

    @Override
    public ScalarIMR get() {
        AttenuationRelationship instance = this.instance(null);
        instance.setParamDefaults();
        return instance;
    }
}

