/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.attenRelImpl;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.opensha.commons.data.Site;
import org.opensha.commons.exceptions.InvalidRangeException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.geo.Location;
import org.opensha.commons.param.constraint.impl.DoubleConstraint;
import org.opensha.commons.param.constraint.impl.DoubleDiscreteConstraint;
import org.opensha.commons.param.constraint.impl.StringConstraint;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.event.ParameterChangeWarningListener;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.gcim.imr.param.EqkRuptureParams.FocalDepthParam;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.param.EqkRuptureParams.FaultTypeParam;
import org.opensha.sha.imr.param.EqkRuptureParams.MagParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.DampingParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.PGA_Param;
import org.opensha.sha.imr.param.IntensityMeasureParams.PeriodParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.SA_Param;
import org.opensha.sha.imr.param.OtherParams.Component;
import org.opensha.sha.imr.param.OtherParams.ComponentParam;
import org.opensha.sha.imr.param.OtherParams.StdDevTypeParam;
import org.opensha.sha.imr.param.OtherParams.TectonicRegionTypeParam;
import org.opensha.sha.imr.param.PropagationEffectParams.DistanceRupParameter;
import org.opensha.sha.util.TectonicRegionType;

public class McVerryetal_2000_AttenRel
extends AttenuationRelationship
implements ParameterChangeListener {
    private static final String C = "McVerryetal_2000_AttenRel";
    private static final boolean D = false;
    public static final String SHORT_NAME = "McVerryetal2000";
    private static final long serialVersionUID = 1234567890987654353L;
    public static final String NAME = "McVerry et al (2000)";
    private static final String URL_INFO_STRING = "http://www.opensha.org/documentation/modelsImplemented/attenRel/McVerryetal_2000.html";
    double[] period = new double[]{-1.0, 0.0, 0.075, 0.1, 0.2, 0.3, 0.4, 0.5, 0.75, 1.0, 1.5, 2.0, 3.0};
    double[] C1_lh = new double[]{0.28815, 0.1813, 1.36561, 1.77717, 1.39535, 0.44591, 0.01645, 0.14826, -0.21246, -0.10451, -0.48665, -0.77433, -1.30916};
    double[] C3AS_lh = new double[]{0.0, 0.0, 0.03, 0.028, -0.0138, -0.036, -0.0518, -0.0635, -0.0862, -0.102, -0.12, -0.12, -0.1726};
    double C4AS_lh = -0.144;
    double[] C5_lh = new double[]{-0.00967, -0.00846, -0.00889, -0.00837, -0.0094, -0.00987, -0.00923, -0.00823, -0.00738, -0.00588, -0.0063, -0.0063, -0.00553};
    double C6AS_lh = 0.17;
    double[] C8_lh = new double[]{-0.70494, -0.75519, -0.94568, -1.01852, -0.78199, -0.56098, -0.51281, -0.56716, -0.55384, -0.65892, -0.58222, -0.58222, -0.57009};
    double[] C10AS_lh = new double[]{5.6, 5.6, 5.58, 5.5, 5.1, 4.8, 4.52, 4.3, 3.9, 3.7, 3.55, 3.55, 3.5};
    double[] C11_lh = new double[]{8.68354, 8.10697, 8.68782, 9.37929, 10.61479, 9.40776, 8.50343, 8.46463, 7.30176, 7.08727, 6.93264, 6.64496, 5.05488};
    double C12y_lh = 1.414;
    double[] C13y_lh = new double[]{0.0, 0.0, 0.0, -0.0011, -0.0027, -0.0036, -0.0043, -0.0048, -0.0057, -0.0064, -0.0073, -0.0073, -0.0089};
    double[] C15_lh = new double[]{-2.552, -2.552, -2.707, -2.655, -2.528, -2.454, -2.401, -2.36, -2.286, -2.234, -2.16, -2.16, -2.033};
    double[] C17_lh = new double[]{-2.56727, -2.48795, -2.54215, -2.60945, -2.70851, -2.47668, -2.36895, -2.4063, -2.26512, -2.27668, -2.28347, -2.28347, -2.0305};
    double C18y_lh = 1.7818;
    double C19y_lh = 0.554;
    double[] C20_lh = new double[]{0.0155, 0.01622, 0.0185, 0.0174, 0.01542, 0.01278, 0.01426, 0.01287, 0.0108, 0.00946, 0.00788, 0.00788, -0.00265};
    double[] C24_lh = new double[]{-0.50962, -0.41369, -0.48652, -0.61973, -0.67672, -0.59339, -0.30579, -0.24839, -0.01298, 0.06672, -0.02289, -0.02289, -0.20537};
    double[] C29_lh = new double[]{0.30206, 0.44307, 0.31139, 0.34059, 0.37235, 0.56648, 0.69911, 0.63188, 0.51577, 0.34048, 0.12468, 0.12468, 0.14593};
    double[] C30AS_lh = new double[]{-0.23, -0.23, -0.28, -0.28, -0.245, -0.195, -0.16, -0.121, -0.05, 0.0, 0.04, 0.04, 0.04};
    double C32_lh = -0.2;
    double[] C33AS_lh = new double[]{0.26, 0.26, 0.26, 0.26, 0.26, 0.198, 0.154, 0.119, 0.057, 0.013, -0.049, -0.049, -0.156};
    double[] C43_lh = new double[]{-0.31769, -0.29648, -0.48366, -0.43854, -0.29906, -0.05184, 0.20301, 0.37026, 0.73517, 0.87764, 0.75438, 0.75438, 0.61545};
    double[] C46_lh = new double[]{-0.03279, -0.03301, -0.03452, -0.03595, -0.03853, -0.03604, -0.03364, -0.0326, -0.02877, -0.02561, -0.02034, -0.02034, -0.01673};
    double[] sigma6_lh = new double[]{0.4865, 0.5035, 0.5281, 0.5398, 0.5703, 0.5505, 0.5627, 0.568, 0.5562, 0.5629, 0.5394, 0.5394, 0.5701};
    double[] sigSlope_lh = new double[]{-0.1261, -0.0635, -0.097, -0.0673, -0.0243, -0.0861, -0.1405, -0.1444, -0.0932, -0.0749, -0.0056, -0.0056, 0.0934};
    double[] tau_lh = new double[]{0.2687, 0.2598, 0.3217, 0.3088, 0.2726, 0.2112, 0.2005, 0.1476, 0.1794, 0.2053, 0.2411, 0.2411, 0.2406};
    double[] C1_gm = new double[]{0.14274, 0.07713, 1.2205, 1.53365, 1.22565, 0.21124, -0.10541, -0.1426, -0.65968, -0.51404, -0.95399, -1.24167, -1.5657};
    double[] C3AS_gm = new double[]{0.0, 0.0, 0.03, 0.028, -0.0138, -0.036, -0.0518, -0.0635, -0.0862, -0.102, -0.12, -0.12, -0.1726};
    double C4AS_gm = -0.144;
    double[] C5_gm = new double[]{-0.00989, -0.00898, -0.00914, -0.00903, -0.00975, -0.01032, -0.00941, -0.00878, -0.00802, -0.00647, -0.00713, -0.00713, -0.00623};
    double C6AS_gm = 0.17;
    double[] C8_gm = new double[]{-0.68744, -0.73728, -0.93059, -0.96506, -0.75855, -0.524, -0.50802, -0.52214, -0.47264, -0.58672, -0.49268, -0.49268, -0.52257};
    double[] C10AS_gm = new double[]{5.6, 5.6, 5.58, 5.5, 5.1, 4.8, 4.52, 4.3, 3.9, 3.7, 3.55, 3.55, 3.5};
    double[] C11_gm = new double[]{8.57343, 8.08611, 8.69303, 9.304, 10.41628, 9.21783, 8.0115, 7.87495, 7.26785, 6.98741, 6.77543, 6.48775, 5.05424};
    double C12y_gm = 1.414;
    double[] C13y_gm = new double[]{0.0, 0.0, 0.0, -0.0011, -0.0027, -0.0036, -0.0043, -0.0048, -0.0057, -0.0064, -0.0073, -0.0073, -0.0089};
    double[] C15_gm = new double[]{-2.552, -2.552, -2.707, -2.655, -2.528, -2.454, -2.401, -2.36, -2.286, -2.234, -2.16, -2.16, -2.033};
    double[] C17_gm = new double[]{-2.56592, -2.49894, -2.55903, -2.61372, -2.70038, -2.47356, -2.30457, -2.31991, -2.2846, -2.28256, -2.27895, -2.27895, -2.0556};
    double C18y_gm = 1.7818;
    double C19y_gm = 0.554;
    double[] C20_gm = new double[]{0.01545, 0.0159, 0.01821, 0.01737, 0.01531, 0.01304, 0.01426, 0.01277, 0.01055, 0.00927, 0.00748, 0.00748, -0.00273};
    double[] C24_gm = new double[]{-0.49963, -0.43223, -0.52504, -0.61452, -0.65966, -0.56604, -0.33169, -0.24374, -0.01583, 0.02009, -0.07051, -0.07051, -0.23967};
    double[] C29_gm = new double[]{0.27315, 0.3873, 0.27879, 0.28619, 0.34064, 0.53213, 0.63272, 0.58809, 0.50708, 0.33002, 0.07445, 0.07445, 0.09869};
    double[] C30AS_gm = new double[]{-0.23, -0.23, -0.28, -0.28, -0.245, -0.195, -0.16, -0.121, -0.05, 0.0, 0.04, 0.04, 0.04};
    double C32_gm = -0.2;
    double[] C33AS_gm = new double[]{0.26, 0.26, 0.26, 0.26, 0.26, 0.198, 0.154, 0.119, 0.057, 0.013, -0.049, -0.049, -0.156};
    double[] C43_gm = new double[]{-0.33716, -0.31036, -0.49068, -0.46604, -0.31282, -0.07565, 0.17615, 0.34775, 0.7238, 0.89239, 0.77743, 0.77743, 0.60938};
    double[] C46_gm = new double[]{-0.03255, -0.0325, -0.03441, -0.03594, -0.03823, -0.03535, -0.03354, -0.03211, -0.02857, -0.025, -0.02008, -0.02008, -0.01587};
    double[] sigma6_gm = new double[]{0.4871, 0.5099, 0.5297, 0.5401, 0.5599, 0.5456, 0.5556, 0.5658, 0.5611, 0.5573, 0.5419, 0.5419, 0.5809};
    double[] sigSlope_gm = new double[]{-0.1011, -0.0259, -0.0703, -0.0292, 0.0172, -0.0566, -0.1064, -0.1123, -0.0836, -0.062, 0.0385, 0.0385, 0.1403};
    double[] tau_gm = new double[]{0.2677, 0.2469, 0.3139, 0.3017, 0.2583, 0.1967, 0.1802, 0.144, 0.1871, 0.2073, 0.2405, 0.2405, 0.2053};
    private HashMap indexFromPerHashMap;
    private int iper;
    private double rRup;
    private double mag;
    private double Hc;
    private String stdDevType;
    private String fltType;
    private Component component;
    private boolean parameterChange;
    private String tecRegType;
    protected static final Double MAG_WARN_MIN = 5.0;
    protected static final Double MAG_WARN_MAX = 8.5;
    protected static final Double DISTANCE_RUP_WARN_MIN = 0.0;
    protected static final Double DISTANCE_RUP_WARN_MAX = 400.0;
    protected static final Double FOCALDEPTH_WARN_MIN = 0.0;
    protected static final Double FOCALDEPTH_WARN_MAX = 100.0;
    private StringParameter siteTypeParam = null;
    public static final String SITE_TYPE_NAME = "McVerryetal Site Type";
    public static final String SITE_TYPE_INFO = "Geological conditions at the site";
    public static final String SITE_TYPE_A = "A-Strong-Rock";
    public static final String SITE_TYPE_B = "B-Rock";
    public static final String SITE_TYPE_C = "C-Shallow-Soil";
    public static final String SITE_TYPE_D = "D-Soft-or-Deep-Soil";
    public static final String SITE_TYPE_DEFAULT = "A-Strong-Rock";
    public static final String FLT_TEC_ENV_CRUSTAL = TectonicRegionType.ACTIVE_SHALLOW.toString();
    public static final String FLT_TEC_ENV_INTERFACE = TectonicRegionType.SUBDUCTION_INTERFACE.toString();
    public static final String FLT_TEC_ENV_SLAB = TectonicRegionType.SUBDUCTION_SLAB.toString();
    public static final String FLT_TEC_ENV_VOLCANIC = TectonicRegionType.VOLCANIC.toString();
    public static final String FLT_TYPE_STRIKE_SLIP = "Strike-Slip";
    public static final String FLT_TYPE_REVERSE = "Reverse";
    public static final String FLT_TYPE_REVERSE_OBLIQUE = "Oblique-Reverse";
    public static final String FLT_TYPE_NORMAL = "Normal";
    public static final String FLT_TYPE_INTERFACE = "Subduction-Interface";
    public static final String FLT_TYPE_DEEP_SLAB = "Subduction-Deep-Slab";
    private transient ParameterChangeWarningListener warningListener = null;

    public McVerryetal_2000_AttenRel(ParameterChangeWarningListener warningListener) {
        this.warningListener = warningListener;
        this.initSupportedIntensityMeasureParams();
        this.indexFromPerHashMap = new HashMap();
        for (int i = 1; i < this.period.length; ++i) {
            this.indexFromPerHashMap.put(this.period[i], i);
        }
        this.initEqkRuptureParams();
        this.initPropagationEffectParams();
        this.initSiteParams();
        this.initOtherParams();
        this.initIndependentParamLists();
        this.initParameterEventListeners();
    }

    @Override
    public void setEqkRupture(EqkRupture eqkRupture) throws InvalidRangeException {
        this.magParam.setValueIgnoreWarning(eqkRupture.getMag());
        this.setFaultTypeFromRake(eqkRupture.getAveRake());
        this.eqkRupture = eqkRupture;
        this.setPropagationEffectParams();
        if (this.tecRegType.equals(FLT_TEC_ENV_INTERFACE) || this.tecRegType.equals(FLT_TEC_ENV_INTERFACE)) {
            RuptureSurface surf = this.eqkRupture.getRuptureSurface();
            double hypoLon = 0.0;
            double hypoLat = 0.0;
            double hypoDep = 0.0;
            double cnt = 0.0;
            for (Location loc : surf.getEvenlyDiscritizedListOfLocsOnSurface()) {
                hypoLon += loc.getLongitude();
                hypoLat += loc.getLatitude();
                hypoDep += loc.getDepth();
                cnt += 1.0;
            }
            hypoLon /= cnt;
            hypoLat /= cnt;
            this.focalDepthParam.setValueIgnoreWarning(hypoDep /= cnt);
        }
    }

    @Override
    public void setSite(Site site) throws ParameterException {
        this.siteTypeParam.setValue((String)site.getParameter(SITE_TYPE_NAME).getValue());
        this.site = site;
        this.setPropagationEffectParams();
    }

    @Override
    protected void setPropagationEffectParams() {
        if (this.site != null && this.eqkRupture != null) {
            this.distanceRupParam.setValueIgnoreWarning(this.eqkRupture.getRuptureSurface().getDistanceRup(this.site.getLocation()));
        }
    }

    protected void setCoeffIndex() throws ParameterException {
        if (this.im == null) {
            throw new ParameterException("McVerryetal_2000_AttenRel: updateCoefficients(): The Intensity Measusre Parameter has not been set yet, unable to process.");
        }
        this.iper = this.im.getName().equalsIgnoreCase("PGA") ? 1 : (Integer)this.indexFromPerHashMap.get(this.saPeriodParam.getValue());
        this.parameterChange = true;
        this.intensityMeasureChanged = false;
    }

    @Override
    public double getMean() {
        if (this.rRup > this.USER_MAX_DISTANCE) {
            return -35.0;
        }
        if (this.intensityMeasureChanged) {
            this.setCoeffIndex();
        }
        double pga = Math.exp(this.getMean(0, this.siteTypeParam, this.rRup, this.mag, this.Hc, this.fltType, this.component));
        double pga_prime = Math.exp(this.getMean(1, this.siteTypeParam, this.rRup, this.mag, this.Hc, this.fltType, this.component));
        double sa_prime = Math.exp(this.getMean(this.iper, this.siteTypeParam, this.rRup, this.mag, this.Hc, this.fltType, this.component));
        return Math.log(sa_prime * pga / pga_prime);
    }

    @Override
    public double getStdDev() {
        if (this.intensityMeasureChanged) {
            this.setCoeffIndex();
        }
        return this.getStdDev(this.iper, this.stdDevType, this.component);
    }

    protected void setFaultTypeFromRake(double rake) throws InvalidRangeException {
        if (rake <= 33.0 && rake >= -33.0) {
            this.fltTypeParam.setValue(FLT_TYPE_STRIKE_SLIP);
        } else if (rake <= -147.0 || rake >= 147.0) {
            this.fltTypeParam.setValue(FLT_TYPE_STRIKE_SLIP);
        } else if (rake > 33.0 && rake < 66.0) {
            this.fltTypeParam.setValue(FLT_TYPE_REVERSE_OBLIQUE);
        } else if (rake > 123.0 && rake < 147.0) {
            this.fltTypeParam.setValue(FLT_TYPE_REVERSE_OBLIQUE);
        } else if (rake > 66.0 && rake < 123.0) {
            this.fltTypeParam.setValue(FLT_TYPE_REVERSE);
        } else if (rake > -147.0 && rake < -33.0) {
            this.fltTypeParam.setValue(FLT_TYPE_NORMAL);
        }
    }

    @Override
    public void setParamDefaults() {
        this.siteTypeParam.setValue("A-Strong-Rock");
        this.magParam.setValueAsDefault();
        this.distanceRupParam.setValueAsDefault();
        this.fltTypeParam.setValueAsDefault();
        this.tectonicRegionTypeParam.setValueAsDefault();
        this.focalDepthParam.setValueAsDefault();
        this.saParam.setValueAsDefault();
        this.saPeriodParam.setValueAsDefault();
        this.saDampingParam.setValueAsDefault();
        this.pgaParam.setValueAsDefault();
        this.stdDevTypeParam.setValueAsDefault();
        this.componentParam.setValueAsDefault();
        this.mag = (Double)this.magParam.getValue();
        this.fltType = (String)this.fltTypeParam.getValue();
        this.Hc = (Double)this.focalDepthParam.getValue();
        this.tecRegType = ((String)this.tectonicRegionTypeParam.getValue()).toString();
        this.stdDevType = (String)this.stdDevTypeParam.getValue();
        this.component = (Component)this.componentParam.getValue();
    }

    protected void initIndependentParamLists() {
        this.meanIndependentParams.clear();
        this.meanIndependentParams.addParameter(this.distanceRupParam);
        this.meanIndependentParams.addParameter(this.siteTypeParam);
        this.meanIndependentParams.addParameter(this.magParam);
        this.meanIndependentParams.addParameter(this.fltTypeParam);
        this.meanIndependentParams.addParameter(this.focalDepthParam);
        this.meanIndependentParams.addParameter(this.tectonicRegionTypeParam);
        this.meanIndependentParams.addParameter(this.componentParam);
        this.stdDevIndependentParams.clear();
        this.stdDevIndependentParams.addParameterList(this.meanIndependentParams);
        this.stdDevIndependentParams.addParameter(this.stdDevTypeParam);
        this.exceedProbIndependentParams.clear();
        this.exceedProbIndependentParams.addParameterList(this.stdDevIndependentParams);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncTypeParam);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncLevelParam);
        this.imlAtExceedProbIndependentParams.addParameterList(this.exceedProbIndependentParams);
        this.imlAtExceedProbIndependentParams.addParameter(this.exceedProbParam);
    }

    @Override
    protected void initSiteParams() {
        StringConstraint siteConstraint = new StringConstraint();
        siteConstraint.addString("A-Strong-Rock");
        siteConstraint.addString(SITE_TYPE_B);
        siteConstraint.addString(SITE_TYPE_C);
        siteConstraint.addString(SITE_TYPE_D);
        siteConstraint.setNonEditable();
        this.siteTypeParam = new StringParameter(SITE_TYPE_NAME, siteConstraint, null);
        this.siteTypeParam.setInfo(SITE_TYPE_INFO);
        this.siteTypeParam.setNonEditable();
        this.siteParams.clear();
        this.siteParams.addParameter(this.siteTypeParam);
    }

    @Override
    protected void initEqkRuptureParams() {
        this.magParam = new MagParam(MAG_WARN_MIN, (double)MAG_WARN_MAX);
        this.focalDepthParam = new FocalDepthParam(FOCALDEPTH_WARN_MIN, (double)FOCALDEPTH_WARN_MAX);
        StringConstraint constraint = new StringConstraint();
        constraint.addString(FLT_TYPE_STRIKE_SLIP);
        constraint.addString(FLT_TYPE_REVERSE);
        constraint.addString(FLT_TYPE_REVERSE_OBLIQUE);
        constraint.addString(FLT_TYPE_NORMAL);
        constraint.addString(FLT_TYPE_INTERFACE);
        constraint.addString(FLT_TYPE_DEEP_SLAB);
        constraint.setNonEditable();
        this.fltTypeParam = new FaultTypeParam(constraint, FLT_TYPE_STRIKE_SLIP);
        this.eqkRuptureParams.clear();
        this.eqkRuptureParams.addParameter(this.magParam);
        this.eqkRuptureParams.addParameter(this.focalDepthParam);
        this.eqkRuptureParams.addParameter(this.fltTypeParam);
    }

    @Override
    protected void initPropagationEffectParams() {
        this.distanceRupParam = new DistanceRupParameter(0.0);
        DoubleConstraint warn = new DoubleConstraint(DISTANCE_RUP_WARN_MIN, DISTANCE_RUP_WARN_MAX);
        warn.setNonEditable();
        this.distanceRupParam.setWarningConstraint(warn);
        this.distanceRupParam.addParameterChangeWarningListener(this.warningListener);
        this.distanceRupParam.setNonEditable();
        this.propagationEffectParams.addParameter(this.distanceRupParam);
    }

    @Override
    protected void initSupportedIntensityMeasureParams() {
        DoubleDiscreteConstraint periodConstraint = new DoubleDiscreteConstraint();
        for (int i = 2; i < this.period.length; ++i) {
            periodConstraint.addDouble((Double)this.period[i]);
        }
        periodConstraint.setNonEditable();
        this.saPeriodParam = new PeriodParam(periodConstraint);
        this.saDampingParam = new DampingParam();
        this.saParam = new SA_Param(this.saPeriodParam, this.saDampingParam);
        this.saParam.setNonEditable();
        this.pgaParam = new PGA_Param();
        this.pgaParam.setNonEditable();
        this.saParam.addParameterChangeWarningListener(this.warningListener);
        this.pgaParam.addParameterChangeWarningListener(this.warningListener);
        this.supportedIMParams.clear();
        this.supportedIMParams.addParameter(this.saParam);
        this.supportedIMParams.addParameter(this.pgaParam);
    }

    @Override
    protected void initOtherParams() {
        super.initOtherParams();
        this.componentParam = new ComponentParam(Component.AVE_HORZ, Component.AVE_HORZ, Component.GREATER_OF_TWO_HORZ);
        StringConstraint stdDevTypeConstraint = new StringConstraint();
        stdDevTypeConstraint.addString("Total");
        stdDevTypeConstraint.addString("None (zero)");
        stdDevTypeConstraint.addString("Inter-Event");
        stdDevTypeConstraint.addString("Intra-Event");
        stdDevTypeConstraint.setNonEditable();
        this.stdDevTypeParam = new StdDevTypeParam(stdDevTypeConstraint);
        StringConstraint tectTypeConstraint = new StringConstraint();
        tectTypeConstraint.addString(FLT_TEC_ENV_CRUSTAL);
        tectTypeConstraint.addString(FLT_TEC_ENV_SLAB);
        tectTypeConstraint.addString(FLT_TEC_ENV_INTERFACE);
        this.tectonicRegionTypeParam = new TectonicRegionTypeParam(tectTypeConstraint, FLT_TEC_ENV_INTERFACE);
        this.otherParams.addParameter(this.componentParam);
        this.otherParams.addParameter(this.stdDevTypeParam);
        this.otherParams.replaceParameter("Tectonic Region", this.tectonicRegionTypeParam);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    public double getMean(int iper, StringParameter siteTypeParam, double rRup, double mag, double Hc, String fltType, Component component) {
        double lnSA_CD;
        double CN = 0.0;
        double CR = 0.0;
        double SI = 0.0;
        double DS = 0.0;
        double deltaC = 0.0;
        double deltaD = 0.0;
        String siteType = ((String)siteTypeParam.getValue()).toString();
        double rVol = 0.0;
        if (this.tecRegType.equals(FLT_TEC_ENV_VOLCANIC)) {
            rVol = rRup;
        }
        if (this.tecRegType.equals(FLT_TEC_ENV_CRUSTAL) || this.tecRegType.equals(FLT_TEC_ENV_VOLCANIC)) {
            if (fltType.equals(FLT_TYPE_NORMAL)) {
                CN = -1.0;
            } else if (fltType.equals(FLT_TYPE_REVERSE)) {
                CR = 1.0;
            } else if (fltType.equals(FLT_TYPE_REVERSE_OBLIQUE)) {
                CR = 0.5;
            } else if (!fltType.equals(FLT_TYPE_STRIKE_SLIP)) {
                throw new RuntimeException("The fault type is not supported");
            }
        } else if (this.tecRegType.equals(FLT_TEC_ENV_INTERFACE)) {
            SI = 1.0;
        } else if (this.tecRegType.equals(FLT_TEC_ENV_SLAB)) {
            DS = 1.0;
        } else {
            throw new RuntimeException("The tectonic region type is not supported");
        }
        if (siteType.equals(SITE_TYPE_C)) {
            deltaC = 1.0;
        } else if (siteType.equals(SITE_TYPE_D)) {
            deltaD = 1.0;
        }
        if (component == Component.AVE_HORZ) {
            double lnSA_AB = this.tecRegType.equals(FLT_TEC_ENV_CRUSTAL) || this.tecRegType.equals(FLT_TEC_ENV_VOLCANIC) ? this.C1_gm[iper] + this.C4AS_gm * (mag - 6.0) + this.C3AS_gm[iper] * Math.pow(8.5 - mag, 2.0) + this.C5_gm[iper] * rRup + (this.C8_gm[iper] + this.C6AS_gm * (mag - 6.0)) * Math.log(Math.sqrt(Math.pow(rRup, 2.0) + Math.pow(this.C10AS_gm[iper], 2.0))) + this.C46_gm[iper] * rVol + this.C32_gm * CN + this.C33AS_gm[iper] * CR : this.C11_gm[iper] + (this.C12y_gm + (this.C15_gm[iper] - this.C17_gm[iper]) * this.C19y_gm) * (mag - 6.0) + this.C13y_gm[iper] * Math.pow(10.0 - mag, 3.0) + this.C17_gm[iper] * Math.log(rRup + this.C18y_gm * Math.exp(this.C19y_gm * mag)) + this.C20_gm[iper] * Hc + this.C24_gm[iper] * SI + this.C46_gm[iper] * rVol * (1.0 - DS);
            lnSA_CD = lnSA_AB + this.C29_gm[iper] * deltaC + (this.C30AS_gm[iper] * Math.log(Math.exp(lnSA_AB) + 0.03) + this.C43_gm[iper]) * deltaD;
        } else {
            double lnSA_AB = this.tecRegType.equals(FLT_TEC_ENV_CRUSTAL) || this.tecRegType.equals(FLT_TEC_ENV_VOLCANIC) ? this.C1_lh[iper] + this.C4AS_lh * (mag - 6.0) + this.C3AS_lh[iper] * Math.pow(8.5 - mag, 2.0) + this.C5_lh[iper] * rRup + (this.C8_lh[iper] + this.C6AS_lh * (mag - 6.0)) * Math.log(Math.sqrt(Math.pow(rRup, 2.0) + Math.pow(this.C10AS_lh[iper], 2.0))) + this.C46_lh[iper] * rVol + this.C32_lh * CN + this.C33AS_lh[iper] * CR : this.C11_lh[iper] + (this.C12y_lh + (this.C15_lh[iper] - this.C17_lh[iper]) * this.C19y_lh) * (mag - 6.0) + this.C13y_lh[iper] * Math.pow(10.0 - mag, 3.0) + this.C17_lh[iper] * Math.log(rRup + this.C18y_lh * Math.exp(this.C19y_lh * mag)) + this.C20_lh[iper] * Hc + this.C24_lh[iper] * SI + this.C46_lh[iper] * rVol * (1.0 - DS);
            lnSA_CD = lnSA_AB + this.C29_lh[iper] * deltaC + (this.C30AS_lh[iper] * Math.log(Math.exp(lnSA_AB) + 0.03) + this.C43_lh[iper]) * deltaD;
        }
        double lnSA = lnSA_CD;
        return lnSA;
    }

    public double getStdDev(int iper, String stdDevType, Component component) {
        if (stdDevType.equals("None (zero)")) {
            return 0.0;
        }
        if (stdDevType.equals("Inter-Event")) {
            double sigmaInter = component == Component.AVE_HORZ ? this.tau_gm[iper] : this.tau_lh[iper];
            return sigmaInter;
        }
        double sigmaIntra = this.mag <= 5.0 ? (component == Component.AVE_HORZ ? this.sigma6_gm[iper] - this.sigSlope_gm[iper] : this.sigma6_lh[iper] - this.sigSlope_lh[iper]) : (this.mag >= 7.0 ? (component == Component.AVE_HORZ ? this.sigma6_gm[iper] + this.sigSlope_gm[iper] : this.sigma6_lh[iper] + this.sigSlope_lh[iper]) : (component == Component.AVE_HORZ ? this.sigma6_gm[iper] + this.sigSlope_gm[iper] * (this.mag - 6.0) : this.sigma6_lh[iper] + this.sigSlope_lh[iper] * (this.mag - 6.0)));
        if (stdDevType.equals("Intra-Event")) {
            return sigmaIntra;
        }
        if (stdDevType.equals("Total")) {
            double sigmaInter = component == Component.AVE_HORZ ? this.tau_gm[iper] : this.tau_lh[iper];
            double sigmaTotal = Math.sqrt(Math.pow(sigmaIntra, 2.0) + Math.pow(sigmaInter, 2.0));
            return sigmaTotal;
        }
        return Double.NaN;
    }

    @Override
    public void parameterChange(ParameterChangeEvent e) {
        String pName = e.getParameterName();
        Object val = e.getNewValue();
        this.parameterChange = true;
        if (pName.equals("DistanceRup")) {
            this.rRup = (Double)val;
        } else if (pName.equals("Magnitude")) {
            this.mag = (Double)val;
        } else if (pName.equals("Std Dev Type")) {
            this.stdDevType = (String)val;
        } else if (pName.equals("Fault Type")) {
            this.fltType = (String)this.fltTypeParam.getValue();
        } else if (pName.equals("Focal Depth")) {
            this.Hc = (Double)this.focalDepthParam.getValue();
        } else if (pName.equals("Tectonic Region")) {
            this.tecRegType = ((String)this.tectonicRegionTypeParam.getValue()).toString();
        } else if (pName.equals("Component")) {
            this.component = (Component)val;
        } else if (pName.equals("SA Period")) {
            this.intensityMeasureChanged = true;
        }
    }

    @Override
    public void resetParameterEventListeners() {
        this.distanceRupParam.removeParameterChangeListener(this);
        this.siteTypeParam.removeParameterChangeListener(this);
        this.magParam.removeParameterChangeListener(this);
        this.focalDepthParam.removeParameterChangeListener(this);
        this.fltTypeParam.removeParameterChangeListener(this);
        this.tectonicRegionTypeParam.removeParameterChangeListener(this);
        this.stdDevTypeParam.removeParameterChangeListener(this);
        this.componentParam.removeParameterChangeListener(this);
        this.saPeriodParam.removeParameterChangeListener(this);
        this.initParameterEventListeners();
    }

    @Override
    protected void initParameterEventListeners() {
        this.distanceRupParam.addParameterChangeListener(this);
        this.siteTypeParam.addParameterChangeListener(this);
        this.magParam.addParameterChangeListener(this);
        this.focalDepthParam.addParameterChangeListener(this);
        this.fltTypeParam.addParameterChangeListener(this);
        this.tectonicRegionTypeParam.addParameterChangeListener(this);
        this.stdDevTypeParam.addParameterChangeListener(this);
        this.componentParam.addParameterChangeListener(this);
        this.saPeriodParam.addParameterChangeListener(this);
    }

    @Override
    public URL getInfoURL() throws MalformedURLException {
        return new URL(URL_INFO_STRING);
    }
}

