/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.attenRelImpl;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.WeightedList;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.exceptions.ConstraintException;
import org.opensha.commons.exceptions.EditableException;
import org.opensha.commons.exceptions.IMRException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.geo.Location;
import org.opensha.commons.param.ParamLinker;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.WarningParameter;
import org.opensha.commons.param.constraint.impl.DoubleDiscreteConstraint;
import org.opensha.commons.param.constraint.impl.EnumConstraint;
import org.opensha.commons.param.constraint.impl.StringConstraint;
import org.opensha.commons.param.impl.EnumParameter;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.commons.param.impl.WarningDoubleParameter;
import org.opensha.commons.param.impl.WeightedListParameter;
import org.opensha.commons.util.ClassUtils;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.imr.param.IntensityMeasureParams.DampingParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.IA_Param;
import org.opensha.sha.imr.param.IntensityMeasureParams.MMI_Param;
import org.opensha.sha.imr.param.IntensityMeasureParams.PGA_Param;
import org.opensha.sha.imr.param.IntensityMeasureParams.PGD_Param;
import org.opensha.sha.imr.param.IntensityMeasureParams.PGV_Param;
import org.opensha.sha.imr.param.IntensityMeasureParams.PeriodInterpolatedParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.PeriodParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.SA_InterpolatedParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.SA_Param;
import org.opensha.sha.imr.param.OtherParams.Component;
import org.opensha.sha.imr.param.OtherParams.ComponentParam;
import org.opensha.sha.imr.param.OtherParams.StdDevTypeParam;

public class MultiIMR_Averaged_AttenRel
extends AttenuationRelationship {
    public static final String NAME = "Averaged Multi IMR";
    public static final String SHORT_NAME = "MultiIMR";
    private static final String C = ClassUtils.getClassNameWithoutPackage(MultiIMR_Averaged_AttenRel.class);
    private static final boolean D = false;
    private List<? extends ScalarIMR> imrs;
    private WeightedList<ScalarIMR> weights;
    public static final String IMR_WEIGHTS_PARAM_NAME = "IMR Weights";
    private WeightedListParameter<ScalarIMR> weightsParam;

    public MultiIMR_Averaged_AttenRel(List<? extends ScalarIMR> imrs) {
        this(imrs, null);
    }

    public MultiIMR_Averaged_AttenRel(List<? extends ScalarIMR> imrs, ArrayList<Double> weights) {
        if (imrs == null) {
            throw new NullPointerException("imrs cannot be null!");
        }
        if (imrs.size() == 0) {
            throw new IllegalArgumentException("imrs must contain at least one IMR");
        }
        this.imrs = imrs;
        this.setWeights(weights);
        this.initSupportedIntensityMeasureParams();
        this.initEqkRuptureParams();
        this.initPropagationEffectParams();
        this.initSiteParams();
        this.initOtherParams();
        this.initIndependentParamLists();
    }

    public List<? extends ScalarIMR> getIMRs() {
        return Collections.unmodifiableList(this.imrs);
    }

    public List<Double> getWeights() {
        ArrayList<Double> ret = new ArrayList<Double>();
        for (int i = 0; i < this.weights.size(); ++i) {
            ret.add(this.weights.getWeight(i));
        }
        return Collections.unmodifiableList(ret);
    }

    public void setWeights(List<Double> newWeights) {
        if (this.weights == null) {
            this.weights = new WeightedList();
            for (ScalarIMR scalarIMR : this.imrs) {
                this.weights.add(scalarIMR, 1.0);
            }
        }
        if (newWeights == null) {
            this.weights.normalize();
        } else {
            this.weights.setWeights(newWeights);
        }
        if (this.weightsParam != null) {
            this.weightsParam.refreshEditor();
        }
    }

    public String toString() {
        StringBuilder s = new StringBuilder("MultiIMR\n");
        for (int i = 0; i < this.imrs.size(); ++i) {
            s.append("\t").append(this.imrs.get(i).getShortName()).append(": ").append(this.weights.getWeight(i)).append("\n");
        }
        return s.toString();
    }

    @Override
    protected void initEqkRuptureParams() {
    }

    @Override
    protected void initPropagationEffectParams() {
    }

    @Override
    protected void initSiteParams() {
        HashMap paramNameIMRMap = new HashMap();
        for (ScalarIMR scalarIMR : this.imrs) {
            ListIterator<Parameter<?>> siteParamsIt = scalarIMR.getSiteParamsIterator();
            while (siteParamsIt.hasNext()) {
                Parameter<?> siteParam = siteParamsIt.next();
                String name = siteParam.getName();
                if (!paramNameIMRMap.containsKey(name)) {
                    paramNameIMRMap.put(name, new ArrayList());
                }
                ArrayList imrsForParam = (ArrayList)paramNameIMRMap.get(name);
                imrsForParam.add(scalarIMR);
            }
        }
        this.siteParams.clear();
        for (String string : paramNameIMRMap.keySet()) {
            ArrayList imrs = (ArrayList)paramNameIMRMap.get(string);
            Object defaultVal = ((ScalarIMR)imrs.get(0)).getParameter(string).getDefaultValue();
            if (defaultVal == null) {
                defaultVal = ((ScalarIMR)imrs.get(0)).getParameter(string).getValue();
            }
            Parameter masterParam = ((ScalarIMR)imrs.get(0)).getParameter(string);
            for (int i = 1; i < imrs.size(); ++i) {
                ScalarIMR imr = (ScalarIMR)imrs.get(i);
                Parameter imrParam = imr.getParameter(string);
                MultiIMR_Averaged_AttenRel.trySetDefault(defaultVal, imrParam);
                MultiIMR_Averaged_AttenRel.linkParams(masterParam, imrParam);
            }
            this.siteParams.addParameter(masterParam);
        }
    }

    private static ParameterList removeNonCommonParams(ParameterList params, ListIterator<Parameter<?>> it) {
        if (params == null) {
            params = new ParameterList();
            while (it.hasNext()) {
                params.addParameter(it.next());
            }
            return params;
        }
        ParameterList paramsToKeep = new ParameterList();
        while (it.hasNext()) {
            Parameter<?> param = it.next();
            paramsToKeep.addParameter(param);
        }
        ParameterList paramsToRemove = new ParameterList();
        for (Parameter<?> param : params) {
            if (paramsToKeep.containsParameter(param)) continue;
            paramsToRemove.addParameter(param);
        }
        for (Parameter<?> param : paramsToRemove) {
            params.removeParameter(param);
        }
        return params;
    }

    @Override
    protected void initSupportedIntensityMeasureParams() {
        ParameterList imrTempList = null;
        for (ScalarIMR scalarIMR : this.imrs) {
            imrTempList = MultiIMR_Averaged_AttenRel.removeNonCommonParams(imrTempList, scalarIMR.getSupportedIntensityMeasuresIterator());
        }
        this.saPeriodParam = null;
        this.saDampingParam = null;
        List<Double> commonPeriods = null;
        if (imrTempList.containsParameter("SA") || imrTempList.containsParameter("SA Interpolated")) {
            this.saDampingParam = new DampingParam();
            this.saDampingParam.setNonEditable();
        }
        if (imrTempList.containsParameter("SA")) {
            commonPeriods = MultiIMR_Averaged_AttenRel.getCommonPeriods(this.imrs);
            if (commonPeriods.size() == 0) {
                System.err.println("WARNING: All IMRS have SA, but no common periods! Skipping SA.");
                imrTempList.removeParameter("SA");
            } else {
                DoubleDiscreteConstraint doubleDiscreteConstraint = new DoubleDiscreteConstraint(commonPeriods);
                Double defaultPeriod = 1.0;
                if (!doubleDiscreteConstraint.isAllowed(defaultPeriod)) {
                    defaultPeriod = doubleDiscreteConstraint.getAllowedDoubles().get(0);
                }
                this.saPeriodParam = new PeriodParam(doubleDiscreteConstraint, defaultPeriod, false);
                this.saPeriodParam.setValueAsDefault();
            }
        }
        this.supportedIMParams.clear();
        for (Parameter<?> imrParam : imrTempList) {
            String name = imrParam.getName();
            if (name.equals("PGA")) {
                this.pgaParam = new PGA_Param();
                this.pgaParam.setNonEditable();
                this.supportedIMParams.addParameter(this.pgaParam);
                continue;
            }
            if (name.equals("PGV")) {
                this.pgvParam = new PGV_Param();
                this.pgvParam.setNonEditable();
                this.supportedIMParams.addParameter(this.pgvParam);
                continue;
            }
            if (name.equals("PGD")) {
                this.pgdParam = new PGD_Param();
                this.pgdParam.setNonEditable();
                this.supportedIMParams.addParameter(this.pgdParam);
                continue;
            }
            if (name.equals("MMI")) {
                MMI_Param mmiParam = new MMI_Param();
                mmiParam.setNonEditable();
                this.supportedIMParams.addParameter(mmiParam);
                continue;
            }
            if (name.equals("IA")) {
                IA_Param iaParam = new IA_Param();
                iaParam.setNonEditable();
                this.supportedIMParams.addParameter(iaParam);
                continue;
            }
            if (name.equals("SA")) {
                this.saParam = new SA_Param(this.saPeriodParam, this.saDampingParam);
                this.saParam.setNonEditable();
                this.supportedIMParams.addParameter(this.saParam);
                for (ScalarIMR scalarIMR : this.imrs) {
                    Parameter imrPeriodParam = scalarIMR.getParameter("SA Period");
                    MultiIMR_Averaged_AttenRel.trySetDefault(this.saPeriodParam, imrPeriodParam);
                    new ParamLinker<Double>(this.saPeriodParam, imrPeriodParam);
                }
                continue;
            }
            if (name.equals("SA Interpolated")) {
                double greatestMin = Double.MIN_VALUE;
                double smallestMax = Double.MAX_VALUE;
                for (ScalarIMR scalarIMR : this.imrs) {
                    SA_InterpolatedParam interParam = (SA_InterpolatedParam)scalarIMR.getParameter("SA Interpolated");
                    try {
                        double min = interParam.getPeriodInterpolatedParam().getMin();
                        double max = interParam.getPeriodInterpolatedParam().getMax();
                        if (min > greatestMin) {
                            greatestMin = min;
                        }
                        if (!(max < smallestMax)) continue;
                        smallestMax = max;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                if (smallestMax <= greatestMin) {
                    throw new RuntimeException("Period ranges don't overlap for interpolated SA");
                }
                double defaultPeriod = 1.0;
                if (defaultPeriod < greatestMin || defaultPeriod > smallestMax) {
                    defaultPeriod = greatestMin;
                }
                PeriodInterpolatedParam periodInterpParam = new PeriodInterpolatedParam(greatestMin, smallestMax, defaultPeriod, false);
                periodInterpParam.setValueAsDefault();
                for (ScalarIMR scalarIMR : this.imrs) {
                    Parameter imrPeriodParam = scalarIMR.getParameter("SA Interpolated Period");
                    MultiIMR_Averaged_AttenRel.trySetDefault(periodInterpParam, imrPeriodParam);
                    new ParamLinker<Double>(periodInterpParam, imrPeriodParam);
                }
                SA_InterpolatedParam saInterParam = new SA_InterpolatedParam(periodInterpParam, this.saDampingParam);
                this.supportedIMParams.addParameter(saInterParam);
                continue;
            }
            throw new RuntimeException("MultiIMR cannot yet handle param of type '" + name + "'");
        }
    }

    public static List<Double> getCommonPeriods(Collection<? extends ScalarIMR> imrs) {
        ScalarIMR firstIMR = imrs.iterator().next();
        firstIMR.setIntensityMeasure("SA");
        SA_Param saParam = (SA_Param)firstIMR.getIntensityMeasure();
        PeriodParam periodParam = saParam.getPeriodParam();
        List<Double> firstPeriods = periodParam.getAllowedDoubles();
        ArrayList<Double> commonPeriods = new ArrayList<Double>();
        for (Double period : firstPeriods) {
            boolean include = true;
            for (ScalarIMR scalarIMR : imrs) {
                scalarIMR.setIntensityMeasure("SA");
                saParam = (SA_Param)scalarIMR.getIntensityMeasure();
                periodParam = saParam.getPeriodParam();
                if (periodParam.isAllowed(period)) continue;
                include = false;
                break;
            }
            if (!include) continue;
            commonPeriods.add(period);
        }
        return commonPeriods;
    }

    protected void initIndependentParamLists() {
        this.meanIndependentParams.clear();
        for (Parameter<?> siteParam : this.siteParams) {
            this.meanIndependentParams.addParameter(siteParam);
        }
        if (this.componentParam != null) {
            this.meanIndependentParams.addParameter(this.componentParam);
        }
        this.stdDevIndependentParams.clear();
        if (this.stdDevTypeParam != null) {
            this.stdDevIndependentParams.addParameter(this.stdDevTypeParam);
        }
        if (this.componentParam != null) {
            this.stdDevIndependentParams.addParameter(this.componentParam);
        }
        this.exceedProbIndependentParams.clear();
        for (Parameter<?> siteParam : this.siteParams) {
            this.exceedProbIndependentParams.addParameter(siteParam);
        }
        if (this.componentParam != null) {
            this.exceedProbIndependentParams.addParameter(this.componentParam);
        }
        if (this.stdDevTypeParam != null) {
            this.exceedProbIndependentParams.addParameter(this.stdDevTypeParam);
        }
        if (this.sigmaTruncTypeParam != null) {
            this.exceedProbIndependentParams.addParameter(this.sigmaTruncTypeParam);
        }
        if (this.sigmaTruncLevelParam != null) {
            this.exceedProbIndependentParams.addParameter(this.sigmaTruncLevelParam);
        }
        this.imlAtExceedProbIndependentParams.addParameterList(this.exceedProbIndependentParams);
        this.imlAtExceedProbIndependentParams.addParameter(this.exceedProbParam);
    }

    private static void trySetDefault(Parameter master, Parameter child) {
        MultiIMR_Averaged_AttenRel.trySetDefault(master.getDefaultValue(), child);
    }

    private static void trySetDefault(Object defaultVal, Parameter param) {
        try {
            param.setDefaultValue(defaultVal);
        }
        catch (EditableException editableException) {
            // empty catch block
        }
    }

    @Override
    protected void initOtherParams() {
        this.weightsParam = new WeightedListParameter(IMR_WEIGHTS_PARAM_NAME, null);
        this.weightsParam.setValue((ScalarIMR)((Object)this.weights));
        this.otherParams.addParameter(this.weightsParam);
        HashMap newParams = new HashMap();
        for (ScalarIMR scalarIMR : this.imrs) {
            for (Parameter<?> param : scalarIMR.getOtherParams()) {
                if (this.otherParams.containsParameter(param)) continue;
                if (!newParams.containsKey(param.getName())) {
                    newParams.put(param.getName(), new ArrayList());
                }
                ArrayList params = (ArrayList)newParams.get(param.getName());
                params.add(param);
            }
        }
        for (String string : newParams.keySet()) {
            ArrayList params = (ArrayList)newParams.get(string);
            StringConstraint sconst = null;
            String sDefault = null;
            List enumVals = null;
            Enum enumDefault = null;
            String nullOption = null;
            Parameter masterParam = (Parameter)params.get(0);
            if (params.size() > 1) {
                String commonVal;
                int i;
                List myVals;
                List commonVals;
                if (params.get(0) instanceof StringParameter) {
                    boolean allCommon = true;
                    commonVals = null;
                    for (Parameter param : params) {
                        StringConstraint sconst_temp = (StringConstraint)param.getConstraint();
                        myVals = sconst_temp.getAllowedValues();
                        if (commonVals == null) {
                            commonVals = myVals;
                        }
                        for (i = ((ArrayList)commonVals).size() - 1; i >= 0; --i) {
                            commonVal = (String)((ArrayList)commonVals).get(i);
                            if (((ArrayList)myVals).contains(commonVal)) continue;
                            allCommon = false;
                            ((ArrayList)commonVals).remove(i);
                        }
                        allCommon = allCommon && ((ArrayList)commonVals).size() == ((ArrayList)myVals).size();
                    }
                    if (!allCommon) {
                        if (((ArrayList)commonVals).size() == 0) continue;
                        sconst = new StringConstraint(commonVals);
                        sDefault = (String)masterParam.getDefaultValue();
                        if (sDefault == null || !sconst.isAllowed(sDefault)) {
                            sDefault = (String)((ArrayList)commonVals).get(0);
                        }
                    }
                } else if (params.get(0) instanceof EnumParameter) {
                    nullOption = ((EnumParameter)params.get(0)).getNullOption();
                    boolean allCommon = true;
                    commonVals = null;
                    for (Parameter param : params) {
                        EnumConstraint econst_temp = (EnumConstraint)param.getConstraint();
                        if (nullOption != null && !nullOption.equals(((EnumParameter)param).getNullOption())) {
                            nullOption = null;
                        }
                        myVals = econst_temp.getAllowedValues();
                        if (commonVals == null) {
                            commonVals = Lists.newArrayList(myVals);
                        }
                        for (i = commonVals.size() - 1; i >= 0; --i) {
                            commonVal = commonVals.get(i);
                            if (myVals.contains(commonVal)) continue;
                            allCommon = false;
                            commonVals.remove(i);
                        }
                        allCommon = allCommon && commonVals.size() == myVals.size();
                    }
                    if (!allCommon) {
                        if (commonVals.size() == 0) continue;
                        enumVals = commonVals;
                        enumDefault = (Enum)masterParam.getDefaultValue();
                        if (!commonVals.contains(enumDefault)) {
                            enumDefault = (Enum)enumVals.get(0);
                        }
                    }
                }
            }
            if (masterParam instanceof ComponentParam) {
                if (enumVals != null) {
                    masterParam = new ComponentParam((Component)enumDefault, enumVals);
                }
                this.componentParam = (ComponentParam)masterParam;
            } else if (masterParam instanceof StdDevTypeParam) {
                if (sconst != null) {
                    if (masterParam.isEditable()) {
                        masterParam.setConstraint(sconst);
                    } else {
                        masterParam = new StdDevTypeParam(sconst, sDefault);
                    }
                }
                this.stdDevTypeParam = (StdDevTypeParam)masterParam;
            } else if (sconst != null) {
                if (masterParam.isEditable()) {
                    masterParam.setConstraint(sconst);
                } else {
                    StringParameter newSParam = new StringParameter(masterParam.getName(), sconst, masterParam.getUnits(), sDefault);
                    masterParam = newSParam;
                }
            }
            if (sDefault != null) {
                masterParam.setValue(sDefault);
            }
            masterParam.setValueAsDefault();
            for (Parameter param : params) {
                if (masterParam == param) continue;
                MultiIMR_Averaged_AttenRel.linkParams(masterParam, param);
            }
            this.otherParams.addParameter(masterParam);
        }
    }

    public void setParameterInIMRs(String paramName, Object value) {
        for (ScalarIMR scalarIMR : this.imrs) {
            Parameter param = scalarIMR.getParameter(paramName);
            if (param instanceof WarningParameter) {
                ((WarningParameter)param).setValueIgnoreWarning(value);
                continue;
            }
            param.setValue(value);
        }
    }

    private static void linkParams(Parameter<?> masterParam, Parameter<?> childParam) {
        Preconditions.checkState((boolean)masterParam.getClass().equals(childParam.getClass()), (String)"Class mismatch!\n\tMaster: %s\n\tChild: %s", masterParam.getClass(), childParam.getClass());
        if (masterParam.getValue() instanceof ParameterList) {
            ParameterList masterList = (ParameterList)masterParam.getValue();
            ParameterList childList = (ParameterList)childParam.getValue();
            for (Parameter<?> subMasterParam : masterList) {
                MultiIMR_Averaged_AttenRel.linkParams(subMasterParam, childList.getParameter(subMasterParam.getName()));
            }
        } else {
            new ParamLinker(masterParam, childParam);
        }
    }

    @Override
    public void setEqkRupture(EqkRupture eqkRupture) {
        this.eqkRupture = eqkRupture;
        for (ScalarIMR scalarIMR : this.imrs) {
            scalarIMR.setEqkRupture(eqkRupture);
        }
    }

    @Override
    public void setSite(Site site) {
        this.site = site;
        for (Parameter<?> parameter : this.siteParams) {
            if (parameter instanceof WarningDoubleParameter) {
                ((WarningDoubleParameter)parameter).setValueIgnoreWarning((Double)site.getParameter(parameter.getName()).getValue());
                continue;
            }
            parameter.setValue(site.getParameter(parameter.getName()).getValue());
        }
        for (ScalarIMR scalarIMR : this.imrs) {
            scalarIMR.setSite(site);
        }
    }

    @Override
    protected void setPropagationEffectParams() {
        throw new UnsupportedOperationException("setPropagationEffectParams is not supported by " + C);
    }

    @Override
    public void setIntensityMeasure(Parameter intensityMeasure) throws ParameterException, ConstraintException {
        Preconditions.checkNotNull((Object)intensityMeasure, (Object)"IM cannot be null");
        super.setIntensityMeasure(intensityMeasure);
        for (ScalarIMR scalarIMR : this.imrs) {
            scalarIMR.setIntensityMeasure(intensityMeasure);
        }
    }

    @Override
    public void setIntensityMeasure(String intensityMeasureName) throws ParameterException {
        super.setIntensityMeasure(intensityMeasureName);
        for (ScalarIMR scalarIMR : this.imrs) {
            scalarIMR.setIntensityMeasure(intensityMeasureName);
        }
    }

    private boolean canSkipIMR(ScalarIMR imr) {
        return this.canSkipIMR(this.imrs.indexOf(imr));
    }

    private boolean canSkipIMR(int i) {
        return this.weights.getWeight(i) == 0.0;
    }

    private double getWeightedValue(double[] vals) {
        if (!this.weights.isNormalized()) {
            this.weights.normalize();
            if (this.weightsParam != null) {
                this.weightsParam.refreshEditor();
            }
        }
        double weighted = this.weights.getWeightedAverage(vals);
        return weighted;
    }

    @Override
    public double getMean() {
        double[] means = new double[this.imrs.size()];
        for (int i = 0; i < this.imrs.size(); ++i) {
            if (this.canSkipIMR(i)) continue;
            ScalarIMR imr = this.imrs.get(i);
            means[i] = imr.getMean();
        }
        return this.getWeightedValue(means);
    }

    @Override
    public double getStdDev() {
        double[] vars = new double[this.imrs.size()];
        for (int i = 0; i < this.imrs.size(); ++i) {
            if (this.canSkipIMR(i)) continue;
            ScalarIMR imr = this.imrs.get(i);
            double sd = imr.getStdDev();
            vars[i] = sd * sd;
        }
        return Math.sqrt(this.getWeightedValue(vars));
    }

    @Override
    public double getEpsilon() {
        double[] vals = new double[this.imrs.size()];
        for (int i = 0; i < this.imrs.size(); ++i) {
            if (this.canSkipIMR(i)) continue;
            ScalarIMR imr = this.imrs.get(i);
            vals[i] = imr.getEpsilon();
        }
        return this.getWeightedValue(vals);
    }

    @Override
    public double getEpsilon(double iml) {
        double[] vals = new double[this.imrs.size()];
        for (int i = 0; i < this.imrs.size(); ++i) {
            if (this.canSkipIMR(i)) continue;
            ScalarIMR imr = this.imrs.get(i);
            vals[i] = imr.getEpsilon(iml);
        }
        return this.getWeightedValue(vals);
    }

    @Override
    public DiscretizedFunc getExceedProbabilities(DiscretizedFunc intensityMeasureLevels) throws ParameterException {
        ArrayList<DiscretizedFunc> funcs = new ArrayList<DiscretizedFunc>();
        for (ScalarIMR scalarIMR : this.imrs) {
            if (this.canSkipIMR(scalarIMR)) {
                funcs.add(null);
                continue;
            }
            funcs.add(scalarIMR.getExceedProbabilities(intensityMeasureLevels.deepClone()));
        }
        for (int i = 0; i < intensityMeasureLevels.size(); ++i) {
            double[] dArray = new double[this.imrs.size()];
            for (int j = 0; j < funcs.size(); ++j) {
                DiscretizedFunc func = (DiscretizedFunc)funcs.get(j);
                if (func == null) continue;
                dArray[j] = func.getY(i);
            }
            intensityMeasureLevels.set(i, this.getWeightedValue(dArray));
        }
        return intensityMeasureLevels;
    }

    @Override
    public double getExceedProbability() throws ParameterException, IMRException {
        Double iml = null;
        for (int i = 0; i < this.imrs.size(); ++i) {
            if (this.canSkipIMR(i)) continue;
            ScalarIMR imr = this.imrs.get(i);
            Double myIML = (Double)imr.getIntensityMeasureLevel();
            Preconditions.checkNotNull((Object)myIML, (Object)"Sub IMR has null IML");
            if (iml == null) {
                iml = myIML;
                continue;
            }
            Preconditions.checkState((boolean)iml.equals(myIML), (String)"IML mismatch: %s != %s", (Object)iml, (Object)myIML);
        }
        return this.getExceedProbability(iml);
    }

    @Override
    protected double getExceedProbability(double mean, double stdDev, double iml) throws ParameterException, IMRException {
        throw new UnsupportedOperationException("getExceedProbability(mean, stdDev, iml) is unsupported for " + C);
    }

    @Override
    public double getExceedProbability(double iml) throws ParameterException, IMRException {
        double[] vals = new double[this.imrs.size()];
        for (int i = 0; i < this.imrs.size(); ++i) {
            if (this.canSkipIMR(i)) continue;
            ScalarIMR imr = this.imrs.get(i);
            vals[i] = imr.getExceedProbability(iml);
        }
        return this.getWeightedValue(vals);
    }

    @Override
    public double getIML_AtExceedProb() throws ParameterException {
        double[] vals = new double[this.imrs.size()];
        for (int i = 0; i < this.imrs.size(); ++i) {
            if (this.canSkipIMR(i)) continue;
            ScalarIMR imr = this.imrs.get(i);
            vals[i] = imr.getIML_AtExceedProb();
        }
        return this.getWeightedValue(vals);
    }

    @Override
    public double getIML_AtExceedProb(double exceedProb) throws ParameterException {
        double[] vals = new double[this.imrs.size()];
        for (int i = 0; i < this.imrs.size(); ++i) {
            if (this.canSkipIMR(i)) continue;
            ScalarIMR imr = this.imrs.get(i);
            vals[i] = imr.getIML_AtExceedProb(exceedProb);
        }
        return this.getWeightedValue(vals);
    }

    @Override
    public DiscretizedFunc getSA_ExceedProbSpectrum(double iml) throws ParameterException, IMRException {
        throw new UnsupportedOperationException("getSA_IML_AtExceedProbSpectrum is unsupported for " + C);
    }

    @Override
    public DiscretizedFunc getSA_IML_AtExceedProbSpectrum(double exceedProb) throws ParameterException, IMRException {
        throw new UnsupportedOperationException("getSA_IML_AtExceedProbSpectrum is unsupported for " + C);
    }

    @Override
    public void setIntensityMeasureLevel(Double iml) throws ParameterException {
        for (ScalarIMR scalarIMR : this.imrs) {
            scalarIMR.setIntensityMeasureLevel(iml);
        }
    }

    @Override
    public void setIntensityMeasureLevel(Object iml) throws ParameterException {
        for (ScalarIMR scalarIMR : this.imrs) {
            scalarIMR.setIntensityMeasureLevel(iml);
        }
    }

    @Override
    public void setSiteLocation(Location loc) {
        for (ScalarIMR scalarIMR : this.imrs) {
            scalarIMR.setSiteLocation(loc);
        }
    }

    @Override
    public void setUserMaxDistance(double maxDist) {
        for (ScalarIMR scalarIMR : this.imrs) {
            scalarIMR.setUserMaxDistance(maxDist);
        }
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void setParamDefaults() {
        if (this.weightsParam.getValue() == null) {
            this.weightsParam.setValue((ScalarIMR)((Object)this.weights));
        }
        for (ScalarIMR scalarIMR : this.imrs) {
            scalarIMR.setParamDefaults();
        }
    }
}

