/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.attenRelImpl;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.ListIterator;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.siteData.SiteDataValue;
import org.opensha.commons.exceptions.IMRException;
import org.opensha.commons.exceptions.InvalidRangeException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.param.AbstractParameter;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.constraint.ParameterConstraint;
import org.opensha.commons.param.constraint.impl.DoubleConstraint;
import org.opensha.commons.param.constraint.impl.IntegerConstraint;
import org.opensha.commons.param.constraint.impl.StringConstraint;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.event.ParameterChangeWarningListener;
import org.opensha.commons.param.impl.BooleanParameter;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.commons.param.impl.IntegerParameter;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.imr.attenRelImpl.AS_1997_AttenRel;
import org.opensha.sha.imr.attenRelImpl.BJF_1997_AttenRel;
import org.opensha.sha.imr.attenRelImpl.Campbell_1997_AttenRel;
import org.opensha.sha.imr.param.IntensityMeasureParams.PeriodParam;
import org.opensha.sha.imr.param.OtherParams.Component;
import org.opensha.sha.imr.param.OtherParams.ComponentParam;
import org.opensha.sha.imr.param.OtherParams.SigmaTruncLevelParam;
import org.opensha.sha.imr.param.OtherParams.SigmaTruncTypeParam;
import org.opensha.sha.imr.param.OtherParams.StdDevTypeParam;
import org.opensha.sha.imr.param.SiteParams.Vs30_Param;
import org.opensha.sha.util.SiteTranslator;

public class SiteSpecific_2006_AttenRel
extends AttenuationRelationship
implements ParameterChangeListener {
    private static final String C = "SiteSpecific_2006_AttenRel";
    private static final boolean D = false;
    public static final String NAME = "Site Specfic AttenuationRelationship (2006)";
    public static final String SHORT_NAME = "SS2006";
    private static final long serialVersionUID = 1234567890987654369L;
    private double[] period = new double[]{0.0, 0.01, 0.02, 0.03, 0.04, 0.05, 0.06, 0.075, 0.09, 0.1, 0.12, 0.15, 0.17, 0.2, 0.24, 0.3, 0.36, 0.4, 0.46, 0.5, 0.6, 0.75, 0.85, 1.0, 1.5, 2.0, 3.0, 4.0, 5.0};
    private double[] b1 = new double[]{-0.64, -0.64, -0.63, -0.62, -0.61, -0.64, -0.64, -0.64, -0.64, -0.6, -0.56, -0.53, -0.53, -0.52, -0.52, -0.52, -0.51, -0.51, -0.5, -0.5, -0.49, -0.47, -0.46, -0.44, -0.4, -0.38, -0.34, -0.31, -0.3};
    private double[] vRef = new double[]{418.0, 418.0, 490.0, 324.0, 233.0, 192.0, 181.0, 196.0, 239.0, 257.0, 299.0, 357.0, 406.0, 453.0, 493.0, 532.0, 535.0, 535.0, 535.0, 535.0, 535.0, 535.0, 535.0, 535.0, 535.0, 535.0, 535.0, 535.0, 535.0};
    private double[] c = new double[]{-0.36, -0.36, -0.34, -0.33, -0.31, -0.29, -0.25, -0.23, -0.23, -0.25, -0.26, -0.28, -0.29, -0.31, -0.38, -0.44, -0.48, -0.5, -0.55, -0.6, -0.66, -0.69, -0.69, -0.7, -0.72, -0.73, -0.74, -0.75, -0.75};
    private double[] b2 = new double[]{-0.14, -0.14, -0.12, -0.11, -0.11, -0.11, -0.11, -0.11, -0.12, -0.13, -0.14, -0.18, -0.19, -0.19, -0.16, -0.14, -0.11, -0.1, -0.08, -0.06, -0.03, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
    private double[] tau = new double[]{0.27, 0.27, 0.26, 0.26, 0.26, 0.25, 0.25, 0.24, 0.23, 0.23, 0.24, 0.25, 0.26, 0.27, 0.29, 0.35, 0.38, 0.4, 0.42, 0.42, 0.42, 0.42, 0.42, 0.42, 0.42, 0.43, 0.45, 0.47, 0.49};
    private double[] e1 = new double[]{0.44, 0.44, 0.45, 0.46, 0.47, 0.47, 0.48, 0.48, 0.49, 0.49, 0.49, 0.49, 0.48, 0.47, 0.47, 0.46, 0.46, 0.46, 0.45, 0.45, 0.44, 0.44, 0.44, 0.44, 0.44, 0.44, 0.44, 0.44, 0.44};
    private double[] e3 = new double[]{0.5, 0.5, 0.51, 0.51, 0.51, 0.52, 0.52, 0.52, 0.52, 0.53, 0.53, 0.54, 0.55, 0.56, 0.56, 0.57, 0.57, 0.57, 0.58, 0.59, 0.6, 0.63, 0.63, 0.64, 0.67, 0.69, 0.71, 0.73, 0.75};
    private ArbitrarilyDiscretizedFunc funcb1 = new ArbitrarilyDiscretizedFunc();
    private ArbitrarilyDiscretizedFunc funcvRef = new ArbitrarilyDiscretizedFunc();
    private ArbitrarilyDiscretizedFunc funcc = new ArbitrarilyDiscretizedFunc();
    private ArbitrarilyDiscretizedFunc funcb2 = new ArbitrarilyDiscretizedFunc();
    private ArbitrarilyDiscretizedFunc functau = new ArbitrarilyDiscretizedFunc();
    private ArbitrarilyDiscretizedFunc funce1 = new ArbitrarilyDiscretizedFunc();
    private ArbitrarilyDiscretizedFunc funce3 = new ArbitrarilyDiscretizedFunc();
    public static final String BJF_CLASS_NAME = "org.opensha.sha.imr.attenRelImpl.BJF_1997_AttenRel";
    public static final String AS_CLASS_NAME = "org.opensha.sha.imr.attenRelImpl.AS_1997_AttenRel";
    public static final String C_CLASS_NAME = "org.opensha.sha.imr.attenRelImpl.Campbell_1997_AttenRel";
    public static final String SCEMY_CLASS_NAME = "org.opensha.sha.imr.attenRelImpl.SadighEtAl_1997_AttenRel";
    private ArrayList attenRelObjects = new ArrayList();
    protected static final Double VS30_WARN_MIN = 50.0;
    protected static final Double VS30_WARN_MAX = 760.0;
    private BooleanParameter softSoilParam = null;
    public static final String SOFT_SOIL_NAME = "Soft Soil Case";
    public static final String SOFT_SOIL_INFO = "Indicates that site is considered NEHRP E regardless of Vs30.\n\nConditions required are undrained shear strength < 24 kPa, PI > 20, water content > 40%, and thickness of clay exceeds 3 m.";
    public static final Boolean SOFT_SOIL_DEFAULT = false;
    private DoubleParameter AF_InterceptParam;
    public static final String AF_INTERCEPT_PARAM_NAME = "AF Intercept";
    public static final String AF_INTERCEPT_PARAM_INFO = "Intercept of the median regression model for the ground response analyses";
    private DoubleConstraint AF_InterceptparamConstraint = new DoubleConstraint(-2.0, 2.0);
    public static final double AF_INTERCEPT_PARAM_DEFAULT = 0.0;
    private DoubleParameter AF_SlopeParam;
    public static final String AF_SLOPE_PARAM_NAME = "AF Slope";
    public static final String AF_SLOPE_PARAM_INFO = "Slope of the median regression model for the ground response analyses";
    private DoubleConstraint AF_slopeParamConstraint = new DoubleConstraint(-1.0, 1.0);
    public static final double AF_SLOPE_PARAM_DEFAULT = 0.0;
    private DoubleParameter AF_AddRefAccParam;
    public static final String AF_ADDITIVE_REF_ACCELERATION_PARAM_NAME = "AF Add. Ref. Acceleration";
    public static final String AF_ADDITIVE_REF_ACCELERATION_PARAM_INFO = "Additive reference acceleration of the median regression model for the ground response analyses. This parameter improves the linear model fit for low Sa(rock) / PGA(rock)values and leads to more relaistic predictons than quadratic models";
    private DoubleConstraint AFaddRefAccParamConstraint = new DoubleConstraint(0.0, 0.5);
    public static final double AF_ADDITIVE_REF_ACCERLATION_DEFAULT = 0.03;
    private DoubleParameter AF_StdDevParam;
    public static final String AF_STD_DEV_PARAM_NAME = "Std. Dev. AF";
    public static final String AF_STD_DEV_PARAM_INFO = "Standard Deviation of the amplification factor from the ground response analyses regression model";
    private DoubleConstraint AF_StdDevParamConstraint = new DoubleConstraint(0.0, 1.0);
    public static final double AF_STD_DEV_DEFAULT = 0.3;
    private IntegerParameter numRunsParam;
    public static final String NUM_RUNS_PARAM_NAME = "Number of Runs";
    public static final String NUM_RUNS_PARAM_INFO = "Number of runs of the wave propagation simulation for the site";
    private IntegerConstraint numRunsConstraint = new IntegerConstraint(1, Integer.MAX_VALUE);
    public static final int NUM_RUNS_PARAM_DEFAULT = 1;
    private StringParameter siteEffectCorrectionParam;
    public static final String SITE_EFFECT_PARAM_NAME = "Site Effect Model";
    public static final String SITE_EFFECT_PARAM_INFO = "Select which model to apply for site effect correction";
    private static final String BATURAY_STEWART_MODEL = "Baturay and Stewart (2003)";
    private static final String BAZZURO_CORNELL_MODEL = "Bazzuro and Cornell(2004)";
    private StringParameter rockAttenRelSelectorParam;
    public static final String ROCK_ATTEN_REL_SELECT_PARAM_NAME = "Rock AttenuationRelationship";
    public static final String ROCK_ATTEN_REL_SELECT_PARAM_INFO = "Select from the given Rock AttenuationRelationships ";
    private ScalarIMR attenRel;
    private SiteTranslator vs30Trans = new SiteTranslator();

    public SiteSpecific_2006_AttenRel(ParameterChangeWarningListener listener) {
        this.listener = listener;
        this.initCoeffFunctionlist();
        this.initRockAttenuationRealtionships();
        this.initRockAttenuationRelationshipSelectorParam();
        this.initSupportedIntensityMeasureParams();
        this.initEqkRuptureParams();
        this.initPropagationEffectParams();
        this.initSiteParams();
        this.initOtherParams();
        this.initIndependentParamLists();
    }

    private void initCoeffFunctionlist() {
        int numPeriods = this.period.length;
        for (int i = 0; i < numPeriods; ++i) {
            this.funcb1.set(this.period[i], this.b1[i]);
            this.funcvRef.set(this.period[i], this.vRef[i]);
            this.funcc.set(this.period[i], this.c[i]);
            this.funcb2.set(this.period[i], this.b2[i]);
            this.functau.set(this.period[i], this.tau[i]);
            this.funce1.set(this.period[i], this.e1[i]);
            this.funce3.set(this.period[i], this.e3[i]);
        }
    }

    private void initRockAttenuationRealtionships() {
        ArrayList<String> supportedAttenRelClasses = new ArrayList<String>();
        supportedAttenRelClasses.add(BJF_CLASS_NAME);
        supportedAttenRelClasses.add(AS_CLASS_NAME);
        supportedAttenRelClasses.add(C_CLASS_NAME);
        supportedAttenRelClasses.add(SCEMY_CLASS_NAME);
        this.createIMRClassInstance(supportedAttenRelClasses);
    }

    private void createIMRClassInstance(ArrayList supportedAttenRelClasses) {
        String S = "SiteSpecific_2006_AttenRel: createIMRClassInstance(): ";
        int size = supportedAttenRelClasses.size();
        for (int i = 0; i < size; ++i) {
            try {
                Class<?> listenerClass = Class.forName("org.opensha.commons.param.event.ParameterChangeWarningListener");
                Object[] paramObjects = new Object[]{this.listener};
                Class[] params = new Class[]{listenerClass};
                Class<?> imrClass = Class.forName((String)supportedAttenRelClasses.get(i));
                Constructor<?> con = imrClass.getConstructor(params);
                Object attenRel = con.newInstance(paramObjects);
                this.attenRelObjects.add(attenRel);
                continue;
            }
            catch (ClassCastException e) {
                System.out.println(S + e.toString());
                throw new RuntimeException(S + e.toString());
            }
            catch (ClassNotFoundException e) {
                System.out.println(S + e.toString());
                throw new RuntimeException(S + e.toString());
            }
            catch (NoSuchMethodException e) {
                System.out.println(S + e.toString());
                throw new RuntimeException(S + e.toString());
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                System.out.println(S + e.toString());
                throw new RuntimeException(S + e.toString());
            }
            catch (IllegalAccessException e) {
                System.out.println(S + e.toString());
                throw new RuntimeException(S + e.toString());
            }
            catch (InstantiationException e) {
                System.out.println(S + e.toString());
                throw new RuntimeException(S + e.toString());
            }
        }
    }

    private void initRockAttenuationRelationshipSelectorParam() {
        ArrayList<String> rockAttenRelList = new ArrayList<String>();
        int size = this.attenRelObjects.size();
        for (int i = 0; i < size; ++i) {
            rockAttenRelList.add(((AttenuationRelationship)this.attenRelObjects.get(i)).getName());
        }
        this.rockAttenRelSelectorParam = new StringParameter(ROCK_ATTEN_REL_SELECT_PARAM_NAME, rockAttenRelList, (String)rockAttenRelList.get(0));
        this.rockAttenRelSelectorParam.setInfo(ROCK_ATTEN_REL_SELECT_PARAM_INFO);
        this.rockAttenRelSelectorParam.addParameterChangeListener(this);
        this.attenRel = (AttenuationRelationship)this.attenRelObjects.get(0);
        this.setRockAttenRelAndParamLists();
    }

    private void setRockAttenRelAndParamLists() {
        String attenRelName = this.attenRel.getName();
        if (attenRelName.equals("Abrahamson & Silva (1997)")) {
            Parameter siteParam = ((AS_1997_AttenRel)this.attenRel).getParameter("AS Site Type");
            SiteDataValue<Double> val = new SiteDataValue<Double>("Vs30", "Inferred", 760.0);
            this.vs30Trans.setParameterValue(siteParam, val);
            this.attenRel.getParameter("Component").setValue(Component.AVE_HORZ);
            this.sigmaTruncTypeParam = (SigmaTruncTypeParam)this.attenRel.getParameter("Gaussian Truncation");
            this.sigmaTruncLevelParam = (SigmaTruncLevelParam)this.attenRel.getParameter("Truncation Level");
            this.exceedProbParam = (DoubleParameter)this.attenRel.getParameter("Exceed. Prob.");
            this.stdDevTypeParam = (StdDevTypeParam)this.attenRel.getParameter("Std Dev Type");
        } else if (attenRelName.equals("Boore, Joyner & Fumal (1997)")) {
            Parameter siteParam = ((BJF_1997_AttenRel)this.attenRel).getParameter("Vs30");
            SiteDataValue<Double> val = new SiteDataValue<Double>("Vs30", "Inferred", 760.0);
            this.vs30Trans.setParameterValue(siteParam, val);
            this.attenRel.getParameter("Component").setValue(Component.AVE_HORZ);
            this.sigmaTruncTypeParam = (SigmaTruncTypeParam)this.attenRel.getParameter("Gaussian Truncation");
            this.sigmaTruncLevelParam = (SigmaTruncLevelParam)this.attenRel.getParameter("Truncation Level");
            this.exceedProbParam = (DoubleParameter)this.attenRel.getParameter("Exceed. Prob.");
            this.stdDevTypeParam = (StdDevTypeParam)this.attenRel.getParameter("Std Dev Type");
        } else if (attenRelName.equals("Campbell (1997) w/ erratum (2000) changes")) {
            Parameter siteParam = ((Campbell_1997_AttenRel)this.attenRel).getParameter("Campbell Site Type");
            SiteDataValue<Double> val = new SiteDataValue<Double>("Vs30", "Inferred", 760.0);
            this.vs30Trans.setParameterValue(siteParam, val);
            this.attenRel.getParameter("Component").setValue(Component.AVE_HORZ);
            this.sigmaTruncTypeParam = (SigmaTruncTypeParam)this.attenRel.getParameter("Gaussian Truncation");
            this.sigmaTruncLevelParam = (SigmaTruncLevelParam)this.attenRel.getParameter("Truncation Level");
            this.exceedProbParam = (DoubleParameter)this.attenRel.getParameter("Exceed. Prob.");
            this.stdDevTypeParam = (StdDevTypeParam)this.attenRel.getParameter("Std Dev Type");
        } else if (attenRelName.equals("Sadigh et al (1997)")) {
            this.attenRel.getParameter("Sadigh Site Type").setValue("Rock");
            this.attenRel.getParameter("Component").setValue(Component.AVE_HORZ);
            this.sigmaTruncTypeParam = (SigmaTruncTypeParam)this.attenRel.getParameter("Gaussian Truncation");
            this.sigmaTruncLevelParam = (SigmaTruncLevelParam)this.attenRel.getParameter("Truncation Level");
            this.exceedProbParam = (DoubleParameter)this.attenRel.getParameter("Exceed. Prob.");
            this.stdDevTypeParam = (StdDevTypeParam)this.attenRel.getParameter("Std Dev Type");
        }
        this.saPeriodParam = (PeriodParam)this.attenRel.getParameter("SA Period");
    }

    @Override
    protected void setPropagationEffectParams() {
    }

    @Override
    public void parameterChange(ParameterChangeEvent e) {
        String pName = e.getParameterName();
        Object val = e.getNewValue();
        if (pName.equals(ROCK_ATTEN_REL_SELECT_PARAM_NAME)) {
            this.attenRel = this.getSelectedIMR_Instance((String)this.rockAttenRelSelectorParam.getValue());
            this.setRockAttenRelAndParamLists();
            this.initSupportedIntensityMeasureParams();
            this.initEqkRuptureParams();
            this.initPropagationEffectParams();
            this.initOtherParams();
            this.attenRel.setParamDefaults();
        } else if (pName.equals(SITE_EFFECT_PARAM_NAME)) {
            if (val.equals(BAZZURO_CORNELL_MODEL)) {
                if (this.siteParams.containsParameter(this.vs30Param)) {
                    this.siteParams.removeParameter("Vs30");
                }
                if (this.siteParams.containsParameter(SOFT_SOIL_NAME)) {
                    this.siteParams.removeParameter(SOFT_SOIL_NAME);
                }
                if (this.siteParams.containsParameter(NUM_RUNS_PARAM_NAME)) {
                    this.siteParams.removeParameter(NUM_RUNS_PARAM_NAME);
                }
            } else {
                if (!this.siteParams.containsParameter(this.vs30Param)) {
                    this.siteParams.addParameter(this.vs30Param);
                }
                if (!this.siteParams.containsParameter(this.softSoilParam)) {
                    this.siteParams.addParameter(this.softSoilParam);
                }
                if (!this.siteParams.containsParameter(this.numRunsParam)) {
                    this.siteParams.addParameter(this.numRunsParam);
                }
            }
        }
        this.initIndependentParamLists();
    }

    public ScalarIMR getSelectedIMR_Instance(String selectedIMR) {
        ScalarIMR imr = null;
        int size = this.attenRelObjects.size();
        for (int i = 0; i < size && !(imr = (ScalarIMR)this.attenRelObjects.get(i)).getName().equalsIgnoreCase(selectedIMR); ++i) {
        }
        return imr;
    }

    @Override
    public void setEqkRupture(EqkRupture eqkRupture) throws InvalidRangeException {
        this.attenRel.setEqkRupture(eqkRupture);
        this.eqkRupture = eqkRupture;
    }

    @Override
    public void setSite(Site site) throws ParameterException {
        this.AF_InterceptParam.setValue((Double)site.getParameter(AF_INTERCEPT_PARAM_NAME).getValue());
        this.AF_AddRefAccParam.setValue((Double)site.getParameter(AF_ADDITIVE_REF_ACCELERATION_PARAM_NAME).getValue());
        this.AF_SlopeParam.setValue((Double)site.getParameter(AF_SLOPE_PARAM_NAME).getValue());
        this.AF_StdDevParam.setValue((Double)site.getParameter(AF_STD_DEV_PARAM_NAME).getValue());
        String modelType = (String)this.siteEffectCorrectionParam.getValue();
        if (modelType.equals(BATURAY_STEWART_MODEL)) {
            this.vs30Param.setValueIgnoreWarning((Double)site.getParameter("Vs30").getValue());
            this.softSoilParam.setValue((Boolean)site.getParameter(SOFT_SOIL_NAME).getValue());
            this.numRunsParam.setValue((Integer)site.getParameter(NUM_RUNS_PARAM_NAME).getValue());
        }
        this.site = site;
        this.attenRel.setSiteLocation(site.getLocation());
    }

    @Override
    public double getMean() throws IMRException {
        this.attenRel.setIntensityMeasure(this.im);
        double asRockSA = this.attenRel.getMean();
        double aVal = (Double)this.AF_InterceptParam.getValue();
        double bVal = (Double)this.AF_SlopeParam.getValue();
        double cVal = (Double)this.AF_AddRefAccParam.getValue();
        double lnAF = aVal + bVal * Math.log(Math.exp(asRockSA) + cVal);
        return lnAF + asRockSA;
    }

    @Override
    public double getStdDev() {
        String stdDevType = ((String)this.stdDevTypeParam.getValue()).toString();
        if (stdDevType.equals("None (zero)")) {
            return 0.0;
        }
        String siteCorrectionModelUsed = (String)this.siteEffectCorrectionParam.getValue();
        if (siteCorrectionModelUsed.equals(BAZZURO_CORNELL_MODEL)) {
            return this.getStdDevForBC();
        }
        float periodParamVal = this.im.getName().equals("SA") ? (float)((Double)this.saPeriodParam.getValue()).doubleValue() : 0.0f;
        if ((double)periodParamVal < 0.75) {
            return this.getStdDevForBS();
        }
        if ((double)periodParamVal > 1.5) {
            return this.getStdDevForCS();
        }
        this.saPeriodParam.setValue(0.75);
        double stdDev_BS = this.getStdDevForBS();
        this.saPeriodParam.setValue(1.5);
        double stdDev_CS = this.getStdDevForCS();
        DecimalFormat format = new DecimalFormat("##.###");
        this.saPeriodParam.setValue(Double.valueOf(format.format(periodParamVal)));
        double stdDev = ((double)periodParamVal - 0.75) / 0.75 * (stdDev_CS - stdDev_BS) + stdDev_BS;
        return stdDev;
    }

    private double getStdDevForBC() {
        double bVal = (Double)this.AF_SlopeParam.getValue();
        double stdDevAF = (Double)this.AF_StdDevParam.getValue();
        this.attenRel.setIntensityMeasure(this.im);
        double asRockStdDev = this.attenRel.getStdDev();
        double stdDev = Math.pow(bVal + 1.0, 2.0) * Math.pow(asRockStdDev, 2.0) + Math.pow(stdDevAF, 2.0);
        return Math.sqrt(stdDev);
    }

    private double getStdDevForBS() {
        double stdDevAF = (Double)this.AF_StdDevParam.getValue();
        int numRuns = (Integer)this.numRunsParam.getValue();
        boolean softSoilCase = (Boolean)this.softSoilParam.getValue();
        double stdError = stdDevAF / Math.sqrt(numRuns);
        double vs30 = (Double)this.vs30Param.getValue();
        double stdDev_gNet = vs30 <= 180.0 || softSoilCase ? 0.38 : 0.56;
        double stdDev = Math.pow(stdDev_gNet, 2.0) + Math.pow(stdError, 2.0);
        return Math.sqrt(stdDev);
    }

    private double getStdDevForCS() throws IMRException {
        double vs30;
        double periodParamVal = (Double)this.saPeriodParam.getValue();
        if (((Boolean)this.softSoilParam.getValue()).booleanValue()) {
            vs30 = 174.0;
        } else {
            try {
                vs30 = (Double)this.vs30Param.getValue();
            }
            catch (NullPointerException e) {
                throw new IMRException("SiteSpecific_2006_AttenRel: getStdDev(): Not all parameters have been set");
            }
        }
        double sigmaV = vs30 < 260.0 ? this.funce1.getInterpolatedY(periodParamVal) : (vs30 < 360.0 ? this.funce1.getInterpolatedY(periodParamVal) + (this.funce3.getInterpolatedY(periodParamVal) - this.funce1.getInterpolatedY(periodParamVal)) / Math.log(1.0) * Math.log(vs30 / 260.0) : this.funce3.getInterpolatedY(periodParamVal));
        return Math.sqrt(sigmaV * sigmaV + this.functau.getInterpolatedY(periodParamVal) * this.functau.getInterpolatedY(periodParamVal));
    }

    @Override
    public void setParamDefaults() {
        this.vs30Param.setValueAsDefault();
        this.softSoilParam.setValue(false);
        String rockAttenDefaultVal = this.rockAttenRelSelectorParam.getAllowedStrings().get(0);
        this.rockAttenRelSelectorParam.setValue(rockAttenDefaultVal);
        this.siteEffectCorrectionParam.setValue(BATURAY_STEWART_MODEL);
        this.AF_AddRefAccParam.setValue(Double.valueOf(0.03));
        this.AF_InterceptParam.setValue(Double.valueOf(0.0));
        this.AF_SlopeParam.setValue(Double.valueOf(0.0));
        this.AF_StdDevParam.setValue(Double.valueOf(0.3));
        this.numRunsParam.setValue(1);
        this.attenRel.setParamDefaults();
        this.initRockAttenuationRealtionships();
    }

    protected void initIndependentParamLists() {
        String siteParamName;
        int i;
        boolean isSiteTypeParam;
        AbstractParameter param;
        this.meanIndependentParams.clear();
        ListIterator it = this.attenRel.getMeanIndependentParamsIterator();
        ArrayList<String> siteParamNames = new ArrayList<String>();
        ListIterator<Parameter<?>> siteTypeParamIterator = this.siteParams.getParametersIterator();
        while (siteTypeParamIterator.hasNext()) {
            Parameter<?> siteParam = siteTypeParamIterator.next();
            siteParamNames.add(siteParam.getName());
        }
        int numSiteParams = siteParamNames.size();
        while (it.hasNext()) {
            param = (AbstractParameter)it.next();
            if (param.getName().equals("Component")) continue;
            isSiteTypeParam = false;
            for (i = 0; i < numSiteParams; ++i) {
                siteParamName = (String)siteParamNames.get(i);
                if (!param.getName().equals(siteParamName)) continue;
                isSiteTypeParam = true;
                break;
            }
            if (isSiteTypeParam || this.meanIndependentParams.containsParameter(param)) continue;
            this.meanIndependentParams.addParameter(param);
        }
        this.stdDevIndependentParams.clear();
        it = this.attenRel.getStdDevIndependentParamsIterator();
        while (it.hasNext()) {
            param = (AbstractParameter)it.next();
            if (param.getName().equals("Component")) continue;
            isSiteTypeParam = false;
            for (i = 0; i < numSiteParams; ++i) {
                siteParamName = (String)siteParamNames.get(i);
                if (!param.getName().equals(siteParamName)) continue;
                isSiteTypeParam = true;
                break;
            }
            if (isSiteTypeParam || this.stdDevIndependentParams.containsParameter(param)) continue;
            this.stdDevIndependentParams.addParameter(param);
        }
        this.exceedProbIndependentParams.clear();
        it = this.attenRel.getExceedProbIndependentParamsIterator();
        while (it.hasNext()) {
            param = (AbstractParameter)it.next();
            if (param.getName().equals("Component")) continue;
            isSiteTypeParam = false;
            for (i = 0; i < numSiteParams; ++i) {
                siteParamName = (String)siteParamNames.get(i);
                if (!param.getName().equals(siteParamName)) continue;
                isSiteTypeParam = true;
                break;
            }
            if (isSiteTypeParam || this.exceedProbIndependentParams.containsParameter(param)) continue;
            this.exceedProbIndependentParams.addParameter(param);
        }
        this.meanIndependentParams.addParameter(this.componentParam);
        this.meanIndependentParams.addParameter(this.rockAttenRelSelectorParam);
        this.meanIndependentParams.addParameter(this.siteEffectCorrectionParam);
        this.stdDevIndependentParams.addParameter(this.componentParam);
        this.stdDevIndependentParams.addParameter(this.rockAttenRelSelectorParam);
        this.stdDevIndependentParams.addParameter(this.siteEffectCorrectionParam);
        this.exceedProbIndependentParams.addParameter(this.componentParam);
        this.exceedProbIndependentParams.addParameter(this.rockAttenRelSelectorParam);
        this.exceedProbIndependentParams.addParameter(this.siteEffectCorrectionParam);
        String siteCorrectionModel = (String)this.siteEffectCorrectionParam.getValue();
        ListIterator<Parameter<?>> lit = this.siteParams.getParametersIterator();
        if (siteCorrectionModel.equals(BATURAY_STEWART_MODEL)) {
            while (lit.hasNext()) {
                Parameter<?> param2 = lit.next();
                this.meanIndependentParams.addParameter(param2);
                this.stdDevIndependentParams.addParameter(param2);
                this.exceedProbIndependentParams.addParameter(param2);
            }
        } else {
            while (lit.hasNext()) {
                Parameter<?> param3 = lit.next();
                if (param3.getName().equals("Vs30")) continue;
                if (param3.getName().equals(NUM_RUNS_PARAM_NAME) || param3.getName().equals(this.softSoilParam.getName())) continue;
                this.meanIndependentParams.addParameter(param3);
                this.stdDevIndependentParams.addParameter(param3);
                this.exceedProbIndependentParams.addParameter(param3);
            }
        }
        this.imlAtExceedProbIndependentParams.clear();
        this.imlAtExceedProbIndependentParams.addParameterList(this.exceedProbIndependentParams);
        this.imlAtExceedProbIndependentParams.addParameter(this.exceedProbParam);
    }

    @Override
    protected void initSiteParams() {
        this.vs30Param = new Vs30_Param(VS30_WARN_MIN, (double)VS30_WARN_MAX);
        this.softSoilParam = new BooleanParameter(SOFT_SOIL_NAME, SOFT_SOIL_DEFAULT);
        this.softSoilParam.setInfo(SOFT_SOIL_INFO);
        this.AF_InterceptParam = new DoubleParameter(AF_INTERCEPT_PARAM_NAME, this.AF_InterceptparamConstraint, (Double)0.0);
        this.AF_InterceptParam.setInfo(AF_INTERCEPT_PARAM_INFO);
        this.AF_SlopeParam = new DoubleParameter(AF_SLOPE_PARAM_NAME, this.AF_slopeParamConstraint, (Double)0.0);
        this.AF_SlopeParam.setInfo(AF_SLOPE_PARAM_INFO);
        this.AF_AddRefAccParam = new DoubleParameter(AF_ADDITIVE_REF_ACCELERATION_PARAM_NAME, this.AFaddRefAccParamConstraint, (Double)0.03);
        this.AF_AddRefAccParam.setInfo(AF_ADDITIVE_REF_ACCELERATION_PARAM_INFO);
        this.AF_StdDevParam = new DoubleParameter(AF_STD_DEV_PARAM_NAME, this.AF_StdDevParamConstraint, (Double)0.3);
        this.AF_StdDevParam.setInfo(AF_STD_DEV_PARAM_INFO);
        this.numRunsParam = new IntegerParameter(NUM_RUNS_PARAM_NAME, (ParameterConstraint<Integer>)this.numRunsConstraint, (Integer)1);
        this.numRunsParam.setInfo(NUM_RUNS_PARAM_INFO);
        this.siteParams.clear();
        this.siteParams.addParameter(this.AF_InterceptParam);
        this.siteParams.addParameter(this.AF_SlopeParam);
        this.siteParams.addParameter(this.AF_AddRefAccParam);
        this.siteParams.addParameter(this.AF_StdDevParam);
        this.siteParams.addParameter(this.vs30Param);
        this.siteParams.addParameter(this.softSoilParam);
        this.siteParams.addParameter(this.numRunsParam);
    }

    @Override
    protected void initEqkRuptureParams() {
        this.eqkRuptureParams.clear();
        ListIterator<Parameter<?>> it = this.attenRel.getEqkRuptureParamsIterator();
        while (it.hasNext()) {
            this.eqkRuptureParams.addParameter((AbstractParameter)it.next());
        }
    }

    @Override
    protected void initPropagationEffectParams() {
        this.propagationEffectParams.clear();
        ListIterator<Parameter<?>> it = this.attenRel.getPropagationEffectParamsIterator();
        while (it.hasNext()) {
            this.propagationEffectParams.addParameter((AbstractParameter)it.next());
        }
    }

    @Override
    protected void initSupportedIntensityMeasureParams() {
        this.supportedIMParams.clear();
        ListIterator<Parameter<?>> it = this.attenRel.getSupportedIntensityMeasuresIterator();
        while (it.hasNext()) {
            Parameter imParam = (Parameter)it.next();
            if (!imParam.getName().equals("SA")) continue;
            this.supportedIMParams.addParameter(imParam);
        }
    }

    @Override
    protected void initOtherParams() {
        this.componentParam = new ComponentParam(Component.AVE_HORZ, Component.AVE_HORZ);
        this.otherParams.clear();
        this.otherParams.addParameter(this.rockAttenRelSelectorParam);
        ArrayList<String> siteEffectCorrectionModelList = new ArrayList<String>();
        siteEffectCorrectionModelList.add(BATURAY_STEWART_MODEL);
        siteEffectCorrectionModelList.add(BAZZURO_CORNELL_MODEL);
        StringConstraint siteEffectCorrectionConstraint = new StringConstraint(siteEffectCorrectionModelList);
        this.siteEffectCorrectionParam = new StringParameter(SITE_EFFECT_PARAM_NAME, siteEffectCorrectionConstraint, siteEffectCorrectionModelList.get(0));
        this.siteEffectCorrectionParam.setInfo(SITE_EFFECT_PARAM_INFO);
        this.siteEffectCorrectionParam.addParameterChangeListener(this);
        this.otherParams.addParameter(this.siteEffectCorrectionParam);
        this.otherParams.addParameter(this.componentParam);
        ListIterator<Parameter<?>> it = this.attenRel.getOtherParamsIterator();
        while (it.hasNext()) {
            AbstractParameter param = (AbstractParameter)it.next();
            if ("Component".equals(param.getName())) continue;
            this.otherParams.addParameter(param);
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }
}

