/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.attenRelImpl;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.opensha.commons.data.Site;
import org.opensha.commons.exceptions.InvalidRangeException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.geo.Location;
import org.opensha.commons.param.constraint.impl.DoubleConstraint;
import org.opensha.commons.param.constraint.impl.DoubleDiscreteConstraint;
import org.opensha.commons.param.constraint.impl.StringConstraint;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.event.ParameterChangeWarningListener;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.param.EqkRuptureParams.FaultTypeParam;
import org.opensha.sha.imr.param.EqkRuptureParams.MagParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.DampingParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.PGA_Param;
import org.opensha.sha.imr.param.IntensityMeasureParams.PeriodParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.SA_Param;
import org.opensha.sha.imr.param.OtherParams.Component;
import org.opensha.sha.imr.param.OtherParams.ComponentParam;
import org.opensha.sha.imr.param.OtherParams.StdDevTypeParam;
import org.opensha.sha.imr.param.OtherParams.TectonicRegionTypeParam;
import org.opensha.sha.imr.param.PropagationEffectParams.DistanceRupParameter;
import org.opensha.sha.util.TectonicRegionType;

public class ZhaoEtAl_2006_AttenRel
extends AttenuationRelationship
implements ParameterChangeListener {
    private static final String C = "ZhaoEtAl_2006_AttenRel";
    private static final boolean D = false;
    public static final String SHORT_NAME = "ZhaoEtAl2006";
    private static final long serialVersionUID = 1234567890987654353L;
    public static final String NAME = "ZhaoEtAl (2006)";
    private final double[] period = new double[]{0.0, 0.05, 0.1, 0.15, 0.2, 0.25, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0, 1.25, 1.5, 2.0, 2.5, 3.0, 4.0, 5.0};
    private final double[] a = new double[]{1.101, 1.076, 1.118, 1.134, 1.147, 1.149, 1.163, 1.2, 1.25, 1.293, 1.336, 1.386, 1.433, 1.479, 1.551, 1.621, 1.694, 1.748, 1.759, 1.826, 1.825};
    private final double[] b = new double[]{-0.00564, -0.00671, -0.00787, -0.00722, -0.00659, -0.0059, -0.0052, -0.00422, -0.00338, -0.00282, -0.00258, -0.00242, -0.00232, -0.0022, -0.00207, -0.00224, -0.00201, -0.00187, -0.00147, -0.00195, -0.00237};
    private final double[] c = new double[]{0.0055, 0.0075, 0.009, 0.01, 0.012, 0.014, 0.015, 0.01, 0.006, 0.003, 0.0025, 0.0022, 0.002, 0.002, 0.002, 0.002, 0.0025, 0.0028, 0.0032, 0.004, 0.005};
    private final double[] d = new double[]{1.07967, 1.05984, 1.08274, 1.05292, 1.0136, 0.96638, 0.93427, 0.9588, 1.00779, 1.08773, 1.08384, 1.08849, 1.1092, 1.11474, 1.08295, 1.09117, 1.05492, 1.05191, 1.02452, 1.04356, 1.06518};
    private final double[] e = new double[]{0.01412, 0.01463, 0.01423, 0.01509, 0.01462, 0.01459, 0.01458, 0.01257, 0.01114, 0.01019, 0.00979, 0.00944, 0.00972, 0.01005, 0.01003, 0.00928, 0.00833, 0.00776, 0.00644, 0.0059, 0.0051};
    private final double[] Sr = new double[]{0.2509, 0.2513, 0.2403, 0.2506, 0.2601, 0.269, 0.259, 0.2479, 0.247, 0.2326, 0.22, 0.2321, 0.2196, 0.2107, 0.251, 0.2483, 0.2631, 0.262, 0.3066, 0.3529, 0.2485};
    private final double[] Si = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0412, -0.0528, -0.1034, -0.146, -0.1638, -0.2062, -0.2393, -0.2557, -0.3065, -0.3214, -0.3366, -0.3306, -0.3898, -0.4978};
    private final double[] Ss = new double[]{2.607, 2.764, 2.156, 2.161, 1.901, 1.814, 2.181, 2.432, 2.629, 2.702, 2.654, 2.48, 2.332, 2.233, 2.029, 1.589, 0.966, 0.789, 1.037, 0.561, 0.225};
    private final double[] SsZhao = new double[]{0.0557, 0.1047, 0.1276, 0.078, 0.1074, 0.0753, 0.0058, -0.012, -0.0448, -0.0727, -0.1082, -0.1257, -0.1859, -0.2268, -0.237, -0.24, -0.2332, -0.2804, -0.2305, -0.2548, -0.3551};
    private final double[] Ssl = new double[]{-0.5284, -0.5507, -0.4201, -0.4315, -0.3715, -0.3601, -0.4505, -0.5061, -0.5538, -0.5746, -0.5721, -0.5397, -0.5216, -0.5094, -0.4692, -0.3787, -0.2484, -0.2215, -0.2625, -0.1689, -0.1201};
    private final double[] Sslr = new double[]{2.6069, 2.7638, 2.1558, 2.1613, 1.9012, 1.8138, 2.1809, 2.4316, 2.6292, 2.7015, 2.6541, 2.4801, 2.3323, 2.2329, 2.0286, 1.5886, 0.9661, 0.7889, 1.037, 0.5608, 0.2248};
    private final double[] Ch = new double[]{0.293, 0.939, 1.499, 1.462, 1.28, 1.121, 0.852, 0.365, -0.207, -0.705, -1.144, -1.609, -2.023, -2.451, -3.243, -3.888, -4.783, -5.444, -5.839, -6.598, -6.752};
    private final double[] C1 = new double[]{1.1111, 1.6845, 2.0609, 1.9165, 1.6688, 1.4683, 1.172, 0.6548, 0.0713, -0.4288, -0.8656, -1.325, -1.7322, -2.1522, -2.9226, -3.5476, -4.4102, -5.0492, -5.4307, -6.1813, -6.3471};
    private final double[] C2 = new double[]{1.344, 1.793, 2.1346, 2.168, 2.0854, 1.9416, 1.6829, 1.1271, 0.5149, -0.0027, -0.4493, -0.9284, -1.349, -1.7757, -2.5422, -3.1689, -4.0387, -4.6979, -5.089, -5.8821, -6.0512};
    private final double[] C3 = new double[]{1.3548, 1.7474, 2.0311, 2.0518, 2.0007, 1.9407, 1.8083, 1.4825, 0.9339, 0.3936, -0.1109, -0.62, -1.0665, -1.5228, -2.3272, -2.9789, -3.8714, -4.4963, -4.8932, -5.6981, -5.8733};
    private final double[] C4 = new double[]{1.4204, 1.814, 2.0818, 2.1128, 2.0302, 1.9367, 1.7697, 1.3967, 0.9549, 0.5591, 0.188, -0.2463, -0.643, -1.084, -1.9364, -2.6613, -3.6396, -4.3414, -4.7585, -5.5879, -5.7984};
    private final double[] sigma = new double[]{0.6039, 0.6399, 0.6936, 0.7017, 0.6917, 0.6823, 0.6696, 0.6589, 0.653, 0.6527, 0.6516, 0.6467, 0.6525, 0.657, 0.6601, 0.664, 0.6694, 0.6706, 0.6671, 0.6468, 0.6431};
    private final double[] tau = new double[]{0.3976, 0.4437, 0.4903, 0.4603, 0.4233, 0.3908, 0.379, 0.3897, 0.389, 0.4014, 0.4079, 0.4183, 0.4106, 0.4101, 0.4021, 0.4076, 0.4138, 0.4108, 0.3961, 0.3821, 0.3766};
    private final double[] Qc = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -0.0126, -0.0329, -0.0501, -0.065, -0.0781, -0.0899, -0.1148, -0.1351, -0.1672, -0.1921, -0.2124, -0.2445, -0.2694};
    private final double[] Wc = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0116, 0.0202, 0.0274, 0.0336, 0.0391, 0.044, 0.0545, 0.063, 0.0764, 0.0869, 0.0954, 0.1088, 0.1193};
    private final double[] Tau_c = new double[]{0.303, 0.326, 0.342, 0.331, 0.312, 0.298, 0.3, 0.346, 0.338, 0.349, 0.351, 0.356, 0.348, 0.338, 0.313, 0.306, 0.283, 0.287, 0.278, 0.273, 0.275};
    private final double[] Qi = new double[]{0.0, 0.0, 0.0, -0.0138, -0.0256, -0.0348, -0.0423, -0.0541, -0.0632, -0.0707, -0.0771, -0.0825, -0.0874, -0.0917, -0.1009, -0.1083, -0.1202, -0.1293, -0.1368, -0.1486, -0.1578};
    private final double[] Wi = new double[]{0.0, 0.0, 0.0, 0.0286, 0.0352, 0.0403, 0.0445, 0.0511, 0.0562, 0.0604, 0.0639, 0.067, 0.0697, 0.0721, 0.0772, 0.0814, 0.088, 0.0931, 0.0972, 0.1038, 0.109};
    private final double[] Ps = new double[]{0.1392, 0.1636, 0.169, 0.1669, 0.1631, 0.1588, 0.1544, 0.146, 0.1381, 0.1307, 0.1239, 0.1176, 0.1116, 0.106, 0.0933, 0.0821, 0.0628, 0.0465, 0.0322, 0.0083, -0.0117};
    private final double[] Qs = new double[]{0.1584, 0.1932, 0.2057, 0.1984, 0.1856, 0.1714, 0.1573, 0.1309, 0.1078, 0.0878, 0.0705, 0.0556, 0.0426, 0.0314, 0.0093, -0.0062, -0.0235, -0.0287, -0.0261, -0.0065, 0.0246};
    private final double[] Ws = new double[]{-0.0529, -0.0841, -0.0877, -0.0773, -0.0644, -0.0515, -0.0395, -0.0183, -8.0E-4, 0.0136, 0.0254, 0.0352, 0.0432, 0.0498, 0.0612, 0.0674, 0.0692, 0.0622, 0.0496, 0.015, -0.0268};
    private final double[] Tau_s = new double[]{0.321, 0.378, 0.42, 0.372, 0.324, 0.294, 0.284, 0.278, 0.272, 0.285, 0.29, 0.299, 0.289, 0.286, 0.277, 0.282, 0.3, 0.292, 0.274, 0.281, 0.296};
    private final double[] Tau_i = new double[]{0.308, 0.343, 0.403, 0.367, 0.328, 0.289, 0.28, 0.271, 0.277, 0.296, 0.313, 0.329, 0.324, 0.328, 0.339, 0.352, 0.36, 0.356, 0.338, 0.307, 0.272};
    private final double[] Tau_S = new double[]{0.321, 0.378, 0.42, 0.372, 0.324, 0.294, 0.284, 0.278, 0.272, 0.285, 0.29, 0.299, 0.289, 0.286, 0.277, 0.282, 0.3, 0.292, 0.274, 0.281, 0.296};
    private HashMap<Double, Integer> indexFromPerHashMap;
    private int iper;
    private double mag;
    private double rRup;
    private String siteType;
    private String focMechType;
    private String stdDevType;
    private String tecRegType;
    private StringParameter siteTypeParam = null;
    public static final String SITE_TYPE_INFO = "Geological conditions at the site";
    public static final String SITE_TYPE_NAME = "Zhao et al 2006 Site Type";
    public static final String SITE_TYPE_HARD_ROCK = "Hard Rock";
    public static final String SITE_TYPE_ROCK = " Rock";
    public static final String SITE_TYPE_HARD_SOIL = "Hard Soil";
    public static final String SITE_TYPE_MEDIUM_SOIL = "Medium Soil";
    public static final String SITE_TYPE_SOFT_SOIL = "Soft Soil";
    public static final String SITE_TYPE_DEFAULT = " Rock";
    public static final String FLT_TEC_ENV_CRUSTAL = TectonicRegionType.ACTIVE_SHALLOW.toString();
    public static final String FLT_TEC_ENV_INTERFACE = TectonicRegionType.SUBDUCTION_INTERFACE.toString();
    public static final String FLT_TEC_ENV_SLAB = TectonicRegionType.SUBDUCTION_SLAB.toString();
    public static final String FLT_FOC_MECH_REVERSE = "Reverse";
    public static final String FLT_FOC_MECH_NORMAL = "Normal";
    public static final String FLT_FOC_MECH_STRIKE_SLIP = "Strike-slip";
    public static final String FLT_FOC_MECH_UNKNOWN = "Unknown";
    protected static final Double MAG_WARN_MIN = 5.0;
    protected static final Double MAG_WARN_MAX = 8.3;
    protected static final Double DISTANCE_RUP_WARN_MIN = 0.0;
    protected static final Double DISTANCE_RUP_WARN_MAX = 500.0;
    protected static final Double DEPTH_HYPO_WARN_MIN = 0.0;
    protected static final Double DEPTH_HYPO_WARN_MAX = 125.0;

    public ZhaoEtAl_2006_AttenRel(ParameterChangeWarningListener listener) {
        this.listener = listener;
        this.initSupportedIntensityMeasureParams();
        this.indexFromPerHashMap = new HashMap();
        for (int i = 0; i < this.period.length; ++i) {
            this.indexFromPerHashMap.put(this.period[i], i);
        }
        this.initEqkRuptureParams();
        this.initSiteParams();
        this.initPropagationEffectParams();
        this.initOtherParams();
        this.initIndependentParamLists();
        this.initParameterEventListeners();
    }

    @Override
    public void setEqkRupture(EqkRupture eqkRupture) throws InvalidRangeException {
        this.magParam.setValueIgnoreWarning(eqkRupture.getMag());
        this.eqkRupture = eqkRupture;
        this.setPropagationEffectParams();
    }

    @Override
    public void setSite(Site site) throws ParameterException {
        this.siteTypeParam.setValue((String)site.getParameter(SITE_TYPE_NAME).getValue());
        this.site = site;
        this.setPropagationEffectParams();
    }

    @Override
    public void setPropagationEffectParams() {
        if (this.site != null && this.eqkRupture != null) {
            this.distanceRupParam.setValue(this.eqkRupture, this.site);
        }
    }

    protected void setCoeffIndex() throws ParameterException {
        if (this.im == null) {
            throw new ParameterException("ZhaoEtAl_2006_AttenRel: updateCoefficients(): The Intensity Measusre Parameter has not been set yet, unable to process.");
        }
        this.iper = this.im.getName().equalsIgnoreCase("PGA") ? 0 : this.indexFromPerHashMap.get(this.saPeriodParam.getValue());
        this.intensityMeasureChanged = false;
    }

    @Override
    public double getMean() {
        if (this.rRup > this.USER_MAX_DISTANCE) {
            return -35.0;
        }
        if (this.intensityMeasureChanged) {
            this.setCoeffIndex();
        }
        return this.getMean(this.iper, this.mag, this.rRup);
    }

    @Override
    public double getStdDev() {
        if (this.intensityMeasureChanged) {
            this.setCoeffIndex();
        }
        return this.getStdDev(this.iper, this.stdDevType, this.tecRegType);
    }

    @Override
    public void setParamDefaults() {
        this.magParam.setValueAsDefault();
        this.fltTypeParam.setValueAsDefault();
        this.tectonicRegionTypeParam.setValueAsDefault();
        this.distanceRupParam.setValueAsDefault();
        this.saParam.setValueAsDefault();
        this.saPeriodParam.setValueAsDefault();
        this.saDampingParam.setValueAsDefault();
        this.pgaParam.setValueAsDefault();
        this.stdDevTypeParam.setValueAsDefault();
        this.siteTypeParam.setValue(" Rock");
        this.componentParam.setValueAsDefault();
        this.mag = (Double)this.magParam.getValue();
        this.rRup = (Double)this.distanceRupParam.getValue();
        this.focMechType = ((String)this.fltTypeParam.getValue()).toString();
        this.tecRegType = ((String)this.tectonicRegionTypeParam.getValue()).toString();
        this.siteType = ((String)this.siteTypeParam.getValue()).toString();
    }

    @Override
    protected void initEqkRuptureParams() {
        this.magParam = new MagParam(MAG_WARN_MIN, (double)MAG_WARN_MAX);
        StringConstraint fltConstr = new StringConstraint();
        fltConstr.addString(FLT_FOC_MECH_REVERSE);
        fltConstr.addString(FLT_FOC_MECH_NORMAL);
        fltConstr.addString(FLT_FOC_MECH_STRIKE_SLIP);
        fltConstr.addString(FLT_FOC_MECH_UNKNOWN);
        this.fltTypeParam = new FaultTypeParam(fltConstr, FLT_FOC_MECH_REVERSE);
        this.eqkRuptureParams.clear();
        this.eqkRuptureParams.addParameter(this.magParam);
        this.eqkRuptureParams.addParameter(this.fltTypeParam);
    }

    @Override
    protected void initSiteParams() {
        StringConstraint siteConstraint = new StringConstraint();
        siteConstraint.addString(SITE_TYPE_HARD_ROCK);
        siteConstraint.addString(" Rock");
        siteConstraint.addString(SITE_TYPE_HARD_SOIL);
        siteConstraint.addString(SITE_TYPE_MEDIUM_SOIL);
        siteConstraint.addString(SITE_TYPE_SOFT_SOIL);
        siteConstraint.setNonEditable();
        this.siteTypeParam = new StringParameter(SITE_TYPE_NAME, siteConstraint, null);
        this.siteTypeParam.setInfo(SITE_TYPE_INFO);
        this.siteTypeParam.setNonEditable();
        this.siteParams.clear();
        this.siteParams.addParameter(this.siteTypeParam);
    }

    @Override
    protected void initPropagationEffectParams() {
        this.distanceRupParam = new DistanceRupParameter(0.0);
        this.distanceRupParam.addParameterChangeWarningListener(this.listener);
        DoubleConstraint warn = new DoubleConstraint(DISTANCE_RUP_WARN_MIN, DISTANCE_RUP_WARN_MAX);
        warn.setNonEditable();
        this.distanceRupParam.setWarningConstraint(warn);
        this.distanceRupParam.setNonEditable();
        this.propagationEffectParams.addParameter(this.distanceRupParam);
    }

    @Override
    protected void initOtherParams() {
        super.initOtherParams();
        StringConstraint stdDevTypeConstraint = new StringConstraint();
        stdDevTypeConstraint.addString("Total");
        stdDevTypeConstraint.addString("None (zero)");
        stdDevTypeConstraint.addString("Inter-Event");
        stdDevTypeConstraint.addString("Intra-Event");
        stdDevTypeConstraint.setNonEditable();
        this.stdDevTypeParam = new StdDevTypeParam(stdDevTypeConstraint);
        StringConstraint constraint = new StringConstraint();
        this.componentParam = new ComponentParam(Component.AVE_HORZ, Component.AVE_HORZ);
        constraint = new StringConstraint();
        constraint.addString(FLT_TEC_ENV_CRUSTAL);
        constraint.addString(FLT_TEC_ENV_SLAB);
        constraint.addString(FLT_TEC_ENV_INTERFACE);
        this.tectonicRegionTypeParam = new TectonicRegionTypeParam(constraint, FLT_TEC_ENV_INTERFACE);
        this.otherParams.addParameter(this.stdDevTypeParam);
        this.otherParams.addParameter(this.componentParam);
        this.otherParams.replaceParameter("Tectonic Region", this.tectonicRegionTypeParam);
    }

    protected void initIndependentParamLists() {
        this.meanIndependentParams.clear();
        this.meanIndependentParams.addParameter(this.magParam);
        this.meanIndependentParams.addParameter(this.fltTypeParam);
        this.meanIndependentParams.addParameter(this.tectonicRegionTypeParam);
        this.meanIndependentParams.addParameter(this.distanceRupParam);
        this.meanIndependentParams.addParameter(this.siteTypeParam);
        this.stdDevIndependentParams.clear();
        this.stdDevIndependentParams.addParameter(this.saPeriodParam);
        this.stdDevIndependentParams.addParameter(this.tectonicRegionTypeParam);
        this.stdDevIndependentParams.addParameter(this.stdDevTypeParam);
        this.exceedProbIndependentParams.clear();
        this.exceedProbIndependentParams.addParameterList(this.meanIndependentParams);
        this.exceedProbIndependentParams.addParameter(this.stdDevTypeParam);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncTypeParam);
        this.exceedProbIndependentParams.addParameter(this.sigmaTruncLevelParam);
        this.imlAtExceedProbIndependentParams.addParameterList(this.exceedProbIndependentParams);
        this.imlAtExceedProbIndependentParams.addParameter(this.exceedProbParam);
    }

    @Override
    protected void initSupportedIntensityMeasureParams() {
        DoubleDiscreteConstraint periodConstraint = new DoubleDiscreteConstraint();
        for (int i = 1; i < this.period.length; ++i) {
            periodConstraint.addDouble((Double)this.period[i]);
        }
        periodConstraint.setNonEditable();
        this.saPeriodParam = new PeriodParam(periodConstraint);
        this.saDampingParam = new DampingParam();
        this.saParam = new SA_Param(this.saPeriodParam, this.saDampingParam);
        this.saParam.setNonEditable();
        this.pgaParam = new PGA_Param();
        this.pgaParam.setNonEditable();
        this.saParam.addParameterChangeWarningListener(this.listener);
        this.pgaParam.addParameterChangeWarningListener(this.listener);
        this.supportedIMParams.clear();
        this.supportedIMParams.addParameter(this.saParam);
        this.supportedIMParams.addParameter(this.pgaParam);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    public double getMean(int iper, double mag, double rRup) {
        double hypodepth;
        double mc;
        double flag_sc = 0.0;
        double flag_Fr = 0.0;
        double flag_Si = 0.0;
        double flag_Ss = 0.0;
        double flag_Ssl = 0.0;
        double hc = 125.0;
        double hlow = 15.0;
        double delta_h = 0.0;
        double pFa = 0.0;
        double qFa = 0.0;
        double wFa = 0.0;
        double m2CorrFact = 0.0;
        double soilCoeff = 0.0;
        if (this.siteType.equals(SITE_TYPE_HARD_ROCK)) {
            soilCoeff = this.Ch[iper];
        } else if (this.siteType.equals(" Rock")) {
            soilCoeff = this.C1[iper];
        } else if (this.siteType.equals(SITE_TYPE_HARD_SOIL)) {
            soilCoeff = this.C2[iper];
        } else if (this.siteType.equals(SITE_TYPE_MEDIUM_SOIL)) {
            soilCoeff = this.C3[iper];
        } else if (this.siteType.equals(SITE_TYPE_SOFT_SOIL)) {
            soilCoeff = this.C4[iper];
        } else {
            throw new RuntimeException("\n  Unrecognized site type \n");
        }
        if (this.focMechType.equals(FLT_FOC_MECH_REVERSE) && this.tecRegType.equals(FLT_TEC_ENV_CRUSTAL)) {
            flag_Fr = 1.0;
            mc = 6.3;
            pFa = 0.0;
            qFa = this.Qc[iper];
            wFa = this.Wc[iper];
        } else if (this.tecRegType.equals(FLT_TEC_ENV_CRUSTAL)) {
            flag_sc = 1.0;
            mc = 6.3;
            pFa = 0.0;
            qFa = this.Qc[iper];
            wFa = this.Wc[iper];
        } else if (this.tecRegType.equals(FLT_TEC_ENV_INTERFACE)) {
            flag_Si = 1.0;
            mc = 6.3;
            pFa = 0.0;
            qFa = this.Qi[iper];
            wFa = this.Wi[iper];
        } else if (this.tecRegType.equals(FLT_TEC_ENV_SLAB)) {
            flag_Ss = 1.0;
            flag_Ssl = 1.0;
            mc = 6.5;
            pFa = this.Ps[iper];
            qFa = this.Qs[iper];
            wFa = this.Ws[iper];
        } else {
            System.out.println("+++" + this.tecRegType.toString() + "--");
            System.out.println("+++" + this.focMechType.toString() + "--");
            throw new RuntimeException("\n  Cannot handle this combination: \n  tectonic region + focal mechanism ");
        }
        RuptureSurface surf = this.eqkRupture.getRuptureSurface();
        Location hypo = this.eqkRupture.getHypocenterLocation();
        if (hypo == null) {
            try {
                double hypoLon = 0.0;
                double hypoLat = 0.0;
                double hypoDep = 0.0;
                double cnt = 0.0;
                for (Location loc : surf.getEvenlyDiscritizedListOfLocsOnSurface()) {
                    hypoLon += loc.getLongitude();
                    hypoLat += loc.getLatitude();
                    hypoDep += loc.getDepth();
                    cnt += 1.0;
                }
                hypo = new Location(hypoLat /= cnt, hypoLon /= cnt, hypoDep /= cnt);
            }
            catch (Exception hypoLon) {
                // empty catch block
            }
        }
        if ((hypodepth = hypo == null ? surf.getAveRupTopDepth() + 0.5 * surf.getAveWidth() * Math.sin(Math.toRadians(surf.getAveDip())) : hypo.getDepth()) > hlow) {
            delta_h = 1.0;
            hypodepth = hypodepth < hc ? (hypodepth -= hlow) : hc - hlow;
        } else {
            delta_h = 0.0;
        }
        m2CorrFact = pFa * (mag - mc) + qFa * Math.pow(mag - mc, 2.0) + wFa;
        double r = rRup + this.c[iper] * Math.exp(this.d[iper] * mag);
        double lnGm = this.a[iper] * mag + this.b[iper] * rRup - Math.log(r) + this.e[iper] * hypodepth * delta_h + flag_Fr * this.Sr[iper] + flag_Si * this.Si[iper] + flag_Ss * this.Ss[iper] + flag_Ssl * this.Ssl[iper] * Math.log(rRup) + soilCoeff;
        return Math.log(Math.exp(lnGm += m2CorrFact) / 981.0);
    }

    public double getStdDev(int iper, String stdDevType, String tecRegType) {
        if (tecRegType.equals(FLT_TEC_ENV_CRUSTAL)) {
            if (stdDevType.equals("Total")) {
                return Math.sqrt(this.Tau_c[iper] * this.Tau_c[iper] + this.sigma[iper] * this.sigma[iper]);
            }
            if (stdDevType.equals("None (zero)")) {
                return 0.0;
            }
            if (stdDevType.equals("Inter-Event")) {
                return this.Tau_c[iper];
            }
            if (stdDevType.equals("Intra-Event")) {
                return this.sigma[iper];
            }
            return Double.NaN;
        }
        if (tecRegType.equals(FLT_TEC_ENV_INTERFACE)) {
            if (stdDevType.equals("Total")) {
                return Math.sqrt(this.Tau_i[iper] * this.Tau_i[iper] + this.sigma[iper] * this.sigma[iper]);
            }
            if (stdDevType.equals("None (zero)")) {
                return 0.0;
            }
            if (stdDevType.equals("Inter-Event")) {
                return this.Tau_i[iper];
            }
            if (stdDevType.equals("Intra-Event")) {
                return this.sigma[iper];
            }
            return Double.NaN;
        }
        if (tecRegType.equals(FLT_TEC_ENV_SLAB)) {
            if (stdDevType.equals("Total")) {
                return Math.sqrt(this.Tau_s[iper] * this.Tau_s[iper] + this.sigma[iper] * this.sigma[iper]);
            }
            if (stdDevType.equals("None (zero)")) {
                return 0.0;
            }
            if (stdDevType.equals("Inter-Event")) {
                return this.Tau_s[iper];
            }
            if (stdDevType.equals("Intra-Event")) {
                return this.sigma[iper];
            }
            return Double.NaN;
        }
        return 0.0;
    }

    @Override
    public void parameterChange(ParameterChangeEvent e) {
        String pName = e.getParameterName();
        Object val = e.getNewValue();
        if (pName.equals("DistanceRup")) {
            this.rRup = (Double)val;
        } else if (pName.equals("Magnitude")) {
            this.mag = (Double)val;
        } else if (pName.equals("Std Dev Type")) {
            this.stdDevType = (String)val;
        } else if (pName.equals("Fault Type")) {
            this.focMechType = ((String)this.fltTypeParam.getValue()).toString();
        } else if (pName.equals("Tectonic Region")) {
            this.tecRegType = ((String)this.tectonicRegionTypeParam.getValue()).toString();
        } else if (pName.equals(SITE_TYPE_NAME)) {
            this.siteType = this.getParameter(SITE_TYPE_NAME).getValue().toString();
        } else if (pName.equals("SA Period")) {
            this.intensityMeasureChanged = true;
        }
    }

    @Override
    public void resetParameterEventListeners() {
        this.magParam.removeParameterChangeListener(this);
        this.fltTypeParam.removeParameterChangeListener(this);
        this.tectonicRegionTypeParam.removeParameterChangeListener(this);
        this.siteTypeParam.removeParameterChangeListener(this);
        this.distanceRupParam.removeParameterChangeListener(this);
        this.stdDevTypeParam.removeParameterChangeListener(this);
        this.saPeriodParam.removeParameterChangeListener(this);
        this.initParameterEventListeners();
    }

    @Override
    protected void initParameterEventListeners() {
        this.magParam.addParameterChangeListener(this);
        this.fltTypeParam.addParameterChangeListener(this);
        this.tectonicRegionTypeParam.addParameterChangeListener(this);
        this.siteTypeParam.addParameterChangeListener(this);
        this.distanceRupParam.addParameterChangeListener(this);
        this.stdDevTypeParam.addParameterChangeListener(this);
        this.saPeriodParam.addParameterChangeListener(this);
    }

    @Override
    public URL getInfoURL() throws MalformedURLException {
        return new URL("http://www.opensha.org/documentation/modelsImplemented/attenRel/ZhaoEtAl_2006.html");
    }
}

