/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.attenRelImpl.ngaw2;

import java.util.Collection;
import org.opensha.sha.imr.attenRelImpl.ngaw2.Coefficients;
import org.opensha.sha.imr.attenRelImpl.ngaw2.DefaultGroundMotion;
import org.opensha.sha.imr.attenRelImpl.ngaw2.FaultStyle;
import org.opensha.sha.imr.attenRelImpl.ngaw2.IMT;
import org.opensha.sha.imr.attenRelImpl.ngaw2.NGAW2_GMM;
import org.opensha.sha.imr.attenRelImpl.ngaw2.ScalarGroundMotion;
import org.opensha.sha.util.TectonicRegionType;

public class BSSA_2014
implements NGAW2_GMM {
    public static final String NAME = "Boore, Stewart, Seyhan & Atkinson (2014)";
    public static final String SHORT_NAME = "BSSA2014";
    private static final double A = Math.pow(570.94, 4.0);
    private static final double B = Math.pow(1360.0, 4.0) + A;
    private static final double M_REF = 4.5;
    private static final double R_REF = 1.0;
    private static final double DC3_CA_TW = 0.0;
    private static final double V_REF = 760.0;
    private static final double F1 = 0.0;
    public static final double F3 = 0.1;
    private static final double V1 = 225.0;
    private static final double V2 = 300.0;
    private final Coeffs coeffs;
    private final Coeffs coeffsPGA;
    private IMT imt = null;
    private double Mw = Double.NaN;
    private double rJB = Double.NaN;
    private double vs30 = Double.NaN;
    private double z1p0 = Double.NaN;
    private FaultStyle style = FaultStyle.UNKNOWN;

    public BSSA_2014() {
        this.coeffs = new Coeffs();
        this.coeffsPGA = new Coeffs();
    }

    @Override
    public ScalarGroundMotion calc() {
        return this.calc(this.imt, this.Mw, this.rJB, this.vs30, this.z1p0, this.style);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void set_IMT(IMT imt) {
        this.imt = imt;
    }

    @Override
    public void set_Mw(double Mw) {
        this.Mw = Mw;
    }

    @Override
    public void set_rJB(double rJB) {
        this.rJB = rJB;
    }

    @Override
    public void set_rRup(double rRup) {
    }

    @Override
    public void set_rX(double rX) {
    }

    @Override
    public void set_dip(double dip) {
    }

    @Override
    public void set_width(double width) {
    }

    @Override
    public void set_zTop(double zTop) {
    }

    @Override
    public void set_zHyp(double zHyp) {
    }

    @Override
    public void set_vs30(double vs30) {
        this.vs30 = vs30;
    }

    @Override
    public void set_vsInf(boolean vsInf) {
    }

    @Override
    public void set_z2p5(double z2p5) {
    }

    @Override
    public void set_z1p0(double z1p0) {
        this.z1p0 = z1p0;
    }

    @Override
    public void set_fault(FaultStyle style) {
        this.style = style;
    }

    @Override
    public TectonicRegionType get_TRT() {
        return TectonicRegionType.ACTIVE_SHALLOW;
    }

    @Override
    public Collection<IMT> getSupportedIMTs() {
        return this.coeffs.getSupportedIMTs();
    }

    public final ScalarGroundMotion calc(IMT imt, double Mw, double rJB, double vs30, double z1p0, FaultStyle style) {
        this.coeffs.set(imt);
        double pgaRock = BSSA_2014.calcPGArock(this.coeffsPGA, Mw, rJB, style);
        double mean = BSSA_2014.calcMean(this.coeffs, Mw, rJB, vs30, z1p0, style, pgaRock);
        double phi = BSSA_2014.calcPhi(this.coeffs, Mw, rJB, vs30);
        double tau = BSSA_2014.calcTau(this.coeffs, Mw);
        double stdDev = BSSA_2014.calcStdDev(phi, tau);
        return new DefaultGroundMotion(mean, stdDev, phi, tau);
    }

    private static final double calcMean(Coeffs c, double Mw, double rJB, double vs30, double z1p0, FaultStyle style, double pgaRock) {
        double Fe = BSSA_2014.calcSourceTerm(c, Mw, style);
        double R = Math.sqrt(rJB * rJB + c.h * c.h);
        double Fp = BSSA_2014.calcPathTerm(c, Mw, R);
        double lnFlin = BSSA_2014.calcLnFlin(c, vs30);
        double f2 = BSSA_2014.calcF2(c, vs30);
        double lnFnl = 0.0 + f2 * Math.log((pgaRock + 0.1) / 0.1);
        double Fdz1 = BSSA_2014.calcFdz1(c, vs30, z1p0);
        double Fs = lnFlin + lnFnl + Fdz1;
        return Fe + Fp + Fs;
    }

    public final double calcLnFlin(IMT imt, double vs30) {
        this.coeffs.set(imt);
        return BSSA_2014.calcLnFlin(this.coeffs, vs30);
    }

    public final double calcF2(IMT imt, double vs30) {
        this.coeffs.set(imt);
        return BSSA_2014.calcF2(this.coeffs, vs30);
    }

    public final double calcFdz1(IMT imt, double vs30, double z1p0) {
        this.coeffs.set(imt);
        return BSSA_2014.calcFdz1(this.coeffs, vs30, z1p0);
    }

    private static final double calcLnFlin(Coeffs c, double vs30) {
        double vsLin = vs30 <= c.Vc ? vs30 : c.Vc;
        double lnFlin = c.c * Math.log(vsLin / 760.0);
        return lnFlin;
    }

    private static final double calcF2(Coeffs c, double vs30) {
        double f2 = c.f4 * (Math.exp(c.f5 * (Math.min(vs30, 760.0) - 360.0)) - Math.exp(c.f5 * 400.0));
        return f2;
    }

    private static final double calcFdz1(Coeffs c, double vs30, double z1p0) {
        double DZ1 = BSSA_2014.calcDeltaZ1(z1p0, vs30);
        double Fdz1 = c.imt().isSA() && c.imt().getPeriod() >= 0.65 ? (DZ1 <= c.f7 / c.f6 ? c.f6 * DZ1 : c.f7) : 0.0;
        return Fdz1;
    }

    private static final double calcPGArock(Coeffs c, double Mw, double rJB, FaultStyle style) {
        double FePGA = BSSA_2014.calcSourceTerm(c, Mw, style);
        double R = Math.sqrt(rJB * rJB + c.h * c.h);
        double FpPGA = BSSA_2014.calcPathTerm(c, Mw, R);
        return Math.exp(FePGA + FpPGA);
    }

    private static final double calcSourceTerm(Coeffs c, double Mw, FaultStyle style) {
        double Fe = style == FaultStyle.STRIKE_SLIP ? c.e1 : (style == FaultStyle.REVERSE ? c.e3 : (style == FaultStyle.NORMAL ? c.e2 : c.e0));
        double MwMh = Mw - c.Mh;
        return Fe += Mw <= c.Mh ? c.e4 * MwMh + c.e5 * MwMh * MwMh : c.e6 * MwMh;
    }

    private static final double calcPathTerm(Coeffs c, double Mw, double R) {
        return (c.c1 + c.c2 * (Mw - 4.5)) * Math.log(R / 1.0) + (c.c3 + 0.0) * (R - 1.0);
    }

    private static final double calcDeltaZ1(double z1p0, double vs30) {
        if (Double.isNaN(z1p0)) {
            return 0.0;
        }
        return z1p0 - BSSA_2014.calcZ1ref(vs30);
    }

    public static final double calcZ1ref(double vs30) {
        double vsPow4 = vs30 * vs30 * vs30 * vs30;
        return Math.exp(-1.7875 * Math.log((vsPow4 + A) / B)) / 1000.0;
    }

    private static final double calcStdDev(Coeffs c, double Mw, double rJB, double vs30) {
        double tau = BSSA_2014.calcTau(c, Mw);
        double phiMRV = BSSA_2014.calcPhi(c, Mw, rJB, vs30);
        return BSSA_2014.calcStdDev(phiMRV, tau);
    }

    private static final double calcStdDev(double phiMRV, double tau) {
        return Math.sqrt(phiMRV * phiMRV + tau * tau);
    }

    private static double calcTau(Coeffs c, double Mw) {
        double tau = Mw >= 5.5 ? c.tau2 : (Mw <= 4.5 ? c.tau1 : c.tau1 + (c.tau2 - c.tau1) * (Mw - 4.5));
        return tau;
    }

    private static double calcPhi(Coeffs c, double Mw, double rJB, double vs30) {
        double phiM;
        double phiMR = phiM = Mw >= 5.5 ? c.phi2 : (Mw <= 4.5 ? c.phi1 : c.phi1 + (c.phi2 - c.phi1) * (Mw - 4.5));
        if (rJB > c.R2) {
            phiMR += c.dPhiR;
        } else if (rJB > c.R1) {
            phiMR += c.dPhiR * (Math.log(rJB / c.R1) / Math.log(c.R2 / c.R1));
        }
        double phiMRV = phiMR;
        if (vs30 <= 225.0) {
            phiMRV -= c.dPhiV;
        } else if (vs30 < 300.0) {
            phiMRV -= c.dPhiV * (Math.log(300.0 / vs30) / Math.log(1.3333333333333333));
        }
        return phiMRV;
    }

    private static class Coeffs
    extends Coefficients {
        double e0;
        double e1;
        double e2;
        double e3;
        double e4;
        double e5;
        double e6;
        double Mh;
        double c1;
        double c2;
        double c3;
        double h;
        double c;
        double Vc;
        double f4;
        double f5;
        double f6;
        double f7;
        double R1;
        double R2;
        double dPhiR;
        double dPhiV;
        double phi1;
        double phi2;
        double tau1;
        double tau2;
        double Mref;
        double Rref;
        double Dc3CaTw;
        double Vref;
        double f1;
        double f3;
        double v1;
        double v2;
        double Dc3CnTr;
        double Dc3ItJp;

        Coeffs() {
            super("BSSA14.csv");
            this.set(IMT.PGA);
        }
    }
}

