/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.mod;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.exceptions.IMRException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.param.ParamLinker;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.constraint.impl.DoubleDiscreteConstraint;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.event.ParameterChangeWarningListener;
import org.opensha.commons.param.impl.EnumParameter;
import org.opensha.commons.param.impl.ParameterListParameter;
import org.opensha.commons.util.ServerPrefUtils;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.imr.AttenRelRef;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.imr.mod.AbstractAttenRelMod;
import org.opensha.sha.imr.mod.ModAttenRelRef;
import org.opensha.sha.imr.param.IntensityMeasureParams.DampingParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.PGA_Param;
import org.opensha.sha.imr.param.IntensityMeasureParams.PGV_Param;
import org.opensha.sha.imr.param.IntensityMeasureParams.PeriodParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.SA_Param;
import org.opensha.sha.imr.param.SiteParams.DepthTo1pt0kmPerSecParam;
import org.opensha.sha.imr.param.SiteParams.DepthTo2pt5kmPerSecParam;
import org.opensha.sha.imr.param.SiteParams.Vs30_Param;
import org.opensha.sha.imr.param.SiteParams.Vs30_TypeParam;

public class ModAttenuationRelationship
extends AttenuationRelationship
implements ParameterChangeListener {
    private static final boolean D = false;
    public static final String NAME = "Modified Attenuation Relationship";
    public static final String SHORT_NAME = "ModAttenRel";
    private double[] periods = new double[]{0.01, 0.02, 0.03, 0.05, 0.075, 0.1, 0.15, 0.2, 0.25, 0.3, 0.4, 0.5, 0.75, 1.0, 1.5, 2.0, 3.0, 4.0, 5.0, 7.5, 10.0};
    private ParameterListParameter imrParams;
    protected ParameterListParameter modParams;
    public static final String IMRS_PARAM_NAME = "Reference IMR";
    private EnumSet<AttenRelRef> supportedIMRs;
    private EnumParameter<AttenRelRef> imrsParam;
    public static final String MODS_PARAM_NAME = "Modifier";
    private EnumSet<ModAttenRelRef> supportedMods;
    private EnumParameter<ModAttenRelRef> modsParam;
    private Map<AttenRelRef, ScalarIMR> imrsCache = Maps.newHashMap();
    private Map<ModAttenRelRef, AbstractAttenRelMod> modsCache = Maps.newHashMap();
    private ScalarIMR imr;
    private AbstractAttenRelMod mod;
    private boolean imtStale = true;

    public ModAttenuationRelationship() {
        this(null);
    }

    public ModAttenuationRelationship(AttenRelRef supportedIMR, ModAttenRelRef supportedMod) {
        this((Collection<AttenRelRef>)Lists.newArrayList((Object[])new AttenRelRef[]{supportedIMR}), Lists.newArrayList((Object[])new ModAttenRelRef[]{supportedMod}));
    }

    public ModAttenuationRelationship(Collection<AttenRelRef> supportedIMRs, ModAttenRelRef supportedMod) {
        this(supportedIMRs, Lists.newArrayList((Object[])new ModAttenRelRef[]{supportedMod}));
    }

    public ModAttenuationRelationship(Collection<AttenRelRef> supportedIMRs, Collection<ModAttenRelRef> supportedMods) {
        this(null, EnumSet.copyOf(supportedIMRs), EnumSet.copyOf(supportedMods));
    }

    public ModAttenuationRelationship(ParameterChangeWarningListener l) {
        this(l, EnumSet.copyOf(AttenRelRef.get(ServerPrefUtils.SERVER_PREFS)), EnumSet.allOf(ModAttenRelRef.class));
    }

    public ModAttenuationRelationship(ParameterChangeWarningListener l, EnumSet<AttenRelRef> supportedIMRs, EnumSet<ModAttenRelRef> supportedMods) {
        this.supportedIMRs = supportedIMRs;
        this.supportedMods = supportedMods;
        this.initSupportedIntensityMeasureParams();
        this.initEqkRuptureParams();
        this.initPropagationEffectParams();
        this.initSiteParams();
        this.initOtherParams();
    }

    @Override
    public ParameterList getMeanIndependentParams() {
        return this.imr.getMeanIndependentParams();
    }

    @Override
    public ParameterList getStdDevIndependentParams() {
        return this.imr.getStdDevIndependentParams();
    }

    @Override
    public ParameterList getExceedProbIndependentParams() {
        return this.imr.getExceedProbIndependentParams();
    }

    @Override
    public ParameterList getIML_AtExceedProbIndependentParams() {
        return this.imr.getIML_AtExceedProbIndependentParams();
    }

    @Override
    public double getMean() {
        Preconditions.checkNotNull((Object)this.imr, (Object)"IMR is null!");
        Preconditions.checkNotNull((Object)this.mod, (Object)"Mod is null!");
        this.checkUpdateIMT();
        return this.mod.getModMean(this.imr);
    }

    @Override
    public double getStdDev() {
        Preconditions.checkNotNull((Object)this.imr, (Object)"IMR is null!");
        Preconditions.checkNotNull((Object)this.mod, (Object)"Mod is null!");
        this.checkUpdateIMT();
        return this.mod.getModStdDev(this.imr);
    }

    @Override
    public double getExceedProbability() throws ParameterException, IMRException {
        double iml = (Double)this.im.getValue();
        ArbitrarilyDiscretizedFunc imls = new ArbitrarilyDiscretizedFunc();
        imls.set(iml, 1.0);
        return this.getExceedProbabilities(imls).getY(0);
    }

    @Override
    public double getExceedProbability(double iml) throws ParameterException, IMRException {
        return super.getExceedProbability(iml);
    }

    @Override
    public DiscretizedFunc getExceedProbabilities(DiscretizedFunc intensityMeasureLevels) throws ParameterException {
        this.checkUpdateIMT();
        return this.mod.getModExceedProbabilities(this.getCurrentIMR(), intensityMeasureLevels);
    }

    @Override
    public void setParamDefaults() {
        this.saParam.setValueAsDefault();
        this.saPeriodParam.setValueAsDefault();
        this.saDampingParam.setValueAsDefault();
        this.pgaParam.setValueAsDefault();
        this.pgvParam.setValueAsDefault();
        this.vs30Param.setValueAsDefault();
        this.depthTo2pt5kmPerSecParam.setValueAsDefault();
        this.depthTo1pt0kmPerSecParam.setValueAsDefault();
        this.vs30_TypeParam.setValueAsDefault();
        this.updateCurrentMod();
        this.updateCurrentIMR();
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    @Override
    protected void setPropagationEffectParams() {
    }

    @Override
    protected void initSupportedIntensityMeasureParams() {
        DoubleDiscreteConstraint periodConstraint = new DoubleDiscreteConstraint();
        for (double period : this.periods) {
            periodConstraint.addDouble((Double)period);
        }
        periodConstraint.setNonEditable();
        this.saPeriodParam = new PeriodParam(periodConstraint);
        this.saDampingParam = new DampingParam();
        this.saParam = new SA_Param(this.saPeriodParam, this.saDampingParam);
        this.saPeriodParam.addParameterChangeListener(this);
        this.saDampingParam.addParameterChangeListener(this);
        this.saParam.setNonEditable();
        this.pgaParam = new PGA_Param();
        this.pgaParam.setNonEditable();
        this.pgvParam = new PGV_Param();
        this.pgvParam.setNonEditable();
        this.supportedIMParams.clear();
        this.supportedIMParams.addParameter(this.saParam);
        this.supportedIMParams.addParameter(this.pgaParam);
        this.supportedIMParams.addParameter(this.pgvParam);
    }

    @Override
    protected void initSiteParams() {
        this.vs30Param = new Vs30_Param(760.0);
        this.depthTo2pt5kmPerSecParam = new DepthTo2pt5kmPerSecParam(null, 0.0, 30000.0, true);
        this.depthTo1pt0kmPerSecParam = new DepthTo1pt0kmPerSecParam(null, true);
        this.depthTo1pt0kmPerSecParam.setValueAsDefault();
        this.vs30_TypeParam = new Vs30_TypeParam();
        this.siteParams.clear();
        this.siteParams.addParameter(this.vs30Param);
        this.siteParams.addParameter(this.vs30_TypeParam);
        this.siteParams.addParameter(this.depthTo2pt5kmPerSecParam);
        this.siteParams.addParameter(this.depthTo1pt0kmPerSecParam);
    }

    @Override
    protected void initEqkRuptureParams() {
    }

    @Override
    protected void initPropagationEffectParams() {
    }

    @Override
    protected void initOtherParams() {
        super.initOtherParams();
        AttenRelRef defaultIMR = AttenRelRef.CB_2008;
        if (!this.supportedIMRs.contains(defaultIMR)) {
            defaultIMR = (AttenRelRef)this.supportedIMRs.iterator().next();
        }
        this.imrsParam = new EnumParameter<AttenRelRef>(IMRS_PARAM_NAME, this.supportedIMRs, defaultIMR, null);
        this.imrsParam.addParameterChangeListener(this);
        this.otherParams.addParameter(0, this.imrsParam);
        this.imrParams = new ParameterListParameter("Reference IMR Params");
        this.imrParams.setDefaultValue(new ParameterList());
        this.otherParams.addParameter(1, this.imrParams);
        ModAttenRelRef defaultMod = ModAttenRelRef.SIMPLE_SCALE;
        if (!this.supportedMods.contains((Object)defaultMod)) {
            defaultMod = (ModAttenRelRef)((Object)this.supportedMods.iterator().next());
        }
        this.modsParam = new EnumParameter<ModAttenRelRef>(MODS_PARAM_NAME, this.supportedMods, defaultMod, null);
        this.modsParam.addParameterChangeListener(this);
        this.otherParams.addParameter(2, this.modsParam);
        this.modParams = new ParameterListParameter("Modifier Params");
        this.modParams.setDefaultValue(new ParameterList());
        this.modParams.setValueAsDefault();
        this.otherParams.addParameter(3, this.modParams);
    }

    private synchronized void updateCurrentIMR() {
        AttenRelRef ref = (AttenRelRef)this.imrsParam.getValue();
        this.imr = this.imrsCache.get(ref);
        if (this.imr == null) {
            this.imr = ref.instance(null);
            Preconditions.checkNotNull((Object)this.imr, (Object)("Could not build IMR: " + ref.name()));
            this.imr.setParamDefaults();
            new ParamLinker<String>(this.sigmaTruncTypeParam, this.imr.getParameter("Gaussian Truncation"));
            new ParamLinker<String>(this.imr.getParameter("Gaussian Truncation"), this.sigmaTruncTypeParam);
            new ParamLinker<Double>(this.sigmaTruncLevelParam, this.imr.getParameter("Truncation Level"));
            new ParamLinker<Double>(this.imr.getParameter("Truncation Level"), this.sigmaTruncLevelParam);
            this.imrsCache.put(ref, this.imr);
        }
        this.imrParams.setValue(this.getReferenceIMRParams(this.imr.getOtherParams()));
        try {
            this.imrParams.refreshEditor();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.synchModAndIMR();
    }

    protected ParameterList getReferenceIMRParams(ParameterList paramsFromIMR) {
        return paramsFromIMR;
    }

    private synchronized void updateCurrentMod() {
        ParameterList params;
        ModAttenRelRef ref = (ModAttenRelRef)((Object)this.modsParam.getValue());
        this.mod = this.modsCache.get((Object)ref);
        if (this.mod == null) {
            this.mod = ref.instance();
            this.modsCache.put(ref, this.mod);
        }
        if ((params = this.mod.getModParams()) == null) {
            params = new ParameterList();
        }
        this.modParams.setValue(params);
        try {
            this.modParams.refreshEditor();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.synchModAndIMR();
    }

    private void synchModAndIMR() {
        if (this.mod != null && this.imr != null) {
            this.mod.setIMRParams(this.imr);
            if (this.getIntensityMeasure() != null) {
                this.mod.setIMT_IMT(this.imr, this.getIntensityMeasure());
            }
            if (this.site != null) {
                this.mod.setIMRSiteParams(this.imr, this.site);
            }
            if (this.eqkRupture != null) {
                this.mod.setIMRRupParams(this.imr, this.eqkRupture);
            }
        }
    }

    @Override
    public void setIntensityMeasure(String intensityMeasureName) throws ParameterException {
        super.setIntensityMeasure(intensityMeasureName);
        this.imtStale = true;
    }

    private void checkUpdateIMT() {
        if (this.imtStale) {
            Parameter newIMT = this.getIntensityMeasure();
            if (this.mod != null && this.imr != null && this.getIntensityMeasure() != null) {
                this.mod.setIMT_IMT(this.imr, newIMT);
            }
            this.imtStale = false;
        }
    }

    @Override
    public void setSite(Site site) {
        super.setSite(site);
        if (this.mod != null && this.imr != null && site != null) {
            this.mod.setIMRSiteParams(this.imr, site);
        }
    }

    @Override
    public void setEqkRupture(EqkRupture eqkRupture) {
        super.setEqkRupture(eqkRupture);
        if (this.mod != null && this.imr != null && eqkRupture != null) {
            this.mod.setIMRRupParams(this.imr, eqkRupture);
        }
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        if (event.getParameter() == this.imrsParam) {
            this.updateCurrentIMR();
        } else if (event.getParameter() == this.modsParam) {
            this.updateCurrentMod();
        } else if (event.getParameter() == this.saPeriodParam || event.getParameter() == this.saDampingParam) {
            this.imtStale = true;
        }
    }

    public ScalarIMR getCurrentIMR() {
        return this.imr;
    }

    public AbstractAttenRelMod getCurrentMod() {
        return this.mod;
    }
}

