/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.mod.impl.stewartSiteSpecific;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.math3.util.Precision;
import org.jfree.data.Range;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DefaultXY_DataSet;
import org.opensha.commons.data.function.XY_DataSet;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.commons.gui.plot.HeadlessGraphPanel;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.gui.plot.PlotSymbol;
import org.opensha.commons.util.DataUtils;
import org.opensha.commons.util.Interpolate;
import org.opensha.sha.imr.attenRelImpl.ngaw2.BSSA_2014;
import org.opensha.sha.imr.attenRelImpl.ngaw2.IMT;
import org.opensha.sha.imr.mod.impl.stewartSiteSpecific.NonErgodicSiteResponseMod;
import org.opensha.sha.imr.mod.impl.stewartSiteSpecific.ParamInterpolator;
import org.opensha.sha.imr.mod.impl.stewartSiteSpecific.PeriodDependentParamSet;
import org.opensha.sha.imr.param.SiteParams.DepthTo1pt0kmPerSecParam;
import org.opensha.sha.imr.param.SiteParams.Vs30_Param;

public class BSSA_ParamInterpolator
implements ParamInterpolator<NonErgodicSiteResponseMod.Params> {
    private PeriodDependentParamSet<NonErgodicSiteResponseMod.RatioParams> f3Ratios;
    BSSA_2014 bssa = new BSSA_2014();

    public BSSA_ParamInterpolator(PeriodDependentParamSet<NonErgodicSiteResponseMod.RatioParams> f3Ratios) {
        this.f3Ratios = f3Ratios;
    }

    double calcEmpirical(NonErgodicSiteResponseMod.Params param, double period, double vs30, double z1p0) {
        IMT imt = null;
        for (IMT testIMT : this.bssa.getSupportedIMTs()) {
            double saPeriod;
            if (!testIMT.isSA() || !Precision.equals((double)(saPeriod = testIMT.getPeriod().doubleValue()), (double)period, (double)1.0E-6)) continue;
            imt = testIMT;
            break;
        }
        if (imt == null) {
            IMT imtBelow = null;
            IMT imtAbove = null;
            for (IMT testIMT : this.bssa.getSupportedIMTs()) {
                if (!testIMT.isSA()) continue;
                double testPeriod = testIMT.getPeriod();
                if (testPeriod < period && (imtBelow == null || testPeriod > imtBelow.getPeriod())) {
                    imtBelow = testIMT;
                }
                if (!(testPeriod > period) || imtAbove != null && !(testPeriod < imtAbove.getPeriod())) continue;
                imtAbove = testIMT;
            }
            Preconditions.checkState((imtBelow != null && imtAbove != null ? 1 : 0) != 0, (String)"Can't interpolate empirical for %ss, no bounding periods available", (Object)period);
            double x1 = imtBelow.getPeriod();
            double x2 = imtAbove.getPeriod();
            Preconditions.checkState((x1 < period ? 1 : 0) != 0);
            Preconditions.checkState((x2 > period ? 1 : 0) != 0);
            double y1 = this.calcEmpirical(param, imtBelow, vs30, z1p0);
            double y2 = this.calcEmpirical(param, imtAbove, vs30, z1p0);
            return Interpolate.findY(Math.log(x1), y1, Math.log(x2), y2, Math.log(period));
        }
        return this.calcEmpirical(param, imt, vs30, z1p0);
    }

    double calcEmpirical(NonErgodicSiteResponseMod.Params param, IMT imt, double vs30, double z1p0) {
        Preconditions.checkNotNull((Object)((Object)imt));
        switch (param) {
            case F1: {
                return this.bssa.calcLnFlin(imt, vs30) + this.bssa.calcFdz1(imt, vs30, z1p0);
            }
            case F2: {
                return this.bssa.calcF2(imt, vs30);
            }
            case F3: {
                return 0.1;
            }
        }
        return Double.NaN;
    }

    @Override
    public double[] getInterpolated(PeriodDependentParamSet<NonErgodicSiteResponseMod.Params> periodParams, double period, double refPeriod, double tSite, double tSiteN, Site site) {
        NonErgodicSiteResponseMod.Params[] params = (NonErgodicSiteResponseMod.Params[])periodParams.getParams();
        return this.getInterpolated(periodParams, params, period, refPeriod, tSite, tSiteN, site);
    }

    public double[] getInterpolated(PeriodDependentParamSet<NonErgodicSiteResponseMod.Params> periodParams, NonErgodicSiteResponseMod.Params[] params, double period, double refPeriod, double tSite, double tSiteN, Site site) {
        double[] y2;
        double x2;
        Preconditions.checkArgument((Double.isNaN(tSite) || tSiteN > 1.0 ? 1 : 0) != 0, (Object)"N for Tsite must be > 1 when Tsite is non Nan");
        List<Double> periods = periodParams.getPeriods();
        Preconditions.checkState((boolean)site.containsParameter("Vs30"));
        double vs30 = site.getParameter(Double.class, "Vs30").getValue();
        Double z1p0 = site.getParameter(Double.class, "Depth 1.0 km/sec").getValue();
        z1p0 = z1p0 == null ? Double.valueOf(Double.NaN) : Double.valueOf(z1p0 / 1000.0);
        double tSiteZoneEnd = tSiteN * tSite;
        int periodIndex = Collections.binarySearch(periods, period);
        if (periodIndex >= 0) {
            double[] ret = periodParams.get(params, periodIndex);
            for (int i = 0; i < params.length; ++i) {
                if (params[i] != NonErgodicSiteResponseMod.Params.F1 && params[i] != NonErgodicSiteResponseMod.Params.F2) continue;
                double empirical = this.calcEmpirical(params[i], period, vs30, (double)z1p0);
                double interpVal = ret[i];
                ret[i] = period <= tSite || Double.isNaN(tSite) ? interpVal : (period >= tSiteZoneEnd ? empirical : interpVal * Math.log(tSiteZoneEnd / period) / Math.log(2.0) + empirical * Math.log(period / tSite) / Math.log(2.0));
            }
            return ret;
        }
        if (period < periods.get(0)) {
            return periodParams.get(params, 0);
        }
        int insertionIndex = -(periodIndex + 1);
        Preconditions.checkState((insertionIndex > 0 && insertionIndex <= periods.size() ? 1 : 0) != 0);
        double x1 = periods.get(insertionIndex - 1);
        double[] y1 = periodParams.getValues(params, insertionIndex - 1);
        if (insertionIndex == periods.size()) {
            x2 = period;
            y2 = y1;
        } else {
            x2 = periods.get(insertionIndex);
            y2 = periodParams.getValues(params, insertionIndex);
        }
        double w1 = Math.log(x2 / period) / Math.log(x2 / x1);
        double w2 = Math.log(period / x1) / Math.log(x2 / x1);
        double[] ret = new double[params.length];
        for (int i = 0; i < params.length; ++i) {
            double val;
            NonErgodicSiteResponseMod.Params param = params[i];
            if (param == NonErgodicSiteResponseMod.Params.F1 || param == NonErgodicSiteResponseMod.Params.F2) {
                double empiricalBelow = this.calcEmpirical(param, x1, vs30, (double)z1p0);
                double empirical = this.calcEmpirical(param, period, vs30, (double)z1p0);
                double empiricalAbove = this.calcEmpirical(param, x2, vs30, (double)z1p0);
                double epsilonBelow = y1[i] - empiricalBelow;
                double epsilonAbove = y2[i] - empiricalAbove;
                double interpVal = empirical + w1 * epsilonBelow + w2 * epsilonAbove;
                val = period <= tSite || Double.isNaN(tSite) ? interpVal : (period >= tSiteZoneEnd ? empirical : interpVal * Math.log(tSiteZoneEnd / period) / Math.log(2.0) + empirical * Math.log(period / tSite) / Math.log(2.0));
            } else if (param == NonErgodicSiteResponseMod.Params.F3) {
                double epsilonAbove;
                double epsilonBelow;
                double empirical = this.calcEmpirical(param, period, vs30, (double)z1p0);
                if (Double.isNaN(refPeriod)) {
                    epsilonBelow = y1[i] - this.f3Ratios.getInterpolated(NonErgodicSiteResponseMod.RatioParams.RATIO, x1) * empirical;
                    epsilonAbove = y2[i] - this.f3Ratios.getInterpolated(NonErgodicSiteResponseMod.RatioParams.RATIO, x2) * empirical;
                    val = this.f3Ratios.getInterpolated(NonErgodicSiteResponseMod.RatioParams.RATIO, period) * empirical + w1 * epsilonBelow + w2 * epsilonAbove;
                } else {
                    epsilonBelow = y1[i] - this.f3Ratios.getInterpolated(NonErgodicSiteResponseMod.RatioParams.RATIO, refPeriod) * empirical;
                    epsilonAbove = y2[i] - this.f3Ratios.getInterpolated(NonErgodicSiteResponseMod.RatioParams.RATIO, refPeriod) * empirical;
                    val = this.f3Ratios.getInterpolated(NonErgodicSiteResponseMod.RatioParams.RATIO, refPeriod) * empirical + w1 * epsilonBelow + w2 * epsilonAbove;
                }
            } else {
                val = x1 > 0.0 ? Interpolate.findY(Math.log(x1), y1[i], Math.log(x2), y2[i], Math.log(period)) : Interpolate.findY(x1, y1[i], x2, y2[i], period);
            }
            ret[i] = val;
        }
        return ret;
    }

    public void plotInterpolation(PeriodDependentParamSet<NonErgodicSiteResponseMod.Params> periodParams, List<Double> periods, double refPeriod, double tSite, double tSiteN, Site site) {
        List<PlotSpec> specs = this.getInterpolationPlot(periodParams, periods, refPeriod, tSite, tSiteN, site);
        for (PlotSpec spec : specs) {
            GraphWindow gw = new GraphWindow(spec);
            gw.setXLog(true);
        }
    }

    public void writeInterpolationPlot(PeriodDependentParamSet<NonErgodicSiteResponseMod.Params> periodParams, List<Double> periods, double refPeriod, double tSite, double tSiteN, Site site, File outputFile) throws IOException {
        Collections.sort(periods);
        List<PlotSpec> specs = this.getInterpolationPlot(periodParams, periods, refPeriod, tSite, tSiteN, site);
        HeadlessGraphPanel gp = new HeadlessGraphPanel();
        gp.setBackgroundColor(Color.WHITE);
        gp.setTickLabelFontSize(18);
        gp.setAxisLabelFontSize(20);
        gp.setPlotLabelFontSize(21);
        ArrayList xRanges = Lists.newArrayList((Object[])new Range[]{new Range(periods.get(0).doubleValue(), periods.get(periods.size() - 1).doubleValue())});
        gp.drawGraphPanel(specs, true, false, (List<Range>)xRanges, null);
        gp.getChartPanel().setSize(1000, 800);
        String name = outputFile.getName().toLowerCase();
        if (name.endsWith(".png")) {
            gp.saveAsPNG(outputFile.getAbsolutePath());
        } else if (name.endsWith(".pdf")) {
            gp.saveAsPDF(outputFile.getAbsolutePath());
        } else if (name.endsWith(".txt")) {
            gp.saveAsTXT(outputFile.getAbsolutePath());
        } else {
            throw new IllegalStateException("Unknown plot extention: " + outputFile.getName());
        }
    }

    private List<PlotSpec> getInterpolationPlot(PeriodDependentParamSet<NonErgodicSiteResponseMod.Params> periodParams, List<Double> periods, double refPeriod, double tSite, double tSiteN, Site site) {
        NonErgodicSiteResponseMod.Params[] paramsToPlot = new NonErgodicSiteResponseMod.Params[]{NonErgodicSiteResponseMod.Params.F1, NonErgodicSiteResponseMod.Params.F2, NonErgodicSiteResponseMod.Params.F3};
        ArbitrarilyDiscretizedFunc[] interpolatedFunc = new ArbitrarilyDiscretizedFunc[paramsToPlot.length];
        ArbitrarilyDiscretizedFunc[] empiricalFunc = new ArbitrarilyDiscretizedFunc[paramsToPlot.length];
        ArbitrarilyDiscretizedFunc[] preferredFunc = new ArbitrarilyDiscretizedFunc[paramsToPlot.length];
        for (int i = 0; i < interpolatedFunc.length; ++i) {
            interpolatedFunc[i] = new ArbitrarilyDiscretizedFunc();
            interpolatedFunc[i].setName("Interpolated");
            empiricalFunc[i] = new ArbitrarilyDiscretizedFunc();
            empiricalFunc[i].setName("Empirical");
            preferredFunc[i] = new ArbitrarilyDiscretizedFunc();
            preferredFunc[i].setName("Preferred");
        }
        Preconditions.checkState((boolean)site.containsParameter("Vs30"));
        double vs30 = site.getParameter(Double.class, "Vs30").getValue();
        Double z1p0 = site.getParameter(Double.class, "Depth 1.0 km/sec").getValue();
        z1p0 = z1p0 == null ? Double.valueOf(Double.NaN) : Double.valueOf(z1p0 / 1000.0);
        for (double period : periods) {
            double[] preferredVals = this.getInterpolated(periodParams, paramsToPlot, period, refPeriod, tSite, tSiteN, site);
            double[] interpVals = this.getInterpolated(periodParams, paramsToPlot, period, refPeriod, Double.NaN, Double.NaN, site);
            for (int i = 0; i < paramsToPlot.length; ++i) {
                interpolatedFunc[i].set(period, interpVals[i]);
                preferredFunc[i].set(period, preferredVals[i]);
                empiricalFunc[i].set(period, this.calcEmpirical(paramsToPlot[i], period, vs30, (double)z1p0));
                System.out.println("Empirical " + paramsToPlot[i].name() + ", " + (float)period + "s: " + empiricalFunc[i].getY(period));
            }
        }
        ArrayList specs = Lists.newArrayList();
        for (int i = 0; i < paramsToPlot.length; ++i) {
            ArrayList funcs = Lists.newArrayList();
            ArrayList chars = Lists.newArrayList();
            funcs.add(empiricalFunc[i]);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLUE));
            funcs.add(interpolatedFunc[i]);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.RED));
            funcs.add(preferredFunc[i]);
            chars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, PlotSymbol.CIRCLE, 4.0f, Color.RED));
            ArbitrarilyDiscretizedFunc input = new ArbitrarilyDiscretizedFunc();
            input.setName("Input");
            for (double period : periodParams.getPeriods()) {
                input.set(period, periodParams.get(paramsToPlot[i], period));
            }
            funcs.add(input);
            chars.add(new PlotCurveCharacterstics(PlotSymbol.TRIANGLE, 6.0f, Color.BLACK));
            DataUtils.MinMaxAveTracker yTrack = new DataUtils.MinMaxAveTracker();
            for (XY_DataSet func : funcs) {
                yTrack.addValue(func.getMaxY());
                yTrack.addValue(func.getMinY());
            }
            Range yRange = new Range(yTrack.getMin() - 0.1, yTrack.getMax() + 0.1);
            DefaultXY_DataSet tSiteLine = new DefaultXY_DataSet();
            DefaultXY_DataSet t2SiteLine = new DefaultXY_DataSet();
            double t2Site = 2.0 * tSite;
            tSiteLine.set(tSite, yRange.getLowerBound());
            tSiteLine.set(tSite, yRange.getUpperBound());
            t2SiteLine.set(t2Site, yRange.getLowerBound());
            t2SiteLine.set(t2Site, yRange.getUpperBound());
            tSiteLine.setName("Tsite");
            funcs.add(tSiteLine);
            chars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 1.0f, Color.GRAY));
            t2SiteLine.setName("2Tsite");
            funcs.add(t2SiteLine);
            chars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 1.0f, Color.DARK_GRAY));
            PlotSpec spec = new PlotSpec(funcs, chars, "Parameter Interpolation", "Period", paramsToPlot[i].toString());
            if (i == paramsToPlot.length - 1) {
                spec.setLegendVisible(true);
            }
            specs.add(spec);
        }
        return specs;
    }

    public static void main(String[] args) throws IOException {
        PeriodDependentParamSet periodParams = PeriodDependentParamSet.loadCSV((Enum[])NonErgodicSiteResponseMod.Params.values(), (InputStream)PeriodDependentParamSet.class.getResourceAsStream("/data/imr/sag_2017_nonergodic/params.csv"));
        for (double period : periodParams.getPeriods()) {
            periodParams.set(period, NonErgodicSiteResponseMod.Params.F3, 0.25 + Math.random() * 0.5);
        }
        File outputDir = new File("/tmp");
        PeriodDependentParamSet imtRatios = PeriodDependentParamSet.loadCSV((Enum[])NonErgodicSiteResponseMod.RatioParams.values(), (InputStream)NonErgodicSiteResponseMod.class.getResourceAsStream("/data/imr/sag_2017_nonergodic/ratios.csv"));
        BSSA_ParamInterpolator interp = new BSSA_ParamInterpolator(imtRatios);
        Site site = new Site();
        Vs30_Param vs30 = new Vs30_Param();
        vs30.setValue(197.0);
        site.addParameter(vs30);
        DepthTo1pt0kmPerSecParam z10 = new DepthTo1pt0kmPerSecParam();
        z10.setValue(0.004200000000000001);
        site.addParameter(z10);
        double tSite = 0.7;
        double tSiteN = 2.0;
        double refPeriod = Double.NaN;
        ArrayList periods = Lists.newArrayList();
        for (IMT imt : interp.bssa.getSupportedIMTs()) {
            if (!imt.isSA()) continue;
            periods.add(imt.getPeriod());
        }
        Collections.sort(periods);
        System.out.println("Periods: " + Joiner.on((String)",").join((Iterable)periods));
        interp.writeInterpolationPlot(periodParams, periods, refPeriod, tSite, tSiteN, site, new File("/tmp/param_interpolation.png"));
    }
}

