/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.mod.impl.stewartSiteSpecific;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.primitives.Doubles;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import javax.swing.JOptionPane;
import org.opensha.commons.data.ShortNamed;
import org.opensha.commons.data.Site;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.editor.impl.ParameterListEditor;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.BooleanParameter;
import org.opensha.commons.param.impl.ButtonParameter;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.imr.attenRelImpl.ngaw2.IMT;
import org.opensha.sha.imr.mod.impl.IML_DependentAttenRelMod;
import org.opensha.sha.imr.mod.impl.stewartSiteSpecific.BSSA_ParamInterpolator;
import org.opensha.sha.imr.mod.impl.stewartSiteSpecific.PeriodDependentParamSet;
import org.opensha.sha.imr.mod.impl.stewartSiteSpecific.PeriodDependentParamSetParam;
import org.opensha.sha.imr.param.IntensityMeasureParams.SA_Param;
import org.opensha.sha.imr.param.SiteParams.DepthTo1pt0kmPerSecParam;
import org.opensha.sha.imr.param.SiteParams.DepthTo2pt5kmPerSecParam;
import org.opensha.sha.imr.param.SiteParams.Vs30_Param;
import org.opensha.sha.imr.param.SiteParams.Vs30_TypeParam;

public class NonErgodicSiteResponseMod
extends IML_DependentAttenRelMod
implements ParameterChangeListener {
    private static final boolean D = false;
    private static final boolean DD = false;
    public static final String NAME = "Non Ergodic Site Response 2016 Mod";
    public static final String SHORT_NAME = "NonErgodic2016";
    private static final Map<Params, Double> defaultParamValues = Maps.newHashMap();
    private static double[] periodsForDefault;
    private PeriodDependentParamSet<Params> periodParams;
    private double curPeriod;
    private double[] curParamValues;
    private PeriodDependentParamSetParam<Params> periodParamsParam;
    private BooleanParameter usePhiSSParam;
    private DoubleParameter rhoParam;
    private static final String REF_IMT_DEFAULT = "PGA";
    private static final String REF_IMT_OF_INTEREST = "IMT of Interst";
    private StringParameter refIMTParam;
    private PeriodDependentParamSet<RatioParams> imtRatios;
    private PeriodDependentParamSetParam<RatioParams> imtRatiosParam;
    private DoubleParameter tSiteParam;
    private DoubleParameter tSiteNParam;
    private ButtonParameter plotInterpParam;
    private ParameterList paramList;
    private Parameter<Double> imt;
    private Site curSite;
    private BSSA_ParamInterpolator interp;
    private ParameterList referenceSiteParams;
    private boolean refSiteParamsStale = true;
    static final String RESOURCES_DIR = "/data/imr/sag_2017_nonergodic";

    public NonErgodicSiteResponseMod() {
        try {
            this.periodParams = PeriodDependentParamSet.loadCSV((Enum[])Params.values(), (InputStream)this.getClass().getResourceAsStream("/data/imr/sag_2017_nonergodic/params.csv"));
        }
        catch (IOException e) {
            System.err.println("Error loading default params:");
            e.printStackTrace();
            this.periodParams = new PeriodDependentParamSet((Enum[])Params.values());
        }
        this.periodParamsParam = new PeriodDependentParamSetParam<Params>("Period Dependent Params", this.periodParams);
        this.periodParamsParam.addParameterChangeListener(this);
        this.paramList = new ParameterList();
        this.paramList.addParameter(this.periodParamsParam);
        this.usePhiSSParam = new BooleanParameter("Use " + Params.PHI_SS.toString(), false);
        this.paramList.addParameter(this.usePhiSSParam);
        this.tSiteParam = new DoubleParameter("Tsite", Double.NaN);
        this.tSiteParam.setInfo("(Optional) The natural period of the site (sec). The transition of amplification parameters from \nuser-entered values to the Semi-empirical model starts from Tsite. If no values are entered, the \ntransition will not happen, and the last user-entered value for amplification parameters will be used \nfor all periods longer than the longest period for which the user has entered the amplification values.");
        this.tSiteParam.addParameterChangeListener(this);
        this.paramList.addParameter(this.tSiteParam);
        this.tSiteNParam = new DoubleParameter("N for Tsite", 2.0);
        this.tSiteNParam.setInfo("The transition from user-entered values to the Semi-empirical model starts at Tsite and ends at N*Tsite.");
        this.tSiteNParam.addParameterChangeListener(this);
        this.paramList.addParameter(this.tSiteNParam);
        this.plotInterpParam = new ButtonParameter("Interpolation", "Plot Interpolation");
        this.plotInterpParam.addParameterChangeListener(this);
        this.paramList.addParameter(this.plotInterpParam);
        this.rhoParam = new DoubleParameter("lnZ, lnX correlation", 0.0, 1.0, (Double)0.65);
        this.rhoParam.setInfo("Correlation between surface intensity measure and the reference intensity measure.");
        this.paramList.addParameter(this.rhoParam);
        this.refIMTParam = new StringParameter("Reference IMT", Lists.newArrayList((Object[])new String[]{REF_IMT_DEFAULT, REF_IMT_OF_INTEREST}));
        this.refIMTParam.setValue(REF_IMT_DEFAULT);
        this.refIMTParam.addParameterChangeListener(this);
        this.paramList.addParameter(this.refIMTParam);
        try {
            this.imtRatios = PeriodDependentParamSet.loadCSV((Enum[])RatioParams.values(), (InputStream)this.getClass().getResourceAsStream("/data/imr/sag_2017_nonergodic/ratios.csv"));
        }
        catch (IOException e) {
            System.err.println("Error loading default ratios:");
            e.printStackTrace();
            this.imtRatios = new PeriodDependentParamSet((Enum[])RatioParams.values());
        }
        this.imtRatiosParam = new PeriodDependentParamSetParam<RatioParams>("Ref IMT Ratio for f3 interpolation", this.imtRatios);
        this.imtRatiosParam.setInfo("In the case that Reference IM is not PGA, these values will be used to convert PGA to the\nreference IM for f3 calculations. For details see Stewart et al. (2014).");
        this.paramList.addParameter(this.imtRatiosParam);
        this.setReferenceSiteParams(NonErgodicSiteResponseMod.getDefaultReferenceSiteParams());
    }

    static ParameterList getDefaultReferenceSiteParams() {
        ParameterList params = new ParameterList();
        Vs30_Param vs30 = new Vs30_Param(760.0);
        vs30.setValueAsDefault();
        params.addParameter(vs30);
        Vs30_TypeParam vs30Type = new Vs30_TypeParam();
        vs30Type.setValue("Measured");
        params.addParameter(vs30Type);
        DepthTo2pt5kmPerSecParam z25 = new DepthTo2pt5kmPerSecParam(null, true);
        z25.setValueAsDefault();
        params.addParameter(z25);
        DepthTo1pt0kmPerSecParam z10 = new DepthTo1pt0kmPerSecParam(null, true);
        z10.setValueAsDefault();
        params.addParameter(z10);
        return params;
    }

    public void setReferenceSiteParams(ParameterList referenceSiteParams) {
        if (this.referenceSiteParams == null) {
            this.referenceSiteParams = referenceSiteParams;
            for (Parameter<?> param : referenceSiteParams) {
                param.addParameterChangeListener(this);
            }
        } else {
            for (Parameter<?> param : referenceSiteParams) {
                this.referenceSiteParams.getParameter(param.getName()).setValue(param.getValue());
            }
        }
    }

    ParameterList getReferenceSiteParams() {
        return this.referenceSiteParams;
    }

    @Override
    public String getShortName() {
        return SHORT_NAME;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void setIMRParams(ScalarIMR imr) {
        this.refSiteParamsStale = true;
        this.checkUpdateRefIMRSiteParams(imr);
        Preconditions.checkState((boolean)imr.isIntensityMeasureSupported(REF_IMT_DEFAULT));
    }

    private void checkUpdateRefIMRSiteParams(ScalarIMR imr) {
        Parameter param2;
        if (!this.refSiteParamsStale) {
            return;
        }
        try {
            param2 = imr.getParameter("Vs30");
            param2.setValue(this.referenceSiteParams.getParameter(Double.class, "Vs30").getValue());
        }
        catch (ParameterException param2) {
            // empty catch block
        }
        try {
            param2 = imr.getParameter("Vs30 Type");
            param2.setValue(this.referenceSiteParams.getParameter(String.class, "Vs30 Type").getValue());
        }
        catch (ParameterException param3) {
            // empty catch block
        }
        try {
            param2 = imr.getParameter("Depth 2.5 km/sec");
            param2.setValue(this.referenceSiteParams.getParameter(Double.class, "Depth 2.5 km/sec").getValue());
        }
        catch (ParameterException param4) {
            // empty catch block
        }
        try {
            param2 = imr.getParameter("Depth 1.0 km/sec");
            param2.setValue(this.referenceSiteParams.getParameter(Double.class, "Depth 1.0 km/sec").getValue());
        }
        catch (ParameterException parameterException) {
            // empty catch block
        }
        this.refSiteParamsStale = false;
    }

    @Override
    public void setIMT_IMT(ScalarIMR imr, Parameter<Double> imt) {
        this.imt = imt;
        if (imt.getName().equals("SA")) {
            this.curPeriod = SA_Param.getPeriodInSA_Param(imt);
        } else {
            Preconditions.checkState((boolean)imt.getName().equals(REF_IMT_DEFAULT), (Object)"Only SA and PGA supported");
            this.curPeriod = 0.0;
        }
        this.curParamValues = null;
        super.setIMT_IMT(imr, imt);
    }

    private BSSA_ParamInterpolator getInterpolator() {
        if (this.interp == null) {
            this.interp = new BSSA_ParamInterpolator(this.imtRatios);
        }
        return this.interp;
    }

    private synchronized double[] getCurParams(ScalarIMR imr) {
        if (this.curParamValues == null) {
            BSSA_ParamInterpolator interp = this.getInterpolator();
            if (this.periodParams.isEmpty()) {
                double vs30 = (Double)this.curSite.getParameter("Vs30").getValue();
                Double z1p0 = (Double)this.curSite.getParameter("Depth 1.0 km/sec").getValue();
                z1p0 = z1p0 == null ? Double.valueOf(Double.NaN) : Double.valueOf(z1p0 / 1000.0);
                ArrayList periods = Lists.newArrayList();
                for (double period : periodsForDefault) {
                    periods.add(period);
                }
                periods.add(this.curPeriod);
                Object object = periods.iterator();
                while (object.hasNext()) {
                    double period = (Double)object.next();
                    for (Params param : Params.values()) {
                        Double defaultVal = defaultParamValues.get(param);
                        if (defaultVal == null) {
                            defaultVal = interp.calcEmpirical(param, period, vs30, (double)z1p0);
                        }
                        this.periodParams.set(period, param, (double)defaultVal);
                    }
                }
                this.periodParamsParam.getEditor().refreshParamEditor();
                this.curParamValues = this.periodParams.getInterpolated((Params[])this.periodParams.getParams(), this.curPeriod);
            } else {
                double refPeriod = this.getRefPeriodForInterpolation(imr.getIntensityMeasure().getName());
                this.curParamValues = interp == null || this.curPeriod <= 0.0 ? this.periodParams.getInterpolated((Params[])this.periodParams.getParams(), this.curPeriod) : interp.getInterpolated(this.periodParams, this.curPeriod, refPeriod, (double)((Double)this.tSiteParam.getValue()), (double)((Double)this.tSiteNParam.getValue()), this.curSite);
            }
        }
        return this.curParamValues;
    }

    private double getRefPeriodForInterpolation(String imt) {
        if (((String)this.refIMTParam.getValue()).equals(REF_IMT_OF_INTEREST)) {
            if (imt.equals("SA")) {
                return Double.NaN;
            }
            if (imt.equals(REF_IMT_DEFAULT)) {
                return 0.0;
            }
            if (imt.equals("PGV")) {
                return -1.0;
            }
            throw new IllegalStateException("Unknown IMT: " + imt);
        }
        Preconditions.checkState((boolean)((String)this.refIMTParam.getValue()).equals(REF_IMT_DEFAULT));
        return 0.0;
    }

    void printCurParams() {
        if (this.curParamValues == null) {
            return;
        }
        StringBuilder sb = new StringBuilder("Current Params:\n");
        sb.append("\tPeriod\t").append(PeriodDependentParamSet.j.join((Object[])this.periodParams.getParams())).append("\n");
        sb.append("\t").append(this.curPeriod).append("\t").append(PeriodDependentParamSet.j.join((Iterable)Doubles.asList((double[])this.curParamValues))).append("\n");
        System.out.println(sb.toString());
    }

    public void setSiteAmpParams(double period, Map<Params, Double> values) {
        for (Params param : values.keySet()) {
            this.periodParams.set(period, param, (double)values.get(param));
        }
        this.curParamValues = null;
    }

    public void setTsite(double tSite) {
        this.tSiteParam.setValue(tSite);
    }

    @Override
    public void setIMRSiteParams(ScalarIMR imr, Site site) {
        imr.setSiteLocation(site.getLocation());
        this.curSite = site;
        this.curParamValues = null;
    }

    public void setReferenceIMT(String refIMT) {
        Preconditions.checkArgument((boolean)this.refIMTParam.isAllowed(refIMT), (String)"Value is not allowed: %s", (Object)refIMT);
        this.refIMTParam.setValue(refIMT);
    }

    @Override
    public double getModMean(ScalarIMR imr, double iml) {
        this.checkUpdateRefIMRSiteParams(imr);
        String origIMT = this.imt.getName();
        Preconditions.checkState((boolean)imr.getIntensityMeasure().getName().equals(origIMT));
        double u_lnX = imr.getMean();
        double x_ref = this.calcXref(imr, iml);
        Preconditions.checkState((boolean)imr.getIntensityMeasure().getName().equals(origIMT));
        double[] params = this.getCurParams(imr);
        double f1 = params[this.periodParams.getParamIndex(Params.F1)];
        double f2 = params[this.periodParams.getParamIndex(Params.F2)];
        double f3 = params[this.periodParams.getParamIndex(Params.F3)];
        double ln_y = f1 + f2 * Math.log((x_ref + f3) / f3);
        Preconditions.checkState((boolean)Doubles.isFinite((double)ln_y));
        double yMax = Math.log(params[this.periodParams.getParamIndex(Params.Ymax)]);
        if (Doubles.isFinite((double)yMax)) {
            ln_y = Math.min(ln_y, yMax);
        }
        Preconditions.checkState((boolean)Doubles.isFinite((double)ln_y));
        return u_lnX + ln_y;
    }

    private double calcXref(ScalarIMR imr, double iml) {
        double sd_x_ref;
        double x_ref;
        String refIMT = (String)this.refIMTParam.getValue();
        if (!refIMT.equals(REF_IMT_OF_INTEREST)) {
            imr.setIntensityMeasure(refIMT);
            Preconditions.checkState((boolean)imr.getIntensityMeasure().getName().equals(refIMT));
            double x_ref_ln = imr.getMean();
            x_ref = Math.exp(x_ref_ln);
            sd_x_ref = imr.getStdDev();
            imr.setIntensityMeasure(this.imt);
        } else {
            x_ref = Math.exp(imr.getMean());
            sd_x_ref = imr.getStdDev();
        }
        double rho = (Double)this.rhoParam.getValue();
        if (rho > 0.0) {
            imr.setIntensityMeasureLevel(iml);
            double epsilon = imr.getEpsilon();
            x_ref *= Math.exp(rho * epsilon * sd_x_ref);
        }
        return x_ref;
    }

    @Override
    protected boolean isCurrentlyIML_Dependent() {
        return (Double)this.rhoParam.getValue() > 0.0;
    }

    @Override
    public double getModStdDev(ScalarIMR imr, double iml) {
        this.checkUpdateRefIMRSiteParams(imr);
        StringParameter imrTypeParam = (StringParameter)imr.getParameter("Std Dev Type");
        String origIMRType = (String)imrTypeParam.getValue();
        imrTypeParam.setValue("Inter-Event");
        double origTau = imr.getStdDev();
        imrTypeParam.setValue("Intra-Event");
        double origPhi = imr.getStdDev();
        imrTypeParam.setValue(origIMRType);
        double[] params = this.getCurParams(imr);
        double f2 = params[this.periodParams.getParamIndex(Params.F2)];
        double f3 = params[this.periodParams.getParamIndex(Params.F3)];
        double F = params[this.periodParams.getParamIndex(Params.F)];
        double phiS2S = params[this.periodParams.getParamIndex(Params.PHI_S2S)];
        double phiLnY = params[this.periodParams.getParamIndex(Params.PHI_lnY)];
        double phiSS = params[this.periodParams.getParamIndex(Params.PHI_SS)];
        boolean usePhiSS = (Boolean)this.usePhiSSParam.getValue();
        double x_ref = this.calcXref(imr, iml);
        Preconditions.checkState((boolean)imr.getIntensityMeasure().getName().equals(this.imt.getName()));
        double term1 = Math.pow(f2 * x_ref / (x_ref + f3) + 1.0, 2.0);
        double term2 = usePhiSS ? phiSS * phiSS : origPhi * origPhi - F * phiS2S * phiS2S;
        double phi_lnZ = Math.sqrt(term1 * term2 + phiLnY * phiLnY);
        double modStdDev = Math.sqrt(phi_lnZ * phi_lnZ + origTau * origTau);
        return modStdDev;
    }

    @Override
    public ParameterList getModParams() {
        return this.paramList;
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        if (event.getSource() == this.periodParamsParam || event.getSource() == this.tSiteParam || event.getSource() == this.tSiteNParam) {
            this.curParamValues = null;
        } else if (this.referenceSiteParams.containsParameter(event.getParameterName())) {
            this.refSiteParamsStale = true;
        } else if (event.getParameter() == this.refIMTParam) {
            this.curParamValues = null;
        } else if (event.getSource() == this.plotInterpParam) {
            ArrayList periods = Lists.newArrayList();
            BSSA_ParamInterpolator interp = this.getInterpolator();
            for (IMT imt : interp.bssa.getSupportedIMTs()) {
                if (!imt.isSA()) continue;
                periods.add(imt.getPeriod());
            }
            Collections.sort(periods);
            Site site = new Site();
            ParameterList interpSiteParams = new ParameterList();
            interpSiteParams.addParameter(new Vs30_Param(760.0));
            interpSiteParams.getParameter("Vs30").setValueAsDefault();
            interpSiteParams.addParameter(new DepthTo1pt0kmPerSecParam(null, true));
            ParameterListEditor editor = new ParameterListEditor(interpSiteParams);
            editor.setTitle("Empirical Model Site Parameters");
            JOptionPane.showMessageDialog(null, editor, "Enter Site Parameters for Interpolation", 3);
            site.addParameterList(interpSiteParams);
            double refPeriod = this.getRefPeriodForInterpolation("SA");
            interp.plotInterpolation(this.periodParams, periods, refPeriod, (Double)this.tSiteParam.getValue(), (Double)this.tSiteNParam.getValue(), site);
        }
    }

    public static void main(String[] args) {
        new NonErgodicSiteResponseMod();
    }

    static {
        defaultParamValues.put(Params.F1, null);
        defaultParamValues.put(Params.F2, null);
        defaultParamValues.put(Params.F3, 0.1);
        defaultParamValues.put(Params.PHI_lnY, 0.3);
        defaultParamValues.put(Params.PHI_S2S, 0.4);
        defaultParamValues.put(Params.F, 1.0);
        defaultParamValues.put(Params.PHI_SS, 0.437);
        defaultParamValues.put(Params.Ymax, Double.NaN);
        for (Params param : Params.values()) {
            Preconditions.checkState((boolean)defaultParamValues.containsKey(param), (String)"Missing default for %s", (Object)param);
        }
        periodsForDefault = new double[]{0.01, 0.02, 0.05, 0.1, 0.2, 0.5, 1.0};
    }

    public static enum Params implements ShortNamed
    {
        F1("f1", "Weak-motion (linear) amplification"),
        F2("f2", "The level of nonlinearity in site response."),
        F3("f3", "The level of reference site ground shaking below which the amplification\nconverges towards a linear (constant) upper limit."),
        PHI_lnY("\u03d5 lnY", "Standard deviation of amplification function"),
        PHI_S2S("\u03d5 S2S", "Represents site-to-site amplification variability"),
        F("F", "Reduction factor for site-to-site variability for single site analysis which is between 0 and 1. \nF=1 means completely eliminating site-to-site variability, F=0 means no reduction of site-to-site variability."),
        PHI_SS("\u03d5 SS", "Represents within-event single site standard deviation of ground motion. \nIn the case of activating \"Use \u03d5 SS\" button, \u03d5 S2S will be ignored, and \u03d5 SSs will be used."),
        Ymax("Ymax", "(Optional) Weak motion amplification level beyond which the amplification function will be truncated to Ymax. \nIf no values (or NaN) are entered, no truncation will happen.");

        private String name;
        private String description;

        private Params(String name, String description) {
            this.name = name;
            this.description = description;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public String getName() {
            return this.description;
        }

        @Override
        public String getShortName() {
            return this.name;
        }
    }

    public static enum RatioParams {
        RATIO("Ratio");

        private String name;

        private RatioParams(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

