/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.param.EqkRuptureParams;

import org.opensha.commons.param.constraint.impl.DoubleConstraint;
import org.opensha.commons.param.impl.WarningDoubleParameter;

public class RupTopDepthParam
extends WarningDoubleParameter {
    public static final String NAME = "Rupture Top Depth";
    public static final String UNITS = "km";
    public static final String INFO = "The depth to the shallowest point on the earthquake rupture surface";
    protected static final Double MIN = 0.0;
    protected static final Double MAX = 100.0;

    public RupTopDepthParam(double min, double max, double minWarning, double maxWarning, double defaultDepth) {
        super(NAME, new DoubleConstraint(min, max));
        this.getConstraint().setNonEditable();
        DoubleConstraint warn = new DoubleConstraint(minWarning, maxWarning);
        warn.setNonEditable();
        this.setWarningConstraint(warn);
        this.setInfo(INFO);
        this.setDefaultValue(defaultDepth);
        this.setNonEditable();
    }

    public RupTopDepthParam(double minWarning, double maxWarning, double defaultDepth) {
        this(Double.min(MIN, minWarning), Double.max(MAX, maxWarning), minWarning, maxWarning, defaultDepth);
    }

    public RupTopDepthParam(double minWarning, double maxWarning) {
        this(minWarning, maxWarning, 0.0);
    }

    public RupTopDepthParam(double defaultDepth) {
        super(NAME, new DoubleConstraint(MIN, MAX), UNITS);
        this.getConstraint().setNonEditable();
        this.setInfo(INFO);
        this.setDefaultValue(defaultDepth);
    }

    public RupTopDepthParam() {
        this(0.0);
    }
}

