/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.param.IntensityMeasureParams;

import java.util.List;
import org.opensha.commons.param.constraint.impl.DoubleDiscreteConstraint;
import org.opensha.commons.param.impl.DoubleDiscreteParameter;

public class PeriodParam
extends DoubleDiscreteParameter {
    public static final String NAME = "SA Period";
    public static final String UNITS = "sec";
    public static final String INFO = "Oscillator Period for SA";

    public PeriodParam(DoubleDiscreteConstraint peroidList, double defaultPeriod, boolean leaveEditable) {
        super(NAME, peroidList, UNITS);
        peroidList.setNonEditable();
        this.setInfo(INFO);
        this.setDefaultValue(defaultPeriod);
        if (!leaveEditable) {
            this.setNonEditable();
        }
    }

    public PeriodParam(DoubleDiscreteConstraint peroidList) {
        this(peroidList, 1.0, false);
    }

    public List<Double> getSupportedPeriods() {
        DoubleDiscreteConstraint constr = (DoubleDiscreteConstraint)this.getConstraint();
        List<Double> periods = constr.getAllowedDoubles();
        return periods;
    }

    public double getMinPeriod() {
        List<Double> periods = this.getSupportedPeriods();
        return periods.get(0);
    }

    public double getMaxPeriod() {
        List<Double> periods = this.getSupportedPeriods();
        return periods.get(periods.size() - 1);
    }

    public double[] getPeriods() {
        List<Double> periods = this.getSupportedPeriods();
        double[] pers = new double[periods.size()];
        for (int i = 0; i < periods.size(); ++i) {
            pers[i] = periods.get(i);
        }
        return pers;
    }
}

