/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.imr.param.PropagationEffectParams;

import java.util.ListIterator;
import org.dom4j.Element;
import org.opensha.commons.exceptions.ConstraintException;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.param.constraint.ParameterConstraint;
import org.opensha.commons.param.constraint.impl.DoubleConstraint;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.imr.param.PropagationEffectParams.AbstractDoublePropEffectParam;

public class DistRupMinusJB_OverRupParameter
extends AbstractDoublePropEffectParam {
    protected static final String C = "DistanceRupMinusJB_Parameter";
    protected static final boolean D = false;
    public static final String NAME = "(distRup-distJB)/distRup";
    public static final String INFO = "(DistanceRup - DistanceJB)/DistanceRup";
    private static final Double MIN = 0.0;
    private static final Double MAX = 1.0;

    public DistRupMinusJB_OverRupParameter() {
        super(NAME);
        this.init();
    }

    public DistRupMinusJB_OverRupParameter(double defaultValue) {
        super(NAME);
        this.init();
        this.setDefaultValue(defaultValue);
    }

    public DistRupMinusJB_OverRupParameter(ParameterConstraint warningConstraint) throws ConstraintException {
        super(NAME);
        if (warningConstraint != null && !(warningConstraint instanceof DoubleConstraint)) {
            throw new ConstraintException("DistanceRupMinusJB_Parameter : Constructor(): Input constraint must be a DoubleConstraint");
        }
        this.init((DoubleConstraint)warningConstraint);
    }

    public DistRupMinusJB_OverRupParameter(ParameterConstraint warningConstraint, double defaultValue) throws ConstraintException {
        super(NAME);
        if (warningConstraint != null && !(warningConstraint instanceof DoubleConstraint)) {
            throw new ConstraintException("DistanceRupMinusJB_Parameter : Constructor(): Input constraint must be a DoubleConstraint");
        }
        this.init((DoubleConstraint)warningConstraint);
        this.setDefaultValue(defaultValue);
    }

    protected void init(DoubleConstraint warningConstraint) {
        this.warningConstraint = warningConstraint;
        this.constraint = new DoubleConstraint(MIN, MAX);
        this.constraint.setNullAllowed(false);
        this.name = NAME;
        this.constraint.setName(this.name);
        this.info = INFO;
    }

    protected void init() {
        this.init(null);
    }

    @Override
    protected void calcValueFromSiteAndEqkRup() {
        if (this.site != null && this.eqkRupture != null) {
            double totalDist;
            Location loc1 = this.site.getLocation();
            double minRupDistance = Double.MAX_VALUE;
            double minHorzDistance = Double.MAX_VALUE;
            RuptureSurface rupSurf = this.eqkRupture.getRuptureSurface();
            ListIterator<Location> it = rupSurf.getAveDip() > 89.0 ? rupSurf.getEvenlyDiscritizedUpperEdge().listIterator() : rupSurf.getLocationsIterator();
            while (it.hasNext()) {
                double vertDist;
                Location loc2 = it.next();
                double horzDist = LocationUtils.horzDistance(loc1, loc2);
                totalDist = horzDist * horzDist + (vertDist = LocationUtils.vertDistance(loc1, loc2)) * vertDist;
                if (totalDist < minRupDistance) {
                    minRupDistance = totalDist;
                }
                if (!(horzDist < minHorzDistance)) continue;
                minHorzDistance = horzDist;
            }
            totalDist = Math.sqrt(minRupDistance);
            if (totalDist == 0.0) {
                this.setValueIgnoreWarning(0.0);
            } else {
                double fract = (totalDist - minHorzDistance) / totalDist;
                this.setValueIgnoreWarning(fract);
            }
        } else {
            this.value = null;
        }
    }

    @Override
    public String getType() {
        Object type = "DoubleParameter";
        ParameterConstraint constraint = this.constraint;
        if (constraint != null) {
            type = "Constrained" + (String)type;
        }
        return type;
    }

    @Override
    public Object clone() {
        DoubleConstraint c1 = null;
        DoubleConstraint c2 = null;
        if (this.constraint != null) {
            c1 = (DoubleConstraint)this.constraint.clone();
        }
        if (this.warningConstraint != null) {
            c2 = (DoubleConstraint)this.warningConstraint.clone();
        }
        Double val = null;
        Double val2 = null;
        if (this.value != null) {
            val = (Double)this.value;
            val2 = (double)val;
        }
        DistRupMinusJB_OverRupParameter param = new DistRupMinusJB_OverRupParameter();
        param.value = val2;
        param.constraint = c1;
        param.warningConstraint = c2;
        param.name = this.name;
        param.info = this.info;
        param.site = this.site;
        param.eqkRupture = this.eqkRupture;
        if (!this.editable) {
            param.setNonEditable();
        }
        return param;
    }

    @Override
    public boolean setIndividualParamValueFromXML(Element el) {
        return false;
    }
}

