/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.magdist;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.exceptions.InvalidRangeException;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.sha.magdist.GutenbergRichterMagFreqDist;
import org.opensha.sha.magdist.IncrementalMagFreqDist;

public class TaperedGR_MagFreqDist
extends IncrementalMagFreqDist {
    public static String NAME = new String("Tapered GR Dist");
    private boolean D = false;
    private double magLower;
    private double magCorner;
    private double bValue;

    public TaperedGR_MagFreqDist(double min, int num, double delta) throws InvalidRangeException {
        super(min, num, delta);
        this.magLower = min;
    }

    public TaperedGR_MagFreqDist(double min, double max, int num) throws InvalidRangeException {
        super(min, max, num);
    }

    public TaperedGR_MagFreqDist(double bValue, double totCumRate, double min, double max, int num) throws InvalidRangeException {
        super(min, max, num);
        this.setAllButTotMoRate(min, max, totCumRate, bValue);
    }

    public TaperedGR_MagFreqDist(double min, int num, double delta, double magLower, double magCorner, double totMoRate, double bValue) throws InvalidRangeException {
        super(min, num, delta);
        this.setAllButTotCumRate(magLower, magCorner, totMoRate, bValue);
    }

    public void setAllButTotCumRate(double magLower, double magCorner, double totMoRate, double bValue) {
        this.magLower = magLower;
        this.magCorner = magCorner;
        this.bValue = bValue;
        this.calculateRelativeRates();
        this.scaleToTotalMomentRate(totMoRate);
    }

    public void setAllButTotMoRate(double magLower, double magCorner, double totCumRate, double bValue) {
        this.magLower = magLower;
        this.magCorner = magCorner;
        this.bValue = bValue;
        this.calculateRelativeRates();
        this.scaleToCumRate(magLower, totCumRate);
    }

    public void setAllButCornerMag(double magLower, double totMoRate, double totCumRate, double bValue) {
        boolean success;
        this.magLower = magLower;
        this.bValue = bValue;
        double deltaMag = 1.0;
        double magStart = magLower;
        block0: for (int loop = 0; loop < 5; ++loop) {
            for (double mag = magStart; mag <= this.maxX + deltaMag; mag += deltaMag) {
                this.setAllButTotMoRate(magLower, mag, totCumRate, bValue);
                if (!(this.getTotalMomentRate() > totMoRate)) continue;
                magStart = mag - deltaMag;
                if (magStart < magLower) {
                    throw new RuntimeException(NAME + ": Error - could not find corner magnitude that satisfies the moment rate (magLower too high?).");
                }
                deltaMag /= 10.0;
                continue block0;
            }
        }
        this.magCorner = magStart;
        this.setAllButTotMoRate(magLower, this.magCorner, totCumRate, bValue);
        double moRateBelow = this.getTotalMomentRate();
        this.magCorner = magStart + 1.0E-4;
        this.setAllButTotMoRate(magLower, this.magCorner, totCumRate, bValue);
        boolean bl = success = this.getTotalMomentRate() >= totMoRate && moRateBelow < totMoRate;
        if (!success) {
            throw new RuntimeException(NAME + ": Error - could not find corner magnitude that satisfies the moment rate (maxX too low?).");
        }
        if (this.D) {
            System.out.println("magLower = " + magLower);
            System.out.println("magCorner = " + this.magCorner);
            System.out.println("Orig totMoRate = " + totMoRate);
            System.out.println("Final totMoRate = " + this.getTotalMomentRate());
            System.out.println("Final/Orig totMoRate = " + this.getTotalMomentRate() / totMoRate + " (should be just greater than one)");
            System.out.println("totCumRate = " + this.getTotCumRate());
            System.out.println("bValue = " + bValue);
        }
    }

    public static void main(String[] args) {
        GutenbergRichterMagFreqDist gr = new GutenbergRichterMagFreqDist(0.0, 2001, 0.005);
        gr.setAllButTotMoRate(0.0, 7.6, 360000.0, 1.0);
        System.out.println(gr.getTotalMomentRate());
        TaperedGR_MagFreqDist tgr = new TaperedGR_MagFreqDist(0.0, 2001, 0.005);
        tgr.setAllButCornerMag(0.0, gr.getTotalMomentRate(), 360000.0, 1.0);
        ArrayList<EvenlyDiscretizedFunc> hists = new ArrayList<EvenlyDiscretizedFunc>();
        hists.add(tgr);
        hists.add(gr);
        hists.add(tgr.getCumRateDistWithOffset());
        hists.add(gr.getCumRateDistWithOffset());
        GraphWindow graph = new GraphWindow(hists, "GR Comparison");
        graph.setX_AxisLabel("Mag");
        graph.setY_AxisLabel("Rate");
        graph.setX_AxisRange(5.0, 9.0);
        graph.setY_AxisRange(1.0E-8, 10.0);
        graph.setAxisLabelFontSize(18);
        graph.setPlotLabelFontSize(20);
        graph.setTickLabelFontSize(16);
        graph.setYLog(true);
    }

    @Override
    public void set(Point2D point) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(double x, double y) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void set(int index, double y) {
        throw new UnsupportedOperationException();
    }

    private void calculateRelativeRates() {
        int i;
        if (this.magLower < this.minX || this.magLower > this.maxX) {
            throw new IllegalArgumentException("magLower should lie between minX and maxX");
        }
        if (this.magLower > this.magCorner) {
            throw new InvalidRangeException("magLower must be < magCorner");
        }
        int indexLow = this.getXIndex(this.magLower);
        double[] cumRate = new double[this.num + 1];
        for (i = 0; i < cumRate.length; ++i) {
            double mag = (double)i * this.delta + this.minX - this.delta / 2.0;
            cumRate[i] = Math.pow(10.0, -this.bValue * mag) * Math.exp(-Math.pow(10.0, 1.5 * (mag - this.magCorner)));
        }
        for (i = 0; i < cumRate.length - 1; ++i) {
            super.set(i, cumRate[i] - cumRate[i + 1]);
        }
        for (i = 0; i < indexLow; ++i) {
            super.set(i, 0.0);
        }
    }

    public double getTotCumRate() {
        return this.getCumRate(this.magLower);
    }

    public double get_bValue() {
        return this.bValue;
    }

    public double getMagLower() {
        return this.magLower;
    }

    public double getMagCorner() {
        return this.magCorner;
    }

    @Override
    public String getDefaultName() {
        return NAME;
    }

    @Override
    public String getDefaultInfo() {
        return "minMag=" + this.minX + "; maxMag=" + this.maxX + "; numMag=" + this.num + "; bValue=" + this.bValue + "; magLower=" + this.magLower + "; magCorner=" + (float)this.magCorner + "; totMoRate=" + (float)this.getTotalMomentRate() + "; totCumRate=" + (float)this.getCumRate(this.magLower);
    }
}

