/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.param;

import java.io.Serializable;
import java.util.ArrayList;
import org.dom4j.Element;
import org.opensha.commons.geo.Location;
import org.opensha.commons.param.AbstractParameter;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.editor.AbstractParameterEditorOld;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.commons.param.impl.IntegerParameter;
import org.opensha.commons.param.impl.ParameterListParameter;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.sha.faultSurface.AbstractEvenlyGriddedSurfaceWithSubsets;
import org.opensha.sha.faultSurface.EvenlyGriddedSurfFromSimpleFaultData;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.FrankelGriddedSurface;
import org.opensha.sha.faultSurface.SimpleListricGriddedSurface;
import org.opensha.sha.faultSurface.StirlingGriddedSurface;
import org.opensha.sha.param.editor.SimpleFaultParameterEditor;

public class SimpleFaultParameter
extends AbstractParameter
implements ParameterChangeListener,
Serializable {
    protected static final String C = "SimpleFaultParameter";
    protected static final boolean D = false;
    private static final long serialVersionUID = 123456789099999999L;
    public static final String FAULT_NAME = "Fault Name";
    public static final String GRID_SPACING = "Grid Spacing";
    public static final String GRID_SPACING_UNITS = "km";
    public static final String NUMBER_OF_FAULT_TRACE = "Num. of Fault Trace Points";
    public static final String NUM_DIPS = "Num. of Dips";
    public static final String DEPTH_PARAM_NAME = "Depth-";
    public static final String DIP_PARAM_NAME = "Dip-";
    public static final String LON_PARAM_NAME = "Lon-";
    public static final String LAT_PARAM_NAME = "Lat-";
    public static final int DEFAULT_NUM_FAULT_TRACE = 3;
    public static final int DEFAULT_DIPS = 1;
    public static final int latlonCols = 2;
    public static final double DEFAULT_GRID_SPACING = 1.0;
    public static final String LAT_TITLE = "Fault Latitudes";
    public static final String LON_TITLE = "Fault Longitudes";
    public static final String DIP_TITLE = "Dips";
    public static final String DEPTH_TITLE = "Depths";
    public static final String FAULT_TYPE_TITLE = "Finite Fault Type";
    public static final String FRANKEL = "Frankel's";
    public static final String STIRLING = "Stirling's";
    private boolean faultParameterChange = true;
    private double avgDip;
    private FaultTrace fltTrace;
    private double upperSies;
    private double lowerSies;
    private ParameterList parameterList;
    private ParameterListParameter parameterListParameterForLats;
    private ParameterListParameter parameterListParameterForLons;
    private ParameterListParameter parameterListParameterForDips;
    private ParameterListParameter parameterListParameterForDepths;
    public static final String DIP_DIRECTION_PARAM_NAME = "Ave. Dip Direction";
    private static final Double DEFAULT_DIP_DIRECTION = null;
    private static final String DIP_DIRECTION_PARAM_UNITS = "degrees";
    private static final String DIP_DIRECTION_INFO = "Leave blank to make this perpendicular to fault-Strike";
    private DoubleParameter dipDirectionParam = new DoubleParameter("Ave. Dip Direction", (Double)0.0, (Double)360.0, "degrees", DEFAULT_DIP_DIRECTION);
    private IntegerParameter numDipParam = new IntegerParameter("Num. of Dips", 1);
    StringParameter faultName = new StringParameter("Fault Name");
    DoubleParameter gridSpacing = new DoubleParameter("Grid Spacing", 0.01, 5.0, "km", (Double)1.0);
    IntegerParameter numFltTrace = new IntegerParameter("Num. of Fault Trace Points", 2, 100, (Integer)3);
    StringParameter faultTypeParam;
    private ArrayList prevLats;
    private ArrayList prevLons;
    private ArrayList prevDepths;
    private ArrayList prevDips;
    private transient AbstractParameterEditorOld paramEdit = null;

    public SimpleFaultParameter(String name) {
        super(name, null, null, null);
        this.initParamList();
    }

    public SimpleFaultParameter(String name, AbstractEvenlyGriddedSurfaceWithSubsets surface) {
        super(name, null, null, surface);
        this.initParamList();
    }

    @Override
    public int compareTo(Object obj) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This method not implemented yet");
    }

    @Override
    public boolean equals(Object obj) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This method not implemented yet");
    }

    @Override
    public Object clone() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("This method not implemented yet");
    }

    private void addDependenParamList() {
        this.numDipParam.addIndependentParameter(this.faultTypeParam);
        this.numDipParam.addIndependentParameter(this.dipDirectionParam);
        this.faultTypeParam.addIndependentParameter(this.dipDirectionParam);
        this.dipDirectionParam.addParameterChangeListener(this);
        this.faultTypeParam.addParameterChangeListener(this);
    }

    private void initParamList() {
        this.parameterList = new ParameterList();
        this.parameterList.addParameter(this.faultName);
        this.parameterList.addParameter(this.gridSpacing);
        this.parameterList.addParameter(this.numFltTrace);
        this.dipDirectionParam.setInfo(DIP_DIRECTION_INFO);
        this.dipDirectionParam.getConstraint().setNullAllowed(true);
        ArrayList<String> fltType = new ArrayList<String>();
        fltType.add(FRANKEL);
        fltType.add(STIRLING);
        this.faultTypeParam = new StringParameter(FAULT_TYPE_TITLE, fltType, (String)fltType.get(0));
        this.faultName.addParameterChangeListener(this);
        this.gridSpacing.addParameterChangeListener(this);
        this.numFltTrace.addParameterChangeListener(this);
        this.numDipParam.addParameterChangeListener(this);
        this.addDependenParamList();
    }

    public ParameterList getFaultTraceParamList() {
        return this.parameterList;
    }

    public Parameter getLatParam() {
        return this.parameterListParameterForLats;
    }

    public Parameter getLonParam() {
        return this.parameterListParameterForLons;
    }

    public Parameter getDepthParam() {
        return this.parameterListParameterForDepths;
    }

    public Parameter getDipParam() {
        return this.parameterListParameterForDips;
    }

    public Parameter getNumDipParam() {
        return this.numDipParam;
    }

    public Parameter getFaultTypeParam() {
        return this.faultTypeParam;
    }

    public Parameter getDipDirectionParam() {
        return this.dipDirectionParam;
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        this.faultParameterChange = true;
    }

    public double getGridSpacing() {
        return (Double)this.gridSpacing.getValue();
    }

    public void initLatLonParamList() {
        int i;
        int numFltTracePoints = (Integer)this.parameterList.getParameter(NUMBER_OF_FAULT_TRACE).getValue();
        DoubleParameter[] lat = new DoubleParameter[numFltTracePoints];
        DoubleParameter[] lon = new DoubleParameter[numFltTracePoints];
        ParameterList parameterListForLats = new ParameterList();
        ParameterList parameterListForLons = new ParameterList();
        int size = 0;
        if (this.prevLats != null) {
            size = this.prevLats.size();
        } else {
            this.prevLats = new ArrayList();
        }
        for (i = 0; i < numFltTracePoints; ++i) {
            lat[i] = size < i + 1 && size > 0 ? new DoubleParameter(LAT_PARAM_NAME + (i + 1), -90.0, 90.0, "Degrees") : (size == 0 ? new DoubleParameter(LAT_PARAM_NAME + (i + 1), -90.0, 90.0, "Degrees", (Double)(38.2248 - (double)i / 2.0)) : new DoubleParameter(LAT_PARAM_NAME + (i + 1), -90.0, 90.0, "Degrees", (Double)this.prevLats.get(i)));
            lat[i].addParameterChangeListener(this);
            parameterListForLats.addParameter(lat[i]);
        }
        this.parameterListParameterForLats = new ParameterListParameter(LAT_TITLE, parameterListForLats);
        if (this.prevLons != null) {
            size = this.prevLons.size();
        } else {
            this.prevLons = new ArrayList();
        }
        for (i = 0; i < numFltTracePoints; ++i) {
            lon[i] = size < i + 1 && size > 0 ? new DoubleParameter(LON_PARAM_NAME + (i + 1), -360.0, 360.0, "Degrees") : (size == 0 ? new DoubleParameter(LON_PARAM_NAME + (i + 1), -360.0, 360.0, "Degrees", (Double)(-122.0 - (double)i / 2.0)) : new DoubleParameter(LON_PARAM_NAME + (i + 1), -360.0, 360.0, "Degrees", (Double)this.prevLons.get(i)));
            lon[i].addParameterChangeListener(this);
            parameterListForLons.addParameter(lon[i]);
        }
        this.parameterListParameterForLons = new ParameterListParameter(LON_TITLE, parameterListForLons);
        if (this.numFltTrace.containsIndependentParameter(LAT_TITLE)) {
            this.numFltTrace.removeIndependentParameter(LAT_TITLE);
        }
        if (this.numFltTrace.containsIndependentParameter(LON_TITLE)) {
            this.numFltTrace.removeIndependentParameter(LON_TITLE);
        }
        this.numFltTrace.addIndependentParameter(this.parameterListParameterForLats);
        this.numFltTrace.addIndependentParameter(this.parameterListParameterForLons);
    }

    public void initDipParamList() {
        int numDips = (Integer)this.numDipParam.getValue();
        DoubleParameter[] dip = new DoubleParameter[numDips];
        ParameterList parameterListForDips = new ParameterList();
        int size = 0;
        if (this.prevDips != null) {
            size = this.prevDips.size();
        } else {
            this.prevDips = new ArrayList();
        }
        for (int i = 0; i < numDips; ++i) {
            dip[i] = size < i + 1 && size > 0 ? new DoubleParameter(DIP_PARAM_NAME + (i + 1), 0.0, 90.0, "Degrees") : (size == 0 ? new DoubleParameter(DIP_PARAM_NAME + (i + 1), 0.0, 90.0, "Degrees", Double.valueOf(90 - (i + 30))) : new DoubleParameter(DIP_PARAM_NAME + (i + 1), 0.0, 90.0, "Degrees", (Double)this.prevDips.get(i)));
            dip[i].addParameterChangeListener(this);
            parameterListForDips.addParameter(dip[i]);
        }
        this.parameterListParameterForDips = new ParameterListParameter(DIP_TITLE, parameterListForDips);
        if (this.numDipParam.containsIndependentParameter(DIP_TITLE)) {
            this.numDipParam.removeIndependentParameter(DIP_TITLE);
        }
        this.numDipParam.addIndependentParameter(this.parameterListParameterForDips);
    }

    public void initDepthParamList() {
        int numDepths = (Integer)this.numDipParam.getValue() + 1;
        DoubleParameter[] depth = new DoubleParameter[numDepths];
        ParameterList parameterListForDepths = new ParameterList();
        int size = 0;
        if (this.prevDepths != null) {
            size = this.prevDepths.size();
        } else {
            this.prevDepths = new ArrayList();
        }
        for (int i = 0; i < numDepths; ++i) {
            depth[i] = size < i + 1 && size > 0 ? new DoubleParameter(DEPTH_PARAM_NAME + (i + 1), 0.0, 99999.0, GRID_SPACING_UNITS) : (size == 0 ? new DoubleParameter(DEPTH_PARAM_NAME + (i + 1), 0.0, 99999.0, GRID_SPACING_UNITS, Double.valueOf(0 + (i + 6))) : new DoubleParameter(DEPTH_PARAM_NAME + (i + 1), 0.0, 99999.0, GRID_SPACING_UNITS, (Double)this.prevDepths.get(i)));
            parameterListForDepths.addParameter(depth[i]);
            depth[i].addParameterChangeListener(this);
        }
        this.parameterListParameterForDepths = new ParameterListParameter(DEPTH_TITLE, parameterListForDepths);
        if (this.numDipParam.containsIndependentParameter(DEPTH_TITLE)) {
            this.numDipParam.removeIndependentParameter(DEPTH_TITLE);
        }
        this.numDipParam.addIndependentParameter(this.parameterListParameterForDepths);
    }

    public void setEvenlyGriddedSurfaceFromParams() throws RuntimeException {
        if (this.faultParameterChange) {
            int i;
            int i2;
            this.faultParameterChange = false;
            ParameterList independentParamList = new ParameterList();
            EvenlyGriddedSurfFromSimpleFaultData surface = null;
            String fltName = (String)this.parameterList.getParameter(FAULT_NAME).getValue();
            this.fltTrace = new FaultTrace(fltName);
            if (fltName != null) {
                independentParamList.addParameter(this.parameterList.getParameter(FAULT_NAME));
            }
            ArrayList<Double> lats = new ArrayList<Double>();
            ArrayList<Double> lons = new ArrayList<Double>();
            ArrayList<Double> depths = new ArrayList<Double>();
            ArrayList<Double> dips = new ArrayList<Double>();
            int fltTracePoints = (Integer)this.parameterList.getParameter(NUMBER_OF_FAULT_TRACE).getValue();
            int numDips = (Integer)this.numDipParam.getValue();
            independentParamList.addParameter(this.parameterList.getParameter(NUMBER_OF_FAULT_TRACE));
            independentParamList.addParameter(this.numDipParam);
            for (i2 = 0; i2 < fltTracePoints; ++i2) {
                Double latLocation = (Double)this.parameterListParameterForLats.getParameter().getParameter(LAT_PARAM_NAME + (i2 + 1)).getValue();
                lats.add(latLocation);
            }
            for (i2 = 0; i2 < fltTracePoints; ++i2) {
                Double lonLocation = (Double)this.parameterListParameterForLons.getParameter().getParameter(LON_PARAM_NAME + (i2 + 1)).getValue();
                lons.add(lonLocation);
            }
            double prevDepth = (Double)this.parameterListParameterForDepths.getParameter().getParameter(DEPTH_PARAM_NAME + "1").getValue();
            for (i = 0; i <= numDips; ++i) {
                Double depthLocation = (Double)this.parameterListParameterForDepths.getParameter().getParameter(DEPTH_PARAM_NAME + (i + 1)).getValue();
                depths.add(depthLocation);
                if (depthLocation < prevDepth) {
                    throw new RuntimeException("Depths should be entered in increasing order");
                }
                prevDepth = depthLocation;
            }
            for (i = 0; i < numDips; ++i) {
                Double dipLocation = (Double)this.parameterListParameterForDips.getParameter().getParameter(DIP_PARAM_NAME + (i + 1)).getValue();
                dips.add(dipLocation);
            }
            independentParamList.addParameter(this.parameterListParameterForLats);
            independentParamList.addParameter(this.parameterListParameterForLons);
            independentParamList.addParameter(this.parameterListParameterForDepths);
            independentParamList.addParameter(this.parameterListParameterForDips);
            for (i = 0; i < fltTracePoints; ++i) {
                double lat = (Double)lats.get(i);
                double lon = (Double)lons.get(i);
                double depth = (Double)depths.get(0);
                Location loc = new Location(lat, lon, depth);
                this.fltTrace.add(loc);
            }
            double gridSpacing = (Double)this.parameterList.getParameter(GRID_SPACING).getValue();
            independentParamList.addParameter(this.parameterList.getParameter(GRID_SPACING));
            if (numDips == 1) {
                double dip;
                this.avgDip = dip = ((Double)dips.get(0)).doubleValue();
                String fltType = (String)this.faultTypeParam.getValue();
                double upperSiesDepth = depths.get(0);
                double lowerSiesDepth = depths.get(1);
                this.upperSies = upperSiesDepth;
                this.lowerSies = lowerSiesDepth;
                if (fltType.equalsIgnoreCase(FRANKEL)) {
                    surface = new FrankelGriddedSurface(this.fltTrace, dip, upperSiesDepth, lowerSiesDepth, gridSpacing);
                }
                if (fltType.equalsIgnoreCase(STIRLING)) {
                    Double aveDipDir = (Double)this.dipDirectionParam.getValue();
                    surface = aveDipDir == null ? new StirlingGriddedSurface(this.fltTrace, dip, upperSiesDepth, lowerSiesDepth, gridSpacing, Double.NaN) : new StirlingGriddedSurface(this.fltTrace, dip, upperSiesDepth, lowerSiesDepth, gridSpacing, aveDipDir);
                }
                independentParamList.addParameter(this.faultTypeParam);
            } else {
                surface = new SimpleListricGriddedSurface(this.fltTrace, dips, depths, gridSpacing);
            }
            this.setValue(surface);
            this.setIndependentParameters(independentParamList);
        }
    }

    public FaultTrace getFaultTrace() {
        return this.fltTrace;
    }

    public double getUpperSiesmogenicDepth() {
        return this.upperSies;
    }

    public double getLowerSiesmogenicDepth() {
        return this.lowerSies;
    }

    public void setNumFaultTracePoints(int numPoints) {
        this.numFltTrace.setValue(numPoints);
        this.initLatLonParamList();
    }

    public void setNumDips(int numDips) {
        this.numDipParam.setValue(numDips);
        this.initDipParamList();
        this.initDepthParamList();
    }

    public String getFaultName() {
        return (String)this.parameterList.getParameter(FAULT_NAME).getValue();
    }

    public void setDipDirection(double value) {
        if (((String)this.faultTypeParam.getValue()).equals(STIRLING)) {
            this.dipDirectionParam.setValue(Double.valueOf(value));
        }
    }

    public void setAll(String name, double gridSpacing, ArrayList lats, ArrayList lons, ArrayList dips, ArrayList depths, String faultType) {
        this.parameterList.getParameter(FAULT_NAME).setValue(name);
        this.setAll(gridSpacing, lats, lons, dips, depths, faultType);
    }

    public void setAll(double gridSpacing, ArrayList lats, ArrayList lons, ArrayList dips, ArrayList depths, String faultType) {
        int i;
        int numFltPts = lats.size();
        int numDips = dips.size();
        if (lats.size() != lons.size()) {
            throw new RuntimeException("SimpleFaultParameter.setAll(): lats and lons Vectors must be the same size");
        }
        if (dips.size() != depths.size() - 1) {
            throw new RuntimeException("SimpleFaultParameter.setAll(): size of dips ArrayList must one less than the depths ArrayList");
        }
        if (dips.size() > 1 && faultType.equals(FRANKEL)) {
            throw new RuntimeException("SimpleFaultParameter.setAll(): Frankel's fault type can't be used if dips.size() > 1");
        }
        this.prevLats = lats;
        this.prevLons = lons;
        this.prevDepths = depths;
        this.prevDips = dips;
        this.parameterList.getParameter(GRID_SPACING).setValue(gridSpacing);
        this.parameterList.getParameter(NUMBER_OF_FAULT_TRACE).setValue(numFltPts);
        this.numDipParam.setValue(numDips);
        this.initLatLonParamList();
        this.initDipParamList();
        this.initDepthParamList();
        for (i = 0; i < numFltPts; ++i) {
            this.parameterListParameterForLats.getParameter().getParameter(LAT_PARAM_NAME + (i + 1)).setValue(lats.get(i));
            this.parameterListParameterForLons.getParameter().getParameter(LON_PARAM_NAME + (i + 1)).setValue(lons.get(i));
        }
        for (i = 0; i < numDips; ++i) {
            this.parameterListParameterForDips.getParameter().getParameter(DIP_PARAM_NAME + (i + 1)).setValue(dips.get(i));
        }
        for (i = 0; i < numDips + 1; ++i) {
            this.parameterListParameterForDepths.getParameter().getParameter(DEPTH_PARAM_NAME + (i + 1)).setValue(depths.get(i));
        }
        this.faultTypeParam.setValue(faultType);
    }

    public ArrayList getLatParamVals() {
        return this.prevLats;
    }

    public ArrayList getLonParamVals() {
        return this.prevLons;
    }

    public ArrayList getDipParamVals() {
        return this.prevDips;
    }

    public ArrayList getDepthParamVals() {
        return this.prevDepths;
    }

    @Override
    public String getMetadataString() {
        return this.getDependentParamMetadataString();
    }

    @Override
    public String getType() {
        String type = C;
        return type;
    }

    @Override
    public boolean setIndividualParamValueFromXML(Element el) {
        return false;
    }

    @Override
    public AbstractParameterEditorOld getEditor() {
        if (this.paramEdit == null) {
            this.paramEdit = new SimpleFaultParameterEditor(this);
        }
        return this.paramEdit;
    }

    @Override
    public boolean isEditorBuilt() {
        return this.paramEdit != null;
    }
}

