/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.param.editor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ListIterator;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import org.opensha.commons.exceptions.ConstraintException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.constraint.ParameterConstraint;
import org.opensha.commons.param.constraint.impl.StringConstraint;
import org.opensha.commons.param.editor.AbstractParameterEditorOld;
import org.opensha.commons.param.editor.impl.EvenlyDiscretizedFuncParameterEditor;
import org.opensha.commons.param.editor.impl.ParameterListEditor;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeFailEvent;
import org.opensha.commons.param.event.ParameterChangeFailListener;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.sha.magdist.ArbIncrementalMagFreqDist;
import org.opensha.sha.magdist.GaussianMagFreqDist;
import org.opensha.sha.magdist.GutenbergRichterMagFreqDist;
import org.opensha.sha.magdist.SingleMagFreqDist;
import org.opensha.sha.magdist.SummedMagFreqDist;
import org.opensha.sha.magdist.TaperedGR_MagFreqDist;
import org.opensha.sha.magdist.YC_1985_CharMagFreqDist;
import org.opensha.sha.magdist.gui.MagFreqDistAppWindow;
import org.opensha.sha.param.MagFreqDistParameter;
import org.opensha.sha.param.editor.MagDistParameterEditorAPI;

public class MagFreqDistParameterEditor
extends AbstractParameterEditorOld
implements ParameterChangeListener,
ParameterChangeFailListener,
ActionListener,
MagDistParameterEditorAPI {
    protected static final String C = "MagFreqDistParameterEditor";
    protected static final boolean D = false;
    private MagFreqDistParameter magDistParam;
    private boolean magDistParamsChange = true;
    private String name;
    private ParameterList parameterList;
    private MagFreqDistAppWindow magDistPanel;
    private ParameterListEditor editor;
    public static final String MAG_DIST_TITLE = new String("Mag Dist Params");
    protected JComboBox magDistPlotListSelector;
    private StringConstraint sdFixOptions;
    private StringConstraint grSetAllButOptions;
    private StringConstraint grFixOptions;
    private StringConstraint ycSetAllButOptions;
    private StringConstraint gdSetAllButOptions;
    private StringConstraint tap_grSetAllButOptions;

    public MagFreqDistParameterEditor() {
    }

    public MagFreqDistParameterEditor(Parameter model) {
        super(model);
        this.setParameter(model);
    }

    @Override
    public void setParameter(Parameter param) {
        String S = "MagFreqDistParameterEditor: Constructor(): ";
        this.setParameterInEditor(param);
        this.valueEditor = new JButton("Set " + param.getName());
        ((JButton)this.valueEditor).addActionListener(this);
        this.add((Component)this.valueEditor, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.magDistParam = (MagFreqDistParameter)param;
        this.createMagFreqDistParameterEditor();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        this.magDistParamsChange = true;
        this.magDistParam.setSummedDistPlotted(false);
        this.magDistPanel = new MagFreqDistAppWindow();
        this.magDistPanel.setMagDistEditor(this);
        this.magDistPanel.setVisible(true);
    }

    @Override
    public void setMagFreqDistParamButtonVisible(boolean visible) {
        this.valueEditor.setVisible(visible);
    }

    @Override
    public ParameterListEditor createMagFreqDistParameterEditor() {
        this.initParamListAndEditor();
        this.editor = new ParameterListEditor(this.parameterList);
        this.editor.setTitle(MAG_DIST_TITLE);
        this.synchRequiredVisibleParameters();
        return this.editor;
    }

    @Override
    public ParameterListEditor getMagFreqDistParameterEditor() {
        return this.editor;
    }

    @Override
    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
    }

    @Override
    public void refreshParamEditor() {
        this.editor.refreshParamEditor();
    }

    protected void initParamListAndEditor() {
        String S = "MagFreqDistParameterEditor: initControlsParamListAndEditor(): ";
        this.parameterList = (ParameterList)this.magDistParam.getAdjustableParams().clone();
        ListIterator<Parameter<?>> it = this.parameterList.getParametersIterator();
        while (it.hasNext()) {
            Parameter<?> param = it.next();
            param.addParameterChangeFailListener(this);
            param.addParameterChangeListener(this);
        }
        this.sdFixOptions = this.magDistParam.getSingleDistFixOptions();
        this.grSetAllButOptions = this.magDistParam.getGRSetAllButOptions();
        this.grFixOptions = this.magDistParam.getGRFixOptions();
        this.ycSetAllButOptions = this.magDistParam.getYCSetAllButOptions();
        this.gdSetAllButOptions = this.magDistParam.getGaussianDistSetAllButOptions();
        this.tap_grSetAllButOptions = this.magDistParam.getTapGRSetAllButOptions();
    }

    protected void synchRequiredVisibleParameters() throws ParameterException {
        StringParameter param2;
        StringParameter param3;
        String S = "MagFreqDistParameterEditor:synchRequiredVisibleParameters:";
        String distributionName = this.parameterList.getParameter("Distribution Type").getValue().toString();
        StringParameter setAllButParam = (StringParameter)this.parameterList.getParameter(MagFreqDistParameter.SET_ALL_PARAMS_BUT);
        ListIterator<Parameter<?>> it = this.parameterList.getParametersIterator();
        while (it.hasNext()) {
            this.editor.setParameterVisible(it.next().getName(), false);
        }
        this.editor.setParameterVisible(MagFreqDistParameter.MIN, true);
        this.editor.setParameterVisible(MagFreqDistParameter.MAX, true);
        this.editor.setParameterVisible(MagFreqDistParameter.NUM, true);
        this.editor.setParameterVisible("Distribution Type", true);
        if (distributionName.equalsIgnoreCase(SingleMagFreqDist.NAME)) {
            param3 = new StringParameter(MagFreqDistParameter.FIX, this.sdFixOptions, this.sdFixOptions.getAllowedStrings().get(0));
            param3.addParameterChangeListener(this);
            param3.setInfo(MagFreqDistParameter.FIX_INFO);
            this.editor.replaceParameterForEditor(MagFreqDistParameter.FIX, param3);
            this.editor.getParameterEditor(" Arb. Incremental Mag Dist").setVisible(false);
            this.setSingleDistParamsVisible();
        }
        if (distributionName.equalsIgnoreCase(GutenbergRichterMagFreqDist.NAME)) {
            param2 = new StringParameter(setAllButParam.getName(), this.grSetAllButOptions, this.grSetAllButOptions.getAllowedStrings().get(0));
            param2.addParameterChangeListener(this);
            this.editor.replaceParameterForEditor(setAllButParam.getName(), param2);
            param3 = new StringParameter(MagFreqDistParameter.FIX, this.grFixOptions, this.grFixOptions.getAllowedStrings().get(0));
            param3.addParameterChangeListener(this);
            param3.setInfo(MagFreqDistParameter.FIX_INFO);
            this.editor.replaceParameterForEditor(MagFreqDistParameter.FIX, param3);
            this.editor.getParameterEditor(" Arb. Incremental Mag Dist").setVisible(false);
            this.setGR_DistParamsVisible();
        }
        if (distributionName.equalsIgnoreCase(TaperedGR_MagFreqDist.NAME)) {
            param2 = new StringParameter(setAllButParam.getName(), this.tap_grSetAllButOptions, this.tap_grSetAllButOptions.getAllowedStrings().get(0));
            param2.addParameterChangeListener(this);
            this.editor.replaceParameterForEditor(setAllButParam.getName(), param2);
            this.editor.getParameterEditor(" Arb. Incremental Mag Dist").setVisible(false);
            this.setTapGR_DistParamsVisible();
        }
        if (distributionName.equalsIgnoreCase(GaussianMagFreqDist.NAME)) {
            param2 = new StringParameter(setAllButParam.getName(), this.gdSetAllButOptions, this.gdSetAllButOptions.getAllowedStrings().get(0));
            param2.addParameterChangeListener(this);
            this.editor.replaceParameterForEditor(setAllButParam.getName(), param2);
            this.editor.getParameterEditor(" Arb. Incremental Mag Dist").setVisible(false);
            this.setGaussianDistParamsVisible();
        }
        if (distributionName.equalsIgnoreCase(YC_1985_CharMagFreqDist.NAME)) {
            param2 = new StringParameter(setAllButParam.getName(), this.ycSetAllButOptions, this.ycSetAllButOptions.getAllowedStrings().get(0));
            param2.addParameterChangeListener(this);
            this.editor.replaceParameterForEditor(setAllButParam.getName(), param2);
            this.editor.getParameterEditor(" Arb. Incremental Mag Dist").setVisible(false);
            this.setYC_DistParamsVisible();
        } else if (distributionName.equalsIgnoreCase(ArbIncrementalMagFreqDist.NAME)) {
            this.setArbIncrDistParamsVisible();
        }
        this.editor.validate();
        this.editor.repaint();
    }

    private void setSingleDistParamsVisible() {
        this.editor.setParameterVisible(MagFreqDistParameter.SINGLE_PARAMS_TO_SET, true);
        String paramToSet = this.parameterList.getParameter(MagFreqDistParameter.SINGLE_PARAMS_TO_SET).getValue().toString();
        if (paramToSet.equalsIgnoreCase(MagFreqDistParameter.RATE_AND_MAG)) {
            this.editor.setParameterVisible(MagFreqDistParameter.RATE, true);
            this.editor.setParameterVisible(MagFreqDistParameter.MAG, true);
            this.editor.setParameterVisible(MagFreqDistParameter.MO_RATE, false);
            this.editor.setParameterVisible(MagFreqDistParameter.FIX, false);
        }
        if (paramToSet.equalsIgnoreCase(MagFreqDistParameter.MAG_AND_MO_RATE)) {
            this.editor.setParameterVisible(MagFreqDistParameter.RATE, false);
            this.editor.setParameterVisible(MagFreqDistParameter.MAG, true);
            this.editor.setParameterVisible(MagFreqDistParameter.MO_RATE, true);
            this.editor.setParameterVisible(MagFreqDistParameter.FIX, false);
        }
        if (paramToSet.equalsIgnoreCase(MagFreqDistParameter.RATE_AND_MO_RATE)) {
            this.editor.setParameterVisible(MagFreqDistParameter.RATE, true);
            this.editor.setParameterVisible(MagFreqDistParameter.MAG, false);
            this.editor.setParameterVisible(MagFreqDistParameter.MO_RATE, true);
            this.editor.setParameterVisible(MagFreqDistParameter.FIX, true);
        }
    }

    private void setGaussianDistParamsVisible() {
        this.editor.setParameterVisible(MagFreqDistParameter.MEAN, true);
        this.editor.setParameterVisible(MagFreqDistParameter.STD_DEV, true);
        this.editor.setParameterVisible(MagFreqDistParameter.TRUNCATION_REQ, true);
        this.editor.setParameterVisible(MagFreqDistParameter.SET_ALL_PARAMS_BUT, true);
        StringParameter param = (StringParameter)this.parameterList.getParameter(MagFreqDistParameter.SET_ALL_PARAMS_BUT);
        String paramToSet = ((String)param.getValue()).toString();
        if (paramToSet.equalsIgnoreCase(MagFreqDistParameter.TOT_MO_RATE)) {
            this.editor.setParameterVisible(MagFreqDistParameter.TOT_CUM_RATE, true);
            this.editor.setParameterVisible(MagFreqDistParameter.TOT_MO_RATE, false);
        } else {
            this.editor.setParameterVisible(MagFreqDistParameter.TOT_CUM_RATE, false);
            this.editor.setParameterVisible(MagFreqDistParameter.TOT_MO_RATE, true);
        }
        String truncReq = this.parameterList.getParameter(MagFreqDistParameter.TRUNCATION_REQ).getValue().toString();
        if (truncReq.equalsIgnoreCase(MagFreqDistParameter.NONE)) {
            this.editor.setParameterVisible(MagFreqDistParameter.TRUNCATE_NUM_OF_STD_DEV, false);
        } else {
            this.editor.setParameterVisible(MagFreqDistParameter.TRUNCATE_NUM_OF_STD_DEV, true);
        }
    }

    private void setGR_DistParamsVisible() {
        this.editor.setParameterVisible(MagFreqDistParameter.SET_ALL_PARAMS_BUT, true);
        this.editor.setParameterVisible(MagFreqDistParameter.GR_MAG_LOWER, true);
        StringParameter param = (StringParameter)this.parameterList.getParameter(MagFreqDistParameter.SET_ALL_PARAMS_BUT);
        String paramToSet = ((String)param.getValue()).toString();
        if (paramToSet.equalsIgnoreCase(MagFreqDistParameter.TOT_MO_RATE)) {
            this.editor.setParameterVisible(MagFreqDistParameter.GR_BVALUE, true);
            this.editor.setParameterVisible(MagFreqDistParameter.TOT_CUM_RATE, true);
            this.editor.setParameterVisible(MagFreqDistParameter.GR_MAG_UPPER, true);
            this.editor.setParameterVisible(MagFreqDistParameter.TOT_MO_RATE, false);
            this.editor.setParameterVisible(MagFreqDistParameter.FIX, false);
        }
        if (paramToSet.equalsIgnoreCase(MagFreqDistParameter.TOT_CUM_RATE)) {
            this.editor.setParameterVisible(MagFreqDistParameter.GR_BVALUE, true);
            this.editor.setParameterVisible(MagFreqDistParameter.GR_MAG_UPPER, true);
            this.editor.setParameterVisible(MagFreqDistParameter.TOT_MO_RATE, true);
            this.editor.setParameterVisible(MagFreqDistParameter.TOT_CUM_RATE, false);
            this.editor.setParameterVisible(MagFreqDistParameter.FIX, false);
        }
        if (paramToSet.equalsIgnoreCase(MagFreqDistParameter.GR_MAG_UPPER)) {
            this.editor.setParameterVisible(MagFreqDistParameter.GR_BVALUE, true);
            this.editor.setParameterVisible(MagFreqDistParameter.TOT_CUM_RATE, true);
            this.editor.setParameterVisible(MagFreqDistParameter.TOT_MO_RATE, true);
            this.editor.setParameterVisible(MagFreqDistParameter.FIX, true);
            this.editor.setParameterVisible(MagFreqDistParameter.GR_MAG_UPPER, false);
        }
        if (paramToSet.equalsIgnoreCase(MagFreqDistParameter.GR_BVALUE)) {
            this.editor.setParameterVisible(MagFreqDistParameter.GR_BVALUE, false);
            this.editor.setParameterVisible(MagFreqDistParameter.GR_MAG_UPPER, true);
            this.editor.setParameterVisible(MagFreqDistParameter.TOT_MO_RATE, true);
            this.editor.setParameterVisible(MagFreqDistParameter.TOT_CUM_RATE, true);
            this.editor.setParameterVisible(MagFreqDistParameter.FIX, false);
        }
    }

    private void setTapGR_DistParamsVisible() {
        this.editor.setParameterVisible(MagFreqDistParameter.SET_ALL_PARAMS_BUT, true);
        this.editor.setParameterVisible(MagFreqDistParameter.GR_MAG_LOWER, true);
        this.editor.setParameterVisible(MagFreqDistParameter.GR_BVALUE, true);
        this.editor.setParameterVisible(MagFreqDistParameter.FIX, false);
        StringParameter param = (StringParameter)this.parameterList.getParameter(MagFreqDistParameter.SET_ALL_PARAMS_BUT);
        String paramToSet = ((String)param.getValue()).toString();
        if (paramToSet.equalsIgnoreCase(MagFreqDistParameter.TOT_MO_RATE)) {
            this.editor.setParameterVisible(MagFreqDistParameter.TOT_CUM_RATE, true);
            this.editor.setParameterVisible(MagFreqDistParameter.TAPERED_GR_CORNER_MAG, true);
            this.editor.setParameterVisible(MagFreqDistParameter.TOT_MO_RATE, false);
        }
        if (paramToSet.equalsIgnoreCase(MagFreqDistParameter.TOT_CUM_RATE)) {
            this.editor.setParameterVisible(MagFreqDistParameter.TAPERED_GR_CORNER_MAG, true);
            this.editor.setParameterVisible(MagFreqDistParameter.TOT_MO_RATE, true);
            this.editor.setParameterVisible(MagFreqDistParameter.TOT_CUM_RATE, false);
        }
        if (paramToSet.equalsIgnoreCase(MagFreqDistParameter.TAPERED_GR_CORNER_MAG)) {
            this.editor.setParameterVisible(MagFreqDistParameter.TOT_CUM_RATE, true);
            this.editor.setParameterVisible(MagFreqDistParameter.TOT_MO_RATE, true);
            this.editor.setParameterVisible(MagFreqDistParameter.TAPERED_GR_CORNER_MAG, false);
        }
    }

    private void setYC_DistParamsVisible() {
        this.editor.setParameterVisible(MagFreqDistParameter.GR_MAG_LOWER, true);
        this.editor.setParameterVisible(MagFreqDistParameter.GR_MAG_UPPER, true);
        this.editor.setParameterVisible(MagFreqDistParameter.YC_DELTA_MAG_CHAR, true);
        this.editor.setParameterVisible(MagFreqDistParameter.YC_MAG_PRIME, true);
        this.editor.setParameterVisible(MagFreqDistParameter.YC_DELTA_MAG_PRIME, true);
        this.editor.setParameterVisible(MagFreqDistParameter.GR_BVALUE, true);
        this.editor.setParameterVisible(MagFreqDistParameter.SET_ALL_PARAMS_BUT, true);
        StringParameter param = (StringParameter)this.parameterList.getParameter(MagFreqDistParameter.SET_ALL_PARAMS_BUT);
        String paramToSet = ((String)param.getValue()).toString();
        if (paramToSet.equalsIgnoreCase(MagFreqDistParameter.TOT_MO_RATE)) {
            this.editor.setParameterVisible(MagFreqDistParameter.YC_TOT_CHAR_RATE, true);
            this.editor.setParameterVisible(MagFreqDistParameter.TOT_MO_RATE, false);
        } else {
            this.editor.setParameterVisible(MagFreqDistParameter.YC_TOT_CHAR_RATE, false);
            this.editor.setParameterVisible(MagFreqDistParameter.TOT_MO_RATE, true);
        }
    }

    private void setArbIncrDistParamsVisible() {
        this.editor.getParameterEditor(MagFreqDistParameter.MIN).setVisible(false);
        this.editor.getParameterEditor(MagFreqDistParameter.MAX).setVisible(false);
        this.editor.getParameterEditor(MagFreqDistParameter.NUM).setVisible(false);
        this.editor.getParameterEditor(" Arb. Incremental Mag Dist").setVisible(true);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        String S = "MagFreqDistParameterEditor: parameterChange(): ";
        String name1 = event.getParameterName();
        if (name1.equalsIgnoreCase("Distribution Type")) {
            try {
                this.synchRequiredVisibleParameters();
            }
            catch (Exception e) {
                System.out.println(C + " " + e.toString());
                e.printStackTrace();
            }
        } else {
            String distributionName = this.parameterList.getParameter("Distribution Type").getValue().toString();
            if (distributionName.equalsIgnoreCase(SingleMagFreqDist.NAME)) {
                this.setSingleDistParamsVisible();
            }
            if (distributionName.equalsIgnoreCase(GutenbergRichterMagFreqDist.NAME)) {
                this.setGR_DistParamsVisible();
            }
            if (distributionName.equalsIgnoreCase(TaperedGR_MagFreqDist.NAME)) {
                this.setTapGR_DistParamsVisible();
            }
            if (distributionName.equalsIgnoreCase(GaussianMagFreqDist.NAME)) {
                this.setGaussianDistParamsVisible();
            }
            if (distributionName.equalsIgnoreCase(YC_1985_CharMagFreqDist.NAME)) {
                this.setYC_DistParamsVisible();
            }
        }
        this.magDistParamsChange = true;
    }

    @Override
    public void setMagDistFromParams() throws ConstraintException {
        String S = "MagFreqDistParameterEditor: setMagDistFromParams():";
        if (this.magDistParamsChange) {
            this.magDistParam.setMagDist(this.parameterList);
            this.magDistParamsChange = false;
        }
    }

    @Override
    public void setMagDistFromParams(SummedMagFreqDist summedDist, String metadata) throws ConstraintException {
        this.magDistParam.setMagDistAsSummedMagDist(summedDist, metadata);
    }

    @Override
    public void setSummedDistPlotted(boolean sumDistPlotted) {
        this.magDistParam.setSummedDistPlotted(sumDistPlotted);
    }

    @Override
    public void parameterChangeFailed(ParameterChangeFailEvent e) {
        String S = "MagFreqDistParameterEditor : parameterChangeWarning(): ";
        StringBuffer b = new StringBuffer();
        Parameter param = (Parameter)e.getSource();
        ParameterConstraint constraint = param.getConstraint();
        String oldValueStr = e.getOldValue().toString();
        String badValueStr = e.getBadValue().toString();
        String name = param.getName();
        b.append("The value ");
        b.append(badValueStr);
        b.append(" is not permitted for '");
        b.append(name);
        b.append("'.\n");
        b.append("Resetting to ");
        b.append(oldValueStr);
        b.append(". The constraints are: \n");
        b.append(constraint.toString());
        b.append("\n");
        JOptionPane.showMessageDialog(this, b.toString(), "Cannot Change Value", 1);
    }

    @Override
    public String getMagDistName() {
        return this.parameterList.getParameter("Distribution Type").getValue().toString();
    }

    @Override
    public double getMin() {
        String distributionName = this.parameterList.getParameter("Distribution Type").getValue().toString();
        if (distributionName.equalsIgnoreCase(ArbIncrementalMagFreqDist.NAME)) {
            return ((EvenlyDiscretizedFuncParameterEditor)this.editor.getParameterEditor(" Arb. Incremental Mag Dist")).getMin();
        }
        return (Double)this.parameterList.getParameter(MagFreqDistParameter.MIN).getValue();
    }

    @Override
    public double getMax() {
        String distributionName = this.parameterList.getParameter("Distribution Type").getValue().toString();
        if (distributionName.equalsIgnoreCase(ArbIncrementalMagFreqDist.NAME)) {
            return ((EvenlyDiscretizedFuncParameterEditor)this.editor.getParameterEditor(" Arb. Incremental Mag Dist")).getMax();
        }
        return (Double)this.parameterList.getParameter(MagFreqDistParameter.MAX).getValue();
    }

    @Override
    public int getNum() {
        String distributionName = this.parameterList.getParameter("Distribution Type").getValue().toString();
        if (distributionName.equalsIgnoreCase(ArbIncrementalMagFreqDist.NAME)) {
            return ((EvenlyDiscretizedFuncParameterEditor)this.editor.getParameterEditor(" Arb. Incremental Mag Dist")).getNum();
        }
        return (Integer)this.parameterList.getParameter(MagFreqDistParameter.NUM).getValue();
    }

    @Override
    public ParameterList getParamterList() {
        return this.parameterList;
    }

    @Override
    public Parameter getParameter(String name) throws ParameterException {
        return this.parameterList.getParameter(name);
    }

    @Override
    public ParameterList getParameterList() {
        return this.parameterList;
    }
}

