/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.param.editor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ListIterator;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import org.opensha.commons.exceptions.ConstraintException;
import org.opensha.commons.exceptions.ParameterException;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.constraint.ParameterConstraint;
import org.opensha.commons.param.editor.AbstractParameterEditorOld;
import org.opensha.commons.param.editor.impl.ParameterListEditor;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeFailEvent;
import org.opensha.commons.param.event.ParameterChangeFailListener;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.sha.magdist.ArbIncrementalMagFreqDist;
import org.opensha.sha.magdist.GaussianMagFreqDist;
import org.opensha.sha.magdist.GutenbergRichterMagFreqDist;
import org.opensha.sha.magdist.SingleMagFreqDist;
import org.opensha.sha.magdist.SummedMagFreqDist;
import org.opensha.sha.magdist.YC_1985_CharMagFreqDist;
import org.opensha.sha.magdist.gui.MagFreqDistAppWindow;
import org.opensha.sha.param.MagFreqDistParameter;
import org.opensha.sha.param.MagPDF_Parameter;
import org.opensha.sha.param.editor.MagDistParameterEditorAPI;

public class MagPDF_ParameterEditor
extends AbstractParameterEditorOld
implements ParameterChangeListener,
ParameterChangeFailListener,
ActionListener,
MagDistParameterEditorAPI {
    protected static final String C = "MagPDF_ParameterEditor";
    protected static final boolean D = false;
    private MagPDF_Parameter magPDF_Param;
    private boolean magPDF_ParamsChange = true;
    private String name;
    private ParameterList parameterList;
    private ParameterListEditor editor;
    public static final String MAG_DIST_TITLE = new String("Mag PDF Params");
    private MagFreqDistAppWindow magDistPanel;

    public MagPDF_ParameterEditor() {
    }

    public MagPDF_ParameterEditor(Parameter model) {
        super(model);
        this.setParameter(model);
    }

    @Override
    public void setParameter(Parameter param) {
        String S = "MagPDF_ParameterEditor: Constructor(): ";
        this.setParameterInEditor(param);
        this.valueEditor = new JButton("Set " + param.getName());
        ((JButton)this.valueEditor).addActionListener(this);
        this.add((Component)this.valueEditor, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.magPDF_Param = (MagPDF_Parameter)param;
        this.createMagFreqDistParameterEditor();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        this.magDistPanel = new MagFreqDistAppWindow();
        this.magDistPanel.setMagDistEditor(this);
        this.magDistPanel.setVisible(true);
    }

    @Override
    public void setMagFreqDistParamButtonVisible(boolean visible) {
        this.valueEditor.setVisible(visible);
    }

    @Override
    public ParameterListEditor createMagFreqDistParameterEditor() {
        this.initParamList();
        this.editor = new ParameterListEditor(this.parameterList);
        this.editor.setTitle(MAG_DIST_TITLE);
        this.synchRequiredVisibleParameters();
        return this.editor;
    }

    @Override
    public ParameterListEditor getMagFreqDistParameterEditor() {
        return this.editor;
    }

    @Override
    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
    }

    @Override
    public void refreshParamEditor() {
        this.editor.refreshParamEditor();
    }

    protected void initParamList() {
        String S = "MagPDF_ParameterEditor: initControlsParamListAndEditor(): ";
        this.parameterList = (ParameterList)this.magPDF_Param.getAdjustableParams().clone();
        ListIterator<Parameter<?>> it = this.parameterList.getParametersIterator();
        while (it.hasNext()) {
            Parameter<?> param = it.next();
            param.addParameterChangeFailListener(this);
            param.addParameterChangeListener(this);
        }
    }

    protected void synchRequiredVisibleParameters() throws ParameterException {
        String S = "MagPDF_ParameterEditor:synchRequiredVisibleParameters:";
        String distributionName = this.parameterList.getParameter("Distribution Type").getValue().toString();
        ListIterator<Parameter<?>> it = this.parameterList.getParametersIterator();
        while (it.hasNext()) {
            this.editor.setParameterVisible(it.next().getName(), false);
        }
        this.editor.setParameterVisible(MagFreqDistParameter.MIN, true);
        this.editor.setParameterVisible(MagFreqDistParameter.MAX, true);
        this.editor.setParameterVisible(MagFreqDistParameter.NUM, true);
        this.editor.setParameterVisible("Distribution Type", true);
        if (distributionName.equalsIgnoreCase(SingleMagFreqDist.NAME)) {
            this.editor.getParameterEditor(" Arb. Incremental Mag Dist").setVisible(false);
            this.setSingleDistParamsVisible();
        }
        if (distributionName.equalsIgnoreCase(GutenbergRichterMagFreqDist.NAME)) {
            this.editor.getParameterEditor(" Arb. Incremental Mag Dist").setVisible(false);
            this.setGR_DistParamsVisible();
        }
        if (distributionName.equalsIgnoreCase(GaussianMagFreqDist.NAME)) {
            this.editor.getParameterEditor(" Arb. Incremental Mag Dist").setVisible(false);
            this.setGaussianDistParamsVisible();
        }
        if (distributionName.equalsIgnoreCase(YC_1985_CharMagFreqDist.NAME)) {
            this.editor.getParameterEditor(" Arb. Incremental Mag Dist").setVisible(false);
            this.setYC_DistParamsVisible();
        } else if (distributionName.equalsIgnoreCase(ArbIncrementalMagFreqDist.NAME)) {
            this.setArbIncrDistParamsVisible();
        }
        this.editor.validate();
        this.editor.repaint();
    }

    private void setSingleDistParamsVisible() {
        this.editor.setParameterVisible(MagFreqDistParameter.MAG, true);
    }

    private void setGaussianDistParamsVisible() {
        this.editor.setParameterVisible(MagFreqDistParameter.MEAN, true);
        this.editor.setParameterVisible(MagFreqDistParameter.STD_DEV, true);
        this.editor.setParameterVisible(MagFreqDistParameter.TRUNCATION_REQ, true);
        String truncReq = this.parameterList.getParameter(MagFreqDistParameter.TRUNCATION_REQ).getValue().toString();
        if (truncReq.equalsIgnoreCase(MagFreqDistParameter.NONE)) {
            this.editor.setParameterVisible(MagFreqDistParameter.TRUNCATE_NUM_OF_STD_DEV, false);
        } else {
            this.editor.setParameterVisible(MagFreqDistParameter.TRUNCATE_NUM_OF_STD_DEV, true);
        }
    }

    private void setGR_DistParamsVisible() {
        this.editor.setParameterVisible(MagFreqDistParameter.GR_MAG_LOWER, true);
        this.editor.setParameterVisible(MagFreqDistParameter.GR_BVALUE, true);
        this.editor.setParameterVisible(MagFreqDistParameter.GR_MAG_UPPER, true);
    }

    private void setYC_DistParamsVisible() {
        this.editor.setParameterVisible(MagFreqDistParameter.GR_MAG_LOWER, true);
        this.editor.setParameterVisible(MagFreqDistParameter.GR_MAG_UPPER, true);
        this.editor.setParameterVisible(MagFreqDistParameter.YC_DELTA_MAG_CHAR, true);
        this.editor.setParameterVisible(MagFreqDistParameter.YC_MAG_PRIME, true);
        this.editor.setParameterVisible(MagFreqDistParameter.YC_DELTA_MAG_PRIME, true);
        this.editor.setParameterVisible(MagFreqDistParameter.GR_BVALUE, true);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        String S = "MagPDF_ParameterEditor: parameterChange(): ";
        String name1 = event.getParameterName();
        if (name1.equalsIgnoreCase("Distribution Type")) {
            try {
                this.synchRequiredVisibleParameters();
            }
            catch (Exception e) {
                System.out.println(C + " " + e.toString());
                e.printStackTrace();
            }
        }
        this.magPDF_ParamsChange = true;
    }

    private void setArbIncrDistParamsVisible() {
        this.editor.getParameterEditor(MagFreqDistParameter.MIN).setVisible(false);
        this.editor.getParameterEditor(MagFreqDistParameter.MAX).setVisible(false);
        this.editor.getParameterEditor(MagFreqDistParameter.NUM).setVisible(false);
        this.editor.getParameterEditor(" Arb. Incremental Mag Dist").setVisible(true);
    }

    @Override
    public void setMagDistFromParams() throws ConstraintException {
        String S = "MagPDF_ParameterEditor: setMagDistFromParams():";
        if (this.magPDF_ParamsChange) {
            this.magPDF_Param.setMagDist(this.parameterList);
            this.magPDF_ParamsChange = false;
        }
    }

    @Override
    public void setMagDistFromParams(SummedMagFreqDist summedDist, String metadata) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("setMagDistFromParams  not implemented for MagPDF_Parameter");
    }

    @Override
    public void setSummedDistPlotted(boolean sumDistPlotted) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("setMagDistFromParams  not implemented for MagPDF_Parameter");
    }

    @Override
    public void parameterChangeFailed(ParameterChangeFailEvent e) {
        String S = "MagPDF_ParameterEditor : parameterChangeWarning(): ";
        StringBuffer b = new StringBuffer();
        Parameter param = (Parameter)e.getSource();
        ParameterConstraint constraint = param.getConstraint();
        String oldValueStr = e.getOldValue().toString();
        String badValueStr = e.getBadValue().toString();
        String name = param.getName();
        b.append("The value ");
        b.append(badValueStr);
        b.append(" is not permitted for '");
        b.append(name);
        b.append("'.\n");
        b.append("Resetting to ");
        b.append(oldValueStr);
        b.append(". The constraints are: \n");
        b.append(constraint.toString());
        b.append("\n");
        JOptionPane.showMessageDialog(this, b.toString(), "Cannot Change Value", 1);
    }

    @Override
    public String getMagDistName() {
        return this.parameterList.getParameter("Distribution Type").getValue().toString();
    }

    @Override
    public double getMin() {
        return (Double)this.parameterList.getParameter(MagFreqDistParameter.MIN).getValue();
    }

    @Override
    public double getMax() {
        return (Double)this.parameterList.getParameter(MagFreqDistParameter.MAX).getValue();
    }

    @Override
    public int getNum() {
        return (Integer)this.parameterList.getParameter(MagFreqDistParameter.NUM).getValue();
    }

    @Override
    public ParameterList getParamterList() {
        return this.parameterList;
    }

    @Override
    public Parameter getParameter(String name) throws ParameterException {
        return this.parameterList.getParameter(name);
    }

    @Override
    public ParameterList getParameterList() {
        return this.parameterList;
    }
}

