/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.param.editor.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.ListIterator;
import javax.swing.JOptionPane;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.constraint.ParameterConstraint;
import org.opensha.commons.param.editor.AbstractParameterEditorOld;
import org.opensha.commons.param.editor.ParameterEditor;
import org.opensha.commons.param.editor.impl.ConstrainedStringParameterEditor;
import org.opensha.commons.param.editor.impl.IntegerParameterEditor;
import org.opensha.commons.param.editor.impl.ParameterListEditor;
import org.opensha.commons.param.editor.impl.ParameterListParameterEditor;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeFailEvent;
import org.opensha.commons.param.event.ParameterChangeFailListener;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.commons.param.impl.IntegerParameter;
import org.opensha.commons.param.impl.ParameterListParameter;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.sha.param.SimpleFaultParameter;

public class SimpleFaultParameterEditorPanel
extends AbstractParameterEditorOld
implements ParameterChangeListener,
ParameterChangeFailListener,
ActionListener {
    protected static final String C = "SimpleFaultParameterEditorPanel";
    protected static final boolean D = false;
    private Insets defaultInsets = new Insets(4, 4, 4, 4);
    public static final String SIMPLE_FAULT_EDITOR_TITLE = new String("Simple Fault Editor");
    boolean showFaultName = false;
    boolean evenlyGriddedParamChange = true;
    private SimpleFaultParameter surfaceParam;
    private ParameterListEditor editor;
    private ParameterListParameterEditor editorForLats;
    private ParameterListParameterEditor editorForLons;
    private ParameterListParameterEditor editorForDips;
    private ParameterListParameterEditor editorForDepths;
    private IntegerParameterEditor numDipsEditor;
    private ConstrainedStringParameterEditor faultTypeEditor;
    private ParameterEditor<Double> dipDirectionParamEditor;

    public SimpleFaultParameterEditorPanel() {
    }

    public SimpleFaultParameterEditorPanel(Parameter model) {
        super(model);
    }

    @Override
    public void setParameter(Parameter param) {
        String S = "SimpleFaultParameterEditorPanel: Constructor(): ";
        this.setParameterInEditor(param);
        this.removeAll();
        this.surfaceParam = (SimpleFaultParameter)param;
        this.initParamListAndEditor();
        if (!this.showFaultName) {
            this.editor.getParameterEditor("Fault Name").setVisible(false);
        }
        if (this.faultTypeEditor.isVisible()) {
            if (((String)this.faultTypeEditor.getParameter().getValue()).equals("Stirling's")) {
                this.dipDirectionParamEditor.setVisible(true);
            } else {
                this.dipDirectionParamEditor.setVisible(false);
            }
        }
        this.add((Component)this.editor, new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.editorForLats, new GridBagConstraints(0, 1, 0, 1, 1.0, 0.0, 17, 17, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.editorForLons, new GridBagConstraints(0, 1, 0, 1, 1.0, 0.0, 13, 13, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.numDipsEditor, new GridBagConstraints(0, 2, 0, 1, 1.0, 0.0, 11, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.editorForDips, new GridBagConstraints(0, 3, 0, 1, 1.0, 0.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.editorForDepths, new GridBagConstraints(0, 4, 0, 1, 1.0, 0.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.faultTypeEditor, new GridBagConstraints(0, 5, 0, 1, 1.0, 0.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        if (this.dipDirectionParamEditor.isVisible()) {
            this.add((Component)this.dipDirectionParamEditor.getComponent(), new GridBagConstraints(0, 6, 0, 1, 1.0, 0.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
    }

    @Override
    public void refreshParamEditor() {
        this.editor.refreshParamEditor();
        this.editorForLats.refreshParamEditor();
        this.editorForLons.refreshParamEditor();
        this.numDipsEditor.refreshParamEditor();
        this.editorForDips.refreshParamEditor();
        this.editorForDepths.refreshParamEditor();
        this.faultTypeEditor.refreshParamEditor();
        if (this.dipDirectionParamEditor.isVisible()) {
            this.dipDirectionParamEditor.refreshParamEditor();
        }
    }

    private void initParamListAndEditor() {
        ParameterList paramList = this.surfaceParam.getFaultTraceParamList();
        ListIterator<Parameter<?>> it = paramList.getParametersIterator();
        while (it.hasNext()) {
            it.next().addParameterChangeListener(this);
        }
        this.editor = new ParameterListEditor(paramList);
        this.editor.setTitle(SIMPLE_FAULT_EDITOR_TITLE);
        this.setLatLon();
        IntegerParameter dipParam = (IntegerParameter)this.surfaceParam.getNumDipParam();
        dipParam.addParameterChangeListener(this);
        try {
            this.numDipsEditor = new IntegerParameterEditor((Parameter)dipParam);
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        this.setDips();
        this.setDepths();
        StringParameter faultTypeParam = (StringParameter)this.surfaceParam.getFaultTypeParam();
        faultTypeParam.addParameterChangeListener(this);
        DoubleParameter dipDirectionParam = (DoubleParameter)this.surfaceParam.getDipDirectionParam();
        dipDirectionParam.addParameterChangeFailListener(this);
        dipDirectionParam.addParameterChangeListener(this);
        try {
            this.faultTypeEditor = new ConstrainedStringParameterEditor(faultTypeParam);
            this.dipDirectionParamEditor = dipDirectionParam.getEditor();
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    private void setLatLon() {
        this.surfaceParam.initLatLonParamList();
        ParameterListParameter latParam = (ParameterListParameter)this.surfaceParam.getLatParam();
        ListIterator it = latParam.getParametersIterator();
        while (it.hasNext()) {
            ((Parameter)it.next()).addParameterChangeListener(this);
        }
        this.editorForLats = new ParameterListParameterEditor(latParam);
        ParameterListParameter lonParam = (ParameterListParameter)this.surfaceParam.getLonParam();
        it = lonParam.getParametersIterator();
        while (it.hasNext()) {
            ((Parameter)it.next()).addParameterChangeListener(this);
        }
        this.editorForLons = new ParameterListParameterEditor(lonParam);
        this.editorForLats.validate();
        this.editorForLats.repaint();
        this.editorForLons.validate();
        this.editorForLons.repaint();
    }

    public void setAll(String name, double gridSpacing, ArrayList lats, ArrayList lons, ArrayList dips, ArrayList depths, String faultType) {
        this.surfaceParam.setAll(name, gridSpacing, lats, lons, dips, depths, faultType);
        this.refreshParamEditor();
    }

    public void setAll(double gridSpacing, ArrayList lats, ArrayList lons, ArrayList dips, ArrayList depths, String faultType) {
        this.surfaceParam.setAll(gridSpacing, lats, lons, dips, depths, faultType);
        this.refreshParamEditor();
    }

    private void setDips() {
        this.surfaceParam.initDipParamList();
        ParameterListParameter parameterListParameterForDips = (ParameterListParameter)this.surfaceParam.getDipParam();
        ListIterator it = parameterListParameterForDips.getParametersIterator();
        while (it.hasNext()) {
            ((Parameter)it.next()).addParameterChangeListener(this);
        }
        this.editorForDips = new ParameterListParameterEditor(parameterListParameterForDips);
        this.editorForDips.validate();
        this.editorForDips.revalidate();
        this.editorForDips.repaint();
    }

    private void setDepths() {
        this.surfaceParam.initDepthParamList();
        ParameterListParameter parameterListParameterForDepths = (ParameterListParameter)this.surfaceParam.getDepthParam();
        ListIterator it = parameterListParameterForDepths.getParametersIterator();
        while (it.hasNext()) {
            ((Parameter)it.next()).addParameterChangeListener(this);
        }
        this.editorForDepths = new ParameterListParameterEditor(parameterListParameterForDepths);
        this.editorForDepths.validate();
        this.editorForDepths.revalidate();
        this.editorForDepths.repaint();
    }

    public void setDipDirection(double value) {
        if (this.faultTypeEditor.isVisible()) {
            this.surfaceParam.setDipDirection(value);
        }
        this.refreshParamEditor();
    }

    @Override
    protected void jbInit() throws Exception {
        this.setLayout(new GridBagLayout());
    }

    public void setFaultNameVisible(boolean flag) {
        this.showFaultName = flag;
        this.editor.getParameterEditor("Fault Name").setVisible(flag);
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        String S = "SimpleFaultParameterEditorPanel: parameterChange(): ";
        String name1 = event.getParameterName();
        if (name1.equalsIgnoreCase("Num. of Fault Trace Points")) {
            this.remove(this.editorForLats);
            this.remove(this.editorForLons);
            this.setLatLon();
            this.add((Component)this.editorForLats, new GridBagConstraints(0, 1, 0, 1, 1.0, 0.0, 17, 17, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.editorForLons, new GridBagConstraints(0, 1, 0, 1, 1.0, 0.0, 13, 13, new Insets(0, 0, 0, 0), 0, 0));
        }
        if (name1.equalsIgnoreCase("Num. of Dips")) {
            this.remove(this.editorForDips);
            this.remove(this.editorForDepths);
            this.setDips();
            this.setDepths();
            this.add((Component)this.editorForDips, new GridBagConstraints(0, 3, 0, 1, 1.0, 0.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.editorForDepths, new GridBagConstraints(0, 4, 0, 1, 1.0, 0.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
            if ((Integer)this.numDipsEditor.getParameter().getValue() != 1) {
                this.faultTypeEditor.setVisible(false);
                this.dipDirectionParamEditor.setVisible(false);
            }
            if ((Integer)this.numDipsEditor.getParameter().getValue() == 1) {
                this.faultTypeEditor.setVisible(true);
            }
        }
        if (name1.equalsIgnoreCase("Finite Fault Type")) {
            if (((String)this.faultTypeEditor.getParameter().getValue()).equals("Stirling's")) {
                this.dipDirectionParamEditor.setVisible(true);
                this.add((Component)this.dipDirectionParamEditor.getComponent(), new GridBagConstraints(0, 6, 0, 1, 1.0, 0.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
            } else {
                this.dipDirectionParamEditor.setVisible(true);
                this.remove(this.dipDirectionParamEditor.getComponent());
            }
        }
        this.validate();
        this.revalidate();
        this.repaint();
        this.evenlyGriddedParamChange = true;
    }

    @Override
    public void parameterChangeFailed(ParameterChangeFailEvent e) {
        String S = "SimpleFaultParameterEditorPanel : parameterChangeWarning(): ";
        StringBuffer b = new StringBuffer();
        Parameter param = (Parameter)e.getSource();
        ParameterConstraint constraint = param.getConstraint();
        String oldValueStr = e.getOldValue().toString();
        String badValueStr = e.getBadValue().toString();
        String name = param.getName();
        b.append("The value ");
        b.append(badValueStr);
        b.append(" is not permitted for '");
        b.append(name);
        b.append("'.\n");
        b.append("Resetting to ");
        b.append(oldValueStr);
        b.append(". The constraints are: \n");
        b.append(constraint.toString());
        b.append("\n");
        JOptionPane.showMessageDialog(this, b.toString(), "Cannot Change Value", 1);
    }

    public void setEvenlyGriddedSurfaceFromParams() throws RuntimeException {
        if (this.evenlyGriddedParamChange) {
            this.surfaceParam.setEvenlyGriddedSurfaceFromParams();
            this.evenlyGriddedParamChange = false;
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        try {
            this.setEvenlyGriddedSurfaceFromParams();
        }
        catch (RuntimeException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Incorrect Values", 0);
        }
    }
}

