/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.simulators;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.opensha.sha.simulators.EQSIM_EventRecord;
import org.opensha.sha.simulators.SimulatorElement;
import org.opensha.sha.simulators.SimulatorEvent;
import org.opensha.sha.simulators.Vertex;

public class EQSIM_Event
extends SimulatorEvent {
    private List<EQSIM_EventRecord> records;

    public EQSIM_Event(EQSIM_EventRecord eventRecord) {
        this(Lists.newArrayList((Object[])new EQSIM_EventRecord[]{eventRecord}));
    }

    public EQSIM_Event(List<EQSIM_EventRecord> records) {
        super(records);
        this.records = records;
        EQSIM_EventRecord firstRecord = records.get(0);
    }

    public void addEventRecord(EQSIM_EventRecord eventRecord) {
        if (!this.isSameEvent(eventRecord)) {
            throw new RuntimeException("Can't add because event IDs differ");
        }
        this.records.add(eventRecord);
    }

    public boolean doesEventIncludeSectionAndDAS(int sectId, double das) {
        boolean includes = false;
        for (EQSIM_EventRecord eventRecord : this.records) {
            if (eventRecord.getSectionID() != sectId || !(das < eventRecord.das_hi) || !(das > eventRecord.das_lo)) continue;
            includes = true;
        }
        return includes;
    }

    public double[] getNormDistAlongRupForElements() {
        if (this.hasElementSlipsAndIDsOnAllRecords()) {
            double min1_min2_dist;
            double max1_max2_dist;
            double max1_min2_dist;
            double distFromMax1;
            double distFromMin1;
            double min1_max2_dist;
            Vertex[] vertexForMinDAS_forER = new Vertex[this.size()];
            Vertex[] vertexForMaxDAS_forER = new Vertex[this.size()];
            double[] minDAS_forER = new double[this.size()];
            double[] maxDAS_forER = new double[this.size()];
            boolean[] flipER = new boolean[this.size()];
            for (int er_index = 0; er_index < this.size(); ++er_index) {
                EQSIM_EventRecord er = this.get(er_index);
                minDAS_forER[er_index] = er.getMinDAS();
                maxDAS_forER[er_index] = er.getMaxDAS();
                vertexForMinDAS_forER[er_index] = er.getVertxForMinDAS();
                vertexForMaxDAS_forER[er_index] = er.getVertxForMaxDAS();
            }
            ArrayList<Integer> reorderedIndices = new ArrayList<Integer>();
            if (this.size() > 1) {
                double min1_min2_dist2 = vertexForMinDAS_forER[0].getLinearDistance(vertexForMinDAS_forER[1]);
                distFromMin1 = Math.min(min1_min2_dist2, min1_max2_dist = vertexForMinDAS_forER[0].getLinearDistance(vertexForMaxDAS_forER[1]));
                if (distFromMin1 < (distFromMax1 = Math.min(max1_min2_dist = vertexForMaxDAS_forER[0].getLinearDistance(vertexForMinDAS_forER[1]), max1_max2_dist = vertexForMaxDAS_forER[0].getLinearDistance(vertexForMaxDAS_forER[1])))) {
                    reorderedIndices.add(1);
                    reorderedIndices.add(0);
                } else {
                    reorderedIndices.add(0);
                    reorderedIndices.add(1);
                }
                for (int er_index = 2; er_index < this.size(); ++er_index) {
                    double distFromLastER;
                    double distFromFirstER = EQSIM_Event.getMinDistBetweenEventRecordEnds(vertexForMinDAS_forER[(Integer)reorderedIndices.get(0)], vertexForMaxDAS_forER[(Integer)reorderedIndices.get(0)], vertexForMinDAS_forER[er_index], vertexForMaxDAS_forER[er_index]);
                    if (distFromFirstER < (distFromLastER = EQSIM_Event.getMinDistBetweenEventRecordEnds(vertexForMinDAS_forER[(Integer)reorderedIndices.get(reorderedIndices.size() - 1)], vertexForMaxDAS_forER[(Integer)reorderedIndices.get(reorderedIndices.size() - 1)], vertexForMinDAS_forER[er_index], vertexForMaxDAS_forER[er_index]))) {
                        reorderedIndices.add(0, er_index);
                        continue;
                    }
                    reorderedIndices.add(er_index);
                }
            } else {
                reorderedIndices.add(0);
            }
            flipER[0] = this.size() > 1 ? (distFromMin1 = Math.min(min1_min2_dist = vertexForMinDAS_forER[(Integer)reorderedIndices.get(0)].getLinearDistance(vertexForMinDAS_forER[(Integer)reorderedIndices.get(1)]), min1_max2_dist = vertexForMinDAS_forER[(Integer)reorderedIndices.get(0)].getLinearDistance(vertexForMaxDAS_forER[(Integer)reorderedIndices.get(1)]))) < (distFromMax1 = Math.min(max1_min2_dist = vertexForMaxDAS_forER[(Integer)reorderedIndices.get(0)].getLinearDistance(vertexForMinDAS_forER[(Integer)reorderedIndices.get(1)]), max1_max2_dist = vertexForMaxDAS_forER[(Integer)reorderedIndices.get(0)].getLinearDistance(vertexForMaxDAS_forER[(Integer)reorderedIndices.get(1)]))) : false;
            for (int er_index = 1; er_index < this.size(); ++er_index) {
                int lastER_index = (Integer)reorderedIndices.get(er_index - 1);
                Vertex lastVertex = flipER[lastER_index] ? vertexForMinDAS_forER[lastER_index] : vertexForMaxDAS_forER[lastER_index];
                flipER[er_index] = !(lastVertex.getLinearDistance(vertexForMinDAS_forER[(Integer)reorderedIndices.get(er_index)]) < lastVertex.getLinearDistance(vertexForMaxDAS_forER[(Integer)reorderedIndices.get(er_index)]));
            }
            double[] startDistAlongForReorderedER = new double[this.size()];
            startDistAlongForReorderedER[0] = 0.0;
            for (int i = 1; i < this.size(); ++i) {
                startDistAlongForReorderedER[i] = startDistAlongForReorderedER[i - 1] + this.get((Integer)reorderedIndices.get(i - 1)).getLength();
            }
            int rectElemIndex = -1;
            double totalRuptureLength = this.getLength();
            double[] distAlongForEachElement = new double[this.getNumElements()];
            for (int er_index = 0; er_index < this.size(); ++er_index) {
                double startDistanceAlong = startDistAlongForReorderedER[reorderedIndices.indexOf(er_index)];
                EQSIM_EventRecord er = this.get(er_index);
                Object object = er.getElements().iterator();
                while (object.hasNext()) {
                    SimulatorElement rectElem = (SimulatorElement)object.next();
                    ++rectElemIndex;
                    double aveDAS = rectElem.getAveDAS() * 1000.0;
                    if (flipER[er_index]) {
                        distAlongForEachElement[rectElemIndex] = (startDistanceAlong + maxDAS_forER[er_index] - aveDAS) / totalRuptureLength;
                        continue;
                    }
                    distAlongForEachElement[rectElemIndex] = (startDistanceAlong + aveDAS - minDAS_forER[er_index]) / totalRuptureLength;
                }
            }
            Object minDistAlong = Double.MAX_VALUE;
            Object maxDistAlong = Double.NEGATIVE_INFINITY;
            for (double distAlong : distAlongForEachElement) {
                if (minDistAlong > distAlong) {
                    minDistAlong = distAlong;
                }
                if (!(maxDistAlong < distAlong)) continue;
                maxDistAlong = distAlong;
            }
            return distAlongForEachElement;
        }
        return null;
    }

    public double getMeanSlip() {
        double aveSlip = 0.0;
        double totalArea = 0.0;
        for (EQSIM_EventRecord evRec : this.records) {
            aveSlip += evRec.getMeanSlip() * evRec.getArea();
            totalArea += evRec.getArea();
        }
        return aveSlip / totalArea;
    }

    @Override
    public EQSIM_EventRecord get(int index) {
        return this.records.get(index);
    }
}

