/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.simulators;

import java.util.ArrayList;
import java.util.List;
import org.opensha.sha.simulators.RSQSimEventRecord;
import org.opensha.sha.simulators.SimulatorEvent;

public class RSQSimEvent
extends SimulatorEvent {
    private List<RSQSimEventRecord> records;
    private double nextEventTime = Double.NaN;

    public RSQSimEvent(List<RSQSimEventRecord> records) {
        super(records);
        this.records = records;
    }

    public double[] getAllElementTimes() {
        ArrayList<double[]> timeList = new ArrayList<double[]>();
        int totSize = 0;
        for (int r = 0; r < this.size(); ++r) {
            double[] times = this.get(r).getElementTimeFirstSlips();
            totSize += times.length;
            timeList.add(times);
        }
        double[] times = new double[totSize];
        int index = 0;
        for (int i = 0; i < timeList.size(); ++i) {
            double[] recTimes = (double[])timeList.get(i);
            System.arraycopy(recTimes, 0, times, index, recTimes.length);
            index += recTimes.length;
        }
        return times;
    }

    public void setNextEventTime(double time) {
        this.nextEventTime = time;
    }

    public double getNextEventTime() {
        return this.nextEventTime;
    }

    @Override
    public RSQSimEvent cloneNewTime(double timeSeconds, int newID) {
        ArrayList<RSQSimEventRecord> modRecs = new ArrayList<RSQSimEventRecord>();
        double firstPatchTime = Double.POSITIVE_INFINITY;
        for (RSQSimEventRecord rec : this.records) {
            double[] patchTimes = rec.getElementTimeFirstSlips();
            if (patchTimes == null) continue;
            for (double patchTime : patchTimes) {
                firstPatchTime = Double.min(firstPatchTime, patchTime);
            }
        }
        for (RSQSimEventRecord rec : this.records) {
            RSQSimEventRecord modRec = rec.copy();
            modRec.setTime(timeSeconds);
            double[] patchTimes = rec.getElementTimeFirstSlips();
            if (patchTimes != null) {
                double[] modPatchTimes = new double[patchTimes.length];
                for (int i = 0; i < modPatchTimes.length; ++i) {
                    modPatchTimes[i] = timeSeconds + (patchTimes[i] - firstPatchTime);
                }
                modRec.setElementTimeFirstSlips(modPatchTimes);
            }
            modRecs.add(modRec);
        }
        RSQSimEvent o = new RSQSimEvent((List<RSQSimEventRecord>)modRecs);
        o.time = timeSeconds;
        o.event_id = newID;
        o.magnitude = this.magnitude;
        o.duration = this.duration;
        return o;
    }
}

