/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.simulators;

import com.google.common.base.Preconditions;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.sha.earthquake.FocalMechanism;
import org.opensha.sha.faultSurface.FourPointEvenlyGriddedSurface;
import org.opensha.sha.simulators.SimulatorElement;
import org.opensha.sha.simulators.Vertex;

public class RectangularElement
extends SimulatorElement {
    private boolean perfect;

    public RectangularElement(int id, Vertex[] vertices, String sectionName, int faultID, int sectionID, int numAlongStrike, int numDownDip, double slipRate, double aseisFactor, FocalMechanism focalMechanism, boolean perfectRect) {
        super(id, vertices, sectionName, faultID, sectionID, numAlongStrike, numDownDip, slipRate, aseisFactor, focalMechanism);
        Preconditions.checkArgument((vertices.length == 4 ? 1 : 0) != 0, (Object)"RectangularElement: vertices.length should equal 4");
        this.perfect = perfectRect;
        this.perfect = true;
    }

    @Override
    public FourPointEvenlyGriddedSurface getSurface() {
        return new FourPointEvenlyGriddedSurface(this.vertices[0], this.vertices[1], this.vertices[2], this.vertices[3]);
    }

    public boolean isPerfect() {
        return this.perfect;
    }

    public int getPerfectInt() {
        if (this.perfect) {
            return 1;
        }
        return 0;
    }

    @Override
    public double getArea() {
        return LocationUtils.linearDistance(this.vertices[0], this.vertices[1]) * LocationUtils.linearDistance(this.vertices[1], this.vertices[2]) * 1000000.0;
    }

    @Override
    public double getAveDAS() {
        return (this.vertices[0].getDAS() + this.vertices[1].getDAS() + this.vertices[2].getDAS() + this.vertices[3].getDAS()) / 4.0;
    }

    @Override
    public double getAveDepth() {
        return (this.vertices[0].getDepth() + this.vertices[1].getDepth() + this.vertices[2].getDepth() + this.vertices[3].getDepth()) / 4.0;
    }

    @Override
    public Location getCenterLocation() {
        double aveLat = (this.vertices[0].getLatitude() + this.vertices[1].getLatitude() + this.vertices[2].getLatitude() + this.vertices[3].getLatitude()) / 4.0;
        double aveLon = (this.vertices[0].getLongitude() + this.vertices[1].getLongitude() + this.vertices[2].getLongitude() + this.vertices[3].getLongitude()) / 4.0;
        double aveDep = (this.vertices[0].getDepth() + this.vertices[1].getDepth() + this.vertices[2].getDepth() + this.vertices[3].getDepth()) / 4.0;
        return new Location(aveLat, aveLon, aveDep);
    }

    public String toWardFormatLine() {
        Vertex newTop1 = this.vertices[0];
        Vertex newTop2 = this.vertices[3];
        Vertex newBot1 = this.vertices[1];
        Vertex newBot2 = this.vertices[2];
        FocalMechanism focalMechanism = this.getFocalMechanism();
        String line = this.getID() + "\t" + this.getNumAlongStrike() + "\t" + this.getNumDownDip() + "\t" + this.getFaultID() + "\t" + this.getSectionID() + "\t" + (float)this.getSlipRate() + "\tNA\t" + (float)focalMechanism.getStrike() + "\t" + (float)focalMechanism.getDip() + "\t" + (float)focalMechanism.getRake() + "\t" + (float)newTop1.getLatitude() + "\t" + (float)newTop1.getLongitude() + "\t" + (float)newTop1.getDepth() * -1000.0f + "\t" + (float)newBot1.getLatitude() + "\t" + (float)newBot1.getLongitude() + "\t" + (float)newBot1.getDepth() * -1000.0f + "\t" + (float)newBot2.getLatitude() + "\t" + (float)newBot2.getLongitude() + "\t" + (float)newBot2.getDepth() * -1000.0f + "\t" + (float)newTop2.getLatitude() + "\t" + (float)newTop2.getLongitude() + "\t" + (float)newTop2.getDepth() * -1000.0f + "\t" + this.getSectionName();
        return line;
    }
}

