/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.simulators;

import org.opensha.commons.geo.Location;
import org.opensha.sha.earthquake.FocalMechanism;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.simulators.Vertex;

public abstract class SimulatorElement {
    private int id;
    protected Vertex[] vertices;
    private FocalMechanism focalMechanism;
    private double slipRate;
    private double aseisFactor;
    private String sectionName;
    private int sectionID;
    private int faultID;
    private int numAlongStrike;
    private int numDownDip;

    public SimulatorElement(int id, Vertex[] vertices, String sectionName, int faultID, int sectionID, int numAlongStrike, int numDownDip, double slipRate, double aseisFactor, FocalMechanism focalMechanism) {
        this.id = id;
        this.vertices = vertices;
        this.sectionName = sectionName;
        this.faultID = faultID;
        this.sectionID = sectionID;
        this.numAlongStrike = numAlongStrike;
        this.numDownDip = numDownDip;
        this.slipRate = slipRate;
        this.aseisFactor = aseisFactor;
        this.focalMechanism = focalMechanism;
    }

    public abstract RuptureSurface getSurface();

    public String getName() {
        return this.sectionName;
    }

    public abstract double getArea();

    public int getID() {
        return this.id;
    }

    public Vertex[] getVertices() {
        return this.vertices;
    }

    public FocalMechanism getFocalMechanism() {
        return this.focalMechanism;
    }

    public double getSlipRate() {
        return this.slipRate;
    }

    public double getAseisFactor() {
        return this.aseisFactor;
    }

    public String getSectionName() {
        return this.sectionName;
    }

    public void setSectionName(String sectionName) {
        this.sectionName = sectionName;
    }

    public int getSectionID() {
        return this.sectionID;
    }

    public int getFaultID() {
        return this.faultID;
    }

    public void setFaultID(int faultID) {
        this.faultID = faultID;
    }

    public void setNumAlongStrike(int numAlongStrike) {
        this.numAlongStrike = numAlongStrike;
    }

    public int getNumAlongStrike() {
        return this.numAlongStrike;
    }

    public void setNumDownDip(int numDownDip) {
        this.numDownDip = numDownDip;
    }

    public int getNumDownDip() {
        return this.numDownDip;
    }

    public abstract double getAveDAS();

    public abstract double getAveDepth();

    public abstract Location getCenterLocation();

    public double getMinDAS() {
        double min = Double.POSITIVE_INFINITY;
        for (Vertex vertex : this.vertices) {
            min = Math.min(min, vertex.getDAS());
        }
        return min;
    }

    public double getMaxDAS() {
        double max = Double.NEGATIVE_INFINITY;
        for (Vertex vertex : this.vertices) {
            max = Math.max(max, vertex.getDAS());
        }
        return max;
    }

    public Vertex getVertexForMinDAS() {
        int minIndex = -1;
        double min = Double.POSITIVE_INFINITY;
        for (int i = 0; i < this.vertices.length; ++i) {
            if (!(this.vertices[i].getDAS() < min)) continue;
            min = this.vertices[i].getDAS();
            minIndex = i;
        }
        return this.vertices[minIndex];
    }

    public Vertex getVertexForMaxDAS() {
        int maxIndex = -1;
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.vertices.length; ++i) {
            if (!(this.vertices[i].getDAS() > max)) continue;
            max = this.vertices[i].getDAS();
            maxIndex = i;
        }
        return this.vertices[maxIndex];
    }
}

