/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.simulators;

import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationUtils;

public class Vertex
extends Location {
    private int id;
    private int traceFlag;
    private double das;

    public Vertex(double latitute, double longitude, double depth, int id, double das, int traceFlag) {
        super(latitute, longitude, depth);
        this.id = id;
        this.das = das;
        this.traceFlag = traceFlag;
    }

    public Vertex(Location loc, int id, double das, int traceFlag) {
        super(loc.getLatitude(), loc.getLongitude(), loc.getDepth());
        this.id = id;
        this.das = das;
        this.traceFlag = traceFlag;
    }

    public Vertex(double latitute, double longitude, double depth) {
        super(latitute, longitude, depth);
        this.das = Double.NaN;
        this.id = -1;
        this.traceFlag = -1;
    }

    public Vertex(double latitute, double longitude, double depth, int id) {
        super(latitute, longitude, depth);
        this.das = Double.NaN;
        this.id = id;
        this.traceFlag = -1;
    }

    public Vertex(Location loc) {
        super(loc.getLatitude(), loc.getLongitude(), loc.getDepth());
        this.das = Double.NaN;
        this.id = -1;
        this.traceFlag = -1;
    }

    public int getID() {
        return this.id;
    }

    public double getDAS() {
        return this.das;
    }

    public void setDAS(double das) {
        this.das = das;
    }

    public int getTraceFlag() {
        return this.traceFlag;
    }

    public double getLinearDistance(Location loc) {
        return LocationUtils.linearDistance(loc, this);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Vertex)) {
            return false;
        }
        Vertex vert = (Vertex)obj;
        return vert.getID() == this.getID();
    }
}

