/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.simulators.eqsim_v04;

import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.stat.correlation.PearsonsCorrelation;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.jfree.data.Range;
import org.opensha.commons.calc.FaultMomentCalc;
import org.opensha.commons.calc.magScalingRelations.magScalingRelImpl.Ellsworth_B_WG02_MagAreaRel;
import org.opensha.commons.calc.magScalingRelations.magScalingRelImpl.HanksBakun2002_MagAreaRel;
import org.opensha.commons.calc.magScalingRelations.magScalingRelImpl.Shaw_2007_MagAreaRel;
import org.opensha.commons.data.NamedComparator;
import org.opensha.commons.data.function.AbstractXY_DataSet;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DefaultXY_DataSet;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.function.HistogramFunction;
import org.opensha.commons.eq.MagUtils;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.LocationVector;
import org.opensha.commons.geo.PlaneUtils;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.commons.gui.plot.HeadlessGraphPanel;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSymbol;
import org.opensha.commons.util.FileUtils;
import org.opensha.refFaultParamDb.vo.FaultSectionPrefData;
import org.opensha.sha.earthquake.FocalMechanism;
import org.opensha.sha.earthquake.calc.recurInterval.BPT_DistCalc;
import org.opensha.sha.earthquake.calc.recurInterval.LognormalDistCalc;
import org.opensha.sha.earthquake.calc.recurInterval.WeibullDistCalc;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.data.finalReferenceFaultParamDb.DeformationModelPrefDataFinal;
import org.opensha.sha.faultSurface.EvenlyGridCenteredSurface;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.StirlingGriddedSurface;
import org.opensha.sha.gui.infoTools.CalcProgressBar;
import org.opensha.sha.magdist.ArbIncrementalMagFreqDist;
import org.opensha.sha.magdist.GutenbergRichterMagFreqDist;
import org.opensha.sha.simulators.EQSIM_Event;
import org.opensha.sha.simulators.EQSIM_EventRecord;
import org.opensha.sha.simulators.EventRecord;
import org.opensha.sha.simulators.RectangularElement;
import org.opensha.sha.simulators.SimulatorElement;
import org.opensha.sha.simulators.SimulatorEvent;
import org.opensha.sha.simulators.Vertex;
import org.opensha.sha.simulators.iden.RuptureIdentifier;
import scratch.UCERF3.enumTreeBranches.DeformationModels;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.enumTreeBranches.TotalMag5Rate;
import scratch.UCERF3.erf.utils.ProbModelsPlottingUtils;
import scratch.UCERF3.utils.DeformationModelFetcher;
import scratch.UCERF3.utils.UCERF3_DataUtils;

@Deprecated
public class OldGeneral_EQSIM_Tools {
    protected static final boolean D = false;
    ArrayList<SimulatorElement> rectElementsList;
    ArrayList<Vertex> vertexList;
    ArrayList<ArrayList<SimulatorElement>> rectElementsListForSections;
    ArrayList<ArrayList<Vertex>> vertexListForSections;
    ArrayList<String> sectionNamesList;
    ArrayList<Integer> sectionIDs_List;
    ArrayList<Integer> faultIDs_ForSections;
    ArrayList<Double> depthLoForSections;
    ArrayList<Double> depthHiForSections;
    ArrayList<Double> lengthForSections;
    ArrayList<Double> aveDipForSections;
    ArrayList<Double> areaForSections;
    ArrayList<EQSIM_Event> eventList;
    static final String GEOM_FILE_SIG = "EQSim_Input_Geometry_2";
    static final int GEOM_FILE_SPEC_LEVEL = 2;
    static final String EVENT_FILE_SIG = "EQSim_Output_Event_2";
    static final int EVENT_FILE_SPEC_LEVEL = 2;
    public static final double SECONDS_PER_YEAR = 3.1536E7;
    String dirNameForSavingFiles;

    public OldGeneral_EQSIM_Tools(int deformationModelID, boolean aseisReducesArea, double maxDiscretization) {
        this.mkElementsFromUCERF2_DefMod(deformationModelID, aseisReducesArea, maxDiscretization);
    }

    public OldGeneral_EQSIM_Tools(List<FaultSectionPrefData> faultSections, boolean aseisReducesArea, double maxDiscretization) {
        this.mkElementsFromSections(faultSections, aseisReducesArea, maxDiscretization);
    }

    public OldGeneral_EQSIM_Tools(String filePathName) {
        ArrayList<String> lines = null;
        try {
            lines = FileUtils.loadJarFile(filePathName);
            System.out.println("Number of file lines: " + lines.size() + " (in " + filePathName + ")");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.loadFromEQSIMv04_GeometryLines(lines);
    }

    public OldGeneral_EQSIM_Tools(String filePathName, int formatType) {
        System.out.println(filePathName);
        ArrayList<String> lines = null;
        try {
            lines = FileUtils.loadJarFile(filePathName);
            System.out.println("Number of file lines: " + lines.size() + " (in " + filePathName + ")");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (formatType == 0) {
            this.loadFromEQSIMv04_GeometryLines(lines);
        } else if (formatType == 1) {
            this.loadFromSteveWardLines(lines);
        } else {
            throw new RuntimeException("format type not supported");
        }
    }

    public OldGeneral_EQSIM_Tools(File file) throws IOException {
        ArrayList<String> lines = FileUtils.loadFile(file.getAbsolutePath());
        System.out.println("Number of file lines: " + lines.size() + " (in " + file.getAbsolutePath() + ")");
        this.loadFromEQSIMv04_GeometryLines(lines);
    }

    public OldGeneral_EQSIM_Tools(URL url) {
        ArrayList<String> lines = null;
        try {
            lines = FileUtils.loadFile(url);
            System.out.println("Number of file lines: " + lines.size() + " (in " + String.valueOf(url) + ")");
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        this.loadFromEQSIMv04_GeometryLines(lines);
    }

    public ArrayList<String> getSectionsNameList() {
        return this.sectionNamesList;
    }

    public void read_EQSIMv04_EventsFile(URL url) throws IOException {
        this.read_EQSIMv04_EventsFile(url, null);
    }

    public void read_EQSIMv04_EventsFile(URL url, Collection<RuptureIdentifier> rupIdens) throws IOException {
        URLConnection uc = url.openConnection();
        this.read_EQSIMv04_EventsFile(new InputStreamReader((InputStream)uc.getContent()), rupIdens);
    }

    public void read_EQSIMv04_EventsFile(File file) throws IOException {
        this.read_EQSIMv04_EventsFile(file, null);
    }

    public void read_EQSIMv04_EventsFile(File file, Collection<RuptureIdentifier> rupIdens) throws IOException {
        this.read_EQSIMv04_EventsFile(file.getAbsolutePath(), rupIdens);
    }

    public void read_EQSIMv04_EventsFile(String filePathName) throws FileNotFoundException, IOException {
        this.read_EQSIMv04_EventsFile(filePathName, null);
    }

    public void read_EQSIMv04_EventsFile(String filePathName, Collection<RuptureIdentifier> rupIdens) throws FileNotFoundException, IOException {
        this.read_EQSIMv04_EventsFile(new FileReader(filePathName), rupIdens);
    }

    private void read_EQSIMv04_EventsFile(Reader reader, Collection<RuptureIdentifier> rupIdens) throws IOException {
        BufferedReader buffRead = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        String line = buffRead.readLine();
        StringTokenizer tok = new StringTokenizer(line);
        int kindOfLine = Integer.parseInt(tok.nextToken());
        String fileSignature = tok.nextToken();
        int fileSpecLevel = Integer.parseInt(tok.nextToken());
        if (kindOfLine != 101 || !fileSignature.equals(EVENT_FILE_SIG)) {
            throw new RuntimeException("wrong type of event input file; your first file line is:\n\n\t" + line + "\n");
        }
        this.eventList = new ArrayList();
        Object currEvent = null;
        EQSIM_EventRecord evRec = new EQSIM_EventRecord(this.rectElementsList);
        int numEventRecs = 0;
        line = buffRead.readLine();
        while (line != null) {
            tok = new StringTokenizer(line);
            kindOfLine = Integer.parseInt(tok.nextToken());
            if (kindOfLine == 200) {
                try {
                    evRec = new EQSIM_EventRecord(line, this.rectElementsList);
                }
                catch (Exception e) {
                    System.err.println("Unable to parse line: " + line.trim() + " (error: " + e.getMessage() + ")");
                    line = buffRead.readLine();
                    Object tok2 = new StringTokenizer(line);
                    while (Integer.parseInt(((StringTokenizer)tok2).nextToken()) != 200) {
                        line = buffRead.readLine();
                        tok2 = new StringTokenizer(line);
                    }
                    continue;
                }
                ++numEventRecs;
                if (currEvent == null) {
                    EQSIM_Event event = new EQSIM_Event(evRec);
                    currEvent = event;
                } else if (((SimulatorEvent)currEvent).isSameEvent(evRec)) {
                    ((EQSIM_Event)currEvent).addEventRecord(evRec);
                } else {
                    Object event;
                    boolean keep;
                    boolean bl = keep = rupIdens == null || rupIdens.isEmpty();
                    if (!keep) {
                        for (RuptureIdentifier rupIden : rupIdens) {
                            if (!rupIden.isMatch((SimulatorEvent)currEvent)) continue;
                            keep = true;
                            break;
                        }
                    }
                    if (keep) {
                        this.eventList.add((EQSIM_Event)currEvent);
                    }
                    currEvent = event = new EQSIM_Event(evRec);
                }
            } else if (kindOfLine == 201) {
                evRec.addSlipAndElementData(line);
            } else if (kindOfLine == 202) {
                evRec.addType202_Line(line);
            }
            line = buffRead.readLine();
        }
        if (currEvent != null) {
            boolean keep;
            boolean bl = keep = rupIdens == null || rupIdens.isEmpty();
            if (!keep) {
                for (RuptureIdentifier rupIden : rupIdens) {
                    if (!rupIden.isMatch((SimulatorEvent)currEvent)) continue;
                    keep = true;
                    break;
                }
            }
            if (keep) {
                this.eventList.add((EQSIM_Event)currEvent);
            }
        }
        System.out.println("Num Events = " + this.eventList.size() + "\tNum Event Records = " + numEventRecs);
        int numEventsKept = this.eventList.size();
        int numEventsInFile = ((SimulatorEvent)currEvent).getID();
        if (numEventsKept != numEventsInFile) {
            System.out.println("Warning: " + (numEventsInFile - numEventsKept) + " were not able to be read from the input file");
        }
    }

    private void loadFromEQSIMv04_GeometryLines(ArrayList<String> lines) {
        int i;
        this.rectElementsList = new ArrayList();
        this.vertexList = new ArrayList();
        this.rectElementsListForSections = new ArrayList();
        this.vertexListForSections = new ArrayList();
        this.sectionNamesList = new ArrayList();
        this.sectionIDs_List = new ArrayList();
        this.faultIDs_ForSections = new ArrayList();
        this.depthLoForSections = new ArrayList();
        this.depthHiForSections = new ArrayList();
        this.lengthForSections = new ArrayList();
        this.aveDipForSections = new ArrayList();
        this.areaForSections = new ArrayList();
        ListIterator<String> linesIterator = lines.listIterator();
        String line = linesIterator.next();
        StringTokenizer tok = new StringTokenizer(line);
        int kindOfLine = Integer.parseInt(tok.nextToken());
        String fileSignature = tok.nextToken();
        int fileSpecLevel = Integer.parseInt(tok.nextToken());
        if (kindOfLine != 101 || !fileSignature.equals(GEOM_FILE_SIG) || fileSpecLevel < 2) {
            throw new RuntimeException("wrong type of input file");
        }
        int n_section = -1;
        int n_vertex = -1;
        int n_triangle = -1;
        int n_rectangle = -1;
        while (linesIterator.hasNext()) {
            try {
                line = linesIterator.next();
                tok = new StringTokenizer(line);
                kindOfLine = Integer.parseInt(tok.nextToken());
                if (kindOfLine == 200) {
                    n_section = Integer.parseInt(tok.nextToken());
                    n_vertex = Integer.parseInt(tok.nextToken());
                    n_triangle = Integer.parseInt(tok.nextToken());
                    n_rectangle = Integer.parseInt(tok.nextToken());
                }
                if (kindOfLine != 201) continue;
                int sid = Integer.parseInt(tok.nextToken());
                String name = tok.nextToken();
                int n_sect_vertex = Integer.parseInt(tok.nextToken());
                int n_sect_triangle = Integer.parseInt(tok.nextToken());
                int n_sect_rectangle = Integer.parseInt(tok.nextToken());
                tok.nextToken();
                tok.nextToken();
                tok.nextToken();
                tok.nextToken();
                double depth_lo = Double.parseDouble(tok.nextToken());
                double depth_hi = Double.parseDouble(tok.nextToken());
                double das_lo = Double.parseDouble(tok.nextToken());
                double das_hi = Double.parseDouble(tok.nextToken());
                int fault_id = Integer.parseInt(tok.nextToken());
                if (n_sect_triangle > 0) {
                    throw new RuntimeException("Don't yet support triangles");
                }
                this.sectionNamesList.add(name);
                this.sectionIDs_List.add(sid);
                this.faultIDs_ForSections.add(fault_id);
                this.depthLoForSections.add(depth_lo);
                this.depthHiForSections.add(depth_hi);
                this.lengthForSections.add(das_hi - das_lo);
                ArrayList<Vertex> verticesForThisSect = new ArrayList<Vertex>();
                for (int v = 0; v < n_sect_vertex; ++v) {
                    line = linesIterator.next();
                    tok = new StringTokenizer(line);
                    kindOfLine = Integer.parseInt(tok.nextToken());
                    if (kindOfLine != 202) {
                        throw new RuntimeException("Problem with file (line should start with 202)");
                    }
                    int id = Integer.parseInt(tok.nextToken());
                    double lat = Double.parseDouble(tok.nextToken());
                    double lon = Double.parseDouble(tok.nextToken());
                    double depth = -Double.parseDouble(tok.nextToken()) / 1000.0;
                    double das = Double.parseDouble(tok.nextToken()) / 1000.0;
                    int trace_flag = Integer.parseInt(tok.nextToken());
                    Vertex vertex = new Vertex(lat, lon, depth, id, das, trace_flag);
                    verticesForThisSect.add(vertex);
                    this.vertexList.add(vertex);
                }
                this.vertexListForSections.add(verticesForThisSect);
                double aveDip = 0.0;
                ArrayList<RectangularElement> rectElemForThisSect = new ArrayList<RectangularElement>();
                double totArea = 0.0;
                for (int r = 0; r < n_sect_rectangle; ++r) {
                    line = linesIterator.next();
                    tok = new StringTokenizer(line);
                    kindOfLine = Integer.parseInt(tok.nextToken());
                    if (kindOfLine != 204) {
                        throw new RuntimeException("Problem with file (line should start with 204)");
                    }
                    int id = Integer.parseInt(tok.nextToken());
                    int vertex_1_ID = Integer.parseInt(tok.nextToken());
                    int vertex_2_ID = Integer.parseInt(tok.nextToken());
                    int vertex_3_ID = Integer.parseInt(tok.nextToken());
                    int vertex_4_ID = Integer.parseInt(tok.nextToken());
                    double rake = Double.parseDouble(tok.nextToken());
                    double slip_rate = Double.parseDouble(tok.nextToken()) * 3.1536E7;
                    double aseis_factor = Double.parseDouble(tok.nextToken());
                    double strike = Double.parseDouble(tok.nextToken());
                    double dip = Double.parseDouble(tok.nextToken());
                    aveDip += dip / (double)n_sect_rectangle;
                    int perfect_flag = Integer.parseInt(tok.nextToken());
                    boolean perfectBoolean = false;
                    if (perfect_flag == 1) {
                        perfectBoolean = true;
                    }
                    Vertex[] vertices = new Vertex[]{this.vertexList.get(vertex_1_ID - 1), this.vertexList.get(vertex_2_ID - 1), this.vertexList.get(vertex_3_ID - 1), this.vertexList.get(vertex_4_ID - 1)};
                    int numAlongStrike = -1;
                    int numDownDip = -1;
                    FocalMechanism focalMechanism = new FocalMechanism(strike, dip, rake);
                    RectangularElement rectElem = new RectangularElement(id, vertices, name, fault_id, sid, numAlongStrike, numDownDip, slip_rate, aseis_factor, focalMechanism, perfectBoolean);
                    rectElemForThisSect.add(rectElem);
                    this.rectElementsList.add(rectElem);
                    totArea += ((SimulatorElement)rectElem).getArea();
                }
                this.rectElementsListForSections.add(rectElemForThisSect);
                this.aveDipForSections.add(aveDip);
                double areaTest = Math.abs((das_hi - das_lo) * (depth_hi - depth_lo) / Math.sin(aveDip * Math.PI / 180.0));
                double test = areaTest / totArea;
                double testTol = 0.25;
                if (test < 1.0 - testTol || test > 1.0 + testTol) {
                    System.out.println(sid + "\t" + name + "\t" + (float)aveDip + "\t" + totArea + "\t" + areaTest + "\t" + areaTest / totArea);
                    throw new RuntimeException("Error: area discrepancy");
                }
                this.areaForSections.add(totArea);
            }
            catch (RuntimeException e) {
                System.out.println("Offending Line: " + line);
                System.out.flush();
                throw e;
            }
        }
        if (n_section != this.sectionNamesList.size()) {
            throw new RuntimeException("something wrong with number of sections");
        }
        if (n_vertex != this.vertexList.size()) {
            throw new RuntimeException("something wrong with number of vertices");
        }
        if (n_rectangle != this.rectElementsList.size()) {
            throw new RuntimeException("something wrong with number of eleents");
        }
        System.out.println("namesOfSections.size()=" + this.sectionNamesList.size() + "\tvertexList.size()=" + this.vertexList.size() + "\trectElementsList.size()=" + this.rectElementsList.size());
        for (i = 0; i < this.vertexList.size(); ++i) {
            if (i == this.vertexList.get(i).getID() - 1) continue;
            throw new RuntimeException("vertexList index problem at " + i);
        }
        for (i = 0; i < this.rectElementsList.size(); ++i) {
            if (i == this.rectElementsList.get(i).getID() - 1) continue;
            throw new RuntimeException("rectElementsList index problem at " + i);
        }
    }

    public boolean isEventSupraSeismogenic(EQSIM_Event event, double magThresh) {
        boolean supraSeis = false;
        if (Double.isNaN(magThresh)) {
            double totArea = 0.0;
            double totLength = 0.0;
            for (int i = 0; i < event.size(); ++i) {
                EQSIM_EventRecord evRec = event.get(i);
                int sectIndex = evRec.getSectionID() - 1;
                double ddwForSect = this.areaForSections.get(sectIndex) / this.lengthForSections.get(sectIndex);
                double lengthOnRec = evRec.getLength();
                totLength += lengthOnRec;
                totArea += lengthOnRec * ddwForSect;
            }
            double aveFltDDW = totArea / totLength;
            if (Math.sqrt(event.getArea()) >= aveFltDDW - 1500.0) {
                supraSeis = true;
            }
        } else if (event.getMagnitude() >= magThresh) {
            supraSeis = true;
        }
        return supraSeis;
    }

    public ArrayList<SimulatorElement> getElementsList() {
        return this.rectElementsList;
    }

    public String printMinAndMaxElementArea() {
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (SimulatorElement re : this.getElementsList()) {
            double area = re.getArea();
            if (area < min) {
                min = area;
            }
            if (!(area > max)) continue;
            max = area;
        }
        String info = "min element area (km) = " + (float)(min * 1.0E-6) + "; max element area (km) = " + (float)(max * 1.0E-6) + "\n";
        System.out.println(info);
        return info;
    }

    public void testElementAreas() {
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        int el_index = 0;
        for (SimulatorElement re : this.getElementsList()) {
            double area2;
            double ratio;
            double area1 = re.getArea() * 1.0E-6;
            if (area1 < min) {
                min = area1;
            }
            if (area1 > max) {
                max = area1;
            }
            if ((ratio = area1 / (area2 = re.getSurface().getArea())) > 1.01 || ratio < 0.99) {
                System.out.println(el_index + "\t" + ratio + "\t" + area1 + "\t" + area2);
            }
            ++el_index;
        }
        System.out.println("min element area (km) = " + (float)(min * 1.0E-6));
        System.out.println("max element area (km) = " + (float)(max * 1.0E-6));
    }

    public void testDistanceAlong() {
        int testEventID = 192778;
        EQSIM_Event testEvent = this.getEventsHashMap().get(testEventID);
        int numSect = testEvent.size();
        System.out.println("numSect=" + numSect);
        ArrayList<SimulatorElement> elementList = testEvent.getAllElements();
        double[] distAlongArray = testEvent.getNormDistAlongRupForElements();
        try {
            FileWriter fw = new FileWriter("tempDistAlongTest.txt");
            System.out.println("numElem=" + distAlongArray.length);
            for (int i = 0; i < distAlongArray.length; ++i) {
                Location loc = elementList.get(i).getCenterLocation();
                fw.write((float)loc.getLatitude() + "\t" + (float)loc.getLongitude() + "\t" + (float)loc.getDepth() + "\t" + (float)distAlongArray[i] + "\n");
            }
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void mkElementsFromUCERF2_DefMod(int deformationModelID, boolean aseisReducesArea, double maxDiscretization) {
        DeformationModelPrefDataFinal deformationModelPrefDB = new DeformationModelPrefDataFinal();
        ArrayList<FaultSectionPrefData> allFaultSectionPrefData = deformationModelPrefDB.getAllFaultSectionPrefData(deformationModelID);
        this.mkElementsFromSections(allFaultSectionPrefData, aseisReducesArea, maxDiscretization);
    }

    public void mkElementsFromSections(List<FaultSectionPrefData> allFaultSectionPrefData, boolean aseisReducesArea, double maxDiscretization) {
        allFaultSectionPrefData = Lists.newArrayList(allFaultSectionPrefData);
        this.rectElementsList = new ArrayList();
        this.vertexList = new ArrayList();
        this.rectElementsListForSections = new ArrayList();
        this.vertexListForSections = new ArrayList();
        this.sectionNamesList = new ArrayList();
        this.faultIDs_ForSections = Lists.newArrayList();
        Collections.sort(allFaultSectionPrefData, new NamedComparator());
        for (int i = allFaultSectionPrefData.size() - 1; i >= 0; --i) {
            if (!Double.isNaN(((FaultSectionPrefData)allFaultSectionPrefData.get(i)).getOrigAveSlipRate())) continue;
            allFaultSectionPrefData.remove(i);
        }
        int elementID = 0;
        int numberAlongStrike = 0;
        int faultNumber = -1;
        int sectionNumber = 0;
        double elementSlipRate = 0.0;
        double elementStrike = 0.0;
        double elementDip = 0.0;
        double elementRake = 0.0;
        for (int i = 0; i < allFaultSectionPrefData.size(); ++i) {
            ArrayList<RectangularElement> sectionElementsList = new ArrayList<RectangularElement>();
            ArrayList<Vertex> sectionVertexList = new ArrayList<Vertex>();
            ++sectionNumber;
            FaultSectionPrefData faultSectionPrefData = (FaultSectionPrefData)allFaultSectionPrefData.get(i);
            StirlingGriddedSurface surface = new StirlingGriddedSurface(faultSectionPrefData.getSimpleFaultData(aseisReducesArea), maxDiscretization, maxDiscretization);
            EvenlyGridCenteredSurface gridCenteredSurf = new EvenlyGridCenteredSurface(surface);
            double elementLength = gridCenteredSurf.getGridSpacingAlongStrike();
            double elementDDW = gridCenteredSurf.getGridSpacingDownDip();
            elementRake = faultSectionPrefData.getAveRake();
            elementSlipRate = faultSectionPrefData.getOrigAveSlipRate() / 1000.0;
            double elementAseis = faultSectionPrefData.getAseismicSlipFactor();
            String sectionName = faultSectionPrefData.getName();
            for (int col = 0; col < gridCenteredSurf.getNumCols(); ++col) {
                ++numberAlongStrike;
                for (int row = 0; row < gridCenteredSurf.getNumRows(); ++row) {
                    ++elementID;
                    int numberDownDip = row + 1;
                    Location centerLoc = (Location)gridCenteredSurf.get(row, col);
                    Location top1 = (Location)surface.get(row, col);
                    Location top2 = (Location)surface.get(row, col + 1);
                    Location bot1 = (Location)surface.get(row + 1, col);
                    double[] strikeAndDip = PlaneUtils.getStrikeAndDip(top1, top2, bot1);
                    elementStrike = strikeAndDip[0];
                    elementDip = strikeAndDip[1];
                    double hDistAlong = elementLength / 2.0;
                    double dipRad = Math.PI * elementDip / 180.0;
                    double vDist = elementDDW / 2.0 * Math.sin(dipRad);
                    double hDist = elementDDW / 2.0 * Math.cos(dipRad);
                    LocationVector vect = new LocationVector(elementStrike + 180.0, hDistAlong, 0.0);
                    Location newMid1 = LocationUtils.location(centerLoc, vect);
                    vect.set(elementStrike - 90.0, hDist, -vDist);
                    Location newTop1 = LocationUtils.location(newMid1, vect);
                    vect.set(elementStrike + 90.0, hDist, vDist);
                    Location newBot1 = LocationUtils.location(newMid1, vect);
                    vect.set(elementStrike, hDistAlong, 0.0);
                    Location newMid2 = LocationUtils.location(centerLoc, vect);
                    vect.set(elementStrike - 90.0, hDist, -vDist);
                    Location newTop2 = LocationUtils.location(newMid2, vect);
                    vect.set(elementStrike + 90.0, hDist, vDist);
                    Location newBot2 = LocationUtils.location(newMid2, vect);
                    double das1 = (double)col * elementLength;
                    double das2 = das1 + elementLength;
                    int traceFlagBot = 0;
                    int traceFlagTop1 = 0;
                    int traceFlagTop2 = 0;
                    if (row == 0) {
                        traceFlagTop1 = 1;
                        traceFlagTop2 = 1;
                    }
                    if (row == 0 && col == 0) {
                        traceFlagTop1 = 2;
                    }
                    if (row == 0 && col == gridCenteredSurf.getNumCols() - 1) {
                        traceFlagTop2 = 3;
                    }
                    Vertex[] elementVertices = new Vertex[]{new Vertex(newTop1, this.vertexList.size() + 1, das1, traceFlagTop1), new Vertex(newBot1, this.vertexList.size() + 2, das1, traceFlagBot), new Vertex(newBot2, this.vertexList.size() + 3, das2, traceFlagBot), new Vertex(newTop2, this.vertexList.size() + 4, das2, traceFlagTop2)};
                    FocalMechanism focalMech = new FocalMechanism(elementStrike, elementDip, elementRake);
                    RectangularElement simSurface = new RectangularElement(elementID, elementVertices, sectionName, faultNumber, sectionNumber, numberAlongStrike, numberDownDip, elementSlipRate, elementAseis, focalMech, true);
                    this.rectElementsList.add(simSurface);
                    this.vertexList.add(elementVertices[0]);
                    this.vertexList.add(elementVertices[1]);
                    this.vertexList.add(elementVertices[2]);
                    this.vertexList.add(elementVertices[3]);
                    sectionElementsList.add(simSurface);
                    sectionVertexList.add(elementVertices[0]);
                    sectionVertexList.add(elementVertices[1]);
                    sectionVertexList.add(elementVertices[2]);
                    sectionVertexList.add(elementVertices[3]);
                }
            }
            this.rectElementsListForSections.add(sectionElementsList);
            this.vertexListForSections.add(sectionVertexList);
            String strippedName = faultSectionPrefData.getName().replaceAll("\\W+", "_");
            this.sectionNamesList.add(strippedName);
            if (this.faultIDs_ForSections == null) continue;
            this.faultIDs_ForSections.add(faultSectionPrefData.getParentSectionId());
        }
        System.out.println("rectElementsList.size()=" + this.rectElementsList.size());
        System.out.println("vertexList.size()=" + this.vertexList.size());
    }

    public void writeToWardFile(String fileName) throws IOException {
        FileWriter efw = new FileWriter(fileName);
        for (SimulatorElement rectElem : this.rectElementsList) {
            efw.write(((RectangularElement)rectElem).toWardFormatLine() + "\n");
        }
        efw.close();
    }

    private void loadFromSteveWardLines(ArrayList<String> lines) {
        int i;
        this.rectElementsList = new ArrayList();
        this.vertexList = new ArrayList();
        this.rectElementsListForSections = new ArrayList();
        this.vertexListForSections = new ArrayList();
        this.sectionNamesList = new ArrayList();
        this.faultIDs_ForSections = new ArrayList();
        int lastSectionID = -1;
        ArrayList<RectangularElement> currentRectElForSection = null;
        ArrayList<Vertex> currVertexListForSection = null;
        int numVertices = 0;
        for (String line : lines) {
            if (line == null || line.length() == 0) continue;
            StringTokenizer tok = new StringTokenizer(line);
            int id = Integer.parseInt(tok.nextToken());
            int numAlongStrike = Integer.parseInt(tok.nextToken());
            int numDownDip = Integer.parseInt(tok.nextToken());
            int faultID = Integer.parseInt(tok.nextToken());
            int sectionID = Integer.parseInt(tok.nextToken());
            double slipRate = Double.parseDouble(tok.nextToken());
            double strength = Double.parseDouble(tok.nextToken());
            double strike = Double.parseDouble(tok.nextToken());
            double dip = Double.parseDouble(tok.nextToken());
            double rake = Double.parseDouble(tok.nextToken());
            FocalMechanism focalMechanism = new FocalMechanism(strike, dip, rake);
            Vertex[] vertices = new Vertex[4];
            double lat = Double.parseDouble(tok.nextToken());
            double lon = Double.parseDouble(tok.nextToken());
            double depth = Double.parseDouble(tok.nextToken()) / -1000.0;
            vertices[0] = new Vertex(lat, lon, depth, ++numVertices);
            lat = Double.parseDouble(tok.nextToken());
            lon = Double.parseDouble(tok.nextToken());
            depth = Double.parseDouble(tok.nextToken()) / -1000.0;
            vertices[1] = new Vertex(lat, lon, depth, ++numVertices);
            lat = Double.parseDouble(tok.nextToken());
            lon = Double.parseDouble(tok.nextToken());
            depth = Double.parseDouble(tok.nextToken()) / -1000.0;
            vertices[2] = new Vertex(lat, lon, depth, ++numVertices);
            lat = Double.parseDouble(tok.nextToken());
            lon = Double.parseDouble(tok.nextToken());
            depth = Double.parseDouble(tok.nextToken()) / -1000.0;
            vertices[3] = new Vertex(lat, lon, depth, ++numVertices);
            Object name = null;
            while (tok.hasMoreTokens()) {
                name = name == null ? "" : (String)name + " ";
                name = (String)name + tok.nextToken();
            }
            String sectionName = name;
            RectangularElement rectElem = new RectangularElement(id, vertices, sectionName, faultID, sectionID, numAlongStrike, numDownDip, slipRate, Double.NaN, focalMechanism, true);
            this.rectElementsList.add(rectElem);
            if (sectionID != lastSectionID) {
                currentRectElForSection = new ArrayList<RectangularElement>();
                currVertexListForSection = new ArrayList<Vertex>();
                this.rectElementsListForSections.add(currentRectElForSection);
                this.vertexListForSections.add(currVertexListForSection);
                this.sectionNamesList.add(sectionName);
                this.faultIDs_ForSections.add(faultID);
            }
            currentRectElForSection.add(rectElem);
            for (int i2 = 0; i2 < 4; ++i2) {
                this.vertexList.add(vertices[i2]);
                currVertexListForSection.add(vertices[i2]);
            }
        }
        for (i = 0; i < this.vertexList.size(); ++i) {
            int idMinus1 = this.vertexList.get(i).getID() - 1;
            if (i == idMinus1) continue;
            throw new RuntimeException("vertexList index problem at index " + i + " (ID-1=" + idMinus1 + ")");
        }
        for (i = 0; i < this.rectElementsList.size(); ++i) {
            if (i == this.rectElementsList.get(i).getID() - 1) continue;
            throw new RuntimeException("rectElementsList index problem at " + i);
        }
        System.out.println("namesOfSections.size()=" + this.sectionNamesList.size() + "\tvertexList.size()=" + this.vertexList.size() + "\trectElementsList.size()=" + this.rectElementsList.size());
    }

    public void writeTo_EQSIM_V04_GeometryFile(String fileName, ArrayList<String> infoLines, String titleLine, String author, String date) throws IOException {
        FileWriter efw = new FileWriter(fileName);
        efw.write("101 EQSim_Input_Geometry_2 2\n");
        if (titleLine != null) {
            efw.write("111 " + titleLine + "\n");
        }
        if (author != null) {
            efw.write("112 " + author + "\n");
        }
        if (date != null) {
            efw.write("113 " + date + "\n");
        }
        if (infoLines != null) {
            for (int i = 0; i < infoLines.size(); ++i) {
                efw.write("110 " + infoLines.get(i) + "\n");
            }
        }
        String fullPath = "org/opensha/sha/simulators/eqsim_v04/ALLCAL_Model_v04/ALLCAL_Ward_Geometry.dat";
        ArrayList<String> lines = null;
        try {
            lines = FileUtils.loadJarFile(fullPath);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (int l = 0; l < lines.size(); ++l) {
            String line = lines.get(l);
            StringTokenizer tok = new StringTokenizer(line);
            int kindOfLine = Integer.parseInt(tok.nextToken());
            if (kindOfLine != 120 && kindOfLine != 121 && kindOfLine != 103) continue;
            efw.write(line + "\n");
        }
        efw.write("200 " + this.sectionNamesList.size() + " " + this.vertexList.size() + " 0 " + this.rectElementsList.size() + " " + this.getMinMaxFileString(this.vertexList, false) + "\n");
        for (int i = 0; i < this.sectionNamesList.size(); ++i) {
            ArrayList<Vertex> vertListForSect = this.vertexListForSections.get(i);
            ArrayList<SimulatorElement> rectElemForSect = this.rectElementsListForSections.get(i);
            String fault_id = this.faultIDs_ForSections == null ? "NA" : this.faultIDs_ForSections.get(i).toString();
            efw.write("201 " + (i + 1) + " " + this.sectionNamesList.get(i) + " " + vertListForSect.size() + " 0 " + rectElemForSect.size() + " " + this.getMinMaxFileString(vertListForSect, true) + " " + fault_id + "\n");
            for (int v = 0; v < vertListForSect.size(); ++v) {
                Vertex vert = vertListForSect.get(v);
                efw.write("202 " + vert.getID() + " " + (float)vert.getLatitude() + " " + (float)vert.getLongitude() + " " + (float)(vert.getDepth() * -1000.0) + " " + (float)vert.getDAS() * 1000.0f + " " + vert.getTraceFlag() + "\n");
            }
            for (int e = 0; e < rectElemForSect.size(); ++e) {
                RectangularElement elem = (RectangularElement)rectElemForSect.get(e);
                Vertex[] vert = elem.getVertices();
                FocalMechanism focalMech = elem.getFocalMechanism();
                efw.write("204 " + elem.getID() + " " + vert[0].getID() + " " + vert[1].getID() + " " + vert[2].getID() + " " + vert[3].getID() + " " + (float)focalMech.getRake() + " " + (float)(elem.getSlipRate() / 3.1536E7) + " " + (float)elem.getAseisFactor() + " " + (float)focalMech.getStrike() + " " + (float)focalMech.getDip() + " " + elem.getPerfectInt() + "\n");
            }
        }
        efw.write("999 End\n");
        efw.close();
    }

    private String getMinMaxFileString(ArrayList<Vertex> vertexList, boolean includeDAS) {
        double minLat = Double.MAX_VALUE;
        double maxLat = -1.7976931348623157E308;
        double minLon = Double.MAX_VALUE;
        double maxLon = -1.7976931348623157E308;
        double minDep = Double.MAX_VALUE;
        double maxDep = -1.7976931348623157E308;
        double minDAS = Double.MAX_VALUE;
        double maxDAS = -1.7976931348623157E308;
        for (Vertex vertex : vertexList) {
            if (vertex.getLatitude() < minLat) {
                minLat = vertex.getLatitude();
            }
            if (vertex.getLongitude() < minLon) {
                minLon = vertex.getLongitude();
            }
            if (vertex.getDepth() < minDep) {
                minDep = vertex.getDepth();
            }
            if (vertex.getDAS() < minDAS) {
                minDAS = vertex.getDAS();
            }
            if (vertex.getLatitude() > maxLat) {
                maxLat = vertex.getLatitude();
            }
            if (vertex.getLongitude() > maxLon) {
                maxLon = vertex.getLongitude();
            }
            if (vertex.getDepth() > maxDep) {
                maxDep = vertex.getDepth();
            }
            if (!(vertex.getDAS() > maxDAS)) continue;
            maxDAS = vertex.getDAS();
        }
        String string = (float)minLat + " " + (float)maxLat + " " + (float)minLon + " " + (float)maxLon + " " + (float)maxDep * -1000.0f + " " + (float)minDep * -1000.0f;
        if (includeDAS) {
            string = string + " " + (float)minDAS * 1000.0f + " " + (float)maxDAS * 1000.0f;
        }
        return string;
    }

    public ArbIncrementalMagFreqDist computeTotalMagFreqDist(double minMag, double maxMag, int numMag, boolean makePlot, boolean savePlot) {
        ArbIncrementalMagFreqDist mfd = new ArbIncrementalMagFreqDist(minMag, maxMag, numMag);
        double simDurr = this.getSimulationDurationYears();
        for (EQSIM_Event event : this.eventList) {
            mfd.addResampledMagRate(event.getMagnitude(), 1.0 / simDurr, true);
        }
        mfd.setName("Total Simulator Incremental Mag Freq Dist");
        mfd.setInfo("  ");
        if (makePlot) {
            ArrayList<EvenlyDiscretizedFunc> mfdList = new ArrayList<EvenlyDiscretizedFunc>();
            mfdList.add(mfd);
            mfdList.add(mfd.getCumRateDistWithOffset());
            ((DiscretizedFunc)mfdList.get(1)).setName("Total Simulator Cumulative Mag Freq Dist");
            ((DiscretizedFunc)mfdList.get(1)).setInfo(" ");
            double totRate = TotalMag5Rate.RATE_7p9.getRateMag5();
            GutenbergRichterMagFreqDist grDist = new GutenbergRichterMagFreqDist(1.0, totRate, 5.05, 9.95, 50);
            EvenlyDiscretizedFunc cumGR = grDist.getCumRateDistWithOffset();
            cumGR.setName("Perfect GR with total rate = " + totRate);
            cumGR.setInfo("");
            mfdList.add(cumGR);
            ArrayList<PlotCurveCharacterstics> curveChar = new ArrayList<PlotCurveCharacterstics>();
            curveChar.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.BLACK));
            curveChar.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.RED));
            curveChar.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.GRAY));
            GraphWindow graph = new GraphWindow(mfdList, "Total Mag Freq Dist", curveChar);
            graph.setX_AxisLabel("Magnitude");
            graph.setY_AxisLabel("Rate (per yr)");
            graph.setX_AxisRange(4.5, 8.5);
            double yMin = 1.0E-6;
            double yMax = 20.0;
            graph.setY_AxisRange(yMin, yMax);
            graph.setYLog(true);
            if (savePlot) {
                try {
                    graph.saveAsPDF(this.dirNameForSavingFiles + "/TotalMagFreqDist.pdf");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return mfd;
    }

    public ArrayList<ArbIncrementalMagFreqDist> computeMagFreqDistByFaultSection(double minMag, double maxMag, int numMag, boolean makeOnePlotWithAll, boolean makeSeparatePlots, boolean savePlots) {
        ArrayList<ArbIncrementalMagFreqDist> mfdList = new ArrayList<ArbIncrementalMagFreqDist>();
        for (int s = 0; s < this.sectionNamesList.size(); ++s) {
            ArbIncrementalMagFreqDist mfd = new ArbIncrementalMagFreqDist(minMag, maxMag, numMag);
            mfd.setName(this.sectionNamesList.get(s) + " Incremental MFD");
            mfd.setInfo(" ");
            mfdList.add(mfd);
        }
        double simDurr = this.getSimulationDurationYears();
        for (EQSIM_Event event : this.eventList) {
            int sectionIndex = event.get(0).getSectionID() - 1;
            ((ArbIncrementalMagFreqDist)mfdList.get(sectionIndex)).addResampledMagRate(event.getMagnitude(), 1.0 / simDurr, true);
        }
        double yMin = Math.pow(10.0, Math.floor(Math.log10(1.0 / this.getSimulationDurationYears())));
        if (makeOnePlotWithAll) {
            GraphWindow graph = new GraphWindow(mfdList, "Mag Freq Dists (Incremental)");
            graph.setX_AxisLabel("Magnitude");
            graph.setY_AxisLabel("Rate (per yr)");
            graph.setX_AxisRange(4.5, 8.5);
            double yMax = graph.getY_AxisRange().getUpperBound();
            if (yMin < yMax) {
                graph.setY_AxisRange(yMin, yMax);
                graph.setYLog(true);
            }
            if (savePlots) {
                try {
                    graph.saveAsPDF(this.dirNameForSavingFiles + "/MagFreqDistForAllSections.pdf");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (makeSeparatePlots) {
            int sectNum = -1;
            for (ArbIncrementalMagFreqDist mfd : mfdList) {
                ++sectNum;
                ArrayList<EvenlyDiscretizedFunc> mfdList2 = new ArrayList<EvenlyDiscretizedFunc>();
                mfdList2.add(mfd);
                mfdList2.add(mfd.getCumRateDistWithOffset());
                ((EvenlyDiscretizedFunc)mfdList2.get(1)).setName(this.sectionNamesList.get(sectNum) + " Cumulative MFD");
                ((EvenlyDiscretizedFunc)mfdList2.get(1)).setInfo(" ");
                GraphWindow graph = new GraphWindow(mfdList2, this.sectionNamesList.get(sectNum) + " MFD");
                graph.setX_AxisLabel("Magnitude");
                graph.setY_AxisLabel("Rate (per yr)");
                graph.setX_AxisRange(4.5, 8.5);
                double yMax = graph.getY_AxisRange().getUpperBound();
                if (yMin < yMax) {
                    graph.setY_AxisRange(yMin, yMax);
                    graph.setYLog(true);
                }
                if (!savePlots) continue;
                try {
                    graph.saveAsPDF(this.dirNameForSavingFiles + "/MagFreqDistFor" + this.sectionNamesList.get(sectNum) + ".pdf");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return mfdList;
    }

    public int getNumEventsWithElementSlipData() {
        int numTrue = 0;
        for (EQSIM_Event event : this.eventList) {
            if (!event.hasElementSlipsAndIDs()) continue;
            ++numTrue;
        }
        return numTrue;
    }

    public ArrayList<EQSIM_Event> getEventsList() {
        return this.eventList;
    }

    public HashMap<Integer, EQSIM_Event> getEventsHashMap() {
        HashMap<Integer, EQSIM_Event> map = new HashMap<Integer, EQSIM_Event>();
        for (EQSIM_Event event : this.getEventsList()) {
            map.put(event.getID(), event);
        }
        return map;
    }

    public void randomizeEventTimes() {
        System.out.println("Event Times have been randomized");
        double firstEventTime = this.eventList.get(0).getTime();
        double simDurInSec = this.eventList.get(this.eventList.size() - 1).getTime() - firstEventTime;
        for (EQSIM_Event event : this.eventList) {
            event.setTime(firstEventTime + Math.random() * simDurInSec);
        }
        Collections.sort(this.eventList);
    }

    public void plotYearlyEventRates() {
        double startTime = this.eventList.get(0).getTime();
        int numYears = (int)this.getSimulationDurationYears();
        EvenlyDiscretizedFunc evPerYear = new EvenlyDiscretizedFunc(0.0, numYears + 1, 1.0);
        for (EQSIM_Event event : this.eventList) {
            int year = (int)((event.getTime() - startTime) / 3.1536E7);
            evPerYear.add(year, 1.0);
        }
        ArrayList<EvenlyDiscretizedFunc> funcList = new ArrayList<EvenlyDiscretizedFunc>();
        funcList.add(evPerYear);
        GraphWindow graph = new GraphWindow(funcList, "Num Events Per Year");
        graph.setX_AxisLabel("Year");
        graph.setY_AxisLabel("Number");
    }

    public void plotSAF_EventsAlongStrikeVsTime(double magThresh, int maxNumEvents) {
        ArrayList<ArbitrarilyDiscretizedFunc> funcList = new ArrayList<ArbitrarilyDiscretizedFunc>();
        int numSAF_Events = 0;
        for (EQSIM_Event event : this.eventList) {
            if (!this.isEventSupraSeismogenic(event, magThresh) || !this.doesEventUtilizedFault(event, 1)) continue;
            if (++numSAF_Events > maxNumEvents) break;
            double minDAS = Double.MAX_VALUE;
            double maxDAS = Double.NEGATIVE_INFINITY;
            for (int i = 0; i < event.size(); ++i) {
                EQSIM_EventRecord rec = event.get(i);
                int sectIndex = rec.getSectionID() - 1;
                if (this.faultIDs_ForSections.get(sectIndex) != 1) continue;
                if (rec.getMinDAS() < minDAS) {
                    minDAS = rec.getMinDAS();
                }
                if (!(rec.getMaxDAS() > maxDAS)) continue;
                maxDAS = rec.getMaxDAS();
            }
            ArbitrarilyDiscretizedFunc func = new ArbitrarilyDiscretizedFunc();
            func.set(minDAS / 1000.0, event.getTimeInYears());
            func.set(maxDAS / 1000.0, event.getTimeInYears());
            funcList.add(func);
        }
        GraphWindow graph = new GraphWindow(funcList, "SAF Events");
        graph.setX_AxisLabel("Distance Along Strike (km)");
        graph.setY_AxisLabel("Number");
    }

    public static HistogramFunction getNormRI_Distribution(ArrayList<Double> normRI_List, double deltaT) {
        double max = 0.0;
        for (Double val : normRI_List) {
            if (!(val > max)) continue;
            max = val;
        }
        int num = (int)Math.ceil(max / deltaT) + 2;
        HistogramFunction dist = new HistogramFunction(deltaT / 2.0, num, deltaT);
        dist.setTolerance(2.0 * deltaT);
        int numData = normRI_List.size();
        for (Double val : normRI_List) {
            dist.add(val, 1.0 / ((double)numData * deltaT));
        }
        return dist;
    }

    public static ArrayList<EvenlyDiscretizedFunc> getRenewalModelFunctionFitsToDist(EvenlyDiscretizedFunc dist) {
        ArrayList<EvenlyDiscretizedFunc> funcList = new ArrayList<EvenlyDiscretizedFunc>();
        BPT_DistCalc bpt_calc = new BPT_DistCalc();
        bpt_calc.fitToThisFunction(dist, 0.5, 1.5, 11, 0.1, 1.5, 151);
        EvenlyDiscretizedFunc fitBPT_func = bpt_calc.getPDF();
        fitBPT_func.setName("Best Fit BPT Dist");
        fitBPT_func.setInfo("(mean=" + (float)bpt_calc.getMean() + ", aper=" + (float)bpt_calc.getAperiodicity() + ")");
        funcList.add(fitBPT_func);
        LognormalDistCalc logNorm_calc = new LognormalDistCalc();
        logNorm_calc.fitToThisFunction(dist, 0.5, 1.5, 11, 0.1, 1.5, 141);
        EvenlyDiscretizedFunc fitLogNorm_func = logNorm_calc.getPDF();
        fitLogNorm_func.setName("Best Fit Lognormal Dist");
        fitLogNorm_func.setInfo("(mean=" + (float)logNorm_calc.getMean() + ", aper=" + (float)logNorm_calc.getAperiodicity() + ")");
        funcList.add(fitLogNorm_func);
        WeibullDistCalc weibull_calc = new WeibullDistCalc();
        weibull_calc.fitToThisFunction(dist, 0.5, 1.5, 11, 0.1, 1.5, 141);
        EvenlyDiscretizedFunc fitWeibull_func = weibull_calc.getPDF();
        fitWeibull_func.setName("Best Fit Weibull Dist");
        fitWeibull_func.setInfo("(mean=" + (float)weibull_calc.getMean() + ", aper=" + (float)weibull_calc.getAperiodicity() + ")");
        funcList.add(fitWeibull_func);
        return funcList;
    }

    public static HeadlessGraphPanel getNormRI_DistributionGraphPanel(ArrayList<Double> normRI_List, String plotTitle) {
        double delta = 0.1;
        HistogramFunction dist = OldGeneral_EQSIM_Tools.getNormRI_Distribution(normRI_List, delta);
        ArrayList<EvenlyDiscretizedFunc> funcList = OldGeneral_EQSIM_Tools.getRenewalModelFunctionFitsToDist(dist);
        dist.setName("Recur. Int. Dist");
        dist.setInfo("Number of points = " + normRI_List.size() + "\nMean=" + dist.computeMean() + "\nCOV=" + dist.computeCOV());
        funcList.add(dist);
        ArrayList<PlotCurveCharacterstics> curveCharacteristics = new ArrayList<PlotCurveCharacterstics>();
        curveCharacteristics.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLACK));
        curveCharacteristics.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLUE));
        curveCharacteristics.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.GREEN));
        curveCharacteristics.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 2.0f, Color.RED));
        HeadlessGraphPanel gp = new HeadlessGraphPanel();
        gp.setUserBounds(new Range(0.0, 5.0), null);
        gp.drawGraphPanel("RI (yrs)", "Density", funcList, curveCharacteristics, plotTitle);
        gp.getChartPanel().setSize(1000, 800);
        return gp;
    }

    public static GraphWindow plotNormRI_Distribution(ArrayList<Double> normRI_List, String plotTitle, double bptAperForComparison) {
        double delta = 0.1;
        HistogramFunction dist = OldGeneral_EQSIM_Tools.getNormRI_Distribution(normRI_List, delta);
        dist.setName("Recur. Int. Dist");
        String info = "Number of points = " + normRI_List.size() + "\nComputed mean = " + (float)dist.computeMean() + "\nComputed COV = " + (float)dist.computeCOV();
        dist.setInfo(info);
        ArrayList<EvenlyDiscretizedFunc> funcList = new ArrayList<EvenlyDiscretizedFunc>();
        funcList.add(dist);
        funcList.addAll(OldGeneral_EQSIM_Tools.getRenewalModelFunctionFitsToDist(dist));
        ArrayList<PlotCurveCharacterstics> curveCharacteristics = new ArrayList<PlotCurveCharacterstics>();
        curveCharacteristics.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 2.0f, Color.RED));
        curveCharacteristics.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLACK));
        curveCharacteristics.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLUE));
        curveCharacteristics.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.GREEN));
        if (!Double.isNaN(bptAperForComparison)) {
            BPT_DistCalc bpt_calc = new BPT_DistCalc();
            bpt_calc.setAll(1.0, bptAperForComparison, ((EvenlyDiscretizedFunc)funcList.get(1)).getDelta() / 2.0, ((EvenlyDiscretizedFunc)funcList.get(1)).size());
            EvenlyDiscretizedFunc bpt_func = bpt_calc.getPDF();
            bpt_func.setName("BPT Dist for comparison");
            bpt_func.setInfo("(mean=1.0, aper=" + bptAperForComparison + ")");
            funcList.add(bpt_func);
            curveCharacteristics.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.GRAY));
        }
        GraphWindow graph = new GraphWindow(funcList, plotTitle, curveCharacteristics);
        graph.setX_AxisLabel("RI (yrs)");
        graph.setY_AxisLabel("Density");
        graph.setX_AxisRange(0.0, 5.0);
        graph.setY_AxisRange(0.0, 2.3);
        graph.setAxisLabelFontSize(22);
        graph.setTickLabelFontSize(20);
        graph.setPlotLabelFontSize(22);
        return graph;
    }

    public void testTemp() {
        System.out.println(this.isEventSupraSeismogenic(this.eventList.get(314951), Double.NaN));
    }

    public void plotNormRI_AtHypocenters(double supraSeisMagThresh, boolean saveStuff) {
        double[] lastTimeForElement = new double[this.rectElementsList.size()];
        int[] lastEventID_ForElement = new int[this.rectElementsList.size()];
        for (int i = 0; i < lastTimeForElement.length; ++i) {
            lastTimeForElement[i] = Double.NaN;
            lastEventID_ForElement[i] = -1;
        }
        double[] aveRI_ForElement = new double[this.rectElementsList.size()];
        int[] numEventsForElement = new int[this.rectElementsList.size()];
        for (EQSIM_Event event : this.eventList) {
            double eventTime = event.getTime();
            if (!event.hasElementSlipsAndIDs() || !this.isEventSupraSeismogenic(event, supraSeisMagThresh)) continue;
            int[] elemIDs = event.getAllElementIDs();
            int numElements = elemIDs.length;
            for (int e = 0; e < numElements; ++e) {
                int index;
                int n = index = elemIDs[e] - 1;
                numEventsForElement[n] = numEventsForElement[n] + 1;
                double lastTime = lastTimeForElement[index];
                if (!Double.isNaN(lastTime)) {
                    int n2 = index;
                    aveRI_ForElement[n2] = aveRI_ForElement[n2] + (eventTime - lastTime);
                }
                lastTimeForElement[index] = eventTime;
            }
        }
        int i = 0;
        while (i < aveRI_ForElement.length) {
            int n = i;
            aveRI_ForElement[n] = aveRI_ForElement[n] / (double)(numEventsForElement[i] - 1);
            int n3 = i++;
            aveRI_ForElement[n3] = aveRI_ForElement[n3] / 3.1536E7;
        }
        for (i = 0; i < lastTimeForElement.length; ++i) {
            lastTimeForElement[i] = -1.0;
        }
        CalcProgressBar progressBar = new CalcProgressBar("testTimePredictability", "Events Processed");
        progressBar.showProgress(true);
        int eventNum = -1;
        ArrayList<Double> normRI_List = new ArrayList<Double>();
        for (EQSIM_Event event : this.eventList) {
            double eventTime = event.getTime();
            progressBar.updateProgress(++eventNum, this.eventList.size());
            if (!event.hasElementSlipsAndIDs() || !this.isEventSupraSeismogenic(event, supraSeisMagThresh)) continue;
            int hypoElemID = event.get(0).getHypocenterElementID();
            int hypoElemIndex = hypoElemID - 1;
            double lastTime = lastTimeForElement[hypoElemIndex];
            if (lastTime != -1.0) {
                double normRI = (eventTime - lastTime) / 3.1536E7 / aveRI_ForElement[hypoElemIndex];
                normRI_List.add(normRI);
                if (normRI < 0.1) {
                    System.out.println(normRI + "\t" + event.getID() + "\t" + lastEventID_ForElement[hypoElemIndex] + "\t" + hypoElemID);
                }
            }
            for (int id : event.getAllElementIDs()) {
                int index = id - 1;
                lastTimeForElement[index] = eventTime;
                lastEventID_ForElement[index] = event.getID();
            }
        }
        GraphWindow plot = ProbModelsPlottingUtils.plotNormRI_DistributionWithFits(ProbModelsPlottingUtils.getNormRI_DistributionWithFits(normRI_List, Double.NaN), "Normalized Hypocenter RI");
        if (saveStuff) {
            try {
                plot.saveAsPDF(this.dirNameForSavingFiles + "/normRI_atHypocenters.pdf");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public String testTimePredictability(double supraSeisMagThresh, boolean saveStuff, Integer testElementID, boolean plotSectionResults) {
        Object linesFor_fw_timePred = new String();
        Object tempInfoString = new String();
        double[] lastTimeForElement = new double[this.rectElementsList.size()];
        double[] lastSlipForElement = new double[this.rectElementsList.size()];
        for (int i = 0; i < lastTimeForElement.length; ++i) {
            lastTimeForElement[i] = Double.NaN;
        }
        double[] aveRI_ForElement = new double[this.rectElementsList.size()];
        double[] aveSlipForElement = new double[this.rectElementsList.size()];
        int[] numEventsForElement = new int[this.rectElementsList.size()];
        for (EQSIM_Event event : this.eventList) {
            double eventTime = event.getTime();
            if (!event.hasElementSlipsAndIDs() || !this.isEventSupraSeismogenic(event, supraSeisMagThresh)) continue;
            double[] slips = event.getAllElementSlips();
            int[] elemIDs = event.getAllElementIDs();
            int numElements = slips.length;
            for (int e = 0; e < numElements; ++e) {
                int index;
                int n = index = elemIDs[e] - 1;
                aveSlipForElement[n] = aveSlipForElement[n] + slips[e];
                int n2 = index;
                numEventsForElement[n2] = numEventsForElement[n2] + 1;
                double lastTime = lastTimeForElement[index];
                if (!Double.isNaN(lastTime)) {
                    int n3 = index;
                    aveRI_ForElement[n3] = aveRI_ForElement[n3] + (eventTime - lastTime);
                }
                lastTimeForElement[index] = eventTime;
            }
        }
        int i = 0;
        while (i < aveRI_ForElement.length) {
            int n = i;
            aveRI_ForElement[n] = aveRI_ForElement[n] / (double)(numEventsForElement[i] - 1);
            int n4 = i;
            aveSlipForElement[n4] = aveSlipForElement[n4] / (double)numEventsForElement[i];
            int n5 = i++;
            aveRI_ForElement[n5] = aveRI_ForElement[n5] / 3.1536E7;
        }
        for (i = 0; i < lastTimeForElement.length; ++i) {
            lastTimeForElement[i] = -1.0;
        }
        int numBad = 0;
        double minElementArea = Double.MAX_VALUE;
        double maxElementArea = 0.0;
        int counter = -1;
        ArrayList<Double> obsIntervalList = new ArrayList<Double>();
        ArrayList<Double> tpInterval1List = new ArrayList<Double>();
        ArrayList<Double> tpInterval2List = new ArrayList<Double>();
        ArrayList<Double> spInterval1List = new ArrayList<Double>();
        ArrayList<Double> spInterval2List = new ArrayList<Double>();
        ArrayList<Double> aveSlipRateList = new ArrayList<Double>();
        ArrayList<Double> aveElementIntervalList = new ArrayList<Double>();
        ArrayList<Double> norm_aveElementIntervalList = new ArrayList<Double>();
        ArrayList<Double> norm_aveElementIntervalLowMagList = new ArrayList<Double>();
        ArrayList<Double> norm_aveElementIntervalMidMagList = new ArrayList<Double>();
        ArrayList<Double> norm_aveElementIntervalHighMagList = new ArrayList<Double>();
        ArrayList<Double> norm_aveElementIntervalAlt1_List = new ArrayList<Double>();
        ArrayList<Double> norm_aveElementIntervalAlt2_List = new ArrayList<Double>();
        ArrayList<Double> norm_aveElementIntervalAlt2_LowMagList = new ArrayList<Double>();
        ArrayList<Double> norm_aveElementIntervalAlt2_MidMagList = new ArrayList<Double>();
        ArrayList<Double> norm_aveElementIntervalAlt2_HighMagList = new ArrayList<Double>();
        ArrayList<Double> norm_tpInterval1List = new ArrayList<Double>();
        ArrayList<Double> norm_spInterval1List = new ArrayList<Double>();
        ArrayList<Double> norm_tpInterval2List = new ArrayList<Double>();
        ArrayList<Double> norm_spInterval2List = new ArrayList<Double>();
        ArrayList<Double> norm_lastEventSlipList = new ArrayList<Double>();
        ArrayList<Double> norm_nextEventSlipList = new ArrayList<Double>();
        ArrayList<Integer> nucleationSectionList = new ArrayList<Integer>();
        boolean eventUtilizesTestElement = false;
        ArrayList<Double> tpInterval2ListForTestElement = new ArrayList<Double>();
        ArrayList<Double> spInterval2ListForTestElement = new ArrayList<Double>();
        tempInfoString = (String)tempInfoString + "supraSeisMagThresh = " + supraSeisMagThresh + "\n";
        linesFor_fw_timePred = (String)linesFor_fw_timePred + "counter\tobsInterval\ttpInterval1\tnorm_tpInterval1\ttpInterval2\tnorm_tpInterval2\tspInterval1\tnorm_spInterval1\tspInterval2\tnorm_spInterval2\tnorm_aveElementInterval\tnorm_aveElementIntervalAlt1\tnorm_aveElementIntervalAlt2\taveLastSlip\taveSlip\tnorm_lastEventSlip\tnorm_nextEventSlip\teventMag\teventID\tfirstSectionID\tnumSectionsInEvent\tsectionsInEventString\n";
        double startNormDistAlong = 0.0125;
        double deltaNormDistAlong = 0.025;
        int numDistAlong = 20;
        HistogramFunction aveNormRI_AlongRup = new HistogramFunction(startNormDistAlong, numDistAlong, deltaNormDistAlong);
        HistogramFunction numRIsAlongHist = new HistogramFunction(startNormDistAlong, numDistAlong, deltaNormDistAlong);
        HistogramFunction[] riDistsAlongAlongRup = new HistogramFunction[numDistAlong];
        for (int i2 = 0; i2 < numDistAlong; ++i2) {
            riDistsAlongAlongRup[i2] = new HistogramFunction(0.05, 50, 0.1);
        }
        CalcProgressBar progressBar = new CalcProgressBar("testTimePredictability", "Events Processed");
        progressBar.showProgress(true);
        int eventNum = -1;
        for (EQSIM_Event event : this.eventList) {
            int index;
            int e;
            double eventTime = event.getTime();
            progressBar.updateProgress(++eventNum, this.eventList.size());
            if (!event.hasElementSlipsAndIDs() || !this.isEventSupraSeismogenic(event, supraSeisMagThresh)) continue;
            boolean goodSample = true;
            double eventMag = event.getMagnitude();
            Object sectionsInEventString = new String();
            double[] slips = event.getAllElementSlips();
            int[] elemIDs = event.getAllElementIDs();
            double[] normDistAlong = event.getNormDistAlongRupForElements();
            for (EventRecord evRec : event) {
                if (eventTime != evRec.getTime()) {
                    throw new RuntimeException("problem with event times");
                }
                sectionsInEventString = (String)sectionsInEventString + this.sectionNamesList.get(evRec.getSectionID() - 1) + " + ";
            }
            double aveLastEvTime = 0.0;
            double ave_tpNextEvTime = 0.0;
            double ave_spNextEvTime = 0.0;
            double aveSlipRate = 0.0;
            double aveLastSlip = 0.0;
            double aveEventSlip = 0.0;
            double aveSlipOverElements = 0.0;
            double aveElementInterval = 0.0;
            double aveElementIntervalFromRates = 0.0;
            double aveNormTimeSinceLast = 0.0;
            int numElementsUsed = 0;
            int numNormDistProblems = 0;
            for (int e2 = 0; e2 < slips.length; ++e2) {
                int index2 = elemIDs[e2] - 1;
                double lastTime = lastTimeForElement[index2];
                double lastSlip = lastSlipForElement[index2];
                double slipRate = this.rectElementsList.get(index2).getSlipRate();
                double area = this.rectElementsList.get(index2).getArea();
                if (area < minElementArea) {
                    minElementArea = area;
                }
                if (area > maxElementArea) {
                    maxElementArea = area;
                }
                if (slipRate != 0.0) {
                    aveLastEvTime += lastTime;
                    ave_tpNextEvTime += lastTime + lastSlip / (slipRate / 3.1536E7);
                    ave_spNextEvTime += lastTime + slips[e2] / (slipRate / 3.1536E7);
                    aveSlipRate += slipRate / 3.1536E7;
                    aveLastSlip += lastSlip;
                    aveEventSlip += slips[e2];
                    aveElementInterval += aveRI_ForElement[index2];
                    aveElementIntervalFromRates += 1.0 / aveRI_ForElement[index2];
                    aveSlipOverElements += aveSlipForElement[index2];
                    aveNormTimeSinceLast += (eventTime - lastTime) / 3.1536E7 / aveRI_ForElement[index2];
                    ++numElementsUsed;
                    if (lastTime != -1.0 && normDistAlong != null) {
                        int distAlongIndex;
                        double normRI_forElement = (eventTime - lastTime) / 3.1536E7 / aveRI_ForElement[index2];
                        double distFromEnd = normDistAlong[e2];
                        if (distFromEnd > 0.5) {
                            distFromEnd = 1.0 - distFromEnd;
                        }
                        if ((distAlongIndex = aveNormRI_AlongRup.getXIndex(distFromEnd)) == -1) {
                            ++numNormDistProblems;
                            break;
                        }
                        HistogramFunction hist = riDistsAlongAlongRup[distAlongIndex];
                        int xIndexForHist = hist.getClosestXIndex(normRI_forElement);
                        hist.add(xIndexForHist, 1.0);
                        aveNormRI_AlongRup.add(distFromEnd, normRI_forElement);
                        numRIsAlongHist.add(distFromEnd, 1.0);
                    }
                }
                if (lastTime != -1.0) continue;
                goodSample = false;
            }
            if (numNormDistProblems > 0) {
                tempInfoString = (String)tempInfoString + "WARNING! - Problem with NormalizedSlipAlongRup.pdf (norm distance outside bounds for " + numNormDistProblems + " events)\n";
            }
            aveLastEvTime /= (double)numElementsUsed;
            ave_tpNextEvTime /= (double)numElementsUsed;
            ave_spNextEvTime /= (double)numElementsUsed;
            aveSlipRate /= (double)numElementsUsed;
            aveLastSlip /= (double)numElementsUsed;
            aveEventSlip /= (double)numElementsUsed;
            aveElementInterval /= (double)numElementsUsed;
            aveElementIntervalFromRates = (double)numElementsUsed / aveElementIntervalFromRates;
            aveSlipOverElements /= (double)numElementsUsed;
            aveNormTimeSinceLast /= (double)numElementsUsed;
            double obsInterval = (eventTime - aveLastEvTime) / 3.1536E7;
            double tpInterval1 = (ave_tpNextEvTime - aveLastEvTime) / 3.1536E7;
            double tpInterval2 = aveLastSlip / aveSlipRate / 3.1536E7;
            double spInterval1 = (ave_spNextEvTime - aveLastEvTime) / 3.1536E7;
            double spInterval2 = aveEventSlip / aveSlipRate / 3.1536E7;
            double norm_tpInterval1 = obsInterval / tpInterval1;
            double norm_tpInterval2 = obsInterval / tpInterval2;
            double norm_spInterval1 = obsInterval / spInterval1;
            double norm_spInterval2 = obsInterval / spInterval2;
            double norm_aveElementInterval = obsInterval / aveElementInterval;
            double norm_aveElementIntervalAlt1 = obsInterval / aveElementIntervalFromRates;
            double norm_aveElementIntervalAlt2 = aveNormTimeSinceLast;
            double norm_lastEventSlip = aveLastSlip / aveSlipOverElements;
            double norm_nextEventSlip = aveEventSlip / aveSlipOverElements;
            if (norm_tpInterval1 < 0.0 && goodSample) {
                System.out.println("obsInterval=" + obsInterval);
                System.out.println("tpInterval1=" + tpInterval1);
                System.out.println("tpInterval2=" + tpInterval2);
                System.out.println("ave_tpNextEvTime=" + ave_tpNextEvTime);
                System.out.println("aveLastEvTime=" + aveLastEvTime);
                System.out.println("numElements=" + numElementsUsed);
                System.out.println("elemIDs\teventID\teventMag\teventArea\ttpInterval1\tlastTime\tlastSlip\tslipRate\t(lastSlip/slipRate)\tsectsInEvent");
                for (e = 0; e < numElementsUsed; ++e) {
                    index = elemIDs[e] - 1;
                    double lastTime = lastTimeForElement[index];
                    double lastSlip = lastSlipForElement[index];
                    double slipRate = this.rectElementsList.get(index).getSlipRate();
                    System.out.println(elemIDs[e] + "\t" + event.getID() + "\t" + eventMag + "\t" + event.getArea() + "\t" + tpInterval1 + "\t" + lastTime + "\t" + lastSlip + "\t" + (float)slipRate + "\t" + (float)(lastSlip / slipRate) + "\t" + (String)sectionsInEventString);
                }
                throw new RuntimeException("norm_tpInterval1 is negative: " + norm_tpInterval1);
            }
            if (aveSlipRate == 0.0) {
                goodSample = false;
            }
            if (testElementID != null) {
                eventUtilizesTestElement = Ints.contains((int[])elemIDs, (int)testElementID);
            }
            if (goodSample) {
                linesFor_fw_timePred = (String)linesFor_fw_timePred + ++counter + "\t" + obsInterval + "\t" + tpInterval1 + "\t" + (float)norm_tpInterval1 + "\t" + tpInterval2 + "\t" + (float)norm_tpInterval2 + "\t" + spInterval1 + "\t" + (float)norm_spInterval1 + "\t" + spInterval2 + "\t" + (float)norm_spInterval2 + "\t" + (float)norm_aveElementInterval + "\t" + (float)norm_aveElementIntervalAlt1 + "\t" + (float)norm_aveElementIntervalAlt2 + "\t" + (float)aveLastSlip + "\t" + (float)aveEventSlip + "\t" + (float)norm_lastEventSlip + "\t" + (float)norm_nextEventSlip + "\t" + (float)eventMag + "\t" + event.getID() + "\t" + event.get(0).getSectionID() + "\t" + event.size() + "\t" + (String)sectionsInEventString + "\n";
                obsIntervalList.add(obsInterval);
                tpInterval1List.add(tpInterval1);
                tpInterval2List.add(tpInterval2);
                spInterval1List.add(spInterval1);
                spInterval2List.add(spInterval2);
                aveSlipRateList.add(aveSlipRate);
                aveElementIntervalList.add(aveElementInterval);
                nucleationSectionList.add(event.get(0).getSectionID());
                norm_aveElementIntervalList.add(norm_aveElementInterval);
                if (eventMag <= 6.7) {
                    norm_aveElementIntervalLowMagList.add(norm_aveElementInterval);
                } else if (eventMag <= 7.7) {
                    norm_aveElementIntervalMidMagList.add(norm_aveElementInterval);
                } else {
                    norm_aveElementIntervalHighMagList.add(norm_aveElementInterval);
                }
                if (norm_aveElementIntervalAlt1 < 50.0) {
                    norm_aveElementIntervalAlt1_List.add(norm_aveElementIntervalAlt1);
                } else {
                    norm_aveElementIntervalAlt1_List.add(50.0);
                    System.out.println("Strange norm_aveElementIntervalAlt1: " + norm_aveElementIntervalAlt1 + "\naveElementIntervalFromRates=" + aveElementIntervalFromRates + "\n Element RIs:");
                    for (e = 0; e < slips.length; ++e) {
                        index = elemIDs[e] - 1;
                        double slipRate = this.rectElementsList.get(index).getSlipRate();
                        if (slipRate == 0.0) continue;
                        System.out.println("\t" + e + "\t" + aveRI_ForElement[index]);
                    }
                }
                norm_aveElementIntervalAlt2_List.add(norm_aveElementIntervalAlt2);
                if (eventMag <= 6.7) {
                    norm_aveElementIntervalAlt2_LowMagList.add(norm_aveElementIntervalAlt2);
                } else if (eventMag <= 7.7) {
                    norm_aveElementIntervalAlt2_MidMagList.add(norm_aveElementIntervalAlt2);
                } else {
                    norm_aveElementIntervalAlt2_HighMagList.add(norm_aveElementIntervalAlt2);
                }
                norm_tpInterval1List.add(norm_tpInterval1);
                norm_spInterval1List.add(norm_spInterval1);
                norm_tpInterval2List.add(norm_tpInterval2);
                norm_spInterval2List.add(norm_spInterval2);
                norm_lastEventSlipList.add(norm_lastEventSlip);
                norm_nextEventSlipList.add(norm_nextEventSlip);
                if (testElementID != null && eventUtilizesTestElement) {
                    tpInterval2ListForTestElement.add(tpInterval2);
                    spInterval2ListForTestElement.add(spInterval2);
                }
                if (obsInterval < 1.0) {
                    String str = "Short Interval (less than 1 yr):\t" + obsInterval + " yrs) for eventID=" + event.getID() + "; mag=" + (float)eventMag + "; timeYrs=" + (float)event.getTimeInYears() + "\n";
                    tempInfoString = (String)tempInfoString + str;
                }
            } else {
                ++numBad;
            }
            for (e = 0; e < numElementsUsed; ++e) {
                index = elemIDs[e] - 1;
                lastTimeForElement[index] = eventTime;
                lastSlipForElement[index] = slips[e];
            }
        }
        progressBar.showProgress(false);
        GraphWindow plot1 = OldGeneral_EQSIM_Tools.plotNormRI_Distribution(norm_tpInterval1List, "Normalized Ave Time-Pred RI (norm_tpInterval1List)", Double.NaN);
        GraphWindow plot2 = OldGeneral_EQSIM_Tools.plotNormRI_Distribution(norm_spInterval1List, "Normalized Ave Slip-Pred RI (norm_spInterval1List)", Double.NaN);
        GraphWindow plot3 = OldGeneral_EQSIM_Tools.plotNormRI_Distribution(norm_tpInterval2List, "Normalized Ave Time-Pred RI (norm_tpInterval2List)", Double.NaN);
        GraphWindow plot4 = OldGeneral_EQSIM_Tools.plotNormRI_Distribution(norm_spInterval2List, "Normalized Ave Slip-Pred RI (norm_spInterval2List)", Double.NaN);
        GraphWindow plot6 = OldGeneral_EQSIM_Tools.plotNormRI_Distribution(norm_lastEventSlipList, "Normalized Ave Slip (X-axis is mislabeled; should be normalized slip)", Double.NaN);
        GraphWindow plot5 = ProbModelsPlottingUtils.plotNormRI_DistributionWithFits(ProbModelsPlottingUtils.getNormRI_DistributionWithFits(norm_aveElementIntervalList, Double.NaN), "Normalized Rup RI (ave elem RIs; norm_aveElementIntervalList)");
        GraphWindow plot7 = ProbModelsPlottingUtils.plotNormRI_DistributionWithFits(ProbModelsPlottingUtils.getNormRI_DistributionWithFits(norm_aveElementIntervalAlt1_List, Double.NaN), "Normalized Rup RI (ave elem rates; norm_aveElementIntervalAlt1_List)");
        GraphWindow plot8 = ProbModelsPlottingUtils.plotNormRI_DistributionWithFits(ProbModelsPlottingUtils.getNormRI_DistributionWithFits(norm_aveElementIntervalAlt2_List, Double.NaN), "Normalized Rup RI (ave norm elem RIs; norm_aveElementIntervalAlt2_List)");
        GraphWindow plot13 = ProbModelsPlottingUtils.plotNormRI_DistributionWithFits(ProbModelsPlottingUtils.getNormRI_DistributionWithFits(norm_aveElementIntervalLowMagList, Double.NaN), "M<=6.7 Norm Rup RI");
        GraphWindow plot14 = ProbModelsPlottingUtils.plotNormRI_DistributionWithFits(ProbModelsPlottingUtils.getNormRI_DistributionWithFits(norm_aveElementIntervalMidMagList, Double.NaN), "6.7<M<=7.7 Norm Rup RI");
        GraphWindow plot15 = ProbModelsPlottingUtils.plotNormRI_DistributionWithFits(ProbModelsPlottingUtils.getNormRI_DistributionWithFits(norm_aveElementIntervalHighMagList, Double.NaN), "M>7.7 Norm Rup RI");
        GraphWindow plot16 = ProbModelsPlottingUtils.plotNormRI_DistributionWithFits(ProbModelsPlottingUtils.getNormRI_DistributionWithFits(norm_aveElementIntervalAlt2_LowMagList, Double.NaN), "M<=6.7 Norm Rup RI; Alt2");
        GraphWindow plot17 = ProbModelsPlottingUtils.plotNormRI_DistributionWithFits(ProbModelsPlottingUtils.getNormRI_DistributionWithFits(norm_aveElementIntervalAlt2_MidMagList, Double.NaN), "6.7<M<=7.7 Norm Rup RI; Alt2");
        GraphWindow plot18 = ProbModelsPlottingUtils.plotNormRI_DistributionWithFits(ProbModelsPlottingUtils.getNormRI_DistributionWithFits(norm_aveElementIntervalAlt2_HighMagList, Double.NaN), "M>7.7 Norm Rup RI; Alt2");
        if (saveStuff) {
            try {
                plot1.saveAsPDF(this.dirNameForSavingFiles + "/norm_tpInterval1_Dist.pdf");
                plot2.saveAsPDF(this.dirNameForSavingFiles + "/norm_spInterval1_Dist.pdf");
                plot3.saveAsPDF(this.dirNameForSavingFiles + "/norm_tpInterval2_Dist.pdf");
                plot4.saveAsPDF(this.dirNameForSavingFiles + "/norm_spInterval2_Dist.pdf");
                plot5.saveAsPDF(this.dirNameForSavingFiles + "/norm_aveElementInterval_Dist.pdf");
                plot5.saveAsTXT(this.dirNameForSavingFiles + "/norm_aveElementInterval_Dist.txt");
                plot6.saveAsPDF(this.dirNameForSavingFiles + "/norm_aveSlip_Dist.pdf");
                plot7.saveAsPDF(this.dirNameForSavingFiles + "/norm_aveElementInterval_DistAlt1.pdf");
                plot7.saveAsTXT(this.dirNameForSavingFiles + "/norm_aveElementInterval_DistAlt1.txt");
                plot8.saveAsPDF(this.dirNameForSavingFiles + "/norm_aveElementInterval_DistAlt2.pdf");
                plot8.saveAsTXT(this.dirNameForSavingFiles + "/norm_aveElementInterval_DistAlt2.txt");
                plot13.saveAsPDF(this.dirNameForSavingFiles + "/norm_aveElementIntervalLowMag_Dist.pdf");
                plot13.saveAsTXT(this.dirNameForSavingFiles + "/norm_aveElementIntervalLowMag_Dist.txt");
                plot14.saveAsPDF(this.dirNameForSavingFiles + "/norm_aveElementIntervalMidMag_Dist.pdf");
                plot14.saveAsTXT(this.dirNameForSavingFiles + "/norm_aveElementIntervalMidMag_Dist.txt");
                plot15.saveAsPDF(this.dirNameForSavingFiles + "/norm_aveElementIntervalHighMag_Dist.pdf");
                plot15.saveAsTXT(this.dirNameForSavingFiles + "/norm_aveElementIntervalHighMag_Dist.txt");
                plot16.saveAsPDF(this.dirNameForSavingFiles + "/norm_aveElementIntervalAt2_LowMag_Dist.pdf");
                plot16.saveAsTXT(this.dirNameForSavingFiles + "/norm_aveElementIntervalAt2_LowMag_Dist.txt");
                plot17.saveAsPDF(this.dirNameForSavingFiles + "/norm_aveElementIntervalAt2_MidMag_Dist.pdf");
                plot17.saveAsTXT(this.dirNameForSavingFiles + "/norm_aveElementIntervalAt2_MidMag_Dist.txt");
                plot18.saveAsPDF(this.dirNameForSavingFiles + "/norm_aveElementIntervalAt2_HighMag_Dist.pdf");
                plot18.saveAsTXT(this.dirNameForSavingFiles + "/norm_aveElementIntervalAt2_HighMag_Dist.txt");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        tempInfoString = (String)tempInfoString + "\nCorrelations (and chance it's random) between all Observed and Predicted Intervals:\n\n";
        double[] result = this.getCorrelationAndP_Value(aveElementIntervalList, obsIntervalList);
        tempInfoString = (String)tempInfoString + "\t" + (float)result[0] + "\t(" + result[1] + ") for aveElementInterval (num pts =" + tpInterval1List.size() + ")\n";
        result = this.getCorrelationAndP_Value(tpInterval1List, obsIntervalList);
        tempInfoString = (String)tempInfoString + "\t" + (float)result[0] + "\t(" + result[1] + ") for tpInterval1 (num pts =" + tpInterval1List.size() + ")\n";
        result = this.getCorrelationAndP_Value(tpInterval2List, obsIntervalList);
        tempInfoString = (String)tempInfoString + "\t" + (float)result[0] + "\t(" + result[1] + ") for tpInterval2 (num pts =" + tpInterval2List.size() + ")\n";
        result = this.getCorrelationAndP_Value(spInterval1List, obsIntervalList);
        tempInfoString = (String)tempInfoString + "\t" + (float)result[0] + "\t(" + result[1] + ") for spInterval1 (num pts =" + spInterval1List.size() + ")\n";
        result = this.getCorrelationAndP_Value(spInterval2List, obsIntervalList);
        tempInfoString = (String)tempInfoString + "\t" + (float)result[0] + "\t(" + result[1] + ") for spInterval2 (num pts =" + spInterval2List.size() + ")\n";
        tempInfoString = (String)tempInfoString + "\nCorrelations (and chance it's random) for true time and slip predictability tests:\n\n";
        result = this.getCorrelationAndP_Value(norm_lastEventSlipList, norm_aveElementIntervalList);
        tempInfoString = (String)tempInfoString + "\t" + (float)result[0] + "\t(" + result[1] + ") for norm_lastEventSlip vs norm_aveElementInterval (num pts =" + norm_lastEventSlipList.size() + ")\n";
        result = this.getCorrelationAndP_Value(norm_nextEventSlipList, norm_aveElementIntervalList);
        tempInfoString = (String)tempInfoString + "\t" + (float)result[0] + "\t(" + result[1] + ") for norm_nextEventSlip vs norm_aveElementInterval (num pts =" + norm_nextEventSlipList.size() + ")\n";
        result = this.getCorrelationAndP_Value(norm_lastEventSlipList, norm_aveElementIntervalList);
        String info1 = "correlation=" + (float)result[0] + "\t(" + (float)result[1] + ") for norm_aveElementIntervalList vs norm_lastEventSlipList \n";
        DefaultXY_DataSet xy_data1 = new DefaultXY_DataSet(norm_lastEventSlipList, norm_aveElementIntervalList);
        xy_data1.setName("norm_aveElementIntervalList vs norm_lastEventSlipList");
        xy_data1.setInfo(info1);
        GraphWindow graph1 = new GraphWindow(xy_data1, "Norm Obs RI vs Norm Last Slip");
        graph1.setX_AxisLabel("Normalized Last-Event Slip");
        graph1.setY_AxisLabel("Normalized Recurrence Interval");
        graph1.setAllLineTypes(null, PlotSymbol.CROSS);
        graph1.setAxisRange(0.1, 10.0, 0.1, 10.0);
        graph1.setYLog(true);
        graph1.setXLog(true);
        if (saveStuff) {
            try {
                graph1.saveAsPDF(this.dirNameForSavingFiles + "/normObsRI_vsNormLastSlip.pdf");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        result = this.getCorrelationAndP_Value(norm_nextEventSlipList, norm_aveElementIntervalList);
        String info2 = "correlation=" + (float)result[0] + "\t(" + (float)result[1] + ") for norm_aveElementIntervalList vs norm_nextEventSlipList \n";
        DefaultXY_DataSet xy_data2 = new DefaultXY_DataSet(norm_nextEventSlipList, norm_aveElementIntervalList);
        xy_data2.setName("norm_aveElementIntervalList vs norm_nextEventSlipList");
        xy_data2.setInfo(info2);
        GraphWindow graph2 = new GraphWindow(xy_data2, "Norm Obs RI vs Norm Next Slip");
        graph2.setX_AxisLabel("Normalized Next-Event Slip");
        graph2.setY_AxisLabel("Normalized Recurrence Interval");
        graph2.setAllLineTypes(null, PlotSymbol.CROSS);
        graph2.setAxisRange(0.1, 10.0, 0.1, 10.0);
        graph2.setYLog(true);
        graph2.setXLog(true);
        if (saveStuff) {
            try {
                graph2.saveAsPDF(this.dirNameForSavingFiles + "/normObsRI_vsNormNextSlip.pdf");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        tempInfoString = (String)tempInfoString + "\nCorrelations (and chance it's random) between: Observed & aveElementInterval, Observed & tpInterval2, Observed & spInterval2, normObserved & normAveLastSlip, and normObserved & normAveNextSlip by Section:\n\n";
        tempInfoString = (String)tempInfoString + "\tsectID\taveElRI\tprobRand\ttpInt2\tprobRand\tspInt2\tprobRand\tnormObsVsNormLastSlip\tprobRand\tnormObsVsNormNextSlip\tprobRand\tsectName\tsectID\tnumPts\n";
        ArrayList<DefaultXY_DataSet> obs_tp2_funcs = new ArrayList<DefaultXY_DataSet>();
        HashMap<Integer, DefaultXY_DataSet> obs_tp2_funcsMap = new HashMap<Integer, DefaultXY_DataSet>();
        ArrayList<DefaultXY_DataSet> obs_aveElement_funcs = new ArrayList<DefaultXY_DataSet>();
        HashMap<Integer, DefaultXY_DataSet> obs_aveElement_funcsMap = new HashMap<Integer, DefaultXY_DataSet>();
        ArrayList<DefaultXY_DataSet> normObs_vs_normLastSlip_funcs = new ArrayList<DefaultXY_DataSet>();
        HashMap<Integer, DefaultXY_DataSet> normObs_vs_normLastSlip_funcsMap = new HashMap<Integer, DefaultXY_DataSet>();
        for (int s = 0; s < this.sectionNamesList.size(); ++s) {
            ArrayList<Double> obsVals = new ArrayList<Double>();
            ArrayList<Double> tpVals = new ArrayList<Double>();
            ArrayList<Double> spVals = new ArrayList<Double>();
            ArrayList<Double> aveElVals = new ArrayList<Double>();
            ArrayList<Double> normObsVals = new ArrayList<Double>();
            ArrayList<Double> normLastSlipVals = new ArrayList<Double>();
            ArrayList<Double> normNextSlipVals = new ArrayList<Double>();
            for (int i3 = 0; i3 < obsIntervalList.size(); ++i3) {
                if ((Integer)nucleationSectionList.get(i3) != s + 1) continue;
                obsVals.add(obsIntervalList.get(i3));
                tpVals.add(tpInterval2List.get(i3));
                spVals.add(spInterval2List.get(i3));
                aveElVals.add(aveElementIntervalList.get(i3));
                normObsVals.add(norm_aveElementIntervalList.get(i3));
                normLastSlipVals.add(norm_lastEventSlipList.get(i3));
                normNextSlipVals.add(norm_nextEventSlipList.get(i3));
            }
            if (obsVals.size() > 2) {
                double[] result0 = this.getCorrelationAndP_Value(obsVals, aveElVals);
                double[] result1 = this.getCorrelationAndP_Value(obsVals, tpVals);
                double[] result2 = this.getCorrelationAndP_Value(obsVals, spVals);
                double[] result3 = this.getCorrelationAndP_Value(normObsVals, normLastSlipVals);
                double[] result4 = this.getCorrelationAndP_Value(normObsVals, normNextSlipVals);
                String info = "\t" + (s + 1) + "\t" + (float)result0[0] + "\t" + (float)result0[1] + "\t" + (float)result1[0] + "\t" + (float)result1[1] + "\t" + (float)result2[0] + "\t" + (float)result2[1] + "\t" + (float)result3[0] + "\t" + (float)result3[1] + "\t" + (float)result4[0] + "\t" + (float)result4[1] + "\t" + this.sectionNamesList.get(s) + "\t" + (s + 1) + "\t" + obsVals.size() + "\n";
                tempInfoString = (String)tempInfoString + info;
                DefaultXY_DataSet xy_data0 = new DefaultXY_DataSet(aveElVals, obsVals);
                xy_data0.setName(this.sectionNamesList.get(s));
                xy_data0.setInfo("sectID = " + (s + 1) + "\tcorr = " + (float)result0[0] + "\t(" + (float)result0[1] + ")\t");
                obs_aveElement_funcs.add(xy_data0);
                obs_aveElement_funcsMap.put(s, xy_data0);
                DefaultXY_DataSet xy_data = new DefaultXY_DataSet(tpVals, obsVals);
                xy_data.setName(this.sectionNamesList.get(s));
                xy_data.setInfo("sectID = " + (s + 1) + "\tcorr = " + (float)result1[0] + "\t(" + (float)result1[1] + ")\t");
                obs_tp2_funcs.add(xy_data);
                obs_tp2_funcsMap.put(s, xy_data);
                DefaultXY_DataSet xy_data5 = new DefaultXY_DataSet(normLastSlipVals, normObsVals);
                xy_data5.setName(this.sectionNamesList.get(s));
                xy_data5.setInfo("sectID = " + (s + 1) + "\tcorr = " + (float)result3[0] + "\t(" + (float)result3[1] + ")\t");
                normObs_vs_normLastSlip_funcs.add(xy_data5);
                normObs_vs_normLastSlip_funcsMap.put(s, xy_data5);
                continue;
            }
            tempInfoString = (String)tempInfoString + "\t" + (s + 1) + "\tNaN\t\t\t\t\t\t\t\t" + this.sectionNamesList.get(s) + " (num points = " + obsVals.size() + ")\n";
        }
        GraphWindow graph0 = new GraphWindow(obs_aveElement_funcs, "Obs vs Ave Element RI");
        graph0.setX_AxisLabel("Ave Element RI (aveElementInterval) (years)");
        graph0.setY_AxisLabel("Observed RI (years)");
        graph0.setAllLineTypes(null, PlotSymbol.CROSS);
        graph0.setYLog(true);
        graph0.setXLog(true);
        GraphWindow graph = new GraphWindow(obs_tp2_funcs, "Obs vs Time-Pred RIs");
        graph.setX_AxisLabel("Time Pred RI (tpInterval2List) (years)");
        graph.setY_AxisLabel("Observed RI (years)");
        graph.setAllLineTypes(null, PlotSymbol.CROSS);
        graph.setYLog(true);
        graph.setXLog(true);
        if (saveStuff) {
            try {
                graph0.saveAsPDF(this.dirNameForSavingFiles + "/obsVersusAveElementRIs.pdf");
                graph.saveAsPDF(this.dirNameForSavingFiles + "/obsVersusTimePred2_RIs.pdf");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        for (int i4 = 0; i4 < aveNormRI_AlongRup.size(); ++i4) {
            aveNormRI_AlongRup.set(i4, aveNormRI_AlongRup.getY(i4) / numRIsAlongHist.getY(i4));
        }
        ArrayList<HistogramFunction> funcList = new ArrayList<HistogramFunction>();
        funcList.add(aveNormRI_AlongRup);
        ArrayList<PlotCurveCharacterstics> curveCharacteristics = new ArrayList<PlotCurveCharacterstics>();
        curveCharacteristics.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 2.0f, Color.BLACK));
        GraphWindow graph9 = new GraphWindow(funcList, "Ave Normalized RI Along Rupture", curveCharacteristics);
        graph9.setX_AxisLabel("Normalized Distance From End of Rupture");
        graph9.setY_AxisLabel("Normalized Ave RI");
        if (saveStuff) {
            try {
                graph9.saveAsPDF(this.dirNameForSavingFiles + "/NormalizedSlipAlongRup.pdf");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            FileWriter fw = new FileWriter("riDistsAlongStrikeXYZ.txt");
            fw.write("normDistAlong\tnormRI\tfraction\n");
            ArrayList<HistogramFunction> normRI_AlongRupFuncList = new ArrayList<HistogramFunction>();
            for (int i5 = 0; i5 < aveNormRI_AlongRup.size(); ++i5) {
                double distAlong = aveNormRI_AlongRup.getX(i5);
                HistogramFunction hist = riDistsAlongAlongRup[i5];
                hist.normalizeBySumOfY_Vals();
                hist.setName("Dist Along " + (float)distAlong);
                normRI_AlongRupFuncList.add(hist);
                for (int j = 0; j < hist.size(); ++j) {
                    fw.write((float)distAlong + "\t" + (float)hist.getX(j) + "\t" + (float)hist.getY(j) + "\n");
                }
            }
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (testElementID != null) {
            tempInfoString = (String)tempInfoString + "\nCorrelations (and chance it's random) between Predicted Intervals That Involve Element ID=" + testElementID + ":\n";
            result = this.getCorrelationAndP_Value(tpInterval2ListForTestElement, spInterval2ListForTestElement);
            tempInfoString = (String)tempInfoString + "\t" + (float)result[0] + "\t(" + result[1] + ") for tpInterval2 vs spInterval2List (num pts =" + tpInterval2ListForTestElement.size() + ")\n";
            ArrayList<DefaultXY_DataSet> obs_tp1_funcsForTestElement = new ArrayList<DefaultXY_DataSet>();
            DefaultXY_DataSet xy_data = new DefaultXY_DataSet(tpInterval2ListForTestElement, spInterval2ListForTestElement);
            obs_tp1_funcsForTestElement.add(xy_data);
            GraphWindow graph3 = new GraphWindow(obs_tp1_funcsForTestElement, "Slip-Pred vs Time-Pred RIs at Element ID=" + testElementID);
            graph3.setX_AxisLabel("Time-Pred RI (years)");
            graph3.setY_AxisLabel("Slip-Pred RI (years)");
            graph3.setAllLineTypes(null, PlotSymbol.CROSS);
            graph3.setYLog(true);
            graph3.setXLog(true);
            if (saveStuff) {
                try {
                    graph3.saveAsPDF(this.dirNameForSavingFiles + "/slipVersusTimePred2_RI_AtElemID" + testElementID + ".pdf");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (plotSectionResults) {
            String subDir = "sectionPlots";
            File file1 = new File(this.dirNameForSavingFiles, subDir);
            file1.mkdirs();
            for (int s = 0; s < this.sectionNamesList.size(); ++s) {
                ArrayList<Double> sectNormObsIntervalList = new ArrayList<Double>();
                for (int i6 = 0; i6 < norm_aveElementIntervalList.size(); ++i6) {
                    if ((Integer)nucleationSectionList.get(i6) != s + 1) continue;
                    sectNormObsIntervalList.add(norm_aveElementIntervalList.get(i6));
                }
                if (sectNormObsIntervalList.size() <= 2) continue;
                String plotTitle10 = "Normalized Obs Interval (norm_aveElementIntervalList) for " + this.sectionNamesList.get(s);
                HeadlessGraphPanel plot10 = OldGeneral_EQSIM_Tools.getNormRI_DistributionGraphPanel(sectNormObsIntervalList, plotTitle10);
                String plotTitle11 = "Norm Obs RI vs Norm Last Slip for " + this.sectionNamesList.get(s);
                HeadlessGraphPanel plot11 = new HeadlessGraphPanel();
                ArrayList<DefaultXY_DataSet> tempList = new ArrayList<DefaultXY_DataSet>();
                tempList.add((DefaultXY_DataSet)normObs_vs_normLastSlip_funcsMap.get(s));
                ArrayList<PlotCurveCharacterstics> curveCharacteristics2 = new ArrayList<PlotCurveCharacterstics>();
                curveCharacteristics2.add(new PlotCurveCharacterstics(PlotSymbol.CROSS, 2.0f, Color.RED));
                plot11.setXLog(true);
                plot11.setYLog(true);
                plot11.drawGraphPanel("Norm Last Slip", "Norm Observed RI", tempList, curveCharacteristics2, plotTitle11);
                plot11.getChartPanel().setSize(1000, 800);
                if (!saveStuff) continue;
                String fileName10 = this.dirNameForSavingFiles + "/" + subDir + "/normObsIntervalDist_forSect" + s + ".pdf";
                String fileName11 = this.dirNameForSavingFiles + "/" + subDir + "/normObsVsLastSlip_forSect" + s + ".pdf";
                try {
                    plot10.saveAsPDF(fileName10);
                    plot11.saveAsPDF(fileName11);
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        tempInfoString = (String)tempInfoString + "\n" + numBad + " events were bad (e.g., no previous event time because it was first)\n";
        tempInfoString = (String)tempInfoString + "minElementArea=" + (float)minElementArea + "\tmaxElementArea" + (float)maxElementArea + "\n";
        try {
            if (saveStuff) {
                FileWriter fw_timePred = new FileWriter(this.dirNameForSavingFiles + "/TimePredTestData.txt");
                fw_timePred.write((String)linesFor_fw_timePred);
                fw_timePred.close();
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        System.out.println((String)tempInfoString);
        return tempInfoString;
    }

    private double[] getCorrelationAndP_Value(ArrayList<Double> list1, ArrayList<Double> list2) {
        double[][] vals = new double[list1.size()][2];
        for (int i = 0; i < list1.size(); ++i) {
            vals[i][0] = list1.get(i);
            vals[i][1] = list2.get(i);
        }
        PearsonsCorrelation corrCalc = new PearsonsCorrelation(vals);
        double[] result = new double[2];
        RealMatrix matrix = corrCalc.getCorrelationMatrix();
        result[0] = matrix.getEntry(0, 1);
        matrix = corrCalc.getCorrelationPValues();
        result[1] = matrix.getEntry(0, 1);
        return result;
    }

    public void checkThatAllEventRecordsHaveSlips() {
        System.out.println("checkThatAllEventRecordsHaveSlips");
        for (EQSIM_Event event : this.eventList) {
            if (!event.hasElementSlipsAndIDs()) continue;
            for (int i = 0; i < event.size(); ++i) {
                EQSIM_EventRecord er = event.get(i);
                if (er.hasElementSlipsAndIDs()) continue;
                System.out.println("Event ID " + event.getID() + " has missing slips and IDs on record index " + i);
            }
        }
    }

    public String checkEventMagnitudes(double magThresh) {
        double maxMagDiff = 0.0;
        int maxDiffIndex = -1;
        int i = -1;
        for (EQSIM_Event event : this.eventList) {
            ++i;
            if (!event.hasElementSlipsAndIDs() || !this.isEventSupraSeismogenic(event, magThresh)) continue;
            double eventMag = event.getMagnitude();
            double moment = 0.0;
            double[] slips = event.getAllElementSlips();
            int[] elemIDs = event.getAllElementIDs();
            int numElements = slips.length;
            for (int e = 0; e < numElements; ++e) {
                int index = elemIDs[e] - 1;
                double area = this.rectElementsList.get(index).getArea();
                double slip = slips[e];
                moment += FaultMomentCalc.getMoment(area, slip);
            }
            double computedMag = MagUtils.momentToMag(moment);
            double diff = Math.abs(eventMag - computedMag);
            if (!(diff > maxMagDiff)) continue;
            maxMagDiff = diff;
            maxDiffIndex = i;
        }
        String info = "maximum abs(eventMag-computedMag) =" + maxMagDiff + "; for eventList index " + maxDiffIndex + " (ID=" + this.eventList.get(maxDiffIndex).getID() + ")\n";
        System.out.println(info);
        System.out.println(this.eventList.get(maxDiffIndex).toString());
        return info;
    }

    public void writeEventsThatInvolveMultSections() {
        System.out.println("Events that involve more than one section:");
        System.out.println("\t\tEvID\t# Sect\tMag\tSections involved...");
        int num = 0;
        for (EQSIM_Event event : this.eventList) {
            if (event.size() <= 1) continue;
            double mag = (double)Math.round(event.getMagnitude() * 100.0) / 100.0;
            System.out.print("\t" + ++num + "\t" + event.getID() + "\t" + event.size() + "\t" + mag);
            for (EventRecord rec : event) {
                System.out.print("\t" + this.sectionNamesList.get(rec.getSectionID() - 1) + "_" + rec.getSectionID());
            }
            System.out.print("\n");
        }
    }

    public double getSimulationDuration() {
        return OldGeneral_EQSIM_Tools.getSimulationDuration(this.eventList);
    }

    public static double getSimulationDuration(List<EQSIM_Event> events) {
        EQSIM_Event firstEvent = events.get(0);
        EQSIM_Event lastEvent = events.get(events.size() - 1);
        double startTime = firstEvent.getTime();
        double endTime = lastEvent.getTime() + lastEvent.getDuration();
        return endTime - startTime;
    }

    public double getSimulationDurationYears() {
        return OldGeneral_EQSIM_Tools.getSimulationDurationYears(this.eventList);
    }

    public static double getSimulationDurationYears(List<EQSIM_Event> events) {
        return OldGeneral_EQSIM_Tools.getSimulationDuration(events) / 3.1536E7;
    }

    public void checkElementSlipRates(String fileNamePrefix, boolean makePlot) {
        double[] obsAveSlipRate = new double[this.rectElementsList.size()];
        double[] imposedSlipRate = new double[this.rectElementsList.size()];
        int[] numEvents = new int[this.rectElementsList.size()];
        for (EQSIM_Event event : this.eventList) {
            if (!event.hasElementSlipsAndIDs()) continue;
            double[] slips = event.getAllElementSlips();
            int[] elemIDs = event.getAllElementIDs();
            int numElements = slips.length;
            for (int e = 0; e < numElements; ++e) {
                int index;
                int n = index = elemIDs[e] - 1;
                obsAveSlipRate[n] = obsAveSlipRate[n] + slips[e];
                int n2 = index;
                numEvents[n2] = numEvents[n2] + 1;
            }
        }
        double simDurr = this.getSimulationDurationYears();
        for (int i = 0; i < obsAveSlipRate.length; ++i) {
            int n = i;
            obsAveSlipRate[n] = obsAveSlipRate[n] / simDurr;
            imposedSlipRate[i] = this.rectElementsList.get(i).getSlipRate();
        }
        PearsonsCorrelation corrCalc = new PearsonsCorrelation();
        double slipRateCorr = corrCalc.correlation(obsAveSlipRate, imposedSlipRate);
        System.out.println("Correlation between obs and imposed slip rate = " + (float)slipRateCorr);
        if (makePlot) {
            DefaultXY_DataSet xy_data = new DefaultXY_DataSet(imposedSlipRate, obsAveSlipRate);
            xy_data.setName("Obs versus Imposed Slip Rate");
            xy_data.setInfo(" ");
            ArrayList<DefaultXY_DataSet> funcs = new ArrayList<DefaultXY_DataSet>();
            funcs.add(xy_data);
            GraphWindow graph = new GraphWindow(funcs, "Slip Rate Comparison");
            graph.setX_AxisLabel("Imposed Slip Rate (m/s)");
            graph.setY_AxisLabel("Observed Slip Rate (m/s)");
            ArrayList<PlotCurveCharacterstics> curveCharacteristics = new ArrayList<PlotCurveCharacterstics>();
            curveCharacteristics.add(new PlotCurveCharacterstics(PlotSymbol.FILLED_CIRCLE, 4.0f, Color.BLUE));
            graph.setPlotChars(curveCharacteristics);
            if (fileNamePrefix != null) {
                String plotFileName = fileNamePrefix + ".pdf";
                try {
                    graph.saveAsPDF(this.dirNameForSavingFiles + "/" + plotFileName);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (fileNamePrefix != null) {
            try {
                String dataFileName = this.dirNameForSavingFiles + "/" + fileNamePrefix + ".txt";
                FileWriter fw_slipRates = new FileWriter(dataFileName);
                fw_slipRates.write("obsSlipRate\timposedSlipRate\tdiff\tnumEvents\n");
                for (int i = 0; i < obsAveSlipRate.length; ++i) {
                    double diff = obsAveSlipRate[i] - imposedSlipRate[i];
                    fw_slipRates.write(obsAveSlipRate[i] + "\t" + imposedSlipRate[i] + "\t" + diff + "\t" + numEvents[i] + "\n");
                }
                fw_slipRates.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    public boolean plotAveNormSlipAlongRupture(Double magThresh, boolean savePlot) {
        double startX = 0.0125;
        double deltaX = 0.025;
        int numX = 40;
        HistogramFunction normSlipAlongHist = new HistogramFunction(startX, numX, deltaX);
        for (EQSIM_Event event : this.eventList) {
            int i;
            if (!this.isEventSupraSeismogenic(event, magThresh) || !event.hasElementSlipsAndIDsOnAllRecords()) continue;
            double[] slipArray = event.getAllElementSlips();
            double[] normDistAlong = event.getNormDistAlongRupForElements();
            HistogramFunction normSlipHistForRup = new HistogramFunction(startX, numX, deltaX);
            HistogramFunction totSlipHist = new HistogramFunction(startX, numX, deltaX);
            HistogramFunction numSlip = new HistogramFunction(startX, numX, deltaX);
            for (i = 0; i < slipArray.length; ++i) {
                int index = totSlipHist.getXIndex(normDistAlong[i]);
                if (index == -1) {
                    return false;
                }
                totSlipHist.add(index, slipArray[i]);
                numSlip.add(index, 1.0);
            }
            for (i = 0; i < numX; ++i) {
                if (!(numSlip.getY(i) > 0.0)) continue;
                normSlipHistForRup.set(i, totSlipHist.getY(i) / numSlip.getY(i));
            }
            normSlipHistForRup.normalizeBySumOfY_Vals();
            for (i = 0; i < numX; ++i) {
                normSlipAlongHist.add(i, normSlipHistForRup.getY(i));
            }
        }
        normSlipAlongHist.normalizeBySumOfY_Vals();
        HistogramFunction symNormSlipAlongHist = new HistogramFunction(startX, numX, deltaX);
        int i = 0;
        while ((double)i < Math.floor((double)numX / 2.0)) {
            int i2 = numX - 1 - i;
            double val = (normSlipAlongHist.getY(i) + normSlipAlongHist.getY(i2)) / 2.0;
            symNormSlipAlongHist.add(i, val);
            symNormSlipAlongHist.add(i2, val);
            ++i;
        }
        HistogramFunction sqrtSineHist = new HistogramFunction(startX, numX, deltaX);
        for (int i2 = 0; i2 < numX; ++i2) {
            double xVal = sqrtSineHist.getX(i2) * Math.PI;
            sqrtSineHist.set(i2, Math.sqrt(Math.sin(xVal)));
        }
        sqrtSineHist.normalizeBySumOfY_Vals();
        ArrayList<HistogramFunction> funcList = new ArrayList<HistogramFunction>();
        funcList.add(symNormSlipAlongHist);
        funcList.add(sqrtSineHist);
        GraphWindow graph = new GraphWindow(funcList, "Ave Normalized Slip Along Rupture");
        graph.setX_AxisLabel("Normalized Distance Along Rupture");
        graph.setY_AxisLabel("Normalized Slip");
        ArrayList<PlotCurveCharacterstics> curveCharacteristics = new ArrayList<PlotCurveCharacterstics>();
        curveCharacteristics.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 2.0f, Color.BLACK));
        curveCharacteristics.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.RED));
        graph.setPlotChars(curveCharacteristics);
        if (savePlot) {
            try {
                graph.saveAsPDF(this.dirNameForSavingFiles + "/NormalizedSlipAlongRup.pdf");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    public void plotScalingRelationships(boolean savePlotsToFile) {
        double[] slip = new double[this.eventList.size()];
        double[] mag = new double[this.eventList.size()];
        double[] area = new double[this.eventList.size()];
        double[] length = new double[this.eventList.size()];
        int index = -1;
        for (EQSIM_Event event : this.eventList) {
            slip[++index] = event.getMeanSlip();
            mag[index] = event.getMagnitude();
            area[index] = event.getArea() / 1000000.0;
            length[index] = event.getLength() / 1000.0;
        }
        DefaultXY_DataSet s_vs_l_data = new DefaultXY_DataSet(length, slip);
        s_vs_l_data.setName("Mean Slip vs Length");
        s_vs_l_data.setInfo(" ");
        ArrayList<DefaultXY_DataSet> s_vs_l_funcs = new ArrayList<DefaultXY_DataSet>();
        s_vs_l_funcs.add(s_vs_l_data);
        GraphWindow s_vs_l_graph = new GraphWindow(s_vs_l_funcs, "Mean Slip vs Length");
        s_vs_l_graph.setY_AxisLabel("Mean Slip (m)");
        s_vs_l_graph.setX_AxisLabel("Length (km)");
        ArrayList<PlotCurveCharacterstics> s_vs_l_curveChar = new ArrayList<PlotCurveCharacterstics>();
        s_vs_l_curveChar.add(new PlotCurveCharacterstics(PlotSymbol.CIRCLE, 3.0f, Color.BLUE));
        s_vs_l_graph.setPlotChars(s_vs_l_curveChar);
        DefaultXY_DataSet m_vs_a_data = new DefaultXY_DataSet(area, mag);
        m_vs_a_data.setName("Mag-Area data from simulation");
        m_vs_a_data.setInfo(" ");
        ArrayList<AbstractXY_DataSet> m_vs_a_funcs = new ArrayList<AbstractXY_DataSet>();
        Ellsworth_B_WG02_MagAreaRel elB = new Ellsworth_B_WG02_MagAreaRel();
        HanksBakun2002_MagAreaRel hb = new HanksBakun2002_MagAreaRel();
        Shaw_2007_MagAreaRel sh = new Shaw_2007_MagAreaRel();
        m_vs_a_funcs.add(m_vs_a_data);
        m_vs_a_funcs.add(elB.getMagAreaFunction(1.0, 10000.0, 101));
        m_vs_a_funcs.add(hb.getMagAreaFunction(1.0, 10000.0, 101));
        m_vs_a_funcs.add(sh.getMagAreaFunction(1.0, 10000.0, 101));
        GraphWindow m_vs_a_graph = new GraphWindow(m_vs_a_funcs, "Mag vs Area");
        m_vs_a_graph.setY_AxisLabel("Magnitude (Mw)");
        m_vs_a_graph.setX_AxisLabel("Area (km-sq)");
        ArrayList<PlotCurveCharacterstics> m_vs_a_curveChar = new ArrayList<PlotCurveCharacterstics>();
        m_vs_a_curveChar.add(new PlotCurveCharacterstics(PlotSymbol.CIRCLE, 3.0f, Color.BLACK));
        m_vs_a_curveChar.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.RED));
        m_vs_a_curveChar.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.GREEN));
        m_vs_a_curveChar.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.BLUE));
        m_vs_a_graph.setPlotChars(m_vs_a_curveChar);
        m_vs_a_graph.setXLog(true);
        m_vs_a_graph.setY_AxisRange(4.5, 8.5);
        DefaultXY_DataSet m_vs_l_data = new DefaultXY_DataSet(length, mag);
        m_vs_l_data.setName("Mag vs Length");
        m_vs_l_data.setInfo(" ");
        ArrayList<DefaultXY_DataSet> m_vs_l_funcs = new ArrayList<DefaultXY_DataSet>();
        m_vs_l_funcs.add(m_vs_l_data);
        GraphWindow m_vs_l_graph = new GraphWindow(m_vs_l_funcs, "Mag vs Length");
        m_vs_l_graph.setY_AxisLabel("Magnitude (Mw)");
        m_vs_l_graph.setX_AxisLabel("Length (km)");
        ArrayList<PlotCurveCharacterstics> m_vs_l_curveChar = new ArrayList<PlotCurveCharacterstics>();
        m_vs_l_curveChar.add(new PlotCurveCharacterstics(PlotSymbol.CIRCLE, 3.0f, Color.GREEN));
        m_vs_l_graph.setPlotChars(m_vs_l_curveChar);
        m_vs_l_graph.setY_AxisRange(4.5, 8.5);
        if (savePlotsToFile) {
            try {
                s_vs_l_graph.saveAsPDF(this.dirNameForSavingFiles + "/s_vs_l_graph.pdf");
                m_vs_a_graph.saveAsPDF(this.dirNameForSavingFiles + "/m_vs_a_graph.pdf");
                m_vs_l_graph.saveAsPDF(this.dirNameForSavingFiles + "/m_vs_l_graph.pdf");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public double[] getRecurIntervalsForElement(int elemID, double magThresh) {
        ArrayList<Double> eventTimes = new ArrayList<Double>();
        for (EQSIM_Event event : this.eventList) {
            if (!event.hasElementSlipsAndIDs() || !Ints.contains((int[])event.getAllElementIDs(), (int)elemID) || !this.isEventSupraSeismogenic(event, magThresh)) continue;
            eventTimes.add(event.getTimeInYears());
        }
        if (eventTimes.size() > 0) {
            double[] intervals = new double[eventTimes.size() - 1];
            for (int i = 1; i < eventTimes.size(); ++i) {
                intervals[i - 1] = (Double)eventTimes.get(i) - (Double)eventTimes.get(i - 1);
            }
            return intervals;
        }
        return null;
    }

    public void writeRI_COV_forAllSurfaceElements(double magThresh, String fileName) {
        try {
            FileWriter fw = new FileWriter(fileName);
            fw.write("elemID\tCOV\tfaultName\tNumRIs\n");
            for (SimulatorElement elem : this.rectElementsList) {
                double[] recurInts;
                if (elem.getVertices()[0].getTraceFlag() == 0 || (recurInts = this.getRecurIntervalsForElement(elem.getID(), magThresh)) == null) continue;
                DescriptiveStatistics stats = new DescriptiveStatistics();
                for (double val : recurInts) {
                    stats.addValue(Math.log10(val));
                }
                double cov = stats.getStandardDeviation() / stats.getMean();
                fw.write(elem.getID() + "\t" + cov + "\t" + elem.getName() + "\t" + recurInts.length + "\n");
            }
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeDAS_ForVertices() {
        try {
            FileWriter fw = new FileWriter("tempDAS_forVertices.txt");
            for (Vertex vert : this.vertexList) {
                String sectName = this.sectionNamesList.get(this.getSectionIndexForVertex(vert));
                fw.write(vert.getID() + "\t" + vert.getDAS() + "\t" + sectName + "\n");
            }
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeSectionNamesEtc() {
        try {
            FileWriter fw = new FileWriter("simulatorSectionNamesEtc.txt");
            fw.write("index\tsectID\tsectName\tfaultID");
            for (int i = 0; i < this.sectionNamesList.size(); ++i) {
                fw.write(i + "\t" + String.valueOf(this.sectionIDs_List.get(i)) + "\t" + this.sectionNamesList.get(i) + "\t" + String.valueOf(this.faultIDs_ForSections.get(i)) + "\n");
            }
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void plotNormRecurIntsForAllSurfaceElements(double magThresh, boolean savePlot) {
        ArrayList<Double> vals = new ArrayList<Double>();
        for (SimulatorElement elem : this.rectElementsList) {
            int i;
            int sectID;
            Vertex vert;
            double das;
            double[] recurInts;
            if (elem.getVertices()[0].getTraceFlag() == 0 || (recurInts = this.getRecurIntervalsForDAS_and_FaultID(das = (vert = elem.getVertices()[0]).getDAS() * 1000.0, sectID = this.getSectionIndexForVertex(vert) + 1, magThresh)) == null) continue;
            double mean = 0.0;
            for (i = 0; i < recurInts.length; ++i) {
                mean += recurInts[i] / (double)recurInts.length;
            }
            for (i = 0; i < recurInts.length; ++i) {
                vals.add(recurInts[i] / mean);
            }
        }
        GraphWindow graph = ProbModelsPlottingUtils.plotNormRI_DistributionWithFits(ProbModelsPlottingUtils.getNormRI_DistributionWithFits(vals, Double.NaN), "Normalized RI for All Surface Elements");
        if (savePlot) {
            try {
                graph.saveAsPDF(this.dirNameForSavingFiles + "/NormRecurIntsForAllSurfaceElements.pdf");
                graph.saveAsTXT(this.dirNameForSavingFiles + "/NormRecurIntsForAllSurfaceElements.txt");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean plotRecurIntervalsForNearestLoc(Location loc, double magThresh, boolean savePlot, String locName, String infoString) {
        int sectID;
        Vertex vert = this.getClosestVertex(loc);
        double dist = vert.getLinearDistance(loc);
        if (dist > 5.0) {
            System.out.println("No vertex found near the site " + locName);
            return false;
        }
        double das = vert.getDAS() * 1000.0;
        double[] intervals = this.getRecurIntervalsForDAS_and_FaultID(das, sectID = this.getSectionIndexForVertex(vert) + 1, magThresh);
        if (intervals == null) {
            System.out.println("Not more than two events at " + locName);
            return false;
        }
        if (infoString == null) {
            infoString = new String();
        }
        infoString = (String)infoString + "Closest Vertex is ID=" + vert.getID() + " on " + this.sectionNamesList.get(sectID - 1) + " (" + (float)dist + " km away)\n";
        this.plotRecurIntervalsForElement(intervals, savePlot, locName, (String)infoString);
        return true;
    }

    public void plotRecurIntervalsForElement(double[] intervals, boolean savePlot, String locName, String infoString) {
        double maxInterval = 0.0;
        double meanInterval = 0.0;
        for (int i = 0; i < intervals.length; ++i) {
            if (intervals[i] > maxInterval) {
                maxInterval = intervals[i];
            }
            meanInterval += intervals[i];
        }
        meanInterval /= (double)intervals.length;
        if (infoString == null) {
            infoString = new String();
        }
        infoString = (String)infoString + "Num RIs = " + intervals.length + "\n";
        double binWidth = Math.round(meanInterval / 10.0);
        int numBins = (int)Math.ceil(maxInterval / binWidth) + 1;
        HistogramFunction riHist = new HistogramFunction(binWidth / 2.0, numBins, binWidth);
        for (int i = 0; i < intervals.length; ++i) {
            int testIndex = riHist.getXIndex(intervals[i]);
            if (testIndex == -1) {
                System.out.println(i + "\t" + intervals[i] + "\t" + binWidth + "\t" + numBins + "\t" + meanInterval + "\t" + maxInterval + "\t" + intervals.length);
            }
            riHist.add(intervals[i], 1.0 / (binWidth * (double)intervals.length));
        }
        double stdDevOfMean = 0.0;
        for (int i = 0; i < intervals.length; ++i) {
            stdDevOfMean += (intervals[i] - meanInterval) * (intervals[i] - meanInterval);
        }
        stdDevOfMean = Math.sqrt(stdDevOfMean / (double)(intervals.length - 1));
        double upper95 = meanInterval + 1.96 * (stdDevOfMean /= Math.sqrt(intervals.length));
        double lower95 = meanInterval - 1.96 * stdDevOfMean;
        infoString = (String)infoString + "meanRI=" + Math.round(meanInterval) + "\tlower95=" + Math.round(lower95) + "\tupper95=" + Math.round(upper95) + "\n";
        infoString = (String)infoString + "mean from Histogram=" + riHist.computeMean() + "\tCOV from Histogram=" + riHist.computeCOV() + "\n";
        riHist.normalizeBySumOfY_Vals();
        infoString = (String)infoString + riHist.toString();
        riHist.setName(locName + " RI histogram");
        riHist.setInfo((String)infoString);
        ArrayList<HistogramFunction> funcList = new ArrayList<HistogramFunction>();
        funcList.add(riHist);
        ArrayList<PlotCurveCharacterstics> curveCharacteristics = new ArrayList<PlotCurveCharacterstics>();
        curveCharacteristics.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 2.0f, Color.BLACK));
        GraphWindow graph = new GraphWindow(funcList, "Recurence Intervals for " + locName, curveCharacteristics);
        graph.setX_AxisLabel("RI (yrs)");
        graph.setY_AxisLabel("Density");
        graph.setX_AxisRange(0.0, 5.0 * meanInterval);
        graph.setY_AxisRange(0.0, 2.3 / meanInterval);
        graph.setAxisLabelFontSize(22);
        graph.setTickLabelFontSize(20);
        graph.setPlotLabelFontSize(22);
        if (savePlot) {
            try {
                graph.saveAsPDF(this.dirNameForSavingFiles + "/RI_HistogramFor_" + locName + ".pdf");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public Vertex getClosestVertex(Location loc) {
        double minDist = Double.MAX_VALUE;
        int vertexIndex = -1;
        for (int i = 0; i < this.vertexList.size(); ++i) {
            double dist = LocationUtils.linearDistance(loc, this.vertexList.get(i));
            if (!(dist < minDist)) continue;
            minDist = dist;
            vertexIndex = i;
        }
        return this.vertexList.get(vertexIndex);
    }

    public int getSectionIndexForVertex(Vertex vertex) {
        int sectIndex = -1;
        boolean alreadyGotOne = false;
        for (int i = 0; i < this.vertexListForSections.size(); ++i) {
            if (!this.vertexListForSections.get(i).contains(vertex)) continue;
            if (alreadyGotOne) {
                throw new RuntimeException("more than one section associated to vertex");
            }
            sectIndex = i;
            alreadyGotOne = true;
        }
        return sectIndex;
    }

    public double[] getRecurIntervalsForDAS_and_FaultID(double das, int sectID, double magThresh) {
        ArrayList<Double> eventTimes = new ArrayList<Double>();
        for (EQSIM_Event event : this.eventList) {
            if (!this.isEventSupraSeismogenic(event, magThresh) || !event.doesEventIncludeSectionAndDAS(sectID, das)) continue;
            eventTimes.add(event.getTimeInYears());
        }
        if (eventTimes.size() <= 1) {
            return null;
        }
        double[] intervals = new double[eventTimes.size() - 1];
        double maxInterval = 0.0;
        for (int i = 1; i < eventTimes.size(); ++i) {
            intervals[i - 1] = (Double)eventTimes.get(i) - (Double)eventTimes.get(i - 1);
            if (!(intervals[i - 1] > maxInterval)) continue;
            maxInterval = intervals[i - 1];
        }
        return intervals;
    }

    public void oldTests(String dirNameForSavingFiles, double magThresh) {
        ArrayList<Object> infoStrings = new ArrayList<Object>();
        this.dirNameForSavingFiles = dirNameForSavingFiles;
        File file1 = new File(dirNameForSavingFiles);
        file1.mkdirs();
        infoStrings.add("Simulation Duration is " + (float)this.getSimulationDurationYears() + " years");
        this.randomizeEventTimes();
        String info2 = this.testTimePredictability(magThresh, true, null, true);
        infoStrings.add(info2);
        try {
            FileWriter infoFileWriter = new FileWriter(this.dirNameForSavingFiles + "/INFO.txt");
            for (String string : infoStrings) {
                infoFileWriter.write(string + "\n");
            }
            infoFileWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String checkFullDDW_rupturing(boolean plotResult, boolean savePlot) {
        double minMagThatDoes = 10.0;
        double maxMagThatDoesnt = 0.0;
        int eventID_forMin = -1;
        int eventID_forMax = -1;
        Object eventInfoForMin = "";
        Object eventInfoForMax = "";
        ArbIncrementalMagFreqDist mfd_does = new ArbIncrementalMagFreqDist(4.0, 8.5, 46);
        mfd_does.setName("Rups Completely Down Dip");
        mfd_does.setTolerance(1.0);
        ArbIncrementalMagFreqDist mfd_doesNot = new ArbIncrementalMagFreqDist(4.0, 8.5, 46);
        mfd_doesNot.setName("Does Not Rup Completely Down Dip");
        mfd_doesNot.setTolerance(1.0);
        for (EQSIM_Event event : this.eventList) {
            double ddw;
            double length;
            double area;
            double mag = event.getMagnitude();
            if (mag < 4.0) continue;
            if (this.isEventSupraSeismogenic(event, Double.NaN)) {
                if (mag < minMagThatDoes) {
                    minMagThatDoes = mag;
                    eventID_forMin = event.getID();
                    area = Math.round(event.getArea() * 1.0E-6);
                    length = Math.round(event.getLength() * 0.001);
                    ddw = Math.round(0.001 * event.getArea() / event.getLength());
                    eventInfoForMin = "area=" + area + "; length=" + length + "; area/length=" + ddw + "; time(yrs)=" + event.getTimeInYears();
                }
                mfd_does.add(mag, 1.0);
                continue;
            }
            if (mag > maxMagThatDoesnt) {
                maxMagThatDoesnt = mag;
                eventID_forMax = event.getID();
                area = Math.round(event.getArea() * 1.0E-6);
                length = Math.round(event.getLength() * 0.001);
                ddw = Math.round(0.001 * event.getArea() / event.getLength());
                eventInfoForMax = "area=" + area + "; length=" + length + "; area/length=" + ddw + "; time(yrs)=" + event.getTimeInYears();
            }
            mfd_doesNot.add(mag, 1.0);
        }
        String info = "min full seismogenic mag = " + minMagThatDoes + "\teventID=" + eventID_forMin + "\t" + (String)eventInfoForMin + "\n";
        info = info + "max non full seismogenic mag = " + maxMagThatDoesnt + "\teventID=" + eventID_forMax + "\t" + (String)eventInfoForMax + "\n";
        System.out.println(info);
        if (plotResult) {
            ArrayList<ArbIncrementalMagFreqDist> funcs = new ArrayList<ArbIncrementalMagFreqDist>();
            funcs.add(mfd_does);
            funcs.add(mfd_doesNot);
            ArrayList<PlotCurveCharacterstics> curveChar = new ArrayList<PlotCurveCharacterstics>();
            curveChar.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.BLACK));
            curveChar.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.GRAY));
            GraphWindow graph = new GraphWindow(funcs, "Full Rup Mags (and not)", curveChar);
            graph.setX_AxisLabel("Mag");
            graph.setY_AxisLabel("Number of Observations");
            graph.setY_AxisRange(0.1, Math.ceil(mfd_doesNot.getMaxY()));
            graph.setYLog(true);
            if (savePlot) {
                try {
                    graph.saveAsPDF(this.dirNameForSavingFiles + "/fullDDW_MFDs.pdf");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return info;
    }

    public void setDirNameForSavingFiles(String dirNameForSavingFiles) {
        this.dirNameForSavingFiles = dirNameForSavingFiles;
        File file1 = new File(dirNameForSavingFiles);
        file1.mkdirs();
    }

    public void mkFigsForUCERF3_ProjPlanRepot(String dirNameForSavingFiles, double magThresh) {
        ArrayList<Object> infoStrings = new ArrayList<Object>();
        this.dirNameForSavingFiles = dirNameForSavingFiles;
        File file1 = new File(dirNameForSavingFiles);
        file1.mkdirs();
        infoStrings.add("Simulation Duration is " + (float)this.getSimulationDurationYears() + " years");
        Location loc = (Location)((RectangularElement)this.rectElementsList.get(496)).getSurface().get(0, 1);
        this.plotRecurIntervalsForNearestLoc(loc, 6.5, true, "RI_distAt_NSAF_ElementID497", "");
        Integer testElementID = 661;
        String info2 = this.testTimePredictability(magThresh, true, testElementID, true);
        infoStrings.add(info2);
        try {
            FileWriter infoFileWriter = new FileWriter(this.dirNameForSavingFiles + "/INFO.txt");
            for (String string : infoStrings) {
                infoFileWriter.write(string + "\n");
            }
            infoFileWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean doesEventUtilizedFault(EQSIM_Event event, int faultID) {
        boolean answer = false;
        for (EventRecord eventRecord : event) {
            int sectIndex = eventRecord.getSectionID() - 1;
            if (this.faultIDs_ForSections.get(sectIndex) != faultID) continue;
            answer = true;
            break;
        }
        return answer;
    }

    public static void main(String[] args) throws FileNotFoundException, IOException {
        long startTime = System.currentTimeMillis();
        System.out.println("Starting");
        FaultModels fm = FaultModels.FM3_1;
        DeformationModels dm = DeformationModels.ZENGBB;
        double defaultAseisVal = 0.1;
        File scratchDir = UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR;
        File outputDir = new File("/tmp/ucerf3_dm_eqsim_files");
        if (!outputDir.exists()) {
            outputDir.mkdir();
        }
        boolean aseisReducesArea = false;
        double maxDiscretization = 4.0;
        SimpleDateFormat df = new SimpleDateFormat("MMM d, yyyy");
        DeformationModelFetcher dmFetch = new DeformationModelFetcher(fm, dm, scratchDir, defaultAseisVal);
        ArrayList<FaultSectionPrefData> sects = new ArrayList<FaultSectionPrefData>();
        for (FaultSection faultSection : dmFetch.getSubSectionList()) {
            sects.add((FaultSectionPrefData)faultSection);
        }
        OldGeneral_EQSIM_Tools tools = new OldGeneral_EQSIM_Tools(sects, aseisReducesArea, maxDiscretization);
        File file = new File(outputDir, fm.encodeChoiceString() + "_" + dm.encodeChoiceString() + "_EQSIM.txt");
        tools.writeTo_EQSIM_V04_GeometryFile(file.getAbsolutePath(), null, fm.name() + ", " + dm.name() + " output", "Kevin Milner", df.format(new Date()));
        new OldGeneral_EQSIM_Tools(file);
        int runtime = (int)(System.currentTimeMillis() - startTime) / 1000;
        System.out.println("This Run took " + runtime + " seconds");
    }
}

