/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.simulators.iden;

import com.google.common.base.Preconditions;
import org.opensha.sha.simulators.SimulatorEvent;
import org.opensha.sha.simulators.iden.AbstractRuptureIdentifier;

public class CatalogLengthLoadIden
extends AbstractRuptureIdentifier {
    private double firstEventYears = Double.NaN;
    private final double lengthYears;
    private boolean encounteredEnd = false;

    public CatalogLengthLoadIden(double lengthYears) {
        Preconditions.checkArgument((lengthYears > 0.0 ? 1 : 0) != 0);
        this.lengthYears = lengthYears;
    }

    @Override
    public boolean isMatch(SimulatorEvent event) {
        boolean match;
        double years = event.getTimeInYears();
        Preconditions.checkState((boolean)Double.isFinite(years));
        if (Double.isNaN(this.firstEventYears)) {
            this.firstEventYears = years;
        }
        Preconditions.checkState((years >= this.firstEventYears ? 1 : 0) != 0);
        double diff = years - this.firstEventYears;
        boolean bl = match = diff <= this.lengthYears;
        if (!match) {
            this.encounteredEnd = true;
        }
        return match;
    }

    @Override
    public String getName() {
        return "Total Length Iden";
    }

    @Override
    public boolean furtherMatchesPossible() {
        return !this.encounteredEnd;
    }
}

