/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.simulators.iden;

import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.util.List;
import org.opensha.sha.simulators.SimulatorEvent;
import org.opensha.sha.simulators.iden.AbstractRuptureIdentifier;

public class ElementMagRangeDescription
extends AbstractRuptureIdentifier {
    public static final int SAF_MOJAVE_ELEMENT_ID = 1246;
    public static final int SAF_CARRIZO_ELEMENT_ID = 1026;
    public static final int SAF_COACHELLA_ELEMENT_ID = 1602;
    public static final int SAF_CHOLAME_ELEMENT_ID = 966;
    public static final int GARLOCK_WEST_ELEMENT_ID = 6036;
    public static final int SAN_JACINTO__ELEMENT_ID = 1931;
    public static final int ELSINORE_ELEMENT_ID = 2460;
    public static final int PUENTE_HILLS_ELEMENT_ID = 11829;
    public static final int NEWP_INGL_ONSHORE_ELEMENT_ID = 7672;
    public static final int SAF_SANTA_CRUZ = 663;
    public static final int SAF_MID_PENINSULA = 529;
    public static final int CALAVERAS = 3692;
    public static final int HAYWARD = 3334;
    private String name;
    private List<Integer> elementIDs;
    private double minMag;
    private double maxMag;

    public ElementMagRangeDescription(String name, int elementID, double minMag, double maxMag) {
        this(name, Lists.newArrayList((Object[])new Integer[]{elementID}), minMag, maxMag);
    }

    public ElementMagRangeDescription(String name, double minMag, double maxMag, int ... elementIDs) {
        this(name, Ints.asList((int[])elementIDs), minMag, maxMag);
    }

    public static String smartName(String fault, ElementMagRangeDescription o) {
        return ElementMagRangeDescription.smartName(fault, o.minMag, o.maxMag);
    }

    public static String smartName(String fault, double minMag, double maxMag) {
        if (maxMag < 9.0) {
            return fault + " " + ElementMagRangeDescription.getRoundedStr(minMag) + "=>" + ElementMagRangeDescription.getRoundedStr(maxMag);
        }
        return fault + " " + ElementMagRangeDescription.getRoundedStr(minMag) + "+";
    }

    private static String getRoundedStr(double val) {
        if (val == Math.floor(val)) {
            return "" + (int)val;
        }
        return "" + (float)val;
    }

    public ElementMagRangeDescription(String name, List<Integer> elementIDs, double minMag, double maxMag) {
        this.elementIDs = elementIDs;
        this.minMag = minMag;
        this.maxMag = maxMag;
        this.name = name;
    }

    @Override
    public boolean isMatch(SimulatorEvent event) {
        double mag = event.getMagnitude();
        if (mag < this.minMag || mag >= this.maxMag) {
            return false;
        }
        for (int elementID : this.elementIDs) {
            if (Ints.contains((int[])event.getAllElementIDs(), (int)elementID)) continue;
            return false;
        }
        return true;
    }

    public List<Integer> getElementIDs() {
        return this.elementIDs;
    }

    public void setElementID(int elementID) {
        this.elementIDs = Lists.newArrayList((Object[])new Integer[]{elementID});
    }

    public void addElementID(int elementID) {
        this.elementIDs.add(elementID);
    }

    public int removeElementID(int elementID) {
        int ind = this.elementIDs.indexOf(elementID);
        if (ind < 0) {
            return -1;
        }
        this.elementIDs.remove(ind);
        return ind;
    }

    public void setElementID(List<Integer> elementIDs) {
        this.elementIDs = elementIDs;
    }

    public double getMinMag() {
        return this.minMag;
    }

    public void setMinMag(double minMag) {
        this.minMag = minMag;
    }

    public double getMaxMag() {
        return this.maxMag;
    }

    public void setMaxMag(double maxMag) {
        this.maxMag = maxMag;
    }

    public static void main(String[] args) throws IOException {
    }

    @Override
    public String getName() {
        return this.name;
    }
}

