/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.simulators.iden;

import org.opensha.sha.simulators.SimulatorEvent;
import org.opensha.sha.simulators.iden.AbstractRuptureIdentifier;

public class EventTimeIdentifier
extends AbstractRuptureIdentifier {
    private final double minTime;
    private final double maxTime;
    private boolean furtherPossible = true;

    public EventTimeIdentifier(double minTime, double maxTime, boolean years) {
        if (years) {
            this.minTime = minTime * 3.1536E7;
            this.maxTime = maxTime * 3.1536E7;
        } else {
            this.minTime = minTime;
            this.maxTime = maxTime;
        }
    }

    @Override
    public boolean isMatch(SimulatorEvent event) {
        double time = event.getTime();
        this.furtherPossible = this.furtherPossible && time <= this.maxTime;
        return time >= this.minTime && time <= this.maxTime;
    }

    @Override
    public String getName() {
        double startYears = this.minTime / 3.1536E7;
        double endYears = this.minTime / 3.1536E7;
        return "Time Window(" + startYears + " yr to " + endYears + ")";
    }

    @Override
    public boolean furtherMatchesPossible() {
        return this.furtherPossible;
    }
}

