/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.simulators.iden;

import com.google.common.base.Preconditions;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import org.opensha.commons.geo.Region;
import org.opensha.sha.simulators.EventRecord;
import org.opensha.sha.simulators.SimulatorElement;
import org.opensha.sha.simulators.SimulatorEvent;
import org.opensha.sha.simulators.iden.AbstractRuptureIdentifier;

public class RegionIden
extends AbstractRuptureIdentifier {
    private Region region;
    private BitSet checked;
    private BitSet insides;

    public RegionIden(Region region) {
        this.region = region;
        this.checked = new BitSet();
        this.insides = new BitSet();
    }

    @Override
    public synchronized boolean isMatch(SimulatorEvent event) {
        for (EventRecord rec : event) {
            int[] ids = rec.getElementIDs();
            List<SimulatorElement> elems = null;
            for (int i = 0; i < ids.length; ++i) {
                boolean inside;
                int id = ids[i];
                if (this.checked.get(id)) {
                    inside = this.insides.get(id);
                } else {
                    SimulatorElement elem;
                    if (elems == null) {
                        elems = rec.getElements();
                        Preconditions.checkState((elems.size() == ids.length ? 1 : 0) != 0);
                    }
                    Preconditions.checkState(((elem = elems.get(i)).getID() == id ? 1 : 0) != 0);
                    this.doCacheForElem(elem);
                    inside = this.insides.get(id);
                }
                if (!inside) continue;
                return true;
            }
        }
        return false;
    }

    private void doCacheForElem(SimulatorElement elem) {
        this.checked.set(elem.getID());
        this.insides.set(elem.getID(), this.region.contains(elem.getCenterLocation()));
    }

    public synchronized void cacheForElement(SimulatorElement elem) {
        this.doCacheForElem(elem);
    }

    public synchronized void cacheForElements(Collection<SimulatorElement> elems) {
        for (SimulatorElement elem : elems) {
            this.doCacheForElem(elem);
        }
    }

    @Override
    public String getName() {
        return "RegionIden: " + this.region.getName();
    }
}

