/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.simulators.iden;

import com.google.common.base.Preconditions;
import org.opensha.sha.simulators.SimulatorEvent;
import org.opensha.sha.simulators.iden.AbstractRuptureIdentifier;

public class SkipYearsLoadIden
extends AbstractRuptureIdentifier {
    private double firstEventYears = Double.NaN;
    private final double skipYears;

    public SkipYearsLoadIden(double skipYears) {
        Preconditions.checkArgument((skipYears > 0.0 ? 1 : 0) != 0);
        this.skipYears = skipYears;
    }

    @Override
    public boolean isMatch(SimulatorEvent event) {
        double years = event.getTimeInYears();
        Preconditions.checkState((boolean)Double.isFinite(years));
        if (Double.isNaN(this.firstEventYears)) {
            this.firstEventYears = years;
        }
        Preconditions.checkState((years >= this.firstEventYears ? 1 : 0) != 0);
        double diff = years - this.firstEventYears;
        return diff >= this.skipYears;
    }

    @Override
    public String getName() {
        return "Skip Years Iden";
    }
}

