/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.simulators.parsers;

import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import org.opensha.sha.earthquake.FocalMechanism;
import org.opensha.sha.simulators.EQSIM_Event;
import org.opensha.sha.simulators.EQSIM_EventRecord;
import org.opensha.sha.simulators.RectangularElement;
import org.opensha.sha.simulators.SimulatorElement;
import org.opensha.sha.simulators.SimulatorEvent;
import org.opensha.sha.simulators.Vertex;
import org.opensha.sha.simulators.iden.RuptureIdentifier;

public class EQSIMv06FileReader {
    static final String GEOM_FILE_SIG = "EQSim_Input_Geometry_2";
    static final int GEOM_FILE_MIN_SPEC_LEVEL = 2;
    static final int GEOM_FILE_SPEC_LEVEL = 4;
    static final String EVENT_FILE_SIG = "EQSim_Output_Event_2";
    static final int EVENT_FILE_MIN_SPEC_LEVEL = 2;
    static final int EVENT_FILE_SPEC_LEVEL = 3;
    private static final boolean doAreaDebugScatter = false;

    public static List<SimulatorElement> readGeometryFile(File geomFile) throws IOException {
        return EQSIMv06FileReader.readGeometryFile(new FileInputStream(geomFile));
    }

    public static List<SimulatorElement> readGeometryFile(URL url) throws IOException {
        return EQSIMv06FileReader.readGeometryFile(url.openStream());
    }

    public static List<SimulatorElement> readGeometryFile(InputStream is) throws IOException {
        int i;
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        ArrayList<SimulatorElement> rectElementsList = new ArrayList<SimulatorElement>();
        ArrayList<Vertex> vertexList = new ArrayList<Vertex>();
        ArrayList simElementsListForSections = new ArrayList();
        ArrayList vertexListForSections = new ArrayList();
        ArrayList<String> sectionNamesList = new ArrayList<String>();
        ArrayList<Integer> sectionIDs_List = new ArrayList<Integer>();
        ArrayList<Integer> faultIDs_ForSections = new ArrayList<Integer>();
        ArrayList<Double> depthLoForSections = new ArrayList<Double>();
        ArrayList<Double> depthHiForSections = new ArrayList<Double>();
        ArrayList<Double> aveDipForSections = new ArrayList<Double>();
        String line = reader.readLine();
        StringTokenizer tok = new StringTokenizer(line);
        int kindOfLine = Integer.parseInt(tok.nextToken());
        String fileSignature = tok.nextToken();
        int fileSpecLevel = Integer.parseInt(tok.nextToken());
        Preconditions.checkState((kindOfLine == 101 && fileSignature.equals(GEOM_FILE_SIG) ? 1 : 0) != 0, (Object)"Wrong kind of file");
        Preconditions.checkState((fileSpecLevel >= 2 && fileSpecLevel <= 4 ? 1 : 0) != 0, (Object)("Parser currently supports spec levels 2 through 4 (given file is " + fileSpecLevel + ")"));
        int n_section = -1;
        int n_vertex = -1;
        int n_triangle = -1;
        int n_rectangle = -1;
        line = reader.readLine();
        while (line != null) {
            try {
                tok = new StringTokenizer(line);
                kindOfLine = Integer.parseInt(tok.nextToken());
                if (kindOfLine == 200) {
                    n_section = Integer.parseInt(tok.nextToken());
                    n_vertex = Integer.parseInt(tok.nextToken());
                    n_triangle = Integer.parseInt(tok.nextToken());
                    n_rectangle = Integer.parseInt(tok.nextToken());
                    if (fileSpecLevel >= 5) {
                        tok.nextToken();
                        tok.nextToken();
                        tok.nextToken();
                        tok.nextToken();
                        tok.nextToken();
                        tok.nextToken();
                        int coordSys = Integer.parseInt(tok.nextToken());
                        Preconditions.checkState((coordSys == 0 ? 1 : 0) != 0, (Object)"Currently only spherical coordinates are supported");
                    }
                } else if (kindOfLine == 201) {
                    int sid = Integer.parseInt(tok.nextToken());
                    String name = tok.nextToken();
                    int n_sect_vertex = Integer.parseInt(tok.nextToken());
                    int n_sect_triangle = Integer.parseInt(tok.nextToken());
                    int n_sect_rectangle = Integer.parseInt(tok.nextToken());
                    tok.nextToken();
                    tok.nextToken();
                    tok.nextToken();
                    tok.nextToken();
                    double depth_lo = Double.parseDouble(tok.nextToken());
                    double depth_hi = Double.parseDouble(tok.nextToken());
                    double das_lo = Double.parseDouble(tok.nextToken());
                    double das_hi = Double.parseDouble(tok.nextToken());
                    int fault_id = Integer.parseInt(tok.nextToken());
                    Preconditions.checkState((n_sect_triangle == 0 ? 1 : 0) != 0, (Object)"Don't yet support triangles");
                    sectionNamesList.add(name);
                    sectionIDs_List.add(sid);
                    faultIDs_ForSections.add(fault_id);
                    depthLoForSections.add(depth_lo);
                    depthHiForSections.add(depth_hi);
                    ArrayList<Vertex> verticesForThisSect = new ArrayList<Vertex>();
                    for (int v = 0; v < n_sect_vertex; ++v) {
                        line = reader.readLine();
                        tok = new StringTokenizer(line);
                        kindOfLine = Integer.parseInt(tok.nextToken());
                        Preconditions.checkState((kindOfLine == 202 ? 1 : 0) != 0, (Object)"Problem with file (line should start with 202)");
                        int id = Integer.parseInt(tok.nextToken());
                        double lat = Double.parseDouble(tok.nextToken());
                        double lon = Double.parseDouble(tok.nextToken());
                        double depth = -Double.parseDouble(tok.nextToken()) / 1000.0;
                        double das = Double.parseDouble(tok.nextToken()) / 1000.0;
                        int trace_flag = Integer.parseInt(tok.nextToken());
                        Vertex vertex = new Vertex(lat, lon, depth, id, das, trace_flag);
                        verticesForThisSect.add(vertex);
                        vertexList.add(vertex);
                    }
                    vertexListForSections.add(verticesForThisSect);
                    double aveDip = 0.0;
                    ArrayList<RectangularElement> simElemForThisSect = new ArrayList<RectangularElement>();
                    double totArea = 0.0;
                    for (int r = 0; r < n_sect_rectangle; ++r) {
                        line = reader.readLine();
                        tok = new StringTokenizer(line);
                        kindOfLine = Integer.parseInt(tok.nextToken());
                        Preconditions.checkState((kindOfLine == 204 ? 1 : 0) != 0, (Object)"Problem with file (line should start with 204)");
                        int id = Integer.parseInt(tok.nextToken());
                        int vertex_1_ID = Integer.parseInt(tok.nextToken());
                        int vertex_2_ID = Integer.parseInt(tok.nextToken());
                        int vertex_3_ID = Integer.parseInt(tok.nextToken());
                        int vertex_4_ID = Integer.parseInt(tok.nextToken());
                        double rake = Double.parseDouble(tok.nextToken());
                        double slip_rate = Double.parseDouble(tok.nextToken()) * 3.1536E7;
                        double aseis_factor = Double.parseDouble(tok.nextToken());
                        double strike = Double.parseDouble(tok.nextToken());
                        double dip = Double.parseDouble(tok.nextToken());
                        aveDip += dip / (double)n_sect_rectangle;
                        int perfect_flag = Integer.parseInt(tok.nextToken());
                        boolean perfectBoolean = false;
                        if (perfect_flag == 1) {
                            perfectBoolean = true;
                        }
                        Vertex[] vertices = new Vertex[]{(Vertex)vertexList.get(vertex_1_ID - 1), (Vertex)vertexList.get(vertex_2_ID - 1), (Vertex)vertexList.get(vertex_3_ID - 1), (Vertex)vertexList.get(vertex_4_ID - 1)};
                        int numAlongStrike = -1;
                        int numDownDip = -1;
                        FocalMechanism focalMechanism = new FocalMechanism(strike, dip, rake);
                        RectangularElement rectElem = new RectangularElement(id, vertices, name, fault_id, sid, numAlongStrike, numDownDip, slip_rate, aseis_factor, focalMechanism, perfectBoolean);
                        simElemForThisSect.add(rectElem);
                        rectElementsList.add(rectElem);
                        totArea += rectElem.getArea();
                    }
                    simElementsListForSections.add(simElemForThisSect);
                    aveDipForSections.add(aveDip);
                    double areaTest = Math.abs((das_hi - das_lo) * (depth_hi - depth_lo) / Math.sin(aveDip * Math.PI / 180.0));
                    double test = areaTest / totArea;
                    double testTol = 0.01;
                    if (test < 1.0 - testTol || test > 1.0 + testTol) {
                        System.out.println(sid + "\t" + name + "\t" + (float)aveDip + "\t" + totArea + "\t" + areaTest + "\t" + areaTest / totArea);
                    }
                }
            }
            catch (RuntimeException e) {
                System.out.println("Offending Line: " + line);
                System.out.flush();
                throw e;
            }
            line = reader.readLine();
        }
        Preconditions.checkState((n_section == sectionNamesList.size() ? 1 : 0) != 0, (Object)"something wrong with number of sections");
        Preconditions.checkState((n_vertex == vertexList.size() ? 1 : 0) != 0, (Object)"something wrong with number of vertices");
        Preconditions.checkState((n_rectangle == rectElementsList.size() ? 1 : 0) != 0, (Object)"something wrong with number of elements");
        System.out.println("namesOfSections.size()=" + sectionNamesList.size() + "\tvertexList.size()=" + vertexList.size() + "\trectElementsList.size()=" + rectElementsList.size());
        for (i = 0; i < vertexList.size(); ++i) {
            Preconditions.checkState((i == ((Vertex)vertexList.get(i)).getID() - 1 ? 1 : 0) != 0, (Object)("vertexList index problem at " + i));
        }
        for (i = 0; i < rectElementsList.size(); ++i) {
            Preconditions.checkState((i == ((SimulatorElement)rectElementsList.get(i)).getID() - 1 ? 1 : 0) != 0, (Object)("rectElementsList index problem at " + i));
        }
        return rectElementsList;
    }

    public static List<EQSIM_Event> readEventsFile(URL url, List<SimulatorElement> rectElementsList) throws IOException {
        return EQSIMv06FileReader.readEventsFile(url, rectElementsList, null);
    }

    public static List<EQSIM_Event> readEventsFile(URL url, List<SimulatorElement> rectElementsList, Collection<? extends RuptureIdentifier> rupIdens) throws IOException {
        URLConnection uc = url.openConnection();
        return EQSIMv06FileReader.readEventsFile(new InputStreamReader((InputStream)uc.getContent()), rectElementsList, rupIdens);
    }

    public static List<EQSIM_Event> readEventsFile(File file, List<SimulatorElement> rectElementsList) throws IOException {
        return EQSIMv06FileReader.readEventsFile(file, rectElementsList, null);
    }

    public static List<EQSIM_Event> readEventsFile(File file, List<SimulatorElement> rectElementsList, Collection<? extends RuptureIdentifier> rupIdens) throws IOException {
        return EQSIMv06FileReader.readEventsFile(new FileReader(file), rectElementsList, rupIdens);
    }

    private static List<EQSIM_Event> readEventsFile(Reader reader, List<SimulatorElement> rectElementsList, Collection<? extends RuptureIdentifier> rupIdens) throws IOException {
        BufferedReader buffRead = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        String line = buffRead.readLine();
        StringTokenizer tok = new StringTokenizer(line);
        int kindOfLine = Integer.parseInt(tok.nextToken());
        String fileSignature = tok.nextToken();
        int fileSpecLevel = Integer.parseInt(tok.nextToken());
        if (kindOfLine != 101 || !fileSignature.equals(EVENT_FILE_SIG) || fileSpecLevel < 2) {
            throw new IllegalStateException("wrong type of event input file; your first file line is:\n\n\t" + line + "\n");
        }
        ArrayList<EQSIM_Event> eventList = new ArrayList<EQSIM_Event>();
        Object currEvent = null;
        EQSIM_EventRecord evRec = null;
        int numEventRecs = 0;
        line = buffRead.readLine();
        while (line != null) {
            tok = new StringTokenizer(line);
            kindOfLine = Integer.parseInt(tok.nextToken());
            if (kindOfLine == 200) {
                try {
                    evRec = new EQSIM_EventRecord(line, rectElementsList);
                }
                catch (Exception e) {
                    System.err.println("Unable to parse line: " + line.trim() + " (error: " + e.getMessage() + ")");
                    line = buffRead.readLine();
                    Object tok2 = new StringTokenizer(line);
                    while (Integer.parseInt(((StringTokenizer)tok2).nextToken()) != 200) {
                        line = buffRead.readLine();
                        tok2 = new StringTokenizer(line);
                    }
                    continue;
                }
                ++numEventRecs;
                if (currEvent == null) {
                    EQSIM_Event event = new EQSIM_Event(evRec);
                    currEvent = event;
                } else if (((SimulatorEvent)currEvent).isSameEvent(evRec)) {
                    ((EQSIM_Event)currEvent).addEventRecord(evRec);
                } else {
                    Object event;
                    boolean keep;
                    boolean bl = keep = rupIdens == null || rupIdens.isEmpty();
                    if (!keep) {
                        for (RuptureIdentifier ruptureIdentifier : rupIdens) {
                            if (!ruptureIdentifier.isMatch((SimulatorEvent)currEvent)) continue;
                            keep = true;
                            break;
                        }
                    }
                    if (keep) {
                        eventList.add((EQSIM_Event)currEvent);
                    }
                    currEvent = event = new EQSIM_Event(evRec);
                }
            } else if (kindOfLine == 201) {
                evRec.addSlipAndElementData(line);
            } else if (kindOfLine == 202) {
                evRec.addType202_Line(line);
            }
            line = buffRead.readLine();
        }
        if (currEvent != null) {
            boolean keep;
            boolean bl = keep = rupIdens == null || rupIdens.isEmpty();
            if (!keep) {
                for (RuptureIdentifier ruptureIdentifier : rupIdens) {
                    if (!ruptureIdentifier.isMatch((SimulatorEvent)currEvent)) continue;
                    keep = true;
                    break;
                }
            }
            if (keep) {
                eventList.add((EQSIM_Event)currEvent);
            }
        }
        System.out.println("Num Events = " + eventList.size() + "\tNum Event Records = " + numEventRecs);
        int numEventsKept = eventList.size();
        int numEventsInFile = ((SimulatorEvent)currEvent).getID();
        if (numEventsKept != numEventsInFile) {
            System.out.println("Warning: " + (numEventsInFile - numEventsKept) + " were not able to be read from the input file");
        }
        return eventList;
    }
}

