/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.simulators.stiffness;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Doubles;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.zip.ZipException;
import org.apache.commons.math3.stat.StatUtils;
import org.dom4j.DocumentException;
import org.opensha.commons.util.DataUtils;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.UniqueRupture;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.simulators.stiffness.AggregatedStiffnessCache;
import org.opensha.sha.simulators.stiffness.SubSectStiffnessCalculator;
import scratch.UCERF3.U3FaultSystemRupSet;
import scratch.UCERF3.utils.U3FaultSystemIO;

public class AggregatedStiffnessCalculator {
    private static final boolean D = false;
    private static final boolean DD = false;
    private SubSectStiffnessCalculator.StiffnessType type;
    private SubSectStiffnessCalculator calc;
    private transient AggregatedStiffnessCache cache;
    public static final int MAX_LAYERS = 4;
    private AggregationMethod[] layers;
    private boolean allowSectToSelf = false;
    public static final EnumSet<AggregationMethod> CACHEABLE_AGG_METHODS = EnumSet.range(AggregationMethod.MEAN, AggregationMethod.COUNT);
    private static final int CACHE_ARRAY_SIZE;
    private transient int patch_sect_id_multiplier = -1;
    private transient int patch_sect_id_add = -1;
    private static final boolean CACHE_SS2R = false;
    private transient List<ConcurrentMap<UniqueRupture, Double>> ss2rCache = null;
    private static final boolean CACHE_SS2RS = false;
    private transient ConcurrentMap<UniqueRupture, ConcurrentMap<UniqueRupture, Double>> ss2rsCache = null;

    private static ReceiverDistribution interactionTest(int receiverID, ReceiverDistribution[] dists, double threshold, double valPass, double valFail) {
        double sum = 0.0;
        long interactionCount = 0L;
        for (ReceiverDistribution dist : dists) {
            interactionCount += dist.totNumInteractions;
            for (double val : dist.values) {
                sum += val;
            }
        }
        Preconditions.checkState((interactionCount > 0L ? 1 : 0) != 0, (String)"No interactions (%s) found at this level. Have %s dists and sum=%s", (Object)interactionCount, (Object)dists.length, (Object)sum);
        double fract = sum / (double)interactionCount;
        if (fract > threshold) {
            return new ReceiverDistribution(receiverID, interactionCount, valPass);
        }
        return new ReceiverDistribution(receiverID, interactionCount, valFail);
    }

    private static ReceiverDistribution flatten(int receiverID, ReceiverDistribution[] dists) {
        double[] flattened;
        Preconditions.checkState((dists.length > 0 ? 1 : 0) != 0);
        long totNumInteractions = 0L;
        if (dists.length == 1) {
            flattened = dists[0].values;
            totNumInteractions = dists[0].totNumInteractions;
        } else {
            int totSize = 0;
            for (ReceiverDistribution dist : dists) {
                totSize += dist.values.length;
            }
            flattened = new double[totSize];
            int index = 0;
            for (ReceiverDistribution dist : dists) {
                System.arraycopy(dist.values, 0, flattened, index, dist.values.length);
                index += dist.values.length;
                totNumInteractions += dist.totNumInteractions;
            }
        }
        return new ReceiverDistribution(receiverID, totNumInteractions, flattened);
    }

    private static ReceiverDistribution flatten(int receiverID, List<ReceiverDistribution> dists) {
        double[] flattened;
        Preconditions.checkState((dists.size() > 0 ? 1 : 0) != 0);
        long totNumInteractions = 0L;
        if (dists.size() == 1) {
            flattened = dists.get((int)0).values;
            totNumInteractions = dists.get((int)0).totNumInteractions;
        } else {
            int totSize = 0;
            for (ReceiverDistribution dist : dists) {
                totSize += dist.values.length;
            }
            flattened = new double[totSize];
            int index = 0;
            for (ReceiverDistribution dist : dists) {
                System.arraycopy(dist.values, 0, flattened, index, dist.values.length);
                index += dist.values.length;
                totNumInteractions += dist.totNumInteractions;
            }
        }
        return new ReceiverDistribution(receiverID, totNumInteractions, flattened);
    }

    public static Builder builder(SubSectStiffnessCalculator.StiffnessType type, SubSectStiffnessCalculator calc) {
        return new Builder(type, calc);
    }

    public AggregatedStiffnessCalculator(SubSectStiffnessCalculator.StiffnessType type, SubSectStiffnessCalculator calc, boolean allowSectToSelf, AggregationMethod ... layers) {
        this.type = type;
        this.calc = calc;
        this.allowSectToSelf = allowSectToSelf;
        Preconditions.checkState((layers.length > 0 ? 1 : 0) != 0, (Object)"must supply at least 1 aggregation layer");
        Preconditions.checkState((layers.length < 5 ? 1 : 0) != 0, (Object)"only 4 aggregation layers are possible");
        for (int i = 0; i < layers.length; ++i) {
            Preconditions.checkNotNull((Object)((Object)layers[i]), (String)"Layer at level %s is null", (int)i);
        }
        Preconditions.checkState((boolean)layers[layers.length - 1].isTerminal(), (String)"Final layer must be a terminal layer (but is %s)", (Object)((Object)layers[layers.length - 1]));
        this.layers = layers;
    }

    private int uniquePatchID(int sectID, int patchID) {
        if (this.patch_sect_id_multiplier <= 0) {
            int numSects;
            this.patch_sect_id_add = numSects = this.calc.getSubSects().size();
            this.patch_sect_id_multiplier = Integer.MAX_VALUE / numSects;
        }
        Preconditions.checkState((patchID < this.patch_sect_id_multiplier - 1 ? 1 : 0) != 0, (String)"Patch ID overflow: patchID=%s, multiplier=%s", (int)patchID, (int)this.patch_sect_id_multiplier);
        return this.patch_sect_id_add + sectID * this.patch_sect_id_multiplier + patchID;
    }

    private ReceiverDistribution[] aggRecieverPatches(FaultSection source, FaultSection receiver) {
        Preconditions.checkState((this.layers.length > 0 ? 1 : 0) != 0, (Object)"Patch aggregation layer not supplied");
        int sourceID = source.getSectionId();
        int receiverID = receiver.getSectionId();
        Preconditions.checkState((this.allowSectToSelf || sourceID != receiverID ? 1 : 0) != 0, (Object)"srouceID=receiverID and allowSectToSelf is false");
        if (this.layers[0].isTerminal()) {
            ReceiverDistribution[] cached;
            if (this.cache == null) {
                this.cache = this.calc.getAggregationCache(this.type);
            }
            if ((cached = this.cache.getPatchAggregated(this.layers[0], source, receiver)) != null) {
                return cached;
            }
        }
        SubSectStiffnessCalculator.StiffnessDistribution dist = this.calc.calcStiffnessDistribution(source, receiver);
        double[][] values = dist.get(this.type);
        double[] receiverPatchVals = new double[values.length];
        ReceiverDistribution[] receiverDists = new ReceiverDistribution[values.length];
        boolean sameSect = sourceID == receiverID;
        for (int r = 0; r < receiverPatchVals.length; ++r) {
            double[] receiverVals;
            if (sameSect) {
                Preconditions.checkState((values[r].length == receiverDists.length ? 1 : 0) != 0);
                receiverVals = new double[receiverDists.length - 1];
                if (r > 0) {
                    System.arraycopy(values[r], 0, receiverVals, 0, r);
                }
                if (r < receiverVals.length) {
                    System.arraycopy(values[r], r + 1, receiverVals, r, receiverVals.length - r);
                }
            } else {
                receiverVals = values[r];
            }
            receiverDists[r] = new ReceiverDistribution(this.uniquePatchID(receiver.getSectionId(), r), (long)receiverVals.length, receiverVals);
        }
        ReceiverDistribution[] aggregated = this.layers[0].aggregate(receiver.getSectionId(), receiverDists);
        if (this.cache != null && this.layers[0].isTerminal()) {
            this.cache.putPatchAggregated(this.layers[0], source, receiver, aggregated);
        }
        return aggregated;
    }

    private boolean isSectToSectCacheable() {
        return this.layers[1].isTerminal() && (this.layers[0].isTerminal() || this.layers[0] == AggregationMethod.FLATTEN);
    }

    private StiffnessAggregation getCachedSectToSect(FaultSection source, FaultSection receiver) {
        StiffnessAggregation aggregated;
        AggregationMethod patchAggMethod = null;
        if (this.layers[0].isTerminal()) {
            patchAggMethod = this.layers[0];
        } else {
            Preconditions.checkState((this.layers[0] == AggregationMethod.FLATTEN ? 1 : 0) != 0);
        }
        if (this.cache == null) {
            this.cache = this.calc.getAggregationCache(this.type);
        }
        if ((aggregated = this.cache.getSectAggregated(patchAggMethod, source, receiver)) == null) {
            ReceiverDistribution receiverPatchDist = AggregatedStiffnessCalculator.flatten(receiver.getSectionId(), this.aggRecieverPatches(source, receiver));
            aggregated = new StiffnessAggregation(receiverPatchDist.values, receiverPatchDist.totNumInteractions);
            this.cache.putSectAggregated(patchAggMethod, source, receiver, aggregated);
        }
        return aggregated;
    }

    private ReceiverDistribution[] aggSectToSect(FaultSection source, FaultSection receiver) {
        Preconditions.checkState((this.allowSectToSelf || source.getSectionId() != receiver.getSectionId() ? 1 : 0) != 0, (String)"Source and receiver ID are the same and allowSectToSelf=false: %s", (int)source.getSectionId());
        Preconditions.checkState((this.layers.length > 1 ? 1 : 0) != 0, (Object)"Section-to-section aggregation layer not supplied");
        if (this.isSectToSectCacheable()) {
            StiffnessAggregation aggregated = this.getCachedSectToSect(source, receiver);
            double val = aggregated.get(this.layers[1]);
            return new ReceiverDistribution[]{new ReceiverDistribution(receiver.getSectionId(), (long)((int)aggregated.get(AggregationMethod.COUNT)), new double[]{val})};
        }
        ReceiverDistribution[] receiverPatchDists = this.aggRecieverPatches(source, receiver);
        ReceiverDistribution[] aggregated = this.layers[1].aggregate(receiver.getSectionId(), receiverPatchDists);
        return aggregated;
    }

    private double processUntilTerminal(int curLayer, int receiverID, ReceiverDistribution ... dists) {
        if (this.layers[curLayer].isTerminal()) {
            double val = this.layers[curLayer].get(dists);
            return val;
        }
        dists = this.layers[curLayer].aggregate(receiverID, dists);
        return this.processUntilTerminal(curLayer + 1, -1, dists);
    }

    public double[] calcReceiverPatchAgg(FaultSection source, FaultSection receiver) {
        Preconditions.checkState((source.getSectionId() != receiver.getSectionId() ? 1 : 0) != 0, (String)"Source and receiver ID are the same and allowSectToSelf=false: %s", (int)source.getSectionId());
        ReceiverDistribution[] receiverPatchDists = this.aggRecieverPatches(source, receiver);
        double[] ret = new double[receiverPatchDists.length];
        if (this.layers[0].isTerminal()) {
            for (int i = 0; i < ret.length; ++i) {
                Preconditions.checkState((receiverPatchDists[i].values.length == 1 ? 1 : 0) != 0);
                ret[i] = receiverPatchDists[i].values[0];
            }
        } else {
            for (int i = 0; i < ret.length; ++i) {
                ret[i] = this.processUntilTerminal(1, i, receiverPatchDists[i]);
            }
        }
        return ret;
    }

    public double calc(FaultSection source, FaultSection receiver) {
        Preconditions.checkState((source.getSectionId() != receiver.getSectionId() ? 1 : 0) != 0, (String)"Source and receiver ID are the same and allowSectToSelf=false: %s", (int)source.getSectionId());
        Preconditions.checkState((this.layers.length > 1 ? 1 : 0) != 0, (Object)"Section-to-section aggregation layer not supplied");
        if (this.isSectToSectCacheable()) {
            StiffnessAggregation aggregated = this.getCachedSectToSect(source, receiver);
            double val = aggregated.get(this.layers[1]);
            return val;
        }
        ReceiverDistribution[] receiverPatchDists = this.aggRecieverPatches(source, receiver);
        return this.processUntilTerminal(1, receiver.getSectionId(), receiverPatchDists);
    }

    private ReceiverDistribution[] collectMultiSectsToSect(Collection<? extends FaultSection> sources, FaultSection receiver) {
        if (!this.allowSectToSelf) {
            ArrayList<? extends FaultSection> filtered = new ArrayList<FaultSection>(sources.size());
            int receiverID = receiver.getSectionId();
            for (FaultSection faultSection : sources) {
                if (faultSection.getSectionId() == receiverID) continue;
                filtered.add(faultSection);
            }
            sources = filtered;
        }
        Preconditions.checkState((!sources.isEmpty() ? 1 : 0) != 0, (Object)"No sources that aren't the receiver");
        ReceiverDistribution[] receiverSectDists = new ReceiverDistribution[sources.size()];
        ArrayList<ReceiverDistribution> distsList = null;
        int s = 0;
        for (FaultSection faultSection : sources) {
            ReceiverDistribution[] aggregated = this.aggSectToSect(faultSection, receiver);
            if (distsList != null) {
                Collections.addAll(distsList, aggregated);
            } else if (aggregated.length != 1) {
                if (distsList == null) {
                    distsList = new ArrayList<ReceiverDistribution>(sources.size() * aggregated.length);
                    for (int i = 0; i < s; ++i) {
                        distsList.add(receiverSectDists[i]);
                    }
                }
                Collections.addAll(distsList, aggregated);
            } else {
                receiverSectDists[s] = aggregated[0];
            }
            ++s;
        }
        if (distsList != null) {
            receiverSectDists = distsList.size() > receiverSectDists.length ? distsList.toArray(receiverSectDists) : distsList.toArray(new ReceiverDistribution[distsList.size()]);
        }
        return receiverSectDists;
    }

    public double[] calcReceiverPatchAgg(List<FaultSection> sources, FaultSection receiver) {
        ReceiverDistribution[][] receiverAgg = null;
        for (int s = 0; s < sources.size(); ++s) {
            FaultSection source = sources.get(s);
            ReceiverDistribution[] receiverPatchDists = this.aggRecieverPatches(source, receiver);
            if (receiverAgg == null) {
                receiverAgg = new ReceiverDistribution[receiverPatchDists.length][sources.size()];
            } else {
                Preconditions.checkState((receiverPatchDists.length == receiverAgg.length ? 1 : 0) != 0);
            }
            for (int i = 0; i < receiverPatchDists.length; ++i) {
                receiverAgg[i][s] = receiverPatchDists[i];
            }
        }
        double[] ret = new double[receiverAgg.length];
        for (int i = 0; i < receiverAgg.length; ++i) {
            ret[i] = this.processUntilTerminal(1, this.uniquePatchID(receiver.getSectionId(), i), receiverAgg[i]);
        }
        return ret;
    }

    private ReceiverDistribution[] aggSectsToSect(Collection<? extends FaultSection> sources, FaultSection receiver) {
        Preconditions.checkState((this.layers.length > 2 ? 1 : 0) != 0, (Object)"Sections-to-section aggregation layer not supplied");
        ReceiverDistribution[] receiverSectDists = this.collectMultiSectsToSect(sources, receiver);
        ReceiverDistribution[] aggregated = this.layers[2].aggregate(receiver.getSectionId(), receiverSectDists);
        return aggregated;
    }

    public double calc(Collection<? extends FaultSection> sources, FaultSection receiver) {
        return this.calc(sources, receiver, null);
    }

    private double calc(Collection<? extends FaultSection> sources, FaultSection receiver, UniqueRupture sourcesUnique) {
        Preconditions.checkState((this.layers.length > 2 ? 1 : 0) != 0, (Object)"Sections-to-section aggregation layer not supplied");
        ReceiverDistribution[] receiverSectDists = this.collectMultiSectsToSect(sources, receiver);
        return this.processUntilTerminal(2, receiver.getSectionId(), receiverSectDists);
    }

    /*
     * WARNING - void declaration
     */
    public double calc(Collection<? extends FaultSection> sources, Collection<? extends FaultSection> receivers) {
        Preconditions.checkState((this.layers.length > 3 ? 1 : 0) != 0, (Object)"Sections-to-sections aggregation layer not supplied");
        Preconditions.checkState((boolean)this.layers[3].isTerminal(), (String)"Final layer must be terminal: %s", (Object)((Object)this.layers[3]));
        if (this.layers[3].isSplittable()) {
            if (receivers.size() == 1 && this.layers[3] == this.layers[2]) {
                return this.calc(sources, receivers.iterator().next());
            }
            double[] values = new double[receivers.size()];
            int r = 0;
            UniqueRupture sourcesUnique = null;
            for (FaultSection faultSection : receivers) {
                values[r++] = this.calc(sources, faultSection, sourcesUnique);
            }
            return this.layers[3].calculate(values);
        }
        Object sourcesUnique = null;
        Object receiversUnique = null;
        Object sourcesCache = null;
        Double val = null;
        if (val == null) {
            void var7_15;
            ReceiverDistribution[] receiverDistributionArray = new ReceiverDistribution[receivers.size()];
            ArrayList<ReceiverDistribution> distsList = null;
            int r = 0;
            for (FaultSection faultSection : receivers) {
                ReceiverDistribution[] aggregated = this.aggSectsToSect(sources, faultSection);
                if (distsList != null) {
                    Collections.addAll(distsList, aggregated);
                } else if (aggregated.length > 1) {
                    if (distsList == null) {
                        distsList = new ArrayList<ReceiverDistribution>(sources.size() * aggregated.length);
                        for (int i = 0; i < r; ++i) {
                            distsList.add(receiverDistributionArray[i]);
                        }
                    }
                    Collections.addAll(distsList, aggregated);
                } else {
                    receiverDistributionArray[r] = aggregated[0];
                }
                ++r;
            }
            if (distsList != null) {
                if (distsList.size() > receiverDistributionArray.length) {
                    ReceiverDistribution[] receiverDistributionArray2 = distsList.toArray(receiverDistributionArray);
                } else {
                    ReceiverDistribution[] receiverDistributionArray3 = distsList.toArray(new ReceiverDistribution[distsList.size()]);
                }
            }
            val = this.layers[3].get((ReceiverDistribution[])var7_15);
        }
        return val;
    }

    public boolean hasUnits() {
        boolean hasUnits = true;
        for (AggregationMethod layer : this.layers) {
            hasUnits = hasUnits && layer.hasUnits;
        }
        return hasUnits;
    }

    public AggregationMethod[] getAggregationLayers() {
        return this.layers;
    }

    public String getScalarName() {
        String name = null;
        for (int l = 0; l < this.layers.length; ++l) {
            if (this.layers[l] == AggregationMethod.FLATTEN || this.layers[l] == AggregationMethod.PASSTHROUGH || l > 0 && this.layers[l] == this.layers[l - 1]) continue;
            if (this.layers[l] == AggregationMethod.FRACT_POSITIVE) {
                name = "Fract " + (String)(name == null ? "" : "[" + name + "]") + "\u22650";
                continue;
            }
            if (this.layers[l] == AggregationMethod.NUM_NEGATIVE) {
                name = "Num " + (String)(name == null ? "" : "[" + name + "]") + "<0";
                continue;
            }
            if (this.layers[l] == AggregationMethod.NUM_POSITIVE) {
                name = "Num " + (String)(name == null ? "" : "[" + name + "]") + "\u22650";
                continue;
            }
            if (this.layers[l] == AggregationMethod.NORM_BY_COUNT) {
                name = "[" + (String)(name == null ? "" : name) + "]/Count";
                continue;
            }
            if (l == 0) {
                if (this.layers.length > 1 && this.layers[1] == this.layers[0]) {
                    name = "Sect " + this.layers[l].name;
                    continue;
                }
                name = "Patch " + this.layers[l].name;
                continue;
            }
            if (this.layers[l] == AggregationMethod.RECEIVER_SUM) {
                if (this.layers[1].isTerminal()) {
                    name = "Receiver Sect Aggregate" + (String)(name == null ? "" : " [" + name + "]");
                    continue;
                }
                if (this.layers[0].isTerminal()) {
                    name = "Receiver Patch Aggregate" + (String)(name == null ? "" : " [" + name + "]");
                    continue;
                }
                name = "Receiver Aggregate " + (String)(name == null ? "" : "[" + name + "]");
                continue;
            }
            if (l == 1 && name == null) {
                name = "Sect " + this.layers[l].name;
                continue;
            }
            if (this.layers[l] == this.layers[l - 1]) continue;
            name = this.layers[l].name + (String)(name == null ? "" : " [" + name + "]");
        }
        return name;
    }

    public String getScalarShortName() {
        return this.getScalarName().replaceAll("Receiver", "Rec").replaceAll("Median", "Mdn").replaceAll("Aggregate", "Agg").replaceAll("imum", "").replaceAll("Sect", "S-").replaceAll("Patch", "P-").replaceAll("Dominant", "Dom").replaceAll("Interaction", "Int").replaceAll(" ", "");
    }

    public SubSectStiffnessCalculator.StiffnessType getType() {
        return this.type;
    }

    public String toString() {
        return Arrays.stream(this.layers).map(s -> s.toString()).collect(Collectors.joining(" -> ", "AggStiffnessCalc[", "]"));
    }

    public SubSectStiffnessCalculator getCalc() {
        return this.calc;
    }

    public static void main(String[] args) throws ZipException, IOException, DocumentException {
        File fssFile = new File("/home/kevin/Simulators/catalogs/rundir4983_stitched/fss/rsqsim_sol_m6.5_skip5000_sectArea0.2.zip");
        U3FaultSystemRupSet rupSet = U3FaultSystemIO.loadRupSet(fssFile);
        double lambda = 30000.0;
        double mu = 30000.0;
        double coeffOfFriction = 0.5;
        double gridSpacing = 4.0;
        List<? extends FaultSection> subSects = rupSet.getFaultSectionDataList();
        SubSectStiffnessCalculator calc = new SubSectStiffnessCalculator(subSects, gridSpacing, lambda, mu, coeffOfFriction);
        calc.setPatchAlignment(SubSectStiffnessCalculator.PatchAlignment.FILL_OVERLAP);
        AggregatedStiffnessCalculator aggCalc = new AggregatedStiffnessCalculator(SubSectStiffnessCalculator.StiffnessType.CFF, calc, true, AggregationMethod.NUM_POSITIVE, AggregationMethod.SUM, AggregationMethod.SUM, AggregationMethod.NORM_BY_COUNT);
        ArrayList rupSects = Lists.newArrayList((Object[])new FaultSection[]{subSects.get(419), subSects.get(420)});
        System.out.println(aggCalc.calc((Collection<? extends FaultSection>)rupSects, rupSects));
    }

    static {
        int maxTerminalIndex = -1;
        for (AggregationMethod method : AggregationMethod.values()) {
            if (!CACHEABLE_AGG_METHODS.contains((Object)method)) continue;
            Preconditions.checkState((boolean)method.isTerminal());
            maxTerminalIndex = Integer.max(maxTerminalIndex, method.ordinal());
        }
        CACHE_ARRAY_SIZE = maxTerminalIndex + 1;
    }

    public static class ReceiverDistribution {
        public final int receiverID;
        public final double[] values;
        public final long totNumInteractions;

        public ReceiverDistribution(int receiverID, long totNumInteractions, List<Double> values) {
            this(receiverID, totNumInteractions, Doubles.toArray(values));
        }

        public ReceiverDistribution(int receiverID, long totNumInteractions, double value) {
            this(receiverID, totNumInteractions, new double[]{value});
        }

        public ReceiverDistribution(int receiverID, long totNumInteractions, double[] values) {
            this.receiverID = receiverID;
            this.totNumInteractions = totNumInteractions;
            this.values = values;
        }

        public int getReceiverID() {
            return this.receiverID;
        }

        public String toString() {
            return this.receiverID + ": " + DoubleStream.of(this.values).mapToObj(String::valueOf).collect(Collectors.joining(",")) + "\ttotNumInteractions=" + this.totNumInteractions;
        }
    }

    public static class Builder {
        private SubSectStiffnessCalculator.StiffnessType type;
        private SubSectStiffnessCalculator calc;
        private List<AggregationMethod> layers;
        private boolean allowSectToSelf = false;

        private Builder(SubSectStiffnessCalculator.StiffnessType type, SubSectStiffnessCalculator calc) {
            this.type = type;
            this.calc = calc;
            this.layers = new ArrayList<AggregationMethod>();
        }

        public Builder allowSectToSelf(boolean allowSectToSelf) {
            this.allowSectToSelf = allowSectToSelf;
            return this;
        }

        public Builder flatten() {
            this.layers.add(AggregationMethod.FLATTEN);
            return this;
        }

        public Builder receiverSum() {
            this.layers.add(AggregationMethod.RECEIVER_SUM);
            return this;
        }

        public Builder process(AggregationMethod method) {
            this.layers.add(method);
            return this;
        }

        public Builder passthrough() {
            this.layers.add(AggregationMethod.PASSTHROUGH);
            return this;
        }

        public Builder receiverPatchAgg(AggregationMethod aggMethod) {
            Preconditions.checkState((boolean)this.layers.isEmpty(), (Object)"Receiver patch aggregation must be specified first");
            this.process(aggMethod);
            return this;
        }

        public Builder sectToSectAgg(AggregationMethod aggMethod) {
            Preconditions.checkState((this.layers.size() < 2 ? 1 : 0) != 0);
            if (this.layers.isEmpty()) {
                this.flatten();
            }
            this.process(aggMethod);
            return this;
        }

        public Builder sectsToSectAgg(AggregationMethod aggMethod) {
            Preconditions.checkState((this.layers.size() == 2 ? 1 : 0) != 0, (Object)"Must have supplied a sect-to-sect aggregation level (and nothing further)");
            this.process(aggMethod);
            return this;
        }

        public Builder sectsToSectsAgg(AggregationMethod aggMethod) {
            Preconditions.checkState((this.layers.size() >= 2 ? 1 : 0) != 0, (Object)"Must have supplied at least a sect-to-sect aggregation level first");
            Preconditions.checkState((this.layers.size() < 4 ? 1 : 0) != 0, (Object)"Aggregation levels already completely specified");
            if (this.layers.size() == 2) {
                this.flatten();
            }
            this.process(aggMethod);
            return this;
        }

        public AggregatedStiffnessCalculator get() {
            return new AggregatedStiffnessCalculator(this.type, this.calc, this.allowSectToSelf, this.layers.toArray(new AggregationMethod[0]));
        }
    }

    public static enum AggregationMethod {
        MEAN("Mean", true, true){

            @Override
            public double calculate(double[] values) {
                return StatUtils.mean((double[])values);
            }
        }
        ,
        MEDIAN("Median", true, true){

            @Override
            public double calculate(double[] values) {
                Arrays.sort(values);
                return DataUtils.median_sorted(values);
            }
        }
        ,
        SUM("Sum", true, true){

            @Override
            public double calculate(double[] values) {
                return StatUtils.sum((double[])values);
            }

            @Override
            public boolean isSplittable() {
                return true;
            }
        }
        ,
        MIN("Minimum", true, true){

            @Override
            public double calculate(double[] values) {
                return StatUtils.min((double[])values);
            }

            @Override
            public boolean isSplittable() {
                return true;
            }
        }
        ,
        MAX("Maximum", true, true){

            @Override
            public double calculate(double[] values) {
                return StatUtils.max((double[])values);
            }

            @Override
            public boolean isSplittable() {
                return true;
            }
        }
        ,
        FRACT_POSITIVE("Fraction Positive", false, true){

            @Override
            public double calculate(double[] values) {
                return NUM_POSITIVE.calculate(values) / (double)values.length;
            }
        }
        ,
        NUM_POSITIVE("Num Positive", false, true){

            @Override
            public double calculate(double[] values) {
                int count = 0;
                for (double val : values) {
                    if (!(val >= 0.0)) continue;
                    ++count;
                }
                return count;
            }
        }
        ,
        NUM_NEGATIVE("Num Negative", false, true){

            @Override
            public double calculate(double[] values) {
                return (double)values.length - NUM_POSITIVE.calculate(values);
            }
        }
        ,
        GREATER_SUM_MEDIAN("Max[Sum,Median]", true, true){

            @Override
            public double calculate(double[] values) {
                Arrays.sort(values);
                return Math.max(values[values.length - 1], DataUtils.median_sorted(values));
            }
        }
        ,
        GREATER_MEAN_MEDIAN("Max[Mean,Median]", true, true){

            @Override
            public double calculate(double[] values) {
                Arrays.sort(values);
                return Math.max(MEAN.calculate(values), DataUtils.median_sorted(values));
            }
        }
        ,
        COUNT("Count", true, true){

            @Override
            public double calculate(double[] values) {
                return values.length;
            }
        }
        ,
        FLATTEN("Flatten", true, false){

            @Override
            public ReceiverDistribution[] aggregate(int higherLevelID, ReceiverDistribution[] dists) {
                return new ReceiverDistribution[]{AggregatedStiffnessCalculator.flatten(higherLevelID, dists)};
            }
        }
        ,
        RECEIVER_SUM("ReceiverSum", true, false){

            @Override
            public ReceiverDistribution[] aggregate(int higherLevelID, ReceiverDistribution[] dists) {
                Map<Integer, List<ReceiverDistribution>> grouped = Arrays.stream(dists).collect(Collectors.groupingBy(ReceiverDistribution::getReceiverID));
                ReceiverDistribution[] ret = new ReceiverDistribution[grouped.keySet().size()];
                int index = 0;
                for (Integer receiverID : grouped.keySet()) {
                    List<ReceiverDistribution> receiverDists = grouped.get(receiverID);
                    if (receiverDists.size() == 1) {
                        ret[index++] = receiverDists.get(0);
                        continue;
                    }
                    ReceiverDistribution flattened = AggregatedStiffnessCalculator.flatten((int)receiverID, receiverDists);
                    ret[index++] = new ReceiverDistribution((int)receiverID, flattened.totNumInteractions, StatUtils.sum((double[])flattened.values));
                }
                return ret;
            }
        }
        ,
        NORM_BY_COUNT("Normalize By Interaction Count", false, true){

            @Override
            public ReceiverDistribution[] aggregate(int higherLevelID, ReceiverDistribution[] dists) {
                double sum = 0.0;
                long interactionCount = 0L;
                for (ReceiverDistribution dist : dists) {
                    interactionCount += dist.totNumInteractions;
                    for (double val : dist.values) {
                        sum += val;
                    }
                }
                double fract = sum / (double)interactionCount;
                Preconditions.checkState((interactionCount > 0L ? 1 : 0) != 0, (String)"No interactions (%s) found at this level. Have %s dists and sum=%s", (Object)interactionCount, (Object)dists.length, (Object)sum);
                return new ReceiverDistribution[]{new ReceiverDistribution(higherLevelID, interactionCount, fract)};
            }

            @Override
            public double get(ReceiverDistribution[] dists) {
                ReceiverDistribution[] agg = this.aggregate(-1, dists);
                Preconditions.checkState((agg.length == 1 && agg[0].values.length == 1 ? 1 : 0) != 0);
                return agg[0].values[0];
            }
        }
        ,
        HALF_INTERACTIONS("1/2 Interactions", false, true){

            @Override
            public ReceiverDistribution[] aggregate(int higherLevelID, ReceiverDistribution[] dists) {
                return new ReceiverDistribution[]{AggregatedStiffnessCalculator.interactionTest(higherLevelID, dists, 0.5, 1.0, -1.0)};
            }

            @Override
            public double get(ReceiverDistribution[] dists) {
                ReceiverDistribution[] agg = this.aggregate(-1, dists);
                Preconditions.checkState((agg.length == 1 && agg[0].values.length == 1 ? 1 : 0) != 0);
                return agg[0].values[0];
            }
        }
        ,
        THREE_QUARTER_INTERACTIONS("3/4 Interactions", false, true){

            @Override
            public ReceiverDistribution[] aggregate(int higherLevelID, ReceiverDistribution[] dists) {
                return new ReceiverDistribution[]{AggregatedStiffnessCalculator.interactionTest(higherLevelID, dists, 0.75, 1.0, -1.0)};
            }

            @Override
            public double get(ReceiverDistribution[] dists) {
                ReceiverDistribution[] agg = this.aggregate(-1, dists);
                Preconditions.checkState((agg.length == 1 && agg[0].values.length == 1 ? 1 : 0) != 0);
                return agg[0].values[0];
            }
        }
        ,
        NINE_TENTH_INTERACTIONS("9/10 Interactions", false, true){

            @Override
            public ReceiverDistribution[] aggregate(int higherLevelID, ReceiverDistribution[] dists) {
                return new ReceiverDistribution[]{AggregatedStiffnessCalculator.interactionTest(higherLevelID, dists, 0.9, 1.0, -1.0)};
            }

            @Override
            public double get(ReceiverDistribution[] dists) {
                ReceiverDistribution[] agg = this.aggregate(-1, dists);
                Preconditions.checkState((agg.length == 1 && agg[0].values.length == 1 ? 1 : 0) != 0);
                return agg[0].values[0];
            }
        }
        ,
        PASSTHROUGH("Passthrough", true, false){

            @Override
            public ReceiverDistribution[] aggregate(int higherLevelID, ReceiverDistribution[] dists) {
                return dists;
            }
        }
        ,
        FLAT_SUM("FlatSum", true, true){

            @Override
            public double calculate(double[] values) {
                return StatUtils.sum((double[])values);
            }

            @Override
            public ReceiverDistribution[] aggregate(int higherLevelID, ReceiverDistribution[] dists) {
                double totalSum = 0.0;
                long totalNumInts = 0L;
                for (ReceiverDistribution dist : dists) {
                    totalSum += this.calculate(dist.values);
                    totalNumInts += dist.totNumInteractions;
                }
                return new ReceiverDistribution[]{new ReceiverDistribution(higherLevelID, totalNumInts, totalSum)};
            }
        };

        private String name;
        private boolean hasUnits;
        private boolean terminal;

        private AggregationMethod(String name, boolean hasUnits, boolean isTerminal) {
            this.name = name;
            this.hasUnits = hasUnits;
            this.terminal = isTerminal;
        }

        public String toString() {
            return this.name;
        }

        public double calculate(double[] values) {
            Preconditions.checkState((!this.terminal ? 1 : 0) != 0, (String)"%s is terminal but hasn't implemented calculate(double[])", (Object)this.name());
            throw new IllegalStateException("Can't calculate a single value with a non-terminal aggregation method");
        }

        public ReceiverDistribution[] aggregate(int higherLevelID, ReceiverDistribution[] dists) {
            Preconditions.checkState((boolean)this.terminal, (Object)"Non-terminal aggreagation methods must override aggregate() method");
            ReceiverDistribution[] aggregated = new ReceiverDistribution[dists.length];
            int index = 0;
            for (ReceiverDistribution dist : dists) {
                aggregated[index++] = new ReceiverDistribution(dist.receiverID, dist.totNumInteractions, this.calculate(dist.values));
            }
            return aggregated;
        }

        public double get(ReceiverDistribution[] dists) {
            ReceiverDistribution dist;
            Preconditions.checkState((boolean)this.terminal, (Object)"Can't get a single value for a non-terminal aggregation method");
            if (dists.length > 1) {
                dist = AggregatedStiffnessCalculator.flatten(-1, dists);
            } else {
                Preconditions.checkState((dists.length == 1 ? 1 : 0) != 0, (Object)"No distributions left at this layer");
                dist = dists[0];
            }
            return this.calculate(dist.values);
        }

        public boolean isTerminal() {
            return this.terminal;
        }

        public boolean hasUnits() {
            return this.hasUnits;
        }

        public boolean isSplittable() {
            return false;
        }
    }

    public static class StiffnessAggregation {
        private final double[] aggValues;

        public StiffnessAggregation(double[] values, long interactionCount) {
            Arrays.sort(values);
            this.aggValues = new double[CACHE_ARRAY_SIZE];
            int numPositive = 0;
            double sum = 0.0;
            int count = values.length;
            for (double val : values) {
                sum += val;
                if (!(val >= 0.0)) continue;
                ++numPositive;
            }
            this.aggValues[AggregationMethod.MEAN.ordinal()] = sum / (double)count;
            this.aggValues[AggregationMethod.MEDIAN.ordinal()] = DataUtils.median_sorted(values);
            this.aggValues[AggregationMethod.SUM.ordinal()] = sum;
            this.aggValues[AggregationMethod.MIN.ordinal()] = values[0];
            this.aggValues[AggregationMethod.MAX.ordinal()] = values[count - 1];
            this.aggValues[AggregationMethod.FRACT_POSITIVE.ordinal()] = (double)numPositive / (double)count;
            this.aggValues[AggregationMethod.NUM_POSITIVE.ordinal()] = numPositive;
            this.aggValues[AggregationMethod.NUM_NEGATIVE.ordinal()] = count - numPositive;
            this.aggValues[AggregationMethod.GREATER_SUM_MEDIAN.ordinal()] = Math.max(this.get(AggregationMethod.SUM), this.get(AggregationMethod.MEDIAN));
            this.aggValues[AggregationMethod.GREATER_MEAN_MEDIAN.ordinal()] = Math.max(this.get(AggregationMethod.MEAN), this.get(AggregationMethod.MEDIAN));
            this.aggValues[AggregationMethod.COUNT.ordinal()] = interactionCount;
        }

        StiffnessAggregation(AggregationMethod[] methods, double[] aggValues) {
            int i;
            Preconditions.checkState((methods.length == aggValues.length ? 1 : 0) != 0);
            this.aggValues = new double[CACHE_ARRAY_SIZE];
            for (i = 0; i < this.aggValues.length; ++i) {
                this.aggValues[i] = Double.NaN;
            }
            for (i = 0; i < methods.length; ++i) {
                this.aggValues[methods[i].ordinal()] = aggValues[i];
            }
        }

        public double get(AggregationMethod aggMethod) {
            Preconditions.checkState((boolean)aggMethod.isTerminal(), (Object)"Can only cache values for terminal layers");
            return this.aggValues[aggMethod.ordinal()];
        }
    }
}

