/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.simulators.stiffness;

import com.google.common.base.Preconditions;
import java.util.Arrays;

public class OkadaDisplaceStrainCalc {
    public static Displacement dc3d(double alpha, double x, double y, double z, double depth, double dip, double al1, double al2, double aw1, double aw2, double disl1, double disl2, double disl3) {
        double[] dua;
        C2 c2;
        int j;
        int k;
        int i;
        double[] xi = new double[2];
        double[] et = new double[2];
        double[] kxi = new double[2];
        double[] ket = new double[2];
        double[] u = new double[12];
        double[] du = new double[12];
        double eps = 1.0E-6;
        for (i = 0; i < 12; ++i) {
            u[i] = 0.0;
        }
        double aalpha = alpha;
        double ddip = dip;
        C0 c0 = OkadaDisplaceStrainCalc.dccon0(aalpha, ddip);
        double zz = z;
        double dd1 = disl1;
        double dd2 = disl2;
        double dd3 = disl3;
        xi[0] = x - al1;
        xi[1] = x - al2;
        if (Math.abs(xi[0]) < eps) {
            xi[0] = 0.0;
        }
        if (Math.abs(xi[1]) < eps) {
            xi[1] = 0.0;
        }
        double d = depth + z;
        double p = y * c0.cd + d * c0.sd;
        double q = y * c0.sd - d * c0.cd;
        et[0] = p - aw1;
        et[1] = p - aw2;
        if (Math.abs(q) < eps) {
            q = 0.0;
        }
        if (Math.abs(et[0]) < eps) {
            et[0] = 0.0;
        }
        if (Math.abs(et[1]) < eps) {
            et[1] = 0.0;
        }
        if (q == 0.0 && (xi[0] * xi[1] < 0.0 && et[0] * et[1] == 0.0 || et[0] * et[1] < 0.0 && xi[0] * xi[1] == 0.0)) {
            return null;
        }
        kxi[0] = 0.0;
        kxi[1] = 0.0;
        ket[0] = 0.0;
        ket[1] = 0.0;
        double r12 = Math.sqrt(xi[0] * xi[0] + et[1] * et[1] + q * q);
        double r21 = Math.sqrt(xi[1] * xi[1] + et[0] * et[0] + q * q);
        double r22 = Math.sqrt(xi[1] * xi[1] + et[1] * et[1] + q * q);
        if (xi[0] < 0.0 && r21 + xi[1] < eps) {
            kxi[0] = 1.0;
        }
        if (xi[0] < 0.0 && r22 + xi[1] < eps) {
            kxi[1] = 1.0;
        }
        if (et[0] < 0.0 && r12 + et[1] < eps) {
            ket[0] = 1.0;
        }
        if (et[0] < 0.0 && r22 + et[1] < eps) {
            ket[1] = 1.0;
        }
        for (k = 0; k < 2; ++k) {
            for (j = 0; j < 2; ++j) {
                c2 = OkadaDisplaceStrainCalc.dccon2(xi[j], et[k], q, c0.sd, c0.cd, kxi[k], ket[j]);
                dua = OkadaDisplaceStrainCalc.ua(xi[j], et[k], q, dd1, dd2, dd3, c0, c2);
                for (i = 0; i <= 9; i += 3) {
                    du[i] = -dua[i];
                    du[i + 1] = -dua[i + 1] * c0.cd + dua[i + 2] * c0.sd;
                    du[i + 2] = -dua[i + 1] * c0.sd - dua[i + 2] * c0.cd;
                    if (i != 9) continue;
                    du[i] = -du[i];
                    du[i + 1] = -du[i + 1];
                    du[i + 2] = -du[i + 2];
                }
                for (i = 0; i < 12; ++i) {
                    if (j + k != 1) {
                        int n = i;
                        u[n] = u[n] + du[i];
                        continue;
                    }
                    int n = i;
                    u[n] = u[n] - du[i];
                }
            }
        }
        d = depth - z;
        p = y * c0.cd + d * c0.sd;
        q = y * c0.sd - d * c0.cd;
        et[0] = p - aw1;
        et[1] = p - aw2;
        if (Math.abs(q) < eps) {
            q = 0.0;
        }
        if (Math.abs(et[0]) < eps) {
            et[0] = 0.0;
        }
        if (Math.abs(et[1]) < eps) {
            et[1] = 0.0;
        }
        if (q == 0.0 && (xi[0] * xi[1] < 0.0 && et[0] * et[1] == 0.0 || et[0] * et[1] < 0.0 && xi[0] * xi[1] == 0.0)) {
            return null;
        }
        kxi[0] = 0.0;
        kxi[1] = 0.0;
        ket[0] = 0.0;
        ket[1] = 0.0;
        r12 = Math.sqrt(xi[0] * xi[0] + et[1] * et[1] + q * q);
        r21 = Math.sqrt(xi[1] * xi[1] + et[0] * et[0] + q * q);
        r22 = Math.sqrt(xi[1] * xi[1] + et[1] * et[1] + q * q);
        if (xi[0] < 0.0 && r21 + xi[1] < eps) {
            kxi[0] = 1.0;
        }
        if (xi[0] < 0.0 && r22 + xi[1] < eps) {
            kxi[1] = 1.0;
        }
        if (et[0] < 0.0 && r12 + et[1] < eps) {
            ket[0] = 1.0;
        }
        if (et[0] < 0.0 && r22 + et[1] < eps) {
            ket[1] = 1.0;
        }
        for (k = 0; k < 2; ++k) {
            for (j = 0; j < 2; ++j) {
                c2 = OkadaDisplaceStrainCalc.dccon2(xi[j], et[k], q, c0.sd, c0.cd, kxi[k], ket[j]);
                dua = OkadaDisplaceStrainCalc.ua(xi[j], et[k], q, dd1, dd2, dd3, c0, c2);
                double[] dub = OkadaDisplaceStrainCalc.ub(xi[j], et[k], q, dd1, dd2, dd3, c0, c2);
                double[] duc = OkadaDisplaceStrainCalc.uc(xi[j], et[k], q, zz, dd1, dd2, dd3, c0, c2);
                for (i = 0; i <= 9; i += 3) {
                    du[i] = dua[i] + dub[i] + z * duc[i];
                    du[i + 1] = (dua[i + 1] + dub[i + 1] + z * duc[i + 1]) * c0.cd - (dua[i + 2] + dub[i + 2] + z * duc[i + 2]) * c0.sd;
                    du[i + 2] = (dua[i + 1] + dub[i + 1] - z * duc[i + 1]) * c0.sd + (dua[i + 2] + dub[i + 2] - z * duc[i + 2]) * c0.cd;
                    if (i != 9) continue;
                    du[9] = du[9] + duc[0];
                    du[10] = du[10] + duc[1] * c0.cd - duc[2] * c0.sd;
                    du[11] = du[11] - duc[1] * c0.sd - duc[2] * c0.cd;
                }
                for (i = 0; i < 12; ++i) {
                    if (j + k != 1) {
                        int n = i;
                        u[n] = u[n] + du[i];
                        continue;
                    }
                    int n = i;
                    u[n] = u[n] - du[i];
                }
            }
        }
        return new Displacement(u);
    }

    static double[] ua(double xi, double et, double q, double disl1, double disl2, double disl3, C0 c0, C2 c2) {
        int i;
        double pi2 = Math.PI * 2;
        double[] u = new double[12];
        double[] du = new double[12];
        for (i = 0; i < 12; ++i) {
            u[i] = 0.0;
        }
        double xy = xi * c2.y11;
        double qx = q * c2.x11;
        double qy = q * c2.y11;
        if (disl1 != 0.0) {
            du[0] = c2.tt / 2.0 + c0.alp2 * xi * qy;
            du[1] = c0.alp2 * q / c2.r;
            du[2] = c0.alp1 * c2.ale - c0.alp2 * q * qy;
            du[3] = -c0.alp1 * qy - c0.alp2 * c2.xi2 * q * c2.y32;
            du[4] = -c0.alp2 * xi * q / c2.r3;
            du[5] = c0.alp1 * xy + c0.alp2 * xi * c2.q2 * c2.y32;
            du[6] = c0.alp1 * xy * c0.sd + c0.alp2 * xi * c2.fy + c2.d / 2.0 * c2.x11;
            du[7] = c0.alp2 * c2.ey;
            du[8] = c0.alp1 * (c0.cd / c2.r + qy * c0.sd) - c0.alp2 * q * c2.fy;
            du[9] = c0.alp1 * xy * c0.cd + c0.alp2 * xi * c2.fz + c2.y / 2.0 * c2.x11;
            du[10] = c0.alp2 * c2.ez;
            du[11] = -c0.alp1 * (c0.sd / c2.r - qy * c0.cd) - c0.alp2 * q * c2.fz;
            for (i = 0; i < 12; ++i) {
                int n = i;
                u[n] = u[n] + disl1 / pi2 * du[i];
            }
        }
        if (disl2 != 0.0) {
            du[0] = c0.alp2 * q / c2.r;
            du[1] = c2.tt / 2.0 + c0.alp2 * et * qx;
            du[2] = c0.alp1 * c2.alx - c0.alp2 * q * qx;
            du[3] = -c0.alp2 * xi * q / c2.r3;
            du[4] = -qy / 2.0 - c0.alp2 * et * q / c2.r3;
            du[5] = c0.alp1 / c2.r + c0.alp2 * c2.q2 / c2.r3;
            du[6] = c0.alp2 * c2.ey;
            du[7] = c0.alp1 * c2.d * c2.x11 + xy / 2.0 * c0.sd + c0.alp2 * et * c2.gy;
            du[8] = c0.alp1 * c2.y * c2.x11 - c0.alp2 * q * c2.gy;
            du[9] = c0.alp2 * c2.ez;
            du[10] = c0.alp1 * c2.y * c2.x11 + xy / 2.0 * c0.cd + c0.alp2 * et * c2.gz;
            du[11] = -c0.alp1 * c2.d * c2.x11 - c0.alp2 * q * c2.gz;
            for (i = 0; i < 12; ++i) {
                int n = i;
                u[n] = u[n] + disl2 / pi2 * du[i];
            }
        }
        if (disl3 != 0.0) {
            du[0] = -c0.alp1 * c2.ale - c0.alp2 * q * qy;
            du[1] = -c0.alp1 * c2.alx - c0.alp2 * q * qx;
            du[2] = c2.tt / 2.0 - c0.alp2 * (et * qx + xi * qy);
            du[3] = -c0.alp1 * xy + c0.alp2 * xi * c2.q2 * c2.y32;
            du[4] = -c0.alp1 / c2.r + c0.alp2 * c2.q2 / c2.r3;
            du[5] = -c0.alp1 * qy - c0.alp2 * q * c2.q2 * c2.y32;
            du[6] = -c0.alp1 * (c0.cd / c2.r + qy * c0.sd) - c0.alp2 * q * c2.fy;
            du[7] = -c0.alp1 * c2.y * c2.x11 - c0.alp2 * q * c2.gy;
            du[8] = c0.alp1 * (c2.d * c2.x11 + xy * c0.sd) + c0.alp2 * q * c2.hy;
            du[9] = c0.alp1 * (c0.sd / c2.r - qy * c0.cd) - c0.alp2 * q * c2.fz;
            du[10] = c0.alp1 * c2.d * c2.x11 - c0.alp2 * q * c2.gz;
            du[11] = c0.alp1 * (c2.y * c2.x11 + xy * c0.cd) + c0.alp2 * q * c2.hz;
            for (i = 0; i < 12; ++i) {
                int n = i;
                u[n] = u[n] + disl3 / pi2 * du[i];
            }
        }
        return u;
    }

    static double[] ub(double xi, double et, double q, double disl1, double disl2, double disl3, C0 c0, C2 c2) {
        int i;
        double aj6;
        double aj3;
        double ak3;
        double ak1;
        double ai3;
        double ai4;
        double[] u = new double[12];
        double[] du = new double[12];
        double pi2 = Math.PI * 2;
        double rd = c2.r + c2.d;
        double d11 = 1.0 / (c2.r * rd);
        double aj2 = xi * c2.y / rd * d11;
        double aj5 = -(c2.d + c2.y * c2.y / rd) * d11;
        if (c0.cd != 0.0) {
            if (xi == 0.0) {
                ai4 = 0.0;
            } else {
                double x = Math.sqrt(c2.xi2 + c2.q2);
                ai4 = 1.0 / c0.cdcd * (xi / rd * c0.sdcd + 2.0 * Math.atan((et * (x + q * c0.cd) + x * (c2.r + x) * c0.sd) / (xi * (c2.r + x) * c0.cd)));
            }
            ai3 = (c2.y * c0.cd / rd - c2.ale + c0.sd * Math.log(rd)) / c0.cdcd;
            ak1 = xi * (d11 - c2.y11 * c0.sd) / c0.cd;
            ak3 = (q * c2.y11 - c2.y * d11) / c0.cd;
            aj3 = (ak1 - aj2 * c0.sd) / c0.cd;
            aj6 = (ak3 - aj5 * c0.sd) / c0.cd;
        } else {
            double rd2 = rd * rd;
            ai3 = (et / rd + c2.y * q / rd2 - c2.ale) / 2.0;
            ai4 = xi * c2.y / rd2 / 2.0;
            ak1 = xi * q / rd * d11;
            ak3 = c0.sd / rd * (c2.xi2 * d11 - 1.0);
            aj3 = -xi / rd2 * (c2.q2 * d11 - 0.5);
            aj6 = -c2.y / rd2 * (c2.xi2 * d11 - 0.5);
        }
        double xy = xi * c2.y11;
        double ai1 = -xi / rd * c0.cd - ai4 * c0.sd;
        double ai2 = Math.log(rd) + ai3 * c0.sd;
        double ak2 = 1.0 / c2.r + ak3 * c0.sd;
        double ak4 = xy * c0.cd - ak1 * c0.sd;
        double aj1 = aj5 * c0.cd - aj6 * c0.sd;
        double aj4 = -xy - aj2 * c0.cd + aj3 * c0.sd;
        for (i = 0; i < 12; ++i) {
            u[i] = 0.0;
        }
        double qx = q * c2.x11;
        double qy = q * c2.y11;
        if (disl1 != 0.0) {
            du[0] = -xi * qy - c2.tt - c0.alp3 * ai1 * c0.sd;
            du[1] = -q / c2.r + c0.alp3 * c2.y / rd * c0.sd;
            du[2] = q * qy - c0.alp3 * ai2 * c0.sd;
            du[3] = c2.xi2 * q * c2.y32 - c0.alp3 * aj1 * c0.sd;
            du[4] = xi * q / c2.r3 - c0.alp3 * aj2 * c0.sd;
            du[5] = -xi * c2.q2 * c2.y32 - c0.alp3 * aj3 * c0.sd;
            du[6] = -xi * c2.fy - c2.d * c2.x11 + c0.alp3 * (xy + aj4) * c0.sd;
            du[7] = -c2.ey + c0.alp3 * (1.0 / c2.r + aj5) * c0.sd;
            du[8] = q * c2.fy - c0.alp3 * (qy - aj6) * c0.sd;
            du[9] = -xi * c2.fz - c2.y * c2.x11 + c0.alp3 * ak1 * c0.sd;
            du[10] = -c2.ez + c0.alp3 * c2.y * d11 * c0.sd;
            du[11] = q * c2.fz + c0.alp3 * ak2 * c0.sd;
            for (i = 0; i < 12; ++i) {
                int n = i;
                u[n] = u[n] + disl1 / pi2 * du[i];
            }
        }
        if (disl2 != 0.0) {
            du[0] = -q / c2.r + c0.alp3 * ai3 * c0.sdcd;
            du[1] = -et * qx - c2.tt - c0.alp3 * xi / rd * c0.sdcd;
            du[2] = q * qx + c0.alp3 * ai4 * c0.sdcd;
            du[3] = xi * q / c2.r3 + c0.alp3 * aj4 * c0.sdcd;
            du[4] = et * q / c2.r3 + qy + c0.alp3 * aj5 * c0.sdcd;
            du[5] = -c2.q2 / c2.r3 + c0.alp3 * aj6 * c0.sdcd;
            du[6] = -c2.ey + c0.alp3 * aj1 * c0.sdcd;
            du[7] = -et * c2.gy - xy * c0.sd + c0.alp3 * aj2 * c0.sdcd;
            du[8] = q * c2.gy + c0.alp3 * aj3 * c0.sdcd;
            du[9] = -c2.ez - c0.alp3 * ak3 * c0.sdcd;
            du[10] = -et * c2.gz - xy * c0.cd - c0.alp3 * xi * d11 * c0.sdcd;
            du[11] = q * c2.gz - c0.alp3 * ak4 * c0.sdcd;
            for (i = 0; i < 12; ++i) {
                int n = i;
                u[n] = u[n] + disl2 / pi2 * du[i];
            }
        }
        if (disl3 != 0.0) {
            du[0] = q * qy - c0.alp3 * ai3 * c0.sdsd;
            du[1] = q * qx + c0.alp3 * xi / rd * c0.sdsd;
            du[2] = et * qx + xi * qy - c2.tt - c0.alp3 * ai4 * c0.sdsd;
            du[3] = -xi * c2.q2 * c2.y32 - c0.alp3 * aj4 * c0.sdsd;
            du[4] = -c2.q2 / c2.r3 - c0.alp3 * aj5 * c0.sdsd;
            du[5] = q * c2.q2 * c2.y32 - c0.alp3 * aj6 * c0.sdsd;
            du[6] = q * c2.fy - c0.alp3 * aj1 * c0.sdsd;
            du[7] = q * c2.gy - c0.alp3 * aj2 * c0.sdsd;
            du[8] = -q * c2.hy - c0.alp3 * aj3 * c0.sdsd;
            du[9] = q * c2.fz + c0.alp3 * ak3 * c0.sdsd;
            du[10] = q * c2.gz + c0.alp3 * xi * d11 * c0.sdsd;
            du[11] = -q * c2.hz + c0.alp3 * ak4 * c0.sdsd;
            for (i = 0; i < 12; ++i) {
                int n = i;
                u[n] = u[n] + disl3 / pi2 * du[i];
            }
        }
        return u;
    }

    static double[] uc(double xi, double et, double q, double z, double disl1, double disl2, double disl3, C0 c0, C2 c2) {
        int i;
        double[] u = new double[12];
        double[] du = new double[12];
        double pi2 = Math.PI * 2;
        double c = c2.d + z;
        double x53 = (8.0 * c2.r2 + 9.0 * c2.r * xi + 3.0 * c2.xi2) * c2.x11 * c2.x11 * c2.x11 / c2.r2;
        double y53 = (8.0 * c2.r2 + 9.0 * c2.r * et + 3.0 * c2.et2) * c2.y11 * c2.y11 * c2.y11 / c2.r2;
        double h = q * c0.cd - z;
        double z32 = c0.sd / c2.r3 - h * c2.y32;
        double z53 = 3.0 * c0.sd / c2.r5 - h * y53;
        double y0 = c2.y11 - c2.xi2 * c2.y32;
        double z0 = z32 - c2.xi2 * z53;
        double ppy = c0.cd / c2.r3 + q * c2.y32 * c0.sd;
        double ppz = c0.sd / c2.r3 - q * c2.y32 * c0.cd;
        double qq = z * c2.y32 + z32 + z0;
        double qqy = 3.0 * c * c2.d / c2.r5 - qq * c0.sd;
        double qqz = 3.0 * c * c2.y / c2.r5 - qq * c0.cd + q * c2.y32;
        double xy = xi * c2.y11;
        double qx = q * c2.x11;
        double qy = q * c2.y11;
        double qr = 3.0 * q / c2.r5;
        double cqx = c * q * x53;
        double cdr = (c + c2.d) / c2.r3;
        double yy0 = c2.y / c2.r3 - y0 * c0.cd;
        for (i = 0; i < 12; ++i) {
            u[i] = 0.0;
        }
        if (disl1 != 0.0) {
            du[0] = c0.alp4 * xy * c0.cd - c0.alp5 * xi * q * z32;
            du[1] = c0.alp4 * (c0.cd / c2.r + 2.0 * qy * c0.sd) - c0.alp5 * c * q / c2.r3;
            du[2] = c0.alp4 * qy * c0.cd - c0.alp5 * (c * et / c2.r3 - z * c2.y11 + c2.xi2 * z32);
            du[3] = c0.alp4 * y0 * c0.cd - c0.alp5 * q * z0;
            du[4] = -c0.alp4 * xi * (c0.cd / c2.r3 + 2.0 * q * c2.y32 * c0.sd) + c0.alp5 * c * xi * qr;
            du[5] = -c0.alp4 * xi * q * c2.y32 * c0.cd + c0.alp5 * xi * (3.0 * c * et / c2.r5 - qq);
            du[6] = -c0.alp4 * xi * ppy * c0.cd - c0.alp5 * xi * qqy;
            du[7] = c0.alp4 * 2.0 * (c2.d / c2.r3 - y0 * c0.sd) * c0.sd - c2.y / c2.r3 * c0.cd - c0.alp5 * (cdr * c0.sd - et / c2.r3 - c * c2.y * qr);
            du[8] = -c0.alp4 * q / c2.r3 + yy0 * c0.sd + c0.alp5 * (cdr * c0.cd + c * c2.d * qr - (y0 * c0.cd + q * z0) * c0.sd);
            du[9] = c0.alp4 * xi * ppz * c0.cd - c0.alp5 * xi * qqz;
            du[10] = c0.alp4 * 2.0 * (c2.y / c2.r3 - y0 * c0.cd) * c0.sd + c2.d / c2.r3 * c0.cd - c0.alp5 * (cdr * c0.cd + c * c2.d * qr);
            du[11] = yy0 * c0.cd - c0.alp5 * (cdr * c0.sd - c * c2.y * qr - y0 * c0.sdsd + q * z0 * c0.cd);
            for (i = 0; i < 12; ++i) {
                int n = i;
                u[n] = u[n] + disl1 / pi2 * du[i];
            }
        }
        if (disl2 != 0.0) {
            du[0] = c0.alp4 * c0.cd / c2.r - qy * c0.sd - c0.alp5 * c * q / c2.r3;
            du[1] = c0.alp4 * c2.y * c2.x11 - c0.alp5 * c * et * q * c2.x32;
            du[2] = -c2.d * c2.x11 - xy * c0.sd - c0.alp5 * c * (c2.x11 - c2.q2 * c2.x32);
            du[3] = -c0.alp4 * xi / c2.r3 * c0.cd + c0.alp5 * c * xi * qr + xi * q * c2.y32 * c0.sd;
            du[4] = -c0.alp4 * c2.y / c2.r3 + c0.alp5 * c * et * qr;
            du[5] = c2.d / c2.r3 - y0 * c0.sd + c0.alp5 * c / c2.r3 * (1.0 - 3.0 * c2.q2 / c2.r2);
            du[6] = -c0.alp4 * et / c2.r3 + y0 * c0.sdsd - c0.alp5 * (cdr * c0.sd - c * c2.y * qr);
            du[7] = c0.alp4 * (c2.x11 - c2.y * c2.y * c2.x32) - c0.alp5 * c * ((c2.d + 2.0 * q * c0.cd) * c2.x32 - c2.y * et * q * x53);
            du[8] = xi * ppy * c0.sd + c2.y * c2.d * c2.x32 + c0.alp5 * c * ((c2.y + 2.0 * q * c0.sd) * c2.x32 - c2.y * c2.q2 * x53);
            du[9] = -q / c2.r3 + y0 * c0.sdcd - c0.alp5 * (cdr * c0.cd + c * c2.d * qr);
            du[10] = c0.alp4 * c2.y * c2.d * c2.x32 - c0.alp5 * c * ((c2.y - 2.0 * q * c0.sd) * c2.x32 + c2.d * et * q * x53);
            du[11] = -xi * ppz * c0.sd + c2.x11 - c2.d * c2.d * c2.x32 - c0.alp5 * c * ((c2.d - 2.0 * q * c0.cd) * c2.x32 - c2.d * c2.q2 * x53);
            for (i = 0; i < 12; ++i) {
                int n = i;
                u[n] = u[n] + disl2 / pi2 * du[i];
            }
        }
        if (disl3 != 0.0) {
            du[0] = -c0.alp4 * (c0.sd / c2.r + qy * c0.cd) - c0.alp5 * (z * c2.y11 - c2.q2 * z32);
            du[1] = c0.alp4 * 2.0 * xy * c0.sd + c2.d * c2.x11 - c0.alp5 * c * (c2.x11 - c2.q2 * c2.x32);
            du[2] = c0.alp4 * (c2.y * c2.x11 + xy * c0.cd) + c0.alp5 * q * (c * et * c2.x32 + xi * z32);
            du[3] = c0.alp4 * xi / c2.r3 * c0.sd + xi * q * c2.y32 * c0.cd + c0.alp5 * xi * (3.0 * c * et / c2.r5 - 2.0 * z32 - z0);
            du[4] = c0.alp4 * 2.0 * y0 * c0.sd - c2.d / c2.r3 + c0.alp5 * c / c2.r3 * (1.0 - 3.0 * c2.q2 / c2.r2);
            du[5] = -c0.alp4 * yy0 - c0.alp5 * (c * et * qr - q * z0);
            du[6] = c0.alp4 * (q / c2.r3 + y0 * c0.sdcd) + c0.alp5 * (z / c2.r3 * c0.cd + c * c2.d * qr - q * z0 * c0.sd);
            du[7] = -c0.alp4 * 2.0 * xi * ppy * c0.sd - c2.y * c2.d * c2.x32 + c0.alp5 * c * ((c2.y + 2.0 * q * c0.sd) * c2.x32 - c2.y * c2.q2 * x53);
            du[8] = -c0.alp4 * (xi * ppy * c0.cd - c2.x11 + c2.y * c2.y * c2.x32) + c0.alp5 * (c * ((c2.d + 2.0 * q * c0.cd) * c2.x32 - c2.y * et * q * x53) + xi * qqy);
            du[9] = -et / c2.r3 + y0 * c0.cdcd - c0.alp5 * (z / c2.r3 * c0.sd - c * c2.y * qr - y0 * c0.sdsd + q * z0 * c0.cd);
            du[10] = c0.alp4 * 2.0 * xi * ppz * c0.sd - c2.x11 + c2.d * c2.d * c2.x32 - c0.alp5 * c * ((c2.d - 2.0 * q * c0.cd) * c2.x32 - c2.d * c2.q2 * x53);
            du[11] = c0.alp4 * (xi * ppz * c0.cd + c2.y * c2.d * c2.x32) + c0.alp5 * (c * ((c2.y - 2.0 * q * c0.sd) * c2.x32 + c2.d * et * q * x53) + xi * qqz);
            for (i = 0; i < 12; ++i) {
                int n = i;
                u[n] = u[n] + disl3 / pi2 * du[i];
            }
        }
        return u;
    }

    static C0 dccon0(double alpha, double dip) {
        C0 c0 = new C0();
        double eps = 1.0E-6;
        double pi2 = Math.PI * 2;
        c0.alp1 = (1.0 - alpha) / 2.0;
        c0.alp2 = alpha / 2.0;
        c0.alp3 = (1.0 - alpha) / alpha;
        c0.alp4 = 1.0 - alpha;
        c0.alp5 = alpha;
        double p18 = pi2 / 360.0;
        c0.sd = Math.sin(dip * p18);
        c0.cd = Math.cos(dip * p18);
        if (Math.abs(c0.cd) < eps) {
            c0.cd = 0.0;
            if (c0.sd > 0.0) {
                c0.sd = 1.0;
            }
            if (c0.sd < 0.0) {
                c0.sd = -1.0;
            }
        }
        c0.sdsd = c0.sd * c0.sd;
        c0.cdcd = c0.cd * c0.cd;
        c0.sdcd = c0.sd * c0.cd;
        c0.s2d = 2.0 * c0.sdcd;
        c0.c2d = c0.cdcd - c0.sdsd;
        return c0;
    }

    static C1 dccon1(double x, double y, double d, C0 c0) {
        double eps = 1.0E-6;
        C1 c1 = new C1();
        if (Math.abs(x) < eps) {
            x = 0.0;
        }
        if (Math.abs(y) < eps) {
            y = 0.0;
        }
        if (Math.abs(d) < eps) {
            d = 0.0;
        }
        c1.p = y * c0.cd + d * c0.sd;
        c1.q = y * c0.sd - d * c0.cd;
        c1.s = c1.p * c0.sd + c1.q * c0.cd;
        c1.t = c1.p * c0.cd - c1.q * c0.sd;
        c1.xy = x * y;
        c1.x2 = x * x;
        c1.y2 = y * y;
        c1.d2 = d * d;
        c1.r2 = c1.x2 + c1.y2 + c1.d2;
        c1.r = Math.sqrt(c1.r2);
        if (c1.r == 0.0) {
            return c1;
        }
        c1.r3 = c1.r * c1.r2;
        c1.r5 = c1.r3 * c1.r2;
        double r7 = c1.r5 * c1.r2;
        c1.a3 = 1.0 - 3.0 * c1.x2 / c1.r2;
        c1.a5 = 1.0 - 5.0 * c1.x2 / c1.r2;
        c1.b3 = 1.0 - 3.0 * c1.y2 / c1.r2;
        c1.c3 = 1.0 - 3.0 * c1.d2 / c1.r2;
        c1.qr = 3.0 * c1.q / c1.r5;
        c1.qrx = 5.0 * c1.qr * x / c1.r2;
        c1.uy = c0.sd - 5.0 * y * c1.q / c1.r2;
        c1.uz = c0.cd + 5.0 * d * c1.q / c1.r2;
        c1.vy = c1.s - 5.0 * y * c1.p * c1.q / c1.r2;
        c1.vz = c1.t + 5.0 * d * c1.p * c1.q / c1.r2;
        c1.wy = c1.uy + c0.sd;
        c1.wz = c1.uz + c0.cd;
        return c1;
    }

    static C2 dccon2(double xi, double et, double q, double sd, double cd, double kxi, double ket) {
        C2 c2 = new C2();
        double eps = 1.0E-6;
        if (Math.abs(xi) < eps) {
            xi = 0.0;
        }
        if (Math.abs(et) < eps) {
            et = 0.0;
        }
        if (Math.abs(q) < eps) {
            q = 0.0;
        }
        c2.xi2 = xi * xi;
        c2.et2 = et * et;
        c2.q2 = q * q;
        c2.r2 = c2.xi2 + c2.et2 + c2.q2;
        c2.r = Math.sqrt(c2.r2);
        if (c2.r == 0.0) {
            return c2;
        }
        c2.r3 = c2.r * c2.r2;
        c2.r5 = c2.r3 * c2.r2;
        c2.y = et * cd + q * sd;
        c2.d = et * sd - q * cd;
        c2.tt = q == 0.0 ? 0.0 : Math.atan(xi * et / (q * c2.r));
        if (kxi == 1.0) {
            c2.alx = -Math.log(c2.r - xi);
            c2.x11 = 0.0;
            c2.x32 = 0.0;
        } else {
            double rxi = c2.r + xi;
            c2.alx = Math.log(rxi);
            c2.x11 = 1.0 / (c2.r * rxi);
            c2.x32 = (c2.r + rxi) * c2.x11 * c2.x11 / c2.r;
        }
        if (ket == 1.0) {
            c2.ale = -Math.log(c2.r - et);
            c2.y11 = 0.0;
            c2.y32 = 0.0;
        } else {
            double ret = c2.r + et;
            c2.ale = Math.log(ret);
            c2.y11 = 1.0 / (c2.r * ret);
            c2.y32 = (c2.r + ret) * c2.y11 * c2.y11 / c2.r;
        }
        c2.ey = sd / c2.r - c2.y * q / c2.r3;
        c2.ez = cd / c2.r + c2.d * q / c2.r3;
        c2.fy = c2.d / c2.r3 + c2.xi2 * c2.y32 * sd;
        c2.fz = c2.y / c2.r3 + c2.xi2 * c2.y32 * cd;
        c2.gy = 2.0 * c2.x11 * sd - c2.y * q * c2.x32;
        c2.gz = 2.0 * c2.x11 * cd + c2.d * q * c2.x32;
        c2.hy = c2.d * q * c2.x32 + xi * q * c2.y32 * sd;
        c2.hz = c2.y * q * c2.x32 + xi * q * c2.y32 * cd;
        return c2;
    }

    private static class C0 {
        double alp1;
        double alp2;
        double alp3;
        double alp4;
        double alp5;
        double sd;
        double cd;
        double sdsd;
        double cdcd;
        double sdcd;
        double s2d;
        double c2d;

        private C0() {
        }
    }

    private static class C2 {
        double xi2;
        double et2;
        double q2;
        double r;
        double r2;
        double r3;
        double r5;
        double y;
        double d;
        double tt;
        double alx;
        double ale;
        double x11;
        double y11;
        double x32;
        double y32;
        double ey;
        double ez;
        double fy;
        double fz;
        double gy;
        double gz;
        double hy;
        double hz;

        private C2() {
        }
    }

    public static class Displacement {
        final double[] u;
        final double[][] du;

        private Displacement(double[] u) {
            this.u = Arrays.copyOfRange(u, 0, 3);
            this.du = new double[3][3];
            this.du[0][0] = u[3];
            this.du[1][0] = u[4];
            this.du[2][0] = u[5];
            this.du[0][1] = u[6];
            this.du[1][1] = u[7];
            this.du[2][1] = u[8];
            this.du[0][2] = u[9];
            this.du[1][2] = u[10];
            this.du[2][2] = u[11];
        }

        public Displacement(double[] u, double[][] du) {
            Preconditions.checkState((u.length == 3 ? 1 : 0) != 0);
            Preconditions.checkState((du.length == 3 ? 1 : 0) != 0);
            for (double[] d : du) {
                Preconditions.checkState((d.length == 3 ? 1 : 0) != 0);
            }
            this.u = u;
            this.du = du;
        }
    }

    private static class C1 {
        double p;
        double q;
        double s;
        double t;
        double xy;
        double x2;
        double y2;
        double d2;
        double r;
        double r2;
        double r3;
        double r5;
        double qr;
        double qrx;
        double a3;
        double a5;
        double b3;
        double c3;
        double uy;
        double vy;
        double wy;
        double uz;
        double vz;
        double wz;

        private C1() {
        }
    }
}

