/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.simulators.stiffness;

import java.awt.Color;
import java.awt.Font;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import org.jfree.chart.annotations.XYAnnotation;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.ui.TextAnchor;
import org.jfree.data.Range;
import org.opensha.commons.data.function.DefaultXY_DataSet;
import org.opensha.commons.data.function.XY_DataSet;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.utm.UTM;
import org.opensha.commons.geo.utm.WGS84;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.gui.plot.PlotSymbol;
import org.opensha.sha.earthquake.FocalMechanism;
import org.opensha.sha.simulators.stiffness.OkadaDisplaceStrainCalc;

public class StiffnessCalc {
    private static final double HALF_PI = 1.5707963267948966;

    private static double[] center(Location loc, int zone, char letter) {
        WGS84 wgs = new WGS84(loc.getLatitude(), loc.getLongitude());
        UTM utm = new UTM(wgs, zone, letter);
        return new double[]{utm.getEasting(), utm.getNorthing(), -1000.0 * loc.getDepth()};
    }

    private static double[] cross(double[] x, double[] y) {
        double[] z = new double[]{x[1] * y[2] - x[2] * y[1], x[2] * y[0] - x[0] * y[2], x[0] * y[1] - x[1] * y[0]};
        return z;
    }

    public static double[] calcStiffness(double lambda, double mu, Patch source, Patch receiver) {
        double u2;
        double u1;
        double dipDegree;
        double c;
        double z;
        double zz;
        double yy;
        double sint;
        double y;
        double alpha = (lambda + mu) / (lambda + 2.0 * mu);
        double x = receiver.center[0] - source.corner[0][0];
        double theta = 1.5707963267948966 - source.strike;
        double cost = Math.cos(theta);
        double xx = x * cost + (y = receiver.center[1] - source.corner[0][1]) * (sint = Math.sin(theta));
        OkadaDisplaceStrainCalc.Displacement disp = OkadaDisplaceStrainCalc.dc3d(alpha, xx, yy = -x * sint + y * cost, zz = (z = receiver.center[2]), c = -source.corner[0][2], dipDegree = Math.toDegrees(source.dip), 0.0, source.L, 0.0, source.W, u1 = Math.cos(source.rake), u2 = Math.sin(source.rake), 0.0);
        if (disp == null) {
            return null;
        }
        double[] Sigma = StiffnessCalc.deformationToStress(disp, lambda, mu);
        double[] K = new double[]{Sigma[0] * cost * cost - 2.0 * Sigma[1] * sint * cost + Sigma[3] * sint * sint, Sigma[0] * sint * cost + Sigma[1] * (cost * cost - sint * sint) - Sigma[3] * sint * cost, Sigma[2] * cost - Sigma[4] * sint, Sigma[0] * sint * sint + 2.0 * Sigma[1] * sint * cost + Sigma[3] * cost * cost, Sigma[2] * sint + Sigma[4] * cost, Sigma[5]};
        double[] stiffness = StiffnessCalc.projectStress(K, receiver.nu, receiver.u);
        stiffness[0] = -stiffness[0];
        return stiffness;
    }

    public static double calcCoulombStress(double tau, double sigma, double coeffOfFriction) {
        return tau - coeffOfFriction * sigma;
    }

    static double[] deformationToStress(OkadaDisplaceStrainCalc.Displacement disp, double lambda, double mu) {
        int j;
        int i;
        double[][] ss = new double[3][3];
        for (i = 0; i < 3; ++i) {
            for (j = i; j < 3; ++j) {
                ss[i][j] = mu * (disp.du[i][j] + disp.du[j][i]);
            }
        }
        double tre = 0.0;
        for (i = 0; i < 3; ++i) {
            tre += disp.du[i][i];
        }
        i = 0;
        while (i < 3) {
            double[] dArray = ss[i];
            int n = i++;
            dArray[n] = dArray[n] + lambda * tre;
        }
        int k = 0;
        double[] sigma = new double[6];
        for (i = 0; i < 3; ++i) {
            for (j = i; j < 3; ++j) {
                sigma[k++] = ss[i][j];
            }
        }
        return sigma;
    }

    static double[] projectStress(double[] Sigma, double[] nu, double[] u) {
        int j;
        int i;
        double[][] ss = new double[3][3];
        int k = 0;
        for (i = 0; i < 3; ++i) {
            for (j = i; j < 3; ++j) {
                ss[i][j] = Sigma[k++];
            }
        }
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < i; ++j) {
                ss[i][j] = ss[j][i];
            }
        }
        double sigma = 0.0;
        double tau = 0.0;
        for (i = 0; i < 3; ++i) {
            for (j = 0; j < 3; ++j) {
                sigma += nu[i] * ss[i][j] * nu[j];
                tau += u[i] * ss[i][j] * nu[j];
            }
        }
        return new double[]{sigma, tau};
    }

    public static void plot(Patch source, Patch receiver, double lambda, double mu, double coeffOfFriction) {
        double[] stiffness = StiffnessCalc.calcStiffness(lambda, mu, source, receiver);
        double sigma = stiffness[0];
        double tau = stiffness[1];
        double cff = StiffnessCalc.calcCoulombStress(tau, sigma, coeffOfFriction);
        System.out.println("sigma=" + sigma + ", tau=" + tau + ", cff=" + cff);
        ArrayList<XY_DataSet> funcs = new ArrayList<XY_DataSet>();
        ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
        StiffnessCalc.plotPatch(funcs, chars, source, true);
        StiffnessCalc.plotPatch(funcs, chars, receiver, false);
        double minX = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        for (XY_DataSet func : funcs) {
            minX = Math.min(minX, func.getMinX());
            maxX = Math.max(maxX, func.getMaxX());
            minY = Math.min(minY, func.getMinY());
            maxY = Math.max(maxY, func.getMaxY());
        }
        double maxSpan = Math.max(maxX - minX, maxY - minY);
        double halfSpan = 0.5 * (maxSpan += 2.0);
        double midX = 0.5 * (minX + maxX);
        double midY = 0.5 * (minY + maxY);
        Range xRange = new Range(midX - halfSpan, midX + halfSpan);
        Range yRange = new Range(midY - halfSpan, midY + halfSpan);
        PlotSpec spec = new PlotSpec(funcs, chars, " ", "X (km)", "Y (km)");
        spec.setLegendVisible(true);
        double annY = yRange.getLowerBound() + 0.95 * yRange.getLength();
        double leftX = xRange.getLowerBound() + 0.05 * xRange.getLength();
        double centerX = xRange.getLowerBound() + 0.5 * xRange.getLength();
        double rightX = xRange.getLowerBound() + 0.95 * xRange.getLength();
        Font annFont = new Font("SansSerif", 1, 18);
        double minVal = Math.min(Math.abs(sigma), Math.abs(tau));
        DecimalFormat df = minVal > 10.0 ? new DecimalFormat("0.0") : (minVal > 1.0 ? new DecimalFormat("0.00") : new DecimalFormat("0.000"));
        XYTextAnnotation sigmaAnn = new XYTextAnnotation("Sigma=" + df.format(sigma), leftX, annY);
        sigmaAnn.setTextAnchor(TextAnchor.TOP_LEFT);
        sigmaAnn.setFont(annFont);
        spec.addPlotAnnotation((XYAnnotation)sigmaAnn);
        XYTextAnnotation tauAnn = new XYTextAnnotation("Tau=" + df.format(tau), centerX, annY);
        tauAnn.setTextAnchor(TextAnchor.TOP_CENTER);
        tauAnn.setFont(annFont);
        spec.addPlotAnnotation((XYAnnotation)tauAnn);
        XYTextAnnotation coulombAnn = new XYTextAnnotation("CFF=" + df.format(cff), rightX, annY);
        coulombAnn.setTextAnchor(TextAnchor.TOP_RIGHT);
        coulombAnn.setFont(annFont);
        spec.addPlotAnnotation((XYAnnotation)coulombAnn);
        GraphWindow gw = new GraphWindow(spec);
        gw.setAxisRange(xRange, yRange);
        gw.setDefaultCloseOperation(3);
    }

    private static void plotPatch(List<XY_DataSet> funcs, List<PlotCurveCharacterstics> chars, Patch patch, boolean isSource) {
        Color color;
        boolean dipping = (float)patch.dip < 1.5707964f;
        Color color2 = color = isSource ? Color.GREEN.darker() : Color.MAGENTA.darker();
        if (dipping) {
            DefaultXY_DataSet outline = new DefaultXY_DataSet();
            for (int i = 0; i < patch.corner.length + 1; ++i) {
                double[] point = patch.corner[i % patch.corner.length];
                outline.set(point[0], point[1]);
            }
            funcs.add(outline);
            chars.add(new PlotCurveCharacterstics(PlotLineType.DOTTED, 1.0f, color));
        }
        DefaultXY_DataSet trace = new DefaultXY_DataSet();
        if (isSource) {
            trace.setName("Source");
        } else {
            trace.setName("Receiver");
        }
        trace.set(patch.corner[2][0], patch.corner[2][1]);
        trace.set(patch.corner[3][0], patch.corner[3][1]);
        funcs.add(trace);
        chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, color));
        DefaultXY_DataSet arrow = new DefaultXY_DataSet();
        arrow.set(patch.center[0], patch.center[1]);
        double endX = patch.center[0] + 0.4 * Math.sin(patch.strike - patch.rake);
        double endY = patch.center[1] + 0.4 * Math.cos(patch.strike - patch.rake);
        arrow.set(endX, endY);
        if (!isSource) {
            arrow.setName("Rakes");
        }
        funcs.add(arrow);
        chars.add(new PlotCurveCharacterstics(PlotLineType.DOTTED, 3.0f, Color.BLACK));
        DefaultXY_DataSet center = new DefaultXY_DataSet();
        center.set(patch.center[0], patch.center[1]);
        funcs.add(center);
        chars.add(new PlotCurveCharacterstics(PlotSymbol.FILLED_CIRCLE, 6.0f, color));
    }

    public static void main(String[] args) {
        double lambda = 30000.0;
        double mu = 30000.0;
        double coeffOfFriction = 0.5;
        double[] sourceCenter = new double[]{0.0, 0.0, -1000.0};
        FocalMechanism sourceMech = new FocalMechanism(0.0, 90.0, 180.0);
        Patch source = new Patch(sourceCenter, 2000.0, 2000.0, sourceMech);
        double[] receiverCenter = new double[]{0.0, 5000.0, -1.0};
        FocalMechanism receiverMech = new FocalMechanism(0.0, 90.0, 180.0);
        Patch receiver = new Patch(receiverCenter, 2000.0, 2000.0, receiverMech);
        StiffnessCalc.plot(source, receiver, lambda, mu, coeffOfFriction);
        sourceCenter = new double[]{0.0, -1000.0, -1000.0};
        sourceMech = new FocalMechanism(0.0, 90.0, 180.0);
        source = new Patch(sourceCenter, 4000.0, 2000.0, sourceMech);
        receiverCenter = new double[]{0.0, 5000.0, -1.0};
        receiverMech = new FocalMechanism(0.0, 90.0, 180.0);
        receiver = new Patch(receiverCenter, 2000.0, 2000.0, receiverMech);
        StiffnessCalc.plot(source, receiver, lambda, mu, coeffOfFriction);
    }

    public static class Patch {
        public final double[][] corner;
        public final double[] center;
        public final double L;
        public final double W;
        public final double area;
        public final double strike;
        public final double dip;
        public final double rake;
        public final double[] nu;
        public final double[] u;

        public Patch(Location centerLoc, int utmZone, char utmLetter, double length, double width, FocalMechanism mech) {
            this(StiffnessCalc.center(centerLoc, utmZone, utmLetter), length, width, mech);
        }

        public Patch(double[] center, double length, double width, FocalMechanism mech) {
            this.center = center;
            this.L = length;
            this.W = width;
            this.strike = Math.toRadians(mech.getStrike());
            this.dip = Math.toRadians(mech.getDip());
            this.rake = Math.toRadians(mech.getRake());
            this.area = this.L * this.W;
            double[] st = new double[3];
            double[] dd = new double[3];
            st[0] = Math.sin(this.strike);
            st[1] = Math.cos(this.strike);
            st[2] = 0.0;
            dd[0] = Math.cos(this.dip) * Math.cos(this.strike);
            dd[1] = -Math.cos(this.dip) * Math.sin(this.strike);
            dd[2] = -Math.sin(this.dip);
            this.corner = new double[4][3];
            double halfL = 0.5 * this.L;
            double halfW = 0.5 * this.W;
            for (int i = 0; i < 3; ++i) {
                this.corner[0][i] = center[i] - halfL * st[i] + halfW * dd[i];
                this.corner[1][i] = center[i] + halfL * st[i] + halfW * dd[i];
                this.corner[2][i] = center[i] + halfL * st[i] - halfW * dd[i];
                this.corner[3][i] = center[i] - halfL * st[i] - halfW * dd[i];
            }
            double[] ud = new double[]{-Math.cos(this.dip) * Math.cos(this.strike), Math.cos(this.dip) * Math.sin(this.strike), Math.sin(this.dip)};
            this.nu = StiffnessCalc.cross(st, ud);
            double cosr = Math.cos(this.rake);
            double sinr = Math.sin(this.rake);
            this.u = new double[3];
            for (int ic = 0; ic < 3; ++ic) {
                this.u[ic] = cosr * st[ic] + sinr * ud[ic];
            }
        }
    }
}

