/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.simulators.utils;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.primitives.Doubles;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.stat.StatUtils;
import org.opensha.commons.data.NamedComparator;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.LocationVector;
import org.opensha.commons.geo.PlaneUtils;
import org.opensha.sha.earthquake.FocalMechanism;
import org.opensha.sha.faultSurface.EvenlyGridCenteredSurface;
import org.opensha.sha.faultSurface.EvenlyGriddedSurface;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.simulators.RectangularElement;
import org.opensha.sha.simulators.SimulatorElement;
import org.opensha.sha.simulators.Vertex;

public class RectElemFromPrefDataBuilder {
    private static final boolean D = false;

    public static List<SimulatorElement> build(List<? extends FaultSection> allFaultSectionPrefData, boolean aseisReducesArea, double maxDiscretization) {
        return RectElemFromPrefDataBuilder.build(allFaultSectionPrefData, aseisReducesArea, maxDiscretization, null);
    }

    public static List<SimulatorElement> build(List<? extends FaultSection> allFaultSectionPrefData, boolean aseisReducesArea, double maxDiscretization, Map<Integer, Integer> parentSectToFaultIDMap) {
        allFaultSectionPrefData = Lists.newArrayList(allFaultSectionPrefData);
        ArrayList<SimulatorElement> rectElementsList = new ArrayList<SimulatorElement>();
        ArrayList<Vertex> vertexList = new ArrayList<Vertex>();
        ArrayList rectElementsListForSections = new ArrayList();
        ArrayList vertexListForSections = new ArrayList();
        ArrayList<String> sectionNamesList = new ArrayList<String>();
        Collections.sort(allFaultSectionPrefData, new SubSectNameComparator());
        for (int i = allFaultSectionPrefData.size() - 1; i >= 0; --i) {
            if (!Double.isNaN(((FaultSection)allFaultSectionPrefData.get(i)).getOrigAveSlipRate())) continue;
            allFaultSectionPrefData.remove(i);
        }
        int elementID = 0;
        int numberAlongStrike = 0;
        int faultNumber = -1;
        int sectionNumber = 0;
        double elementSlipRate = 0.0;
        double elementStrike = 0.0;
        double elementDip = 0.0;
        double elementRake = 0.0;
        for (int i = 0; i < allFaultSectionPrefData.size(); ++i) {
            ArrayList<RectangularElement> sectionElementsList = new ArrayList<RectangularElement>();
            ArrayList<Vertex> sectionVertexList = new ArrayList<Vertex>();
            ++sectionNumber;
            FaultSection faultSectionPrefData = (FaultSection)allFaultSectionPrefData.get(i);
            RuptureSurface surface = faultSectionPrefData.getFaultSurface(maxDiscretization, false, aseisReducesArea);
            Preconditions.checkState((boolean)(surface instanceof EvenlyGriddedSurface));
            EvenlyGriddedSurface gridSurf = (EvenlyGriddedSurface)surface;
            EvenlyGridCenteredSurface gridCenteredSurf = new EvenlyGridCenteredSurface(gridSurf);
            double elementLength = gridCenteredSurf.getGridSpacingAlongStrike();
            double elementDDW = gridCenteredSurf.getGridSpacingDownDip();
            if (i == 256) {
                System.out.println("Detected len=" + elementLength + ", ddw=" + elementDDW);
            }
            boolean adjustedLenghts = faultSectionPrefData.getAveDip() < 90.0 && gridSurf.getNumCols() > 1;
            boolean doColSpecific = true;
            double[] colSpecificDDW = null;
            faultNumber = parentSectToFaultIDMap != null && parentSectToFaultIDMap.containsKey(faultSectionPrefData.getParentSectionId()) ? parentSectToFaultIDMap.get(faultSectionPrefData.getParentSectionId()) : (faultSectionPrefData.getParentSectionId() > 0 ? faultSectionPrefData.getParentSectionId() : faultSectionPrefData.getSectionId());
            Preconditions.checkState((faultNumber > 0 ? 1 : 0) != 0, (Object)"Fault ID not provided and parent and reg sect IDs not positive ints");
            if (adjustedLenghts) {
                if (doColSpecific) {
                    colSpecificDDW = new double[gridCenteredSurf.getNumCols()];
                }
                ArrayList candidates = Lists.newArrayList();
                for (int j = 0; j < gridSurf.getNumCols() - 1; ++j) {
                    Location t1 = (Location)gridSurf.get(1, j);
                    Location t2 = (Location)gridSurf.get(1, j + 1);
                    Location testPt = new Location((t1.getLatitude() + t2.getLatitude()) / 2.0, (t1.getLongitude() + t2.getLongitude()) / 2.0, (t1.getDepth() + t2.getDepth()) / 2.0);
                    double myMinDDW = Double.POSITIVE_INFINITY;
                    for (int k = 0; k < gridSurf.getNumCols() - 1; ++k) {
                        Location topL = (Location)gridSurf.get(0, k);
                        Location topR = (Location)gridSurf.get(0, k + 1);
                        if (doColSpecific) {
                            if (k != j) {
                                continue;
                            }
                        } else {
                            double distToR;
                            double c2;
                            double b2;
                            double distBetweenTop = LocationUtils.linearDistanceFast(topL, topR);
                            double distToL = LocationUtils.linearDistanceFast(testPt, topL);
                            double a2 = distToL * distToL;
                            if (a2 + (b2 = distBetweenTop * distBetweenTop) < (c2 = (distToR = LocationUtils.linearDistanceFast(testPt, topR)) * distToR)) continue;
                        }
                        double vertDelta = testPt.getDepth() - topR.getDepth();
                        double ddw = Math.abs(LocationUtils.distanceToLineFast(topL, topR, testPt));
                        ddw = Math.sqrt(ddw * ddw + vertDelta * vertDelta);
                        myMinDDW = Math.min(myMinDDW, ddw);
                    }
                    if (Double.isInfinite(myMinDDW)) continue;
                    Preconditions.checkState((myMinDDW > 0.0 ? 1 : 0) != 0);
                    if (doColSpecific) {
                        colSpecificDDW[j] = myMinDDW;
                    }
                    candidates.add(myMinDDW);
                }
                Preconditions.checkState((!candidates.isEmpty() ? 1 : 0) != 0);
                double[] candidatesArray = Doubles.toArray((Collection)candidates);
                elementDDW = StatUtils.max((double[])candidatesArray);
                if (i == 256) {
                    System.out.println("Modified len=" + elementLength + ", ddw=" + elementDDW);
                }
            }
            elementRake = faultSectionPrefData.getAveRake();
            elementSlipRate = faultSectionPrefData.getOrigAveSlipRate() / 1000.0;
            double elementAseis = faultSectionPrefData.getAseismicSlipFactor();
            String sectionName = faultSectionPrefData.getName().replaceAll("\\W+", "_");
            for (int col = 0; col < gridCenteredSurf.getNumCols(); ++col) {
                if (colSpecificDDW != null) {
                    elementDDW = colSpecificDDW[col];
                }
                ++numberAlongStrike;
                for (int row = 0; row < gridCenteredSurf.getNumRows(); ++row) {
                    ++elementID;
                    int numberDownDip = row + 1;
                    Location centerLoc = (Location)gridCenteredSurf.get(row, col);
                    Location top1 = (Location)gridSurf.get(row, col);
                    Location top2 = (Location)gridSurf.get(row, col + 1);
                    Location bot1 = (Location)gridSurf.get(row + 1, col);
                    double[] strikeAndDip = PlaneUtils.getStrikeAndDip(top1, top2, bot1);
                    elementStrike = strikeAndDip[0];
                    elementDip = strikeAndDip[1];
                    double hDistAlong = elementLength / 2.0;
                    double dipRad = Math.PI * elementDip / 180.0;
                    double vDist = elementDDW / 2.0 * Math.sin(dipRad);
                    double hDist = elementDDW / 2.0 * Math.cos(dipRad);
                    LocationVector vect = new LocationVector(elementStrike + 180.0, hDistAlong, 0.0);
                    Location newMid1 = LocationUtils.location(centerLoc, vect);
                    vect.set(elementStrike - 90.0, hDist, -vDist);
                    Location newTop1 = LocationUtils.location(newMid1, vect);
                    vect.set(elementStrike + 90.0, hDist, vDist);
                    Location newBot1 = LocationUtils.location(newMid1, vect);
                    vect.set(elementStrike, hDistAlong, 0.0);
                    Location newMid2 = LocationUtils.location(centerLoc, vect);
                    vect.set(elementStrike - 90.0, hDist, -vDist);
                    Location newTop2 = LocationUtils.location(newMid2, vect);
                    vect.set(elementStrike + 90.0, hDist, vDist);
                    Location newBot2 = LocationUtils.location(newMid2, vect);
                    double das1 = (double)col * elementLength;
                    double das2 = das1 + elementLength;
                    int traceFlagBot = 0;
                    int traceFlagTop1 = 0;
                    int traceFlagTop2 = 0;
                    if (row == 0) {
                        traceFlagTop1 = 1;
                        traceFlagTop2 = 1;
                    }
                    if (row == 0 && col == 0) {
                        traceFlagTop1 = 2;
                    }
                    if (row == 0 && col == gridCenteredSurf.getNumCols() - 1) {
                        traceFlagTop2 = 3;
                    }
                    Vertex[] elementVertices = new Vertex[]{new Vertex(newTop1, vertexList.size() + 1, das1, traceFlagTop1), new Vertex(newBot1, vertexList.size() + 2, das1, traceFlagBot), new Vertex(newBot2, vertexList.size() + 3, das2, traceFlagBot), new Vertex(newTop2, vertexList.size() + 4, das2, traceFlagTop2)};
                    FocalMechanism focalMech = new FocalMechanism(elementStrike, elementDip, elementRake);
                    RectangularElement simSurface = new RectangularElement(elementID, elementVertices, sectionName, faultNumber, sectionNumber, numberAlongStrike, numberDownDip, elementSlipRate, elementAseis, focalMech, true);
                    rectElementsList.add(simSurface);
                    vertexList.add(elementVertices[0]);
                    vertexList.add(elementVertices[1]);
                    vertexList.add(elementVertices[2]);
                    vertexList.add(elementVertices[3]);
                    sectionElementsList.add(simSurface);
                    sectionVertexList.add(elementVertices[0]);
                    sectionVertexList.add(elementVertices[1]);
                    sectionVertexList.add(elementVertices[2]);
                    sectionVertexList.add(elementVertices[3]);
                }
            }
            rectElementsListForSections.add(sectionElementsList);
            vertexListForSections.add(sectionVertexList);
            String strippedName = faultSectionPrefData.getName().replaceAll("\\W+", "_");
            sectionNamesList.add(strippedName);
        }
        System.out.println("rectElementsList.size()=" + rectElementsList.size());
        System.out.println("vertexList.size()=" + vertexList.size());
        return rectElementsList;
    }

    public static void main(String[] args) throws IOException {
    }

    private static class SubSectNameComparator
    implements Comparator<FaultSection> {
        private NamedComparator nameComp = new NamedComparator();

        private SubSectNameComparator() {
        }

        @Override
        public int compare(FaultSection o1, FaultSection o2) {
            if (o1.getParentSectionId() != o2.getParentSectionId()) {
                return this.nameComp.compare(o1, o2);
            }
            return Integer.valueOf(o1.getSectionId()).compareTo(o2.getSectionId());
        }
    }
}

