/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.simulators.utils;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Doubles;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.LocationVector;
import org.opensha.commons.util.FaultUtils;
import org.opensha.sha.earthquake.FocalMechanism;
import org.opensha.sha.simulators.EventRecord;
import org.opensha.sha.simulators.SimulatorElement;
import org.opensha.sha.simulators.SimulatorEvent;
import org.opensha.sha.simulators.Vertex;

public class SimulatorUtils {
    public static final double SECONDS_PER_YEAR = 3.1536E7;

    public static double getSimulationDuration(List<? extends SimulatorEvent> events) {
        SimulatorEvent firstEvent = events.get(0);
        SimulatorEvent lastEvent = events.get(events.size() - 1);
        double startTime = firstEvent.getTime();
        double endTime = lastEvent.getTime() + lastEvent.getDuration();
        return endTime - startTime;
    }

    public static double getSimulationDurationYears(List<? extends SimulatorEvent> events) {
        return SimulatorUtils.getSimulationDuration(events) / 3.1536E7;
    }

    public static double estimateRuptureLength(SimulatorEvent event) {
        double totLen = 0.0;
        for (EventRecord rec : event) {
            double maxLen = 0.0;
            List<SimulatorElement> elems = rec.getElements();
            if (elems.size() == 1) {
                maxLen = SimulatorUtils.maxHorzDist(elems.get(0), elems.get(0));
            }
            for (int i = 0; i < elems.size(); ++i) {
                for (int j = i + 1; j < elems.size(); ++j) {
                    maxLen = Math.max(maxLen, SimulatorUtils.maxHorzDist(elems.get(i), elems.get(j)));
                }
            }
            totLen += maxLen;
        }
        return totLen;
    }

    private static double maxHorzDist(SimulatorElement e1, SimulatorElement e2) {
        double maxDist = 0.0;
        for (Vertex p1 : e1.getVertices()) {
            for (Vertex p2 : e2.getVertices()) {
                maxDist = Math.max(maxDist, LocationUtils.horzDistanceFast(p1, p2));
            }
        }
        return maxDist;
    }

    public static Location[] estimateVertexDAS(SimulatorEvent event) {
        EventRecord leftRec = null;
        EventRecord rightRec = null;
        if (event.size() == 1) {
            rightRec = leftRec = event.get(0);
        } else {
            int i;
            double maxDist = 0.0;
            Location[] aveLocs = new Location[event.size()];
            for (i = 0; i < event.size(); ++i) {
                aveLocs[i] = SimulatorUtils.aveLoc(event.get(i));
            }
            for (i = 0; i < event.size(); ++i) {
                for (int j = i + 1; j < event.size(); ++j) {
                    double dist = LocationUtils.horzDistanceFast(aveLocs[i], aveLocs[j]);
                    if (!(dist > maxDist)) continue;
                    leftRec = event.get(i);
                    rightRec = event.get(j);
                    maxDist = dist;
                }
            }
        }
        Vertex leftLoc = null;
        Vertex rightLoc = null;
        double maxDist = 0.0;
        for (SimulatorElement e1 : leftRec.getElements()) {
            for (SimulatorElement e2 : rightRec.getElements()) {
                for (Vertex p1 : e1.getVertices()) {
                    for (Vertex p2 : e2.getVertices()) {
                        double dist = LocationUtils.horzDistance(p1, p2);
                        if (!(dist > maxDist)) continue;
                        maxDist = dist;
                        leftLoc = p1;
                        rightLoc = p2;
                    }
                }
            }
        }
        return SimulatorUtils.estimateVertexDAS(event, leftLoc, rightLoc);
    }

    public static Location[] estimateVertexDAS(SimulatorEvent event, Location leftLoc, Location rightLoc) {
        ArrayList<SimulatorElement> elems = event.getAllElements();
        ArrayList<Double> strikesDipping = new ArrayList<Double>();
        for (SimulatorElement e : elems) {
            FocalMechanism mech = e.getFocalMechanism();
            if (!(mech.getDip() < 90.0)) continue;
            strikesDipping.add(mech.getStrike());
        }
        double curStrike = LocationUtils.azimuth(leftLoc, rightLoc);
        if (!strikesDipping.isEmpty()) {
            double targetStrike = FaultUtils.getAngleAverage(strikesDipping);
            double diff = Math.abs(curStrike - targetStrike);
            diff = Math.min(diff, Math.abs(curStrike + 360.0 - targetStrike));
            if ((diff = Math.min(diff, Math.abs(curStrike - (targetStrike + 360.0)))) > 90.0 && diff < 270.0) {
                System.out.println("Swapping direction");
                Location temp = leftLoc;
                leftLoc = rightLoc;
                rightLoc = temp;
            }
        }
        double minDAS = Double.POSITIVE_INFINITY;
        for (SimulatorElement e : elems) {
            for (Vertex v : e.getVertices()) {
                double das = SimulatorUtils.estimateDAS(leftLoc, rightLoc, v);
                minDAS = Math.min(minDAS, das);
                v.setDAS(das);
            }
        }
        for (SimulatorElement e : elems) {
            for (Vertex v : e.getVertices()) {
                v.setDAS(v.getDAS() - minDAS);
            }
        }
        return new Location[]{leftLoc, rightLoc};
    }

    public static double estimateDAS(Location firstLoc, Location lastLoc, Location loc) {
        LocationVector fromLeft = LocationUtils.vector(firstLoc, loc);
        double distToLine = LocationUtils.distanceToLine(firstLoc, lastLoc, loc);
        double sumSq = distToLine * distToLine + fromLeft.getHorzDistance() * fromLeft.getHorzDistance();
        double das = Math.sqrt(sumSq);
        Preconditions.checkState((boolean)Doubles.isFinite((double)das), (String)"bad DAS calc: %s = sqrt(%s^2 + %s^2) = sqrt(%s)", (Object)das, (Object)distToLine, (Object)fromLeft.getHorzDistance(), (Object)sumSq);
        return das;
    }

    private static Location aveLoc(EventRecord rec) {
        double aveLat = 0.0;
        double aveLon = 0.0;
        double aveDep = 0.0;
        List<SimulatorElement> elems = rec.getElements();
        for (SimulatorElement elem : elems) {
            Location loc = elem.getCenterLocation();
            aveLat += loc.getLatitude();
            aveLon += loc.getLongitude();
            aveDep += loc.getDepth();
        }
        return new Location(aveLat / (double)elems.size(), aveLon / (double)elems.size(), aveDep / (double)elems.size());
    }

    public static class SimulatorElementIDComparator
    implements Comparator<SimulatorElement> {
        @Override
        public int compare(SimulatorElement s1, SimulatorElement s2) {
            return Integer.compare(s1.getID(), s2.getID());
        }
    }
}

