/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.util;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.opensha.sha.earthquake.FocalMechanism;

public enum FocalMech {
    STRIKE_SLIP(1, 90.0, 0.0),
    REVERSE(2, 50.0, 90.0),
    NORMAL(3, 50.0, -90.0);

    private int id;
    private double dip;
    private double rake;
    public final FocalMechanism.Unmodifiable mechanism;

    private FocalMech(int id, double dip, double rake) {
        this.id = id;
        this.dip = dip;
        this.rake = rake;
        this.mechanism = new FocalMechanism.Unmodifiable(Double.NaN, dip, rake);
    }

    public static FocalMech typeForID(int id) {
        for (FocalMech fm : FocalMech.values()) {
            if (fm.id != id) continue;
            return fm;
        }
        return null;
    }

    public double dip() {
        return this.dip;
    }

    public double rake() {
        return this.rake;
    }

    public static FocalMech forFocalMechanism(FocalMechanism mechanism) {
        if (mechanism instanceof FocalMechanism.Unmodifiable) {
            for (FocalMech mech : FocalMech.values()) {
                if (mechanism != mech.mechanism) continue;
                return mech;
            }
        }
        for (FocalMech mech : FocalMech.values()) {
            if (mech.dip != mechanism.getDip() || mech.rake != mechanism.getRake()) continue;
            return mech;
        }
        throw null;
    }

    public String toString() {
        return WordUtils.capitalizeFully((String)StringUtils.replaceChars((String)this.name(), (char)'_', (char)'-'), (char[])new char[]{'-'});
    }
}

