/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.util;

import java.io.Serializable;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.impl.WarningDoubleParameter;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.attenRelImpl.AS_1997_AttenRel;
import org.opensha.sha.imr.attenRelImpl.Abrahamson_2000_AttenRel;
import org.opensha.sha.imr.attenRelImpl.BJF_1997_AttenRel;
import org.opensha.sha.imr.attenRelImpl.CB_2003_AttenRel;
import org.opensha.sha.imr.attenRelImpl.Campbell_1997_AttenRel;
import org.opensha.sha.imr.attenRelImpl.Field_2000_AttenRel;
import org.opensha.sha.imr.attenRelImpl.SadighEtAl_1997_AttenRel;
import org.opensha.sha.imr.attenRelImpl.ShakeMap_2003_AttenRel;
import org.opensha.sha.imr.attenRelImpl.USGS_Combined_2004_AttenRel;

public class OldSiteTranslator
implements Serializable {
    private static final String C = "SiteTranslator";
    private static final boolean D = false;
    public static final String WILLS_B = "B";
    public static final String WILLS_BC = "BC";
    public static final String WILLS_C = "C";
    public static final String WILLS_CD = "CD";
    public static final String WILLS_D = "D";
    public static final String WILLS_DE = "DE";
    public static final String WILLS_E = "E";

    public boolean setParameterValue(Parameter param, String willsClass, double basinDepth) {
        String wc = willsClass;
        if (param.getName().equals("AS Site Type")) {
            if (wc.equals(WILLS_DE) || wc.equals(WILLS_D) || wc.equals(WILLS_CD)) {
                param.setValue("Deep-Soil");
                return true;
            }
            if (wc.equals(WILLS_C) || wc.equals(WILLS_BC) || wc.equals(WILLS_B)) {
                param.setValue("Rock/Shallow-Soil");
                return true;
            }
            return false;
        }
        if (param.getName().equals("Sadigh Site Type")) {
            if (wc.equals(WILLS_DE) || wc.equals(WILLS_D) || wc.equals(WILLS_CD)) {
                param.setValue("Deep-Soil");
                return true;
            }
            if (wc.equals(WILLS_C) || wc.equals(WILLS_BC) || wc.equals(WILLS_B)) {
                param.setValue("Rock");
                return true;
            }
            return false;
        }
        if (param.getName().equals("Vs30")) {
            if (wc.equals(WILLS_DE)) {
                param.setValue(180.0);
                return true;
            }
            if (wc.equals(WILLS_D)) {
                param.setValue(270.0);
                return true;
            }
            if (wc.equals(WILLS_CD)) {
                param.setValue(360.0);
                return true;
            }
            if (wc.equals(WILLS_C)) {
                param.setValue(560.0);
                return true;
            }
            if (wc.equals(WILLS_BC)) {
                param.setValue(760.0);
                return true;
            }
            if (wc.equals(WILLS_B)) {
                param.setValue(1000.0);
                return true;
            }
            return false;
        }
        if (param.getName().equals("Campbell-Basin-Depth")) {
            if (wc.equals(WILLS_DE) || wc.equals(WILLS_D) || wc.equals(WILLS_CD)) {
                param.setValue(5.0);
                return true;
            }
            if (wc.equals(WILLS_C)) {
                param.setValue(1.0);
                return true;
            }
            if (wc.equals(WILLS_BC) || wc.equals(WILLS_B)) {
                param.setValue(0.0);
                return true;
            }
            return false;
        }
        if (param.getName().equals("Campbell Site Type")) {
            if (wc.equals(WILLS_DE) || wc.equals(WILLS_D) || wc.equals(WILLS_CD)) {
                param.setValue("Firm-Soil");
                return true;
            }
            if (wc.equals(WILLS_C)) {
                param.setValue("Soft-Rock");
                return true;
            }
            if (wc.equals(WILLS_BC) || wc.equals(WILLS_B)) {
                param.setValue("Hard-Rock");
                return true;
            }
            return false;
        }
        if (param.getName().equals("Campbell-2003 Site Type")) {
            if (wc.equals(WILLS_DE) || wc.equals(WILLS_D)) {
                param.setValue("Firm-Soil");
                return true;
            }
            if (wc.equals(WILLS_CD)) {
                param.setValue("Very-Firm-Soil");
                return true;
            }
            if (wc.equals(WILLS_C)) {
                param.setValue("Soft-Rock");
                return true;
            }
            if (wc.equals(WILLS_BC)) {
                param.setValue("BC-Boundary");
                return true;
            }
            if (wc.equals(WILLS_B)) {
                param.setValue("Firm-Rock");
                return true;
            }
            return false;
        }
        if (param.getName().equals("Field-Basin-Depth")) {
            if (Double.isNaN(basinDepth)) {
                param.setValue(null);
            } else {
                param.setValue(basinDepth / 1000.0);
            }
            return true;
        }
        if (param.getName().equals("Depth 2.5 km/sec")) {
            if (Double.isNaN(basinDepth)) {
                param.setValue(null);
            } else {
                ((WarningDoubleParameter)param).setValueIgnoreWarning(basinDepth / 1000.0);
            }
            return true;
        }
        if (param.getName().equals("Wills Site Class")) {
            if (param.isAllowed(wc)) {
                param.setValue(wc);
                return true;
            }
            return false;
        }
        if (param.getName().equals("Soft Soil Case")) {
            if (wc.equals(WILLS_E)) {
                param.setValue(true);
            } else {
                param.setValue(false);
            }
            return true;
        }
        throw new RuntimeException("SiteTranslator does not support the site type: " + param.getName());
    }

    public void test(Parameter param) {
        System.out.println(param.getName() + "  Parameter (basin depth = NaN):");
        if (this.setParameterValue(param, WILLS_B, Double.NaN)) {
            System.out.println("\tB --> " + String.valueOf(param.getValue()));
        } else {
            System.out.println("\tB --> *** can't set ***");
        }
        if (this.setParameterValue(param, WILLS_BC, Double.NaN)) {
            System.out.println("\tBC --> " + String.valueOf(param.getValue()));
        } else {
            System.out.println("\tBC --> *** can't set ***");
        }
        if (this.setParameterValue(param, WILLS_C, Double.NaN)) {
            System.out.println("\tC --> " + String.valueOf(param.getValue()));
        } else {
            System.out.println("\tC --> *** can't set ***");
        }
        if (this.setParameterValue(param, WILLS_CD, Double.NaN)) {
            System.out.println("\tCD --> " + String.valueOf(param.getValue()));
        } else {
            System.out.println("\tCD --> *** can't set ***");
        }
        if (this.setParameterValue(param, WILLS_D, Double.NaN)) {
            System.out.println("\tD --> " + String.valueOf(param.getValue()));
        } else {
            System.out.println("\tD --> *** can't set ***");
        }
        if (this.setParameterValue(param, WILLS_DE, Double.NaN)) {
            System.out.println("\tDE --> " + String.valueOf(param.getValue()));
        } else {
            System.out.println("\tDE --> *** can't set ***");
        }
        if (this.setParameterValue(param, WILLS_E, Double.NaN)) {
            System.out.println("\tE --> " + String.valueOf(param.getValue()));
        } else {
            System.out.println("\tE --> *** can't set ***");
        }
        System.out.println(param.getName() + "  Parameter (basin depth = 1.0):");
        if (this.setParameterValue(param, WILLS_B, 1.0)) {
            System.out.println("\tB --> " + String.valueOf(param.getValue()));
        } else {
            System.out.println("\tB --> *** can't set ***");
        }
        if (this.setParameterValue(param, WILLS_BC, 1.0)) {
            System.out.println("\tBC --> " + String.valueOf(param.getValue()));
        } else {
            System.out.println("\tBC --> *** can't set ***");
        }
        if (this.setParameterValue(param, WILLS_C, 1.0)) {
            System.out.println("\tC --> " + String.valueOf(param.getValue()));
        } else {
            System.out.println("\tC --> *** can't set ***");
        }
        if (this.setParameterValue(param, WILLS_CD, 1.0)) {
            System.out.println("\tCD --> " + String.valueOf(param.getValue()));
        } else {
            System.out.println("\tCD --> *** can't set ***");
        }
        if (this.setParameterValue(param, WILLS_D, 1.0)) {
            System.out.println("\tD --> " + String.valueOf(param.getValue()));
        } else {
            System.out.println("\tD --> *** can't set ***");
        }
        if (this.setParameterValue(param, WILLS_DE, 1.0)) {
            System.out.println("\tDE --> " + String.valueOf(param.getValue()));
        } else {
            System.out.println("\tDE --> *** can't set ***");
        }
        if (this.setParameterValue(param, WILLS_E, 1.0)) {
            System.out.println("\tE --> " + String.valueOf(param.getValue()));
        } else {
            System.out.println("\tE --> *** can't set ***");
        }
    }

    public static void main(String[] args) {
        OldSiteTranslator siteTrans = new OldSiteTranslator();
        AttenuationRelationship ar = new AS_1997_AttenRel(null);
        siteTrans.test(ar.getParameter("AS Site Type"));
        ar = new SadighEtAl_1997_AttenRel(null);
        siteTrans.test(ar.getParameter("Sadigh Site Type"));
        ar = new BJF_1997_AttenRel(null);
        siteTrans.test(ar.getParameter("Vs30"));
        ar = new Campbell_1997_AttenRel(null);
        siteTrans.test(ar.getParameter("Campbell Site Type"));
        siteTrans.test(ar.getParameter("Campbell-Basin-Depth"));
        ar = new Field_2000_AttenRel(null);
        siteTrans.test(ar.getParameter("Vs30"));
        siteTrans.test(ar.getParameter("Field-Basin-Depth"));
        ar = new Abrahamson_2000_AttenRel(null);
        siteTrans.test(ar.getParameter("AS Site Type"));
        ar = new CB_2003_AttenRel(null);
        siteTrans.test(ar.getParameter("Campbell-2003 Site Type"));
        ar = new ShakeMap_2003_AttenRel(null);
        siteTrans.test(ar.getParameter("Wills Site Class"));
        ar = new USGS_Combined_2004_AttenRel(null);
        siteTrans.test(ar.getParameter("Vs30"));
    }
}

