/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.util;

import java.util.Collection;
import java.util.ListIterator;
import org.opensha.commons.data.siteData.SiteDataValue;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.util.NtoNMap;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.util.SiteTranslator;

public class SiteDataTypeParameterNameMap
extends NtoNMap<String, String> {
    public void addMapping(String type, String paramName) {
        this.put(type, paramName);
    }

    public Collection<String> getTypesForParameterName(String paramName) {
        return this.getLefts(paramName);
    }

    public Collection<String> getParameterNamesForType(String type) {
        return this.getRights(type);
    }

    public boolean isValidMapping(String type, String paramName) {
        return this.containsMapping(type, paramName);
    }

    public boolean isValidMapping(SiteDataValue<?> value, String paramName) {
        return this.containsMapping(value.getDataType(), paramName);
    }

    public boolean isTypeApplicable(String type, ScalarIMR attenRel) {
        ListIterator<Parameter<?>> it = attenRel.getSiteParamsIterator();
        while (it.hasNext()) {
            Parameter<?> param = it.next();
            if (!this.isValidMapping(type, param.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean isTypeApplicable(String type, Collection<? extends ScalarIMR> imrs) {
        for (ScalarIMR scalarIMR : imrs) {
            if (!this.isTypeApplicable(type, scalarIMR)) continue;
            return true;
        }
        return false;
    }

    public boolean isTypeApplicable(SiteDataValue<?> value, ScalarIMR attenRel) {
        return this.isTypeApplicable(value.getDataType(), attenRel);
    }

    public boolean isTypeApplicable(SiteDataValue<?> value, Collection<ScalarIMR> imrs) {
        return this.isTypeApplicable(value.getDataType(), imrs);
    }

    private void printParamsForType(String type) {
        System.out.println("***** Type: " + type);
        Collection<String> names = this.getParameterNamesForType(type);
        if (names == null) {
            System.out.println("- <NONE>");
        } else {
            for (String name : names) {
                System.out.println("- " + name);
            }
        }
    }

    private void printTypesForParams(String paramName) {
        System.out.println("***** Param Name: " + paramName);
        Collection<String> types = this.getTypesForParameterName(paramName);
        if (types == null) {
            System.out.println("- <NONE>");
        } else {
            for (String name : types) {
                System.out.println("- " + name);
            }
        }
    }

    private void printValidTest(String type, String paramName) {
        System.out.println(type + " : " + paramName + " ? " + this.isValidMapping(type, paramName));
    }

    public static void main(String[] args) {
        SiteDataTypeParameterNameMap map = SiteTranslator.DATA_TYPE_PARAM_NAME_MAP;
        map.printParamsForType("Vs30");
        map.printParamsForType("Wills Class");
        map.printParamsForType("Depth to Vs = 2.5 km/sec");
        map.printParamsForType("Depth to Vs = 1.0 km/sec");
        map.printTypesForParams("Vs30");
        map.printValidTest("Vs30", "Vs30");
        map.printValidTest("Wills Class", "Campbell Site Type");
        map.printValidTest("Vs30", "Campbell Site Type");
        map.printValidTest("Depth to Vs = 2.5 km/sec", "Vs30");
        System.out.println("Size: " + map.size());
    }
}

