/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.util;

import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ListIterator;
import org.opensha.commons.data.siteData.SiteDataValue;
import org.opensha.commons.data.siteData.impl.WillsMap2000;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.WarningParameter;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.imr.attenRelImpl.AS_1997_AttenRel;
import org.opensha.sha.imr.attenRelImpl.Abrahamson_2000_AttenRel;
import org.opensha.sha.imr.attenRelImpl.BJF_1997_AttenRel;
import org.opensha.sha.imr.attenRelImpl.CB_2003_AttenRel;
import org.opensha.sha.imr.attenRelImpl.CB_2008_AttenRel;
import org.opensha.sha.imr.attenRelImpl.CS_2005_AttenRel;
import org.opensha.sha.imr.attenRelImpl.CY_2008_AttenRel;
import org.opensha.sha.imr.attenRelImpl.Campbell_1997_AttenRel;
import org.opensha.sha.imr.attenRelImpl.DahleEtAl_1995_AttenRel;
import org.opensha.sha.imr.attenRelImpl.Field_2000_AttenRel;
import org.opensha.sha.imr.attenRelImpl.SEA_1999_AttenRel;
import org.opensha.sha.imr.attenRelImpl.SadighEtAl_1997_AttenRel;
import org.opensha.sha.imr.attenRelImpl.ShakeMap_2003_AttenRel;
import org.opensha.sha.imr.attenRelImpl.USGS_Combined_2004_AttenRel;
import org.opensha.sha.util.SiteDataTypeParameterNameMap;

public class SiteTranslator
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final boolean D = false;
    public static SiteDataTypeParameterNameMap DATA_TYPE_PARAM_NAME_MAP = SiteTranslator.createMap();

    private static SiteDataTypeParameterNameMap createMap() {
        SiteDataTypeParameterNameMap map = new SiteDataTypeParameterNameMap();
        map.addMapping("Wills Class", "Campbell-Basin-Depth");
        map.addMapping("Wills Class", "Wills Site Class");
        map.addMapping("Vs30", "Vs30");
        map.addMapping("Wills Class", "Vs30");
        map.addMapping("Vs30", "Vs30 Type");
        map.addMapping("Wills Class", "Vs30 Type");
        map.addMapping("Vs30", "AS Site Type");
        map.addMapping("Wills Class", "AS Site Type");
        map.addMapping("Vs30", "Sadigh Site Type");
        map.addMapping("Wills Class", "Sadigh Site Type");
        map.addMapping("Vs30", "Campbell Site Type");
        map.addMapping("Wills Class", "Campbell Site Type");
        map.addMapping("Vs30", "Campbell-2003 Site Type");
        map.addMapping("Wills Class", "Campbell-2003 Site Type");
        map.addMapping("Vs30", "Soft Soil Case");
        map.addMapping("Wills Class", "Soft Soil Case");
        map.addMapping("Vs30", "Zhao et al 2006 Site Type");
        map.addMapping("Depth to Vs = 2.5 km/sec", "Depth 2.5 km/sec");
        map.addMapping("Depth to Vs = 2.5 km/sec", "Field-Basin-Depth");
        map.addMapping("Depth to Vs = 2.5 km/sec", "Campbell-Basin-Depth");
        map.addMapping("Depth to Vs = 1.0 km/sec", "Depth 1.0 km/sec");
        return map;
    }

    public boolean setParameterValue(Parameter param, SiteDataValue<?> data) {
        ArrayList datas = new ArrayList();
        datas.add(data);
        return this.setParameterValue(param, datas);
    }

    public boolean setParameterValue(Parameter param, Collection<SiteDataValue<?>> datas) {
        String paramName = param.getName();
        boolean mapping = false;
        for (SiteDataValue<?> data : datas) {
            if (!DATA_TYPE_PARAM_NAME_MAP.isValidMapping(data, paramName)) continue;
            mapping = true;
            break;
        }
        if (mapping) {
            if (paramName.equals("Vs30")) {
                return this.setVS30Param(param, datas);
            }
            if (paramName.equals("Vs30 Type")) {
                return this.setVS30FlagParam(param, datas);
            }
            if (paramName.equals("AS Site Type")) {
                return this.setAS_SiteType(param, datas);
            }
            if (paramName.equals("Sadigh Site Type")) {
                return this.setSCEMY_SiteType(param, datas);
            }
            if (paramName.equals("Campbell-Basin-Depth")) {
                return this.setCampbellBasinDepth(param, datas);
            }
            if (paramName.equals("Campbell Site Type")) {
                return this.setCampbellSiteType(param, datas);
            }
            if (paramName.equals("Campbell-2003 Site Type")) {
                return this.setCB03SiteType(param, datas);
            }
            if (paramName.equals("Wills Site Class")) {
                return this.setWillsSiteTypeName(param, datas);
            }
            if (paramName.equals("Soft Soil Case")) {
                return this.setCS05SoftSoil(param, datas);
            }
            if (paramName.equals("Zhao et al 2006 Site Type")) {
                return this.setZhao06SiteType(param, datas);
            }
            if (paramName.equals("Depth 2.5 km/sec")) {
                return this.setDepthTo2p5Param(param, datas);
            }
            if (paramName.equals("Depth 1.0 km/sec")) {
                return this.setDepthTo1p0Param(param, datas);
            }
            if (paramName.equals("Field-Basin-Depth")) {
                return this.setDepthTo2p5Param(param, datas);
            }
        } else {
            return false;
        }
        return false;
    }

    public boolean setAllSiteParams(ScalarIMR imr, SiteDataValue<?> data) {
        ArrayList datas = new ArrayList();
        datas.add(data);
        return this.setAllSiteParams(imr, datas);
    }

    public boolean setAllSiteParams(Collection<? extends ScalarIMR> imrs, SiteDataValue<?> data) {
        ArrayList datas = new ArrayList();
        datas.add(data);
        return this.setAllSiteParams(imrs, datas);
    }

    public boolean setAllSiteParams(ScalarIMR imr, Collection<SiteDataValue<?>> datas) {
        boolean setSomething = false;
        ListIterator<Parameter<?>> it = imr.getSiteParamsIterator();
        while (it.hasNext()) {
            Parameter<?> param = it.next();
            if (!this.setParameterValue(param, datas)) continue;
            setSomething = true;
        }
        return setSomething;
    }

    public boolean setAllSiteParams(Collection<? extends ScalarIMR> imrs, Collection<SiteDataValue<?>> datas) {
        boolean setSomething = false;
        for (ScalarIMR scalarIMR : imrs) {
            if (!this.setAllSiteParams(scalarIMR, datas)) continue;
            setSomething = true;
        }
        return setSomething;
    }

    private SiteDataValue<?> getDataForType(Collection<SiteDataValue<?>> datas, String type) {
        for (SiteDataValue<?> data : datas) {
            if (!data.getDataType().equals(type)) continue;
            return data;
        }
        return null;
    }

    private boolean isVS30ValueValid(Double vsValue) {
        return vsValue != null && !vsValue.isNaN() && vsValue > 0.0;
    }

    private static void setValueIgnoreWarning(Parameter param, Object value) {
        if (param instanceof WarningParameter) {
            ((WarningParameter)param).setValueIgnoreWarning(value);
        } else {
            param.setValue(value);
        }
    }

    public boolean setVS30Param(Parameter param, Collection<SiteDataValue<?>> datas) {
        Double vsValue = null;
        for (SiteDataValue<?> data : datas) {
            if (data.getDataType().equals("Vs30")) {
                vsValue = (Double)data.getValue();
                if (!this.isVS30ValueValid(vsValue)) continue;
                SiteTranslator.setValueIgnoreWarning(param, vsValue);
                return true;
            }
            if (!data.getDataType().equals("Wills Class") || !this.isVS30ValueValid(vsValue = Double.valueOf(WillsMap2000.getVS30FromWillsClass((String)data.getValue())))) continue;
            SiteTranslator.setValueIgnoreWarning(param, vsValue);
            return true;
        }
        return false;
    }

    public boolean setVS30FlagParam(Parameter param, Collection<SiteDataValue<?>> datas) {
        for (SiteDataValue<?> data : datas) {
            Double vsValue = null;
            if (data.getDataType().equals("Vs30")) {
                vsValue = (Double)data.getValue();
            } else if (data.getDataType().equals("Wills Class")) {
                vsValue = WillsMap2000.getVS30FromWillsClass((String)data.getValue());
            }
            if (!this.isVS30ValueValid(vsValue) || data.getDataMeasurementType() == null) continue;
            if (data.getDataMeasurementType().equals("Measured")) {
                param.setValue("Measured");
                return true;
            }
            param.setValue("Inferred");
            return true;
        }
        return false;
    }

    public boolean setDepthTo2p5Param(Parameter param, Collection<SiteDataValue<?>> datas) {
        for (SiteDataValue<?> data : datas) {
            Double val;
            if (!data.getDataType().equals("Depth to Vs = 2.5 km/sec") || (val = (Double)data.getValue()) == null || Double.isNaN(val)) continue;
            SiteTranslator.setValueIgnoreWarning(param, val);
            return true;
        }
        return false;
    }

    public boolean setDepthTo1p0Param(Parameter param, Collection<SiteDataValue<?>> datas) {
        for (SiteDataValue<?> data : datas) {
            Double val;
            if (!data.getDataType().equals("Depth to Vs = 1.0 km/sec") || (val = (Double)data.getValue()) == null || Double.isNaN(val)) continue;
            val = val * 1000.0;
            SiteTranslator.setValueIgnoreWarning(param, val);
            return true;
        }
        return false;
    }

    public boolean setAS_SiteType(Parameter param, Collection<SiteDataValue<?>> datas) {
        for (SiteDataValue<?> data : datas) {
            if (data.getDataType().equals("Vs30")) {
                Double vsVal = (Double)data.getValue();
                if (!this.isVS30ValueValid(vsVal)) continue;
                SiteDataValue<?> dep2p5Data = this.getDataForType(datas, "Depth to Vs = 2.5 km/sec");
                Double dep = null;
                if (dep2p5Data != null) {
                    dep = (Double)dep2p5Data.getValue();
                }
                if (vsVal <= 400.0 && (dep == null || !Double.isNaN(dep) && dep > 0.1)) {
                    param.setValue("Deep-Soil");
                } else {
                    param.setValue("Rock/Shallow-Soil");
                }
                return true;
            }
            if (!data.getDataType().equals("Wills Class")) continue;
            String wc = (String)data.getValue();
            if (wc.equals("DE") || wc.equals("D") || wc.equals("CD")) {
                param.setValue("Deep-Soil");
                return true;
            }
            if (!wc.equals("C") && !wc.equals("BC") && !wc.equals("B")) continue;
            param.setValue("Rock/Shallow-Soil");
            return true;
        }
        return false;
    }

    public boolean setSCEMY_SiteType(Parameter param, Collection<SiteDataValue<?>> datas) {
        for (SiteDataValue<?> data : datas) {
            if (data.getDataType().equals("Vs30")) {
                Double vsVal = (Double)data.getValue();
                if (!this.isVS30ValueValid(vsVal)) continue;
                SiteDataValue<?> dep2p5Data = this.getDataForType(datas, "Depth to Vs = 2.5 km/sec");
                Double dep = null;
                if (dep2p5Data != null) {
                    dep = (Double)dep2p5Data.getValue();
                }
                if (vsVal <= 400.0 && (dep == null || !Double.isNaN(dep) && dep > 0.1)) {
                    param.setValue("Deep-Soil");
                } else {
                    param.setValue("Rock");
                }
                return true;
            }
            if (!data.getDataType().equals("Wills Class")) continue;
            String wc = (String)data.getValue();
            if (wc.equals("DE") || wc.equals("D") || wc.equals("CD")) {
                param.setValue("Deep-Soil");
                return true;
            }
            if (!wc.equals("C") && !wc.equals("BC") && !wc.equals("B")) continue;
            param.setValue("Rock");
            return true;
        }
        return false;
    }

    public boolean setCampbellBasinDepth(Parameter param, Collection<SiteDataValue<?>> datas) {
        for (SiteDataValue<?> data : datas) {
            Double depth;
            if (data.getDataType().equals("Wills Class")) {
                String wc = (String)data.getValue();
                if (wc.equals("DE") || wc.equals("D") || wc.equals("CD")) {
                    SiteTranslator.setValueIgnoreWarning(param, 5.0);
                    return true;
                }
                if (wc.equals("C")) {
                    SiteTranslator.setValueIgnoreWarning(param, 1.0);
                    return true;
                }
                if (!wc.equals("BC") && !wc.equals("B")) continue;
                SiteTranslator.setValueIgnoreWarning(param, 0.0);
                return true;
            }
            if (!data.getDataType().equals("Depth to Vs = 2.5 km/sec") || (depth = (Double)data.getValue()).isNaN()) continue;
            SiteTranslator.setValueIgnoreWarning(param, depth);
            return true;
        }
        return false;
    }

    public boolean setCampbellSiteType(Parameter param, Collection<SiteDataValue<?>> datas) {
        for (SiteDataValue<?> data : datas) {
            if (data.getDataType().equals("Vs30")) {
                Double vsVal = (Double)data.getValue();
                if (!this.isVS30ValueValid(vsVal)) continue;
                if (vsVal > 180.0 && vsVal <= 400.0) {
                    param.setValue("Firm-Soil");
                    return true;
                }
                if (vsVal > 400.0 && vsVal <= 500.0) {
                    param.setValue("Soft-Rock");
                    return true;
                }
                if (!(vsVal > 500.0)) continue;
                param.setValue("Hard-Rock");
                return true;
            }
            if (!data.getDataType().equals("Wills Class")) continue;
            String wc = (String)data.getValue();
            if (wc.equals("DE") || wc.equals("D") || wc.equals("CD")) {
                param.setValue("Firm-Soil");
                return true;
            }
            if (wc.equals("C")) {
                param.setValue("Soft-Rock");
                return true;
            }
            if (!wc.equals("BC") && !wc.equals("B")) continue;
            param.setValue("Hard-Rock");
            return true;
        }
        return false;
    }

    public boolean setCB03SiteType(Parameter param, Collection<SiteDataValue<?>> datas) {
        for (SiteDataValue<?> data : datas) {
            if (data.getDataType().equals("Vs30")) {
                Double vsVal = (Double)data.getValue();
                if (vsVal > 180.0 && vsVal <= 300.0) {
                    param.setValue("Firm-Soil");
                    return true;
                }
                if (vsVal > 300.0 && vsVal <= 400.0) {
                    param.setValue("Very-Firm-Soil");
                    return true;
                }
                if (vsVal > 400.0 && vsVal <= 500.0) {
                    param.setValue("Soft-Rock");
                    return true;
                }
                if (!(vsVal > 500.0)) continue;
                param.setValue("Firm-Rock");
                return true;
            }
            if (!data.getDataType().equals("Wills Class")) continue;
            String wc = (String)data.getValue();
            if (wc.equals("DE") || wc.equals("D")) {
                param.setValue("Firm-Soil");
                return true;
            }
            if (wc.equals("CD")) {
                param.setValue("Very-Firm-Soil");
                return true;
            }
            if (wc.equals("C")) {
                param.setValue("Soft-Rock");
                return true;
            }
            if (wc.equals("BC")) {
                param.setValue("BC-Boundary");
                return true;
            }
            if (!wc.equals("B")) continue;
            param.setValue("Firm-Rock");
            return true;
        }
        return false;
    }

    public boolean setWillsSiteTypeName(Parameter param, Collection<SiteDataValue<?>> datas) {
        String wc;
        SiteDataValue<?> willsData = this.getDataForType(datas, "Wills Class");
        if (willsData != null && param.isAllowed(wc = (String)willsData.getValue())) {
            param.setValue(wc);
            return true;
        }
        return false;
    }

    public boolean setCS05SoftSoil(Parameter param, Collection<SiteDataValue<?>> datas) {
        for (SiteDataValue<?> data : datas) {
            if (data.getDataType().equals("Vs30")) {
                Double vsVal = (Double)data.getValue();
                if (this.isVS30ValueValid(vsVal)) {
                    param.setValue(vsVal < 180.0);
                    return true;
                }
                return false;
            }
            if (!data.getDataType().equals("Wills Class")) continue;
            String wc = (String)data.getValue();
            if (wc.equals("E")) {
                param.setValue(true);
            } else {
                param.setValue(false);
            }
            return true;
        }
        return false;
    }

    public boolean setZhao06SiteType(Parameter param, Collection<SiteDataValue<?>> datas) {
        for (SiteDataValue<?> data : datas) {
            if (!data.getDataType().equals("Vs30")) continue;
            Double vsVal = (Double)data.getValue();
            if (vsVal <= 200.0) {
                param.setValue("Soft Soil");
                return true;
            }
            if (vsVal <= 300.0) {
                param.setValue("Medium Soil");
                return true;
            }
            if (vsVal <= 600.0) {
                param.setValue("Hard Soil");
                return true;
            }
            if (vsVal <= 1100.0) {
                param.setValue(" Rock");
                return true;
            }
            param.setValue("Hard Rock");
            return true;
        }
        return false;
    }

    @Deprecated
    public boolean setParameterValue(Parameter param, String willsClass, double basinDepth) {
        SiteDataValue<Object> willsData = null;
        String wc = willsClass;
        if (WillsMap2000.wills_vs30_map.keySet().contains(wc)) {
            willsData = new SiteDataValue<String>("Wills Class", "Measured", wc);
        } else {
            try {
                double vs = Double.parseDouble(wc);
                willsData = new SiteDataValue<Double>("Vs30", "Measured", vs);
            }
            catch (NumberFormatException vs) {
                // empty catch block
            }
        }
        SiteDataValue<Double> basinData = null;
        basinData = new SiteDataValue<Double>("Depth to Vs = 2.5 km/sec", "Measured", basinDepth / 1000.0);
        boolean setWills = this.setParameterValue(param, willsData);
        boolean setBasin = this.setParameterValue(param, basinData);
        return setWills || setBasin;
    }

    public void test(Parameter param) {
        System.out.println(param.getName() + "  Parameter (basin depth = NaN):");
        if (this.setParameterValue(param, "B", Double.NaN)) {
            System.out.println("\tB --> " + String.valueOf(param.getValue()));
        } else {
            System.out.println("\tB --> *** can't set ***");
        }
        if (this.setParameterValue(param, "BC", Double.NaN)) {
            System.out.println("\tBC --> " + String.valueOf(param.getValue()));
        } else {
            System.out.println("\tBC --> *** can't set ***");
        }
        if (this.setParameterValue(param, "C", Double.NaN)) {
            System.out.println("\tC --> " + String.valueOf(param.getValue()));
        } else {
            System.out.println("\tC --> *** can't set ***");
        }
        if (this.setParameterValue(param, "CD", Double.NaN)) {
            System.out.println("\tCD --> " + String.valueOf(param.getValue()));
        } else {
            System.out.println("\tCD --> *** can't set ***");
        }
        if (this.setParameterValue(param, "D", Double.NaN)) {
            System.out.println("\tD --> " + String.valueOf(param.getValue()));
        } else {
            System.out.println("\tD --> *** can't set ***");
        }
        if (this.setParameterValue(param, "DE", Double.NaN)) {
            System.out.println("\tDE --> " + String.valueOf(param.getValue()));
        } else {
            System.out.println("\tDE --> *** can't set ***");
        }
        if (this.setParameterValue(param, "E", Double.NaN)) {
            System.out.println("\tE --> " + String.valueOf(param.getValue()));
        } else {
            System.out.println("\tE --> *** can't set ***");
        }
        System.out.println(param.getName() + "  Parameter (basin depth = 1.0):");
        if (this.setParameterValue(param, "B", 1.0)) {
            System.out.println("\tB --> " + String.valueOf(param.getValue()));
        } else {
            System.out.println("\tB --> *** can't set ***");
        }
        if (this.setParameterValue(param, "BC", 1.0)) {
            System.out.println("\tBC --> " + String.valueOf(param.getValue()));
        } else {
            System.out.println("\tBC --> *** can't set ***");
        }
        if (this.setParameterValue(param, "C", 1.0)) {
            System.out.println("\tC --> " + String.valueOf(param.getValue()));
        } else {
            System.out.println("\tC --> *** can't set ***");
        }
        if (this.setParameterValue(param, "CD", 1.0)) {
            System.out.println("\tCD --> " + String.valueOf(param.getValue()));
        } else {
            System.out.println("\tCD --> *** can't set ***");
        }
        if (this.setParameterValue(param, "D", 1.0)) {
            System.out.println("\tD --> " + String.valueOf(param.getValue()));
        } else {
            System.out.println("\tD --> *** can't set ***");
        }
        if (this.setParameterValue(param, "DE", 1.0)) {
            System.out.println("\tDE --> " + String.valueOf(param.getValue()));
        } else {
            System.out.println("\tDE --> *** can't set ***");
        }
        if (this.setParameterValue(param, "E", 1.0)) {
            System.out.println("\tE --> " + String.valueOf(param.getValue()));
        } else {
            System.out.println("\tE --> *** can't set ***");
        }
    }

    private ArrayList<Parameter> getTableParameters() {
        ArrayList<Parameter> params = new ArrayList<Parameter>();
        Object attenNames = "";
        AttenuationRelationship ar = new CB_2008_AttenRel(null);
        attenNames = (String)attenNames + ",(multiple),(multiple)";
        params.add(ar.getParameter("Vs30"));
        params.add(ar.getParameter("Depth 2.5 km/sec"));
        ar = new CY_2008_AttenRel(null);
        attenNames = (String)attenNames + ",(multiple)";
        params.add(ar.getParameter("Depth 1.0 km/sec"));
        ar = new AS_1997_AttenRel(null);
        attenNames = (String)attenNames + "," + ar.getName().replaceAll(",", "");
        params.add(ar.getParameter("AS Site Type"));
        ar = new CB_2003_AttenRel(null);
        attenNames = (String)attenNames + "," + ar.getName().replaceAll(",", "");
        params.add(ar.getParameter("Campbell-2003 Site Type"));
        ar = new CS_2005_AttenRel(null);
        attenNames = (String)attenNames + "," + ar.getName().replaceAll(",", "");
        params.add(ar.getParameter("Soft Soil Case"));
        ar = new Campbell_1997_AttenRel(null);
        attenNames = (String)attenNames + "," + ar.getName().replaceAll(",", "") + "," + ar.getName().replaceAll(",", "");
        params.add(ar.getParameter("Campbell Site Type"));
        params.add(ar.getParameter("Campbell-Basin-Depth"));
        ar = new DahleEtAl_1995_AttenRel(null);
        attenNames = (String)attenNames + "," + ar.getName().replaceAll(",", "");
        params.add(ar.getParameter("Dahle Site Type"));
        ar = new Field_2000_AttenRel(null);
        attenNames = (String)attenNames + "," + ar.getName().replaceAll(",", "");
        params.add(ar.getParameter("Field-Basin-Depth"));
        ar = new SadighEtAl_1997_AttenRel(null);
        attenNames = (String)attenNames + "," + ar.getName().replaceAll(",", "");
        params.add(ar.getParameter("Sadigh Site Type"));
        ar = new SEA_1999_AttenRel(null);
        attenNames = (String)attenNames + "," + ar.getName().replaceAll(",", "");
        params.add(ar.getParameter("SEA Site Type"));
        ar = new ShakeMap_2003_AttenRel(null);
        attenNames = (String)attenNames + "," + ar.getName().replaceAll(",", "");
        params.add(ar.getParameter("Wills Site Class"));
        params.add(new StringParameter("Atten Rel Names", (String)attenNames));
        return params;
    }

    private String getTableValLine(ArrayList<Parameter> params, SiteDataValue<?> val) {
        String line = String.valueOf(val.getValue());
        for (Parameter param : params) {
            boolean flag = this.setParameterValue(param, val);
            if (flag) {
                line = line + "," + String.valueOf(param.getValue());
                continue;
            }
            line = line + ",N/A";
        }
        return line;
    }

    private void generateConversionTables() throws IOException {
        ArrayList<Parameter> params = this.getTableParameters();
        String attenTitles = (String)params.remove(params.size() - 1).getValue();
        FileWriter fw = new FileWriter("siteTrans.csv");
        Object empty = "";
        Object paramNames = "";
        for (Parameter param : params) {
            paramNames = (String)paramNames + "," + param.getName();
            empty = (String)empty + ",";
        }
        fw.write("Vs30" + ((String)empty).substring(1) + "\n");
        fw.write(attenTitles + "\n");
        fw.write((String)paramNames + "\n");
        SiteDataValue<Object> val = new SiteDataValue<Double>("Vs30", "Inferred", Double.NaN);
        String line = this.getTableValLine(params, val);
        fw.write(line + "\n");
        for (double vs30 = 150.0; vs30 < 1000.0; vs30 += 10.0) {
            val = new SiteDataValue<Double>("Vs30", "Inferred", vs30);
            line = this.getTableValLine(params, val);
            fw.write(line + "\n");
        }
        fw.write((String)empty + "\n");
        fw.write("Wills Class" + ((String)empty).substring(1) + "\n");
        fw.write(attenTitles + "\n");
        fw.write((String)paramNames + "\n");
        val = new SiteDataValue<String>("Wills Class", "Inferred", "NA");
        line = this.getTableValLine(params, val);
        fw.write(line + "\n");
        for (String wills : WillsMap2000.getSortedWillsValues()) {
            val = new SiteDataValue<String>("Wills Class", "Inferred", wills);
            line = this.getTableValLine(params, val);
            fw.write(line + "\n");
        }
        fw.write((String)empty + "\n");
        fw.write("Depth to Vs=2.5" + ((String)empty).substring(1) + "\n");
        fw.write(attenTitles + "\n");
        fw.write((String)paramNames + "\n");
        val = new SiteDataValue<Double>("Depth to Vs = 2.5 km/sec", "Inferred", Double.NaN);
        line = this.getTableValLine(params, val);
        fw.write(line + "\n");
        for (double depth2_5 = 0.0; depth2_5 < 3.0; depth2_5 += 0.1) {
            val = new SiteDataValue<Double>("Depth to Vs = 2.5 km/sec", "Inferred", depth2_5);
            line = this.getTableValLine(params, val);
            fw.write(line + "\n");
        }
        fw.write((String)empty + "\n");
        fw.write("Depth to Vs=1.0" + ((String)empty).substring(1) + "\n");
        fw.write(attenTitles + "\n");
        fw.write((String)paramNames + "\n");
        val = new SiteDataValue<Double>("Depth to Vs = 1.0 km/sec", "Inferred", Double.NaN);
        line = this.getTableValLine(params, val);
        fw.write(line + "\n");
        for (double depth1_0 = 0.0; depth1_0 < 3.0; depth1_0 += 0.1) {
            val = new SiteDataValue<Double>("Depth to Vs = 1.0 km/sec", "Inferred", depth1_0);
            line = this.getTableValLine(params, val);
            fw.write(line + "\n");
        }
        fw.write((String)empty + "\n");
        fw.close();
    }

    public static void main(String[] args) throws IOException {
        SiteTranslator siteTrans = new SiteTranslator();
        siteTrans.generateConversionTables();
        AttenuationRelationship ar = new AS_1997_AttenRel(null);
        siteTrans.test(ar.getParameter("AS Site Type"));
        ar = new SadighEtAl_1997_AttenRel(null);
        siteTrans.test(ar.getParameter("Sadigh Site Type"));
        ar = new BJF_1997_AttenRel(null);
        siteTrans.test(ar.getParameter("Vs30"));
        ar = new Campbell_1997_AttenRel(null);
        siteTrans.test(ar.getParameter("Campbell Site Type"));
        siteTrans.test(ar.getParameter("Campbell-Basin-Depth"));
        ar = new Field_2000_AttenRel(null);
        siteTrans.test(ar.getParameter("Vs30"));
        siteTrans.test(ar.getParameter("Field-Basin-Depth"));
        ar = new Abrahamson_2000_AttenRel(null);
        siteTrans.test(ar.getParameter("AS Site Type"));
        ar = new CB_2003_AttenRel(null);
        siteTrans.test(ar.getParameter("Campbell-2003 Site Type"));
        ar = new ShakeMap_2003_AttenRel(null);
        siteTrans.test(ar.getParameter("Wills Site Class"));
        ar = new USGS_Combined_2004_AttenRel(null);
        siteTrans.test(ar.getParameter("Vs30"));
    }
}

