/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.util;

import java.io.IOException;
import java.io.Serializable;
import org.opensha.commons.util.FileUtils;

public enum TectonicRegionType implements Serializable
{
    ACTIVE_SHALLOW("Active Shallow Crust", 300.0),
    STABLE_SHALLOW("Stable Shallow Crust", 1000.0),
    SUBDUCTION_INTERFACE("Subduction Interface", 1000.0),
    SUBDUCTION_SLAB("Subduction IntraSlab", 300.0),
    VOLCANIC("Volcanic", 300.0);

    private String name;
    private double cutoff;

    private TectonicRegionType(String name, double cutoff) {
        this.name = name;
        this.cutoff = cutoff;
    }

    public static TectonicRegionType getTypeForName(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        for (TectonicRegionType trt : TectonicRegionType.values()) {
            if (!trt.name.equals(name)) continue;
            return trt;
        }
        throw new IllegalArgumentException("TectonicRegionType name does not exist");
    }

    public static boolean isValidType(String name) {
        boolean answer = false;
        for (TectonicRegionType trt : TectonicRegionType.values()) {
            if (!trt.name.equals(name)) continue;
            answer = true;
        }
        return answer;
    }

    public String toString() {
        return this.name;
    }

    public double defaultCutoffDist() {
        return this.cutoff;
    }

    public static void main(String[] args) throws IOException {
        System.out.println(TectonicRegionType.isValidType("Active Shallow Crust"));
        String fname = "/tmp/trt.obj";
        TectonicRegionType before = ACTIVE_SHALLOW;
        FileUtils.saveObjectInFile(fname, before);
        TectonicRegionType after = (TectonicRegionType)FileUtils.loadObject(fname);
        System.out.println("before: " + String.valueOf(before));
        System.out.println("after: " + String.valueOf(after));
    }
}

