/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.util.component;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.gui.plot.PlotSymbol;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.sha.imr.param.OtherParams.Component;
import org.opensha.sha.util.component.ComponentTranslation;

public class Boore2010Trans
extends ComponentTranslation {
    private Component from;
    private Component to;
    private int column;
    private DiscretizedFunc convFunc;
    private static final String FILE_NAME = "/data/imr/component/boore_2010_conversions.xls";
    private static HSSFSheet sheet;

    public static List<Boore2010Trans> getAllConverters() {
        ArrayList convs = Lists.newArrayList();
        convs.add(new Boore2010Trans(Component.GMRotI50, Component.RotD50, 11));
        convs.add(new Boore2010Trans(Component.GMRotI50, Component.RotD100, 56));
        return convs;
    }

    private Boore2010Trans(Component from, Component to, int column) {
        this.from = from;
        this.to = to;
        this.column = column;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSheet() {
        Class<ComponentTranslation> clazz = ComponentTranslation.class;
        synchronized (ComponentTranslation.class) {
            if (sheet == null) {
                try {
                    POIFSFileSystem fs = new POIFSFileSystem(ComponentTranslation.class.getResource(FILE_NAME).openStream());
                    HSSFWorkbook wb = new HSSFWorkbook(fs);
                    sheet = wb.getSheetAt(0);
                }
                catch (IOException e) {
                    ExceptionUtils.throwAsRuntimeException(e);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            Preconditions.checkNotNull((Object)sheet);
            return;
        }
    }

    private synchronized DiscretizedFunc getConversionFunc() {
        if (this.convFunc == null) {
            this.loadSheet();
            this.convFunc = new ArbitrarilyDiscretizedFunc();
            int lastRowIndex = sheet.getLastRowNum();
            for (int rowIndex = 1; rowIndex <= lastRowIndex; ++rowIndex) {
                HSSFRow row = sheet.getRow(rowIndex);
                double period = row.getCell(0).getNumericCellValue();
                double factor = row.getCell(this.column).getNumericCellValue();
                this.convFunc.set(period, factor);
            }
        }
        return this.convFunc;
    }

    @Override
    public Component getFromComponent() {
        return this.from;
    }

    @Override
    public Component getToComponent() {
        return this.to;
    }

    @Override
    public double getScalingFactor(double period) throws IllegalArgumentException {
        this.assertValidPeriod(period);
        return this.getConversionFunc().getInterpolatedY(period);
    }

    @Override
    public double getMinPeriod() {
        return this.getConversionFunc().getMinX();
    }

    @Override
    public double getMaxPeriod() {
        return this.getConversionFunc().getMaxX();
    }

    public static void main(String[] args) {
        ArrayList funcs = Lists.newArrayList();
        ArrayList chars = Lists.newArrayList();
        Color[] colors = new Color[]{Color.BLACK, Color.BLUE, Color.RED, Color.GREEN};
        List<Boore2010Trans> convs = Boore2010Trans.getAllConverters();
        for (int i = 0; i < convs.size(); ++i) {
            Boore2010Trans trans = convs.get(i);
            funcs.add(trans.getConversionFunc());
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, PlotSymbol.CIRCLE, 4.0f, colors[i]));
        }
        PlotSpec spec = new PlotSpec(funcs, chars, "Conversion Factors", "Period", "Ratio");
        GraphWindow gw = new GraphWindow(spec);
        gw.setDefaultCloseOperation(3);
        gw.setXLog(true);
    }

    @Override
    public String getName() {
        return "Boore 2010";
    }
}

