/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sha.util.component;

import java.awt.geom.Point2D;
import org.opensha.commons.data.Named;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.sha.imr.param.OtherParams.Component;

public abstract class ComponentTranslation
implements Named {
    public abstract Component getFromComponent();

    public abstract Component getToComponent();

    public abstract double getScalingFactor(double var1) throws IllegalArgumentException;

    public abstract double getMinPeriod();

    public abstract double getMaxPeriod();

    public boolean isPeriodSupported(double period) {
        return (float)period >= (float)this.getMinPeriod() && (float)period <= (float)this.getMaxPeriod();
    }

    protected void assertValidPeriod(double period) {
        if (!this.isPeriodSupported(period)) {
            throw new IllegalArgumentException("Period is not supported: " + period + ". Range: [" + this.getMinPeriod() + "," + this.getMaxPeriod() + "]");
        }
    }

    public DiscretizedFunc convertCurve(DiscretizedFunc curve, double period) {
        double ratio = this.getScalingFactor(period);
        ArbitrarilyDiscretizedFunc scaled = new ArbitrarilyDiscretizedFunc();
        scaled.setName(curve.getName());
        scaled.setInfo(curve.getInfo());
        for (Point2D pt : curve) {
            scaled.set(pt.getX() * ratio, pt.getY());
        }
        return scaled;
    }

    public double getScaledValue(double origVal, double period) {
        double ratio = this.getScalingFactor(period);
        return origVal * ratio;
    }
}

